@extends('layouts.usermaster')

@section('styles')

@endsection

@section('content')

							<!-- Section -->
							<section>
								<div class="bannerimg cover-image" data-bs-image-src="{{asset('build/assets/images/photos/banner1.jpg')}}">
									<div class="header-text mb-0">
										<div class="container">
											<div class="row text-white">
												<div class="col">
													<h1 class="mb-0">{{$faqcategory->faqcategoryname}}</h1>
												</div>
												<div class="col col-auto">
													<ol class="breadcrumb text-center d-flex align-items-center justify-content-center">
														<li class="breadcrumb-item">
															<a href="{{url('/')}}" class="text-white-50">{{lang('Home')}}</a>
														</li>
														<li class="breadcrumb-item">
															<a href="{{url('faq/')}}" class="text-white-50">{{lang('FAQ’s')}}</a>
														</li>
														<li class="breadcrumb-item active">
															<a href="#" class="text-white">{{$faqcategory->faqcategoryname}}</a>
														</li>
													</ol>
												</div>
											</div>
										</div>
									</div>
								</div>
							</section>
							<!-- Section -->

							<!--Section-->
							<section>
								<div class="cover-image sptb">
									<div class="container">
                                        <div class="mb-2">
                                            <a data-placement="top" data-bs-toggle="tooltip" title="{{lang('Translate')}}" data-bs-original-title="{{lang('Translate')}}" href="javascript:void(0);" onclick="langtranslatebtn()">
                                                <b><span class="badge badge-light px-2"><i class="ri-translate align-middle fs-15 chat-info-optionicon d-inline-block"></i></span></b>
                                            </a>
                                        </div>
										<div class="row">
											<div class="col-xl-12">
												<div aria-multiselectable="true" class="accordion suuport-accordion" id="accordion" role="tablist">
													@php $faq = $faqcategory->faqdetails()->where('status', '1')->get();  @endphp

													@if($faq->isNotempty())
													<div class="accordion accordionExample" >
														<div class="row mb-5">

															@foreach ($faq as $faqs)

															<div class="col-xl-12">
																<div class="accordion-item">
																	<h2 class="accordion-header" id="heading{{$faqs->id}}">
																	<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{$faqs->id}}" aria-expanded="true" aria-controls="collapse{{$faqs->id}}">
																		{{$faqs->question}}
																	</button>
																	</h2>
																	<div id="collapse{{$faqs->id}}" class="accordion-collapse collapse " aria-labelledby="heading{{$faqs->id}}" data-bs-parent=".accordionExample">
																		<div class="accordion-body">
                                                                            {!!$faqs->answer!!}
																		</div>
																	</div>
																</div>
															</div>
															@endforeach


														</div>
													</div>


													@else
													<div class="card no-articles">
														<div class="card-body p-8">
															<div class="main-content text-center">
																<div class="notification-icon-container p-4">
																	<img src="{{asset('build/assets/images/noarticle.png')}}" alt="">
																</div>
																<h4 class="mb-1">{{lang('There are no new FAQ’s')}}</h4>
																<p class="text-muted">{{lang('This faq section will be updated shortly.')}}</p>
															</div>
														</div>
													</div>
													@endif
												</div>
											</div>
										</div>
									</div>
								</div>
							</section>
							<!--Section-->
    @include('admin.superadmindashboard.texttranslationpopup')
@endsection

@section('scripts')

    <!-- INTERNAL Vertical-scroll js-->
    <script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}"></script>

    <script type="text/javascript">
        function langtranslatebtn() {
            $('.select2_texttranslation').select2({
                dropdownParent: ".texttranslationmodal",
                minimumResultsForSearch: '',
                placeholder: "Search",
                width: '100%'
            });
            $('#texttranslationmodal').modal('show');
        }

        document.getElementById('translateButtonSave').addEventListener('click', function () {
            document.querySelector('#translateButtonSave').innerHTML = "{{ lang('Translating') }} ... <i class='fa fa-spinner fa-spin'></i>";
            document.querySelectorAll('.accordion-button').forEach((element) => {
                const selectedLanguage = document.getElementById('translate-lang').value;
                const accordionGroup = element.closest('.accordion').previousElementSibling;
                var faqcategorytitle = '';
                if (accordionGroup && accordionGroup.classList.contains('accordion-group')) {
                    faqcategorytitle =  accordionGroup.querySelector('#faqcategorynameadding');
                }
                var faqtitle = element;
                var description = element.closest('.accordion-item').querySelector('.accordion-body');

                function getElementHtmlWithStyles(element) {
                    return element.outerHTML;
                }

                const wrappedHtml = getElementHtmlWithStyles(description);

                fetch('{{ route('articlelangtanslate.lang.translate') }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    },
                    body: JSON.stringify({
                        text: wrappedHtml,
                        title: faqtitle.innerHTML,
                        faqcategorytitle: faqcategorytitle.innerHTML,
                        target_lang: selectedLanguage,
                    }),
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        description.innerHTML = data.translated_text;
                        faqtitle.innerHTML = data.translated_title;
                        faqcategorytitle.innerHTML = data.translated_faqcat;
                    } else {
                        if(data?.message?.includes('Client error: ')){
                            toastr.error('Translation failed due to no translation for this language.');
                        }else{
                            toastr.error('Translation failed: ' + data.message);
                        }
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred.');
                });
            });


            document.querySelector('#translateButtonSave').innerHTML = "{{ lang('Translate') }}";
            $('#texttranslationmodal').modal('hide');

        });
    </script>

@endsection


