@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAL Data table css -->
<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<!-- INTERNAL Sweet-Alert css -->
<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
<style>
    .custom-data-responsive nav {
        position: static !important;
        float: right !important;
        margin-block-end: 5px;
        margin-top: -28px !important;
    }
    .power-ribbone {
        width: 2.5rem;
        height: 2.5rem;
        overflow: hidden;
        position: absolute;
        z-index: 8;
    }
    .power-ribbone span {
        position: absolute;
        display: block;
        width: 5.125rem;
        padding: 0.5rem 0 0.25rem 0;
        color: #fff;
        font: 500 1rem/1 Lato, sans-serif;
        text-shadow: 0 0.0625rem 0.0625rem rgba(0,0,0,0.2);
        text-transform: capitalize;
        text-align: center;
    }

    .power-ribbone-top-left {
        inset-block-start: -0.375rem;
        inset-inline-start: -0.5625rem;
    }
    .power-ribbone-top-left span {
        inset-inline-end: -11px;
        inset-block-start: -14px;
        transform: rotate(-45deg);
    }
    .power-ribbone-top-left span i {
        transform: rotate(45deg);
        padding-block-start: 13px;
        font-size: 10px;
        padding-inline-start: 10px;
    }
    #hideAfterloading {
        position: absolute;
        top: 100px;
        left: 45%;
    }
</style>
@endsection

@section('content')

<!--Page header-->
<div class="page-header d-xl-flex d-block px-3">
    <div class="page-leftheader">
        <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Previous Tickets', 'menu')}}</span></h4>
    </div>
</div>
<!--End Page header-->
<div class="row">
    <div class="col-xl-3 col-lg-3 col-md-3">
        <div class="card user-pro-list overflow-hidden">
            <div class="card-body">
                <div class="user-pic text-center">
                    @if ($users->image == null)

                    <img src="{{asset('uploads/profile/user-profile.png')}}" class="avatar avatar-xxl brround" alt="">

                    @else
                    <img src="{{ route('getprofile.url', ['imagePath' =>$users->image,'storage_disk'=>$users->storage_disk ?? 'public']) }}" class="avatar avatar-xxl brround" alt="">
                    @endif
                    <div class="pro-user mt-3">
                        <h5 class="pro-user-username text-dark mb-1 fs-16">{{$users->username}}</h5>
                        <h6 class="pro-user-desc text-muted fs-12">{{$users->email}}</h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header border-0">
                <h4 class="card-title"> {{lang('Personal Details')}}</h4>
            </div>
            <div class="card-body px-0 pb-0">

                <div class="table-responsive tr-lastchild">
                    <table class="table mb-0 table-information">
                        <tbody>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Name')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->username}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Email')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->email}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Customer Type')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->userType}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Login Type')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->logintype}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Status')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->status}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Phone Number')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->phone}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Login IP')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->last_login_ip}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Customer Country')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->country}}</td>
                            </tr>
                            <tr>
                                <td class="py-2">
                                    <span class="font-weight-semibold w-50"> {{lang('Customer Timezone')}} </span>
                                </td>
                                <td class="py-2 ps-4">{{$users->timezone}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    <div class="col-xl-9 px-3">
        <div class="row">
            <div class="col-xl-3 col-lg-3 col-md-12">
                <div class="card">
                    <span>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-7">
                                    <div class="mt-0 text-start">
                                        <span class="fs-16 font-weight-semibold">{{lang('Total Tickets',
                                            'menu')}}</span>
                                        <h3 class="mb-0 mt-1 text-primary fs-25">{{$total->count()}}</h3>
                                    </div>
                                </div>
                                <div class="col-5">
                                    <div class="icon1 bg-primary-transparent my-auto float-end"> <i
                                            class="las la-ticket-alt"></i> </div>
                                </div>
                            </div>
                        </div>
                    </span>
                </div>
            </div>
            <div class="col-xl-3 col-lg-3 col-md-12">
                <div class="card">
                    <span>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-7">
                                    <div class="mt-0 text-start">
                                        <span class="fs-16 font-weight-semibold">{{lang('Active Tickets',
                                            'menu')}}</span>
                                        <h3 class="mb-0 mt-1 text-success fs-25">

                                            {{$active->count()}}

                                        </h3>
                                    </div>
                                </div>
                                <div class="col-5">
                                    <div class="icon1 bg-success-transparent my-auto float-end"> <i
                                            class="ri-ticket-2-line"></i> </div>
                                </div>
                            </div>
                        </div>
                    </span>
                </div>
            </div>
            <div class="col-xl-3 col-lg-3 col-md-12">
                <div class="card">
                    <span>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-7">
                                    <div class="mt-0 text-start">
                                        <span class="fs-16 font-weight-semibold">{{lang('Solved Tickets',
                                            'menu')}}</span>
                                        <h3 class="mb-0 mt-1 text-secondary fs-25">{{$closed->count()}}</h3>
                                    </div>
                                </div>
                                <div class="col-5">
                                    <div class="icon1 bg-danger-transparent my-auto  float-end"> <i
                                            class="ri-coupon-2-line"></i> </div>
                                </div>
                            </div>
                        </div>
                    </span>
                </div>
            </div>

        </div>
        <div >
            <div class="card ">
                <div class="card-header border-0">
                    <h4 class="card-title">{{lang('Previous Tickets Of Customer', 'menu')}}</h4>
                </div>
                <div class="card-body overflow-scroll custom-show-data" style="min-height: 250px;">
                    <div class="spruko-delete">
                        @can('Ticket Delete')

                        <button id="massdelete" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
                        @endcan
                        <div class="fetchedtabledata custom-data-responsive">
                            {{-- @include('admin.superadmindashboard.tabledatainclude') --}}
                            <table class="table table-bordered border-bottom text-nowrap ticketdeleterow supportticket-list w-100"
                            id="ticketdatatable">
                                <thead>
                                    <tr>
                                        <th class="wpx-40 text-center">{{ lang('Sl.No') }}</th>
                                        @can('Ticket Delete')
                                            <th class="wpx-40 text-center">
                                                <input type="checkbox" id="customCheckAll" class="form-check-input">
                                                <label for="customCheckAll"></label>
                                            </th>
                                        @endcan
                                        @cannot('Ticket Delete')
                                            <th class="wpx-40 text-center">
                                                <input type="checkbox" id="customCheckAll" class="form-check-input" disabled>
                                                <label for="customCheckAll"></label>
                                            </th>
                                        @endcannot

                                        <th>{{ lang('Ticket Details') }}</th>
                                        <th>{{ lang('User') }}</th>
                                        <th>{{ lang('Status') }}</th>
                                        <th>{{ lang('Assign To') }}</th>
                                        <th>{{ lang('Actions') }}</th>

                                    </tr>
                                </thead>
                                <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                                    <p>{{lang('loading.. Please Wait')}}</p>
                                </div>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection


@section('scripts')

<!-- INTERNAL Vertical-scroll js-->
<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Data tables -->
<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])
@vite(['resources/assets/js/select2.js'])

<!-- INTERNAL Sweet-Alert js-->
<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>

<script type="text/javascript">
    "use strict";

    document.addEventListener("DOMContentLoaded", (event) => {

        let tableData = @json($custsimillartickets);

        let dateFormat = @json(setting('date_format'));
        let delPerm = @json(Auth::user()->can('Ticket Delete'));
        let editPerm = @json(Auth::user()->can('Ticket Edit'));
        let assignPerm = @json(Auth::user()->can('Ticket Assign'));

        var dataTable;
        var tableDropDown;

        loadTable(tableData);

        function truncateTitle(title) {
            const maxLength = 40;
            return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
        }

        function dateTime(createdTime) {

            const jsDate = new Date(createdTime);

            let format = @json(setting('date_format'));
            switch (format) {
                case 'd M, Y':
                    return jsDate.toLocaleDateString('en-GB', {
                        day: '2-digit',
                        month: 'short',
                        year: 'numeric'
                    });
                case 'm.d.y':
                    return jsDate.toLocaleDateString('en-US', {
                        day: '2-digit',
                        month: '2-digit',
                        year: '2-digit'
                    }).replace(/\//g, '.');
                case 'Y-m-d':
                    return jsDate.toISOString().split('T')[0];
                case 'd-m-Y':
                    return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                case 'd/m/Y':
                    return jsDate.toLocaleDateString('en-GB');
                case 'Y/m/d':
                    return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                default:
                    return jsDate.toLocaleDateString(); // Default format
            }

        }

        function formatTime(inputTime) {
            const initialDate = new Date(inputTime);
            const now = new Date();

            const diffInMinutes = Math.floor((now - initialDate) / 60000);
            let timeText;

            if (diffInMinutes < 1) {
                timeText = 'Just now';
            } else if (diffInMinutes < 60) {
                timeText = `${diffInMinutes} minute${diffInMinutes > 1 ? 's' : ''} ago`;
            } else {
                const diffInHours = Math.floor(diffInMinutes / 60);
                if (diffInHours < 24) {
                    timeText = `${diffInHours} hour${diffInHours > 1 ? 's' : ''} ago`;
                } else {
                    const diffInDays = Math.floor(diffInHours / 24);
                    timeText = `${diffInDays} day${diffInDays > 1 ? 's' : ''} ago`;
                }
            }

            return timeText;
        }

        function loadTable(tableData) {
            document.getElementById('hideAfterloading')?.classList.remove('d-none');
            document.getElementById('theadShow')?.classList.add('d-none');
            if (tableDropDown)
                tableDropDown.destroy();

            if (dataTable)
                dataTable.destroy();

            if (document.getElementById('tableBody'))
                document.getElementById('tableBody').remove();

            let createTbody = document.createElement('tbody');
            createTbody.setAttribute('id', "tableBody");
            let rows = tableData.map((data, index) => {
                var tickerpriority;
                if(data.priority != null){
                    if(data.priority == 'Low'){
                        tickerpriority = `<li class="ps-5 pe-2 preference preference-low" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Priority') }}">{{ lang('Low') }}</li>`;
                    } else if (data.priority == 'High'){
                        tickerpriority = `<li class="ps-5 pe-2 preference preference-high" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Priority') }}">{{ lang('High') }}</li>`;
                    } else if (data.priority == 'Critical'){
                        tickerpriority = `<li class="ps-5 pe-2 preference preference-critical" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Priority') }}">{{ lang('Critical') }}</li>`;
                    }else{
                        tickerpriority = `<li class="ps-5 pe-2 preference preference-medium" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Priority') }}">{{ lang('Medium') }}</li>`;
                    }
                }else{
                    tickerpriority = '~';
                }

                var purchasesupport = '';
                if(data.purchasecodesupport){
                    if(data.purchasecodesupport == 'Supported'){
                        purchasesupport = `<li class="px-2 text-success font-weight-semibold">{{ lang('Support Active') }}</li>`;
                    }
                    if(data.purchasecodesupport == 'Expired'){
                        purchasesupport = `<li class="px-2 text-danger-dark font-weight-semibold">{{ lang('Support Expired') }}</li>`;
                    }
                }

                var ticketstatus;
                if(data.status == 'New'){
                    ticketstatus = `<span class="badge badge-burnt-orange">{{ lang('New') }}</span>`;
                }else if(data.status == 'Re-Open'){
                    ticketstatus = `<span class="badge badge-teal">{{ lang('Re-Open') }}</span>`;
                }else if(data.status == 'Inprogress'){
                    ticketstatus = `<span class="badge badge-info">{{ lang('Inprogress') }}</span>`;
                }else if(data.status == 'On-Hold'){
                    ticketstatus = `<span class="badge badge-warning">{{ lang('On-Hold') }}</span>`;
                }else{
                    ticketstatus = `<span class="badge badge-danger">{{ lang('Closed') }}</span>`;
                }

                return `
                    <tr ${data.replystatus == 'Replied' ? 'class=bg-success-transparent' : ''} ${data.ticketviolation == 'on' ? 'class="bg-danger-transparent"' : ''}>
                        <td class="wpx-40 text-center">${index + 1}</td>
                        <td class="wpx-40 text-center">
                            ${delPerm
                                ? `<input type="checkbox" name="student_checkbox[]" class="checkall form-check-input" value="${data.encrypted_id}" />`
                                : '~'
                            }
                        </td>

                        <td class="overflow-hidden ticket-details">
                            <div class="d-flex align-items-center">
                                <div class="ribbone-card">
                                    ${data.importantticket == 'on' && data.status != 'Closed' ?
                                        `<div class="power-ribbone power-ribbone-top-left">
                                                <span class="bg-warning"><i class="fa fa-star"></i></span>
                                            </div>`
                                        :
                                        ''
                                    }

                                    ${data.ticketnote.length == 0 ?
                                        (data.overduestatus ?
                                        `<div class="ribbon ribbon-top-right1 text-danger">
                                            <span class="bg-danger text-white">${data.overduestatus}</span>
                                        </div>
                                        `
                                        :
                                        ''
                                        )
                                        :
                                        `<div class="ribbon ribbon-top-right text-warning">
                                            <span class="bg-warning text-white">{{ lang('Note') }}</span>
                                        </div>
                                        ${data.overduestatus ?
                                            `<div class="ribbon ribbon-top-right1 text-danger">
                                                <span class="bg-danger text-white">${data.overduestatus}</span>
                                            </div>`
                                            :
                                            ''
                                        }
                                        `
                                    }

                                    <a href="${data.viewRouteUrl}" class="fs-14 d-block font-weight-semibold">${data.subject}</a>

                                    <ul class="fs-13 font-weight-normal d-flex custom-ul">
                                        <li class="pe-2 text-muted">#${data.ticket_id}</span>
                                        <li class="px-2 text-muted" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Date') }}"><i class="fe fe-calendar me-1 fs-14"></i>
                                            ${dateTime(data.created_at)}
                                        </li>

                                        ${tickerpriority}

                                        ${data.category_id ?
                                            (data.category ?
                                                `<li class="px-2 text-muted" data-bs-toggle="tooltip" data-bs-placement="top"
                                                    title="{{ lang('Category') }}"><i class="fe fe-grid me-1 fs-14"></i>${truncateTitle(data.category.name)}
                                                </li>`
                                                :
                                                '~'
                                            )
                                            :
                                            '~'
                                        }

                                        ${data.last_reply ?
                                            `<li class="px-2 text-muted" data-bs-toggle="tooltip" data-bs-placement="top"
                                                title="{{ lang('Last Replied') }}"><i class="fe fe-clock me-1 fs-14"></i>${formatTime(data.last_reply)}
                                            </li>`
                                            :
                                            `<li class="px-2 text-muted" data-bs-toggle="tooltip" data-bs-placement="top"
                                                title="{{ lang('Last Replied') }}"><i class="fe fe-clock me-1 fs-14"></i>${formatTime(data.created_at)}
                                            </li>`
                                        }

                                        ${purchasesupport}
                                    </ul>
                                </div>
                            </div>
                        </td>

                        <td>
                            ${data.cust.username} ${data.cust.voilated == 'on' ? `<i class="fa fa-exclamation-triangle text-danger"></i>` : ''}
                        </td>

                        <td>${ticketstatus}</td>

                        <td>
                            ${assignPerm ?
                                (data.status == 'Closed' ?
                                    `<div class="btn-group">
                                        ${data.selfassignuser_id  ?
                                            `<button class="btn btn-outline-primary" data-bs-toggle="dropdown"
                                                disabled>${data.selfassign.name } ({{ lang('You') }}) </button>
                                            <button class="btn btn-outline-primary" disabled data-bs-toggle="tooltip" data-bs-placement="top"
                                                title="" data-bs-original-title="{{ lang('Unassign') }}"
                                                aria-label="Unassign"><i class="fe fe-x"></i></button>`
                                            :
                                            `<button class="btn btn-outline-primary" data-bs-toggle="dropdown" disabled>"{{ lang('Assign') }}"</button>`
                                        }
                                    </div>`
                                    :
                                    `<div class="btn-group">
                                        ${data.selfassignuser_id ?
                                            `<a href="javascript:void(0)" class="btn btn-outline-primary btn-sm" data-id="${data.encrypted_id}"
                                                id="assigned">${data.selfassign.name} ({{ lang('You') }})
                                            </a>
                                            <a href="javascript:void(0)" data-id="${data.encrypted_id}" class="btn btn-outline-primary btn-sm" id="btnremove"
                                                data-bs-toggle="tooltip" data-bs-placement="top" title="" data-bs-original-title="{{ lang('Unassign') }}" aria-label="Unassign"><i class="fe fe-x"></i>
                                            </a>`
                                            :
                                            `<a href="javascript:void(0)" class="btn btn-outline-primary btn-sm" data-id="${data.encrypted_id}" id="assigned">
                                                "{{ lang('Assign') }}"
                                            </a>`
                                        }
                                    </div>`
                                )
                                :
                                '~'
                            }
                        </td>

                        <td>
                            <div class = "d-flex">

                                ${editPerm ? `<a href="${data.viewRouteUrl}" class="btn btn-sm action-btns edit-testimonial"><i class="feather feather-eye text-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('View') }}"></i></a>` : '~'
                                }

                                ${delPerm ? `<a href="javascript:void(0)" data-id="${data.encrypted_id}" class="btn btn-sm action-btns" id="show-delete"><i class="feather feather-trash-2 text-danger" data-id="${data.encrypted_id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Delete') }}"></i></a>` : '~'
                                }

                            </div>

                        </td>

                    </tr>
                `;
            });

            if (tableData.length == 0)
                createTbody.innerHTML = ` `;
            else
                createTbody.innerHTML = rows.join('');


            // Append the tbody to your table
            // Replace 'your-table-id' with the actual ID of your table element
            document.getElementById('ticketdatatable').appendChild(createTbody);

            document.getElementById('hideAfterloading')?.classList.add('d-none');
            document.getElementById('theadShow')?.classList.remove('d-none');

            // var myTable = document.querySelector("#support-category");

            $(document).ready(function() {

                var SITEURL = '{{ url('') }}';

                // Csrf field
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                let prev = {!! json_encode(lang("Previous")) !!};
                let next = {!! json_encode(lang("Next")) !!};
                let nodata = {!! json_encode(lang('No data available in table')) !!};
                let noentries = {!! json_encode(lang('No entries to show')) !!};
                let showing = {!! json_encode(lang('showing page')) !!};
                let ofval = {!! json_encode(lang('of')) !!};
                let maxRecordfilter = {!! json_encode(lang('- filtered from ')) !!};
                let maxRecords = {!! json_encode(lang('records')) !!};
                let entries = {!! json_encode(lang('entries')) !!};
                let show = {!! json_encode(lang('Show')) !!};
                let search = {!! json_encode(lang('Search')) !!};

                $('#ticketdatatable').dataTable({
                    language: {
                        searchPlaceholder: search,
                        scrollX: "100%",
                        sSearch: '',
                        paginate: {
                            previous: prev,
                            next: next
                        },
                        emptyTable: nodata,
                        infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                        info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                        infoEmpty: noentries,
                        lengthMenu: `${show} _MENU_ ${entries} `,
                    },
                    order: [],
                    columnDefs: [{
                        "orderable": false,
                        "targets": [0, 1, 4]
                    }],
                });

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

                $('.form-select').on('focus', function() {
                    $(this).attr('aria-hidden', 'false');
                });
            });


            initializeTooltips();

            function initializeTooltips() {
                var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                tooltipElements.forEach(function(element) {
                    new bootstrap.Tooltip(element);
                });
            }


        }

        $(function() {

            (function($)  {

                // Variables
                var SITEURL = '{{url('')}}';

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

                // when user click its get modal popup to assigned the ticket
                $('body').on('click', '#assigned', function () {
                    var assigned_id = $(this).data('id');
                    $('.select2_modalassign').select2({
                        dropdownParent: ".sprukosearch",
                        minimumResultsForSearch: '',
                        placeholder: "Search",
                        width: '100%'
                    });

                    var APP_URL = {!! json_encode(url('/')) !!}
                    $.get(APP_URL+'/admin/assigned/' + assigned_id , function (data) {
                        $('#assigned_id').val(data.assign_data.id);
                        $(".modal-title").text('Assign To Agent');
                        $('#username').html(data.table_data);
                        if(data.assign_user_exist == 'no'){
                            $('#username').val([]).trigger('change')
                        }
                        $('#addassigned').modal('show');
                    });
                });

                // TICKET DELETE SCRIPT
                $('body').on('click', '#show-delete', function () {
                    let parent = $(this).closest('tr');
                    var _id = $(this).data("id");
                    swal({
                        title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                        text: "{{lang('This might erase your records permanently', 'alerts')}}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                                type: "get",
                                url: SITEURL + "/admin/delete-ticket/"+_id,
                                success: function (data) {
                                    toastr.success(data.success);
                                    // var oTable = $('#myticket').dataTable();
                                    // oTable.fnDraw(false);
                                    $(parent[0]).addClass('fade-out');
                                    let newData = tableData.filter(item => item.encrypted_id != _id);
                                    tableData = newData;
                                    setTimeout(() => {
                                        parent[0].remove();
                                        if ($.fn.DataTable.isDataTable('#ticketdatatable')) {
                                            $('#ticketdatatable').DataTable().clear().destroy();
                                        }
                                        loadTable(tableData);
                                    }, 1500);
                                },
                                error: function (data) {
                                console.log('Error:', data);
                                }
                            });
                        }
                    });
                });
                // TICKET DELETE SCRIPT END

                //Mass Delete
                $('body').on('click', '#massdelete', function () {
                    var parent = [];
                    var id = [];
                    $('.checkall:checked').each(function(){
                        parent.push($(this).closest('tr'));
                        id.push($(this).val());
                    });
                    if(id.length > 0){
                        swal({
                            title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                            text: "{{lang('This might erase your records permanently', 'alerts')}}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    url:"{{ url('admin/ticket/delete/tickets')}}",
                                    method:"POST",
                                    data:{id:id},
                                    success:function(data)
                                    {

                                        toastr.success(data.success);
                                        parent.forEach(function(row) {
                                            row.addClass('fade-out');
                                        });
                                        let newData = tableData.filter(item => !id.includes(String(item.encrypted_id)));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent.forEach(function(row) {
                                                row.remove();
                                            });
                                            if ($.fn.DataTable.isDataTable('#ticketdatatable')) {
                                                $('#ticketdatatable').DataTable().clear().destroy();
                                            }
                                            $('#customCheckAll').prop('checked', false);
                                            loadTable(tableData);
                                        }, 1500);

                                    },
                                    error:function(data){

                                    }
                                });
                            }
                        });
                    }
                    else{
                        toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                    }

                });

                // Assigned Submit button
                $('body').on('submit', '#assigned_form', function (e) {
                    e.preventDefault();
                    var actionType = $('#btnsave').val();
                    var fewSeconds = 2;
                    $('#btnsave').html('Sending ... <i class="fa fa-spinner fa-spin"></i>');
                    $('#btnsave').prop('disabled', true);
                        setTimeout(function(){
                            $('#btnsave').prop('disabled', false);
                        }, fewSeconds*1000);
                    var formData = new FormData(this);
                    $.ajax({
                        type:'POST',
                        url: SITEURL + "/admin/assigned/create",
                        data: formData,
                        cache:false,
                        contentType: false,
                        processData: false,

                        success: (data) => {
                            $('#AssignError').html('');
                            $('#assigned_form').trigger("reset");
                            $('#addassigned').modal('hide');
                            $('#btnsave').html('{{lang('Save Changes')}}');
                            // var oTable = $('#myticket').dataTable();
                            // oTable.fnDraw(false);
                            toastr.success(data.success);
                            location.reload();
                        },
                        error: function(data){
                            $('#AssignError').html('');
                            $('#AssignError').html("The assigned agent field is required");
                            // $('#AssignError').html(data.responseJSON.errors.assigned_user_id);
                            $('#btnsave').html('{{lang('Save Changes')}}');
                        }
                    });
                });

                // Remove the assigned from the ticket
                $('body').on('click', '#btnremove', function () {
                    var asid = $(this).data("id");
                    swal({
                        title: `{{lang('Are you sure you want to unassign this agent?', 'alerts')}}`,
                        text: "{{lang('This agent may no longer exist for this ticket.', 'alerts')}}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                type: "get",
                                url: SITEURL + "/admin/assigned/update/"+asid,
                                success: function (data) {
                                    // var oTable = $('#myticket').dataTable();
                                    // oTable.fnDraw(false);
                                    toastr.success(data.success);
                                    location.reload();
                                },
                                error: function (data) {
                                    console.log('Error:', data);
                                }
                            });

                        }
                    });
                });



                $(document).ready(function() {

                    $(document).on('click', '#customCheckAll', function() {
                        $('.checkall').prop('checked', this.checked);
                        updateMassDeleteVisibility();
                    });

                    // Handle individual checkboxes
                    $(document).on('click', '.checkall', function() {
                        updateCustomCheckAll();
                        updateMassDeleteVisibility();
                    });

                    // Handle pagination controls
                    $(document).on('click', '.pagination a', function() {
                        // Assuming '.pagination a' is the selector for your pagination controls
                        setTimeout(function() {
                            updateMassDeleteVisibility();
                        }, 100);
                    });

                    // Initialize the "Select All" checkbox to unchecked
                    $('#customCheckAll').prop('checked', false);

                    // Function to update the visibility of the mass delete button
                    function updateMassDeleteVisibility() {
                        if ($('.checkall:checked').length == 0) {
                            $('#massdelete').hide();
                        } else {
                            $('#massdelete').show();
                        }
                    }

                    // Function to update the state of the "Select All" checkbox
                    function updateCustomCheckAll() {
                        var totalCheckboxes = $('.checkall').length;
                        var checkedCheckboxes = $('.checkall:checked').length;

                        if (checkedCheckboxes === totalCheckboxes) {
                            $('#customCheckAll').prop('checked', true);
                        } else {
                            $('#customCheckAll').prop('checked', false);
                        }
                    }
                });


                $('body').on('click','#selfassigid', function(e){

                    e.preventDefault();

                    let id = $(this).data('id');

                    $.ajax({
                        method:'POST',
                        url: '{{route('admin.selfassign')}}',
                        data: {
                            id : id,
                        },
                        success: (data) => {
                            toastr.success(data.success);
                            location.reload();
                        },
                        error: function(data){

                        }
                    });
                })

            })(jQuery);
        });
    });

</script>

@endsection

@section('modal')

@include('admin.modalpopup.assignmodal')

@endsection
