@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAL Data table css -->
<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>"
	rel="stylesheet" />
<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
<link href="{{asset('build/assets/plugins/datatable/buttonbootstrap.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<style>
    #hideAfterloading {
        position: absolute;
        top: 100px;
        left: 45%;
    }
</style>

@endsection

@section('content')

        <!--Page header-->
        <div class="page-header d-xl-flex d-block">
            <div class="page-leftheader">
                <h4 class="page-title"><span
                        class="font-weight-normal text-muted ms-2">{{lang('Report')}}</span></h4>
            </div>
        </div>
        <!--End Page header-->

    	<div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{lang('Employee Reports')}}</h4>
                </div>
                <div class="card-body" style="min-height: 250px;">
                    <div class="table-responsive">
                        <table class="table table-bordered border-bottom text-nowrap w-100" id="reports">
                            <thead>
                                <tr>
                                    <th width="10">{{lang('Sl.No')}}</th>
                                    <th>{{lang('Name')}}</th>
                                    <th>{{lang('Rating')}}</th>
                                    <th>{{lang('Overall Rating')}}</th>
                                    <th>{{lang('Total Answered Ticket')}}</th>
                                    <th>{{lang('Actions')}}</th>
                                </tr>
                            </thead>
                            <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                                <p>{{lang('loading.. Please Wait')}}</p>
                            </div>
                        </table>
                    </div>
                </div>
            </div>
        </div>


@endsection


@section('scripts')

<!-- INTERNAL Apexchart js-->
<script src="{{asset('build/assets/plugins/apexchart/apexcharts.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Data tables -->
<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/datatablebutton.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/buttonbootstrap.min.js')}}?v=<?php echo time(); ?>"></script>

<script type="text/javascript">

    "use strict";

    document.addEventListener("DOMContentLoaded", (event) => {

        let tableData = @json($users);

        let dateFormat = @json(setting('date_format'));

        var dataTable;
        var tableDropDown;

        loadTable(tableData);

        function truncateTitle(title) {
            const maxLength = 40;
            return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
        }

        function dateTime(createdTime) {

            const jsDate = new Date(createdTime);

            let format = @json(setting('date_format'));
            switch (format) {
                case 'd M, Y':
                    return jsDate.toLocaleDateString('en-GB', {
                        day: '2-digit',
                        month: 'short',
                        year: 'numeric'
                    });
                case 'm.d.y':
                    return jsDate.toLocaleDateString('en-US', {
                        day: '2-digit',
                        month: '2-digit',
                        year: '2-digit'
                    }).replace(/\//g, '.');
                case 'Y-m-d':
                    return jsDate.toISOString().split('T')[0];
                case 'd-m-Y':
                    return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                case 'd/m/Y':
                    return jsDate.toLocaleDateString('en-GB');
                case 'Y/m/d':
                    return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                default:
                    return jsDate.toLocaleDateString(); // Default format
            }

        }

        function generateProfileUrl(imagePath, storageDisk) {
            var baseUrl = "{{ route('getprofile.url', ['imagePath' => ':imagePath', 'storage_disk' => ':storage_disk']) }}";
            return baseUrl.replace(':imagePath', encodeURIComponent(imagePath)).replace(':storage_disk', encodeURIComponent(storageDisk));
        }

        function loadTable(tableData) {
            document.getElementById('hideAfterloading')?.classList.remove('d-none');
            document.getElementById('theadShow')?.classList.add('d-none');
            if (tableDropDown)
                tableDropDown.destroy();

            if (dataTable)
                dataTable.destroy();

            if (document.getElementById('tableBody'))
                document.getElementById('tableBody').remove();

            let createTbody = document.createElement('tbody');
            createTbody.setAttribute('id', "tableBody");
            let rows = tableData.map((data, index) => {
                var viewRouteUrl = "{{ route('admin.reports.employeedetails', ['id' => ':id']) }}".replace(':id', data.id);

                return `
                    <tr>
                        <td>${index + 1}</td>

                        <td>
                            <div class="media mt-0 align-items-center flex-wrap">
                                ${data.image == null ?
                                    `<img src="{{asset('uploads/profile/user-profile.png')}}" class="avatar avatar-md rounded-circle me-3 my-auto" alt="">`
                                    :
                                    `<img src="${generateProfileUrl(data.image, data.storage_disk)}" class="avatar avatar-md rounded-circle me-3 my-auto" alt="">`
                                }

                                <div class="media-body">
                                    <div class="d-flex align-items-center">
                                        <div class="mt-0">
                                            <h5 class="mb-0 fs-13 font-weight-sembold text-dark">${data.name}</h5>
                                            ${data.roles[0].name ? `<small class="fs-12 text-muted"><span class="font-weight-normal1"><b>(${data.roles[0].name})</b></span></small>` : ''}

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>

                        <td>
                            <div class="allemployeerating pt-1" data-rating="${data.rating}"></div>
                        </td>

                        <td>
                            ${data.overallcount}
                        </td>

                        <td>
                            ${data.comentticketss}
                        </td>

                        <td>
                            <div class = "d-flex">
                                <a href="${viewRouteUrl}" class="action-btns1" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('View')}}"><i class="feather feather-eye text-primary"></i></a>
                            </div>

                        </td>

                    </tr>
                `;
            });

            if (tableData.length == 0)
                createTbody.innerHTML = ` `;
            else
                createTbody.innerHTML = rows.join('');


            // Append the tbody to your table
            // Replace 'your-table-id' with the actual ID of your table element
            document.getElementById('reports').appendChild(createTbody);

            document.getElementById('hideAfterloading')?.classList.add('d-none');
            document.getElementById('theadShow')?.classList.remove('d-none');

            $(document).ready(function() {

                var SITEURL = '{{ url('') }}';

                // Csrf field
                $.ajaxSetup({
                    headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });


                let prev = {!! json_encode(lang("Previous")) !!};
                let next = {!! json_encode(lang("Next")) !!};
                let nodata = {!! json_encode(lang("No data available in table")) !!};
                let noentries = {!! json_encode(lang("No entries to show")) !!};
                let showing = {!! json_encode(lang("showing page")) !!};
                let ofval = {!! json_encode(lang("of")) !!};
                let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                let maxRecords = {!! json_encode(lang("records")) !!};
                let entries = {!! json_encode(lang("entries")) !!};
                let show = {!! json_encode(lang("Show")) !!};
                let search = {!! json_encode(lang("Search")) !!};
                // Datatable
                $('#reports').dataTable({
                    language: {
                        searchPlaceholder: search,
                        scrollX: "100%",
                        sSearch: '',
                        paginate: {
                        previous: prev,
                        next: next
                        },
                        emptyTable : nodata,
                        infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                        info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                        infoEmpty: noentries,
                        lengthMenu: `${show} _MENU_ ${entries} `,
                    },
                    order:[],
                    columnDefs: [
                        { "orderable": false, "targets":[ 0,1,4] }
                    ],
                });

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

                $('.form-select').on('focus', function() {
                    $(this).attr('aria-hidden', 'false');
                });
            });


            initializeTooltips();

            function initializeTooltips() {
                var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                tooltipElements.forEach(function(element) {
                    new bootstrap.Tooltip(element);
                });
            }


        }

        $(function() {
            $(".allemployeerating").starRating({
                readOnly: true,
                starSize: 25,
                emptyColor  :  '#ffffff',
                activeColor :  '#F2B827',
                strokeColor :  '#F2B827',
                strokeWidth :  15,
                useGradient : false
            });
        })
    });

</script>

@endsection
