@extends('layouts.adminmaster')

@section('styles')
    <!-- INTERNAL Data table css -->
    <link href="{{ asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />
    <link href="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />
    <link href="{{ asset('build/assets/plugins/datatable/buttonbootstrap.min.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />
@endsection

@section('content')
    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{ lang('Reports') }}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <!--Reports List-->
    <div class="row row-deck">
        <div class="col-xl-4 col-md-12 col-sm-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex border-0">
                    <h4 class="card-title">{{ lang('Employees') }}</h4>
                    <div class="card-options">
                        <a class="btn btn-light btn-sm" href="{{ route('employee') }}">{{ lang('View All') }}</a>
                    </div>
                </div>
                <div class="card-body mx-auto">
                    <div id="userchart" class=""></div>
                    <div class="sales-chart pt-5 pb-3 d-flex mx-auto text-center justify-content-center gap-3">
                        <div class="d-flex"><span class="dot-label bg-success me-2 my-auto"></span>{{ lang('Active') }}
                        </div>
                        <div class="d-flex"><span class="dot-label bg-warning  me-2 my-auto"></span>{{ lang('Inactive') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-md-12 col-sm-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex border-0">
                    <h4 class="card-title">{{ lang('Customers') }}</h4>
                    <div class="card-options">
                        <a class="btn btn-light btn-sm" href="{{ route('admin.customer') }}">{{ lang('View All') }}</a>
                    </div>
                </div>
                <div class="card-body">
                    <div id="customerchart" class=""></div>
                    <div class="sales-chart pt-5 pb-3 d-flex mx-auto text-center justify-content-center gap-3">
                        <div class="d-flex"><span
                                class="dot-label bg-success me-2 my-auto"></span>{{ lang('Active') }}
                        </div>
                        <div class="d-flex"><span class="dot-label bg-warning  me-2 my-auto"></span>{{ lang('Inactive') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-md-12 col-sm-12 col-lg-12">
            <div class="card">
                <div class="card-header border-bottom-0">
                    <h3 class="card-title">
                        {{ lang('Chats') }}
                    </h3>
                </div>
                <div class="card-body pb-8 mx-auto">
                    <div id="chatdata" class="mx-auto"></div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-md-12 col-sm-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex border-0">
                    <h4 class="card-title">{{ lang('Ticket') }}</h4>
                    @can('All Tickets')
                        <div class="card-options">
                            <a class="btn btn-light btn-sm" href="{{ route('admin.alltickets', ['ticketdata' => 'alltickets'])}}">{{ lang('View All') }}</a>
                        </div>
                    @endcan

                </div>
                <div class="card-body mx-auto">
                    <div id="ticketchart" class=""></div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-md-12 col-sm-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex border-bottom-0">
                    <h3 class="card-title">
                        {{ lang('Knowledge Base') }}
                    </h3>
                    <div class="card-options">
                        <a class="btn btn-light btn-sm"
                            href="{{ route('admin.article.index') }}">{{ lang('View All') }}</a>
                    </div>
                </div>
                <div class="card-body pb-8 mx-auto">
                    <div id="article" class="mx-auto"></div>
                </div>
            </div>
        </div>


        <div class="col-xl-4 col-md-12 col-sm-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex border-bottom-0">
                    <h3 class="card-title">{{ lang('Ratings For Employee') }}</h3>
                    <div class="card-options">
                        <a href="{{ route('admin.ticketreports') }}"
                            class="btn btn-light btn-sm">{{ lang('View All') }}</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="list-group">
                        @foreach ($users as $user)
                            <a href="javascript:void(0);">
                                <div class="list-group-item border-0 px-0 pt-0">
                                    <div class="media mt-0 align-items-center flex-wrap">
                                        @if ($user->image == null)
                                            <img src="{{ asset('uploads/profile/user-profile.png') }}"
                                                class="avatar-lg rounded-circle me-3 my-auto" alt="">
                                        @else
                                            <img src="{{ route('getprofile.url', ['imagePath' =>$user->image,'storage_disk'=>$user->storage_disk ?? 'public']) }}"
                                                class="avatar-lg rounded-circle me-3 my-auto" alt="">

                                        @endif

                                        <div class="media-body">
                                            <div class="d-flex align-items-center">
                                                <div class="mt-0">
                                                    @if (!empty($user->getRoleNames()[0]))
                                                        <h5 class="mb-0 fs-13 font-weight-sembold text-dark">
                                                            {{ $user->name }}
                                                        </h5>
                                                        <p class="mb-0 fs-12 text-muted">{{ $user->getRoleNames()[0] }}
                                                        </p>
                                                    @else
                                                        <h5 class="mb-0 fs-13 font-weight-sembold text-dark">
                                                            {{ $user->name }}
                                                        </h5>
                                                    @endif

                                                </div>
                                                @php

                                                    $avgrating1 = App\Models\Employeerating::where('user_id', $user->id)
                                                        ->where('rating', '1')
                                                        ->count();
                                                    $avgrating2 = App\Models\Employeerating::where('user_id', $user->id)
                                                        ->where('rating', '2')
                                                        ->count();
                                                    $avgrating3 = App\Models\Employeerating::where('user_id', $user->id)
                                                        ->where('rating', '3')
                                                        ->count();
                                                    $avgrating4 = App\Models\Employeerating::where('user_id', $user->id)
                                                        ->where('rating', '4')
                                                        ->count();
                                                    $avgrating5 = App\Models\Employeerating::where('user_id', $user->id)
                                                        ->where('rating', '5')
                                                        ->count();

                                                    $avgr = 5 * $avgrating5 + 4 * $avgrating4 + 3 * $avgrating3 + 2 * $avgrating2 + 1 * $avgrating1;
                                                    $avggr = $avgrating1 + $avgrating2 + $avgrating3 + $avgrating4 + $avgrating5;

                                                    if ($avggr == 0) {
                                                        $avggr = 1;
                                                        $avg = $avgr / $avggr;
                                                    } else {
                                                        $avg = $avgr / $avggr;
                                                    }

                                                    $rating = $avg;
                                                @endphp



                                                <span
                                                    class="rating-stars block uhelp-rating ms-auto w-auto allemployeerating"
                                                    data-rating="{{ $rating }}">
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-md-12 col-sm-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex border-bottom-0">
                    <h3 class="card-title">{{ lang('Employee Acivity Report') }}</h3>
                    <div class="card-options">
                        <a href="{{ route('admin.reports.employeeactivity') }}"
                            class="btn btn-light btn-sm">{{ lang('View All') }}</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="list-group">
                        @foreach ($activity as $actvty)
                            <div class="d-flex align-items-top mb-2">
                                <div class="me-2 lh-1">
                                    @if ($actvty->user->image == null)
                                        <img src="{{ asset('uploads/profile/user-profile.png') }}" class="avatar-lg rounded-circle me-3 my-auto" alt="">
                                    @else
                                        <img src="{{ route('getprofile.url', ['imagePath' =>$actvty->user->image,'storage_disk'=>$actvty->user->storage_disk ?? 'public']) }}"
                                        class="avatar-lg rounded-circle me-3 my-auto" alt="">
                                    @endif
                                </div>
                                <div class="flex-fill w-50">
                                    <a href="javascript:void(0);" class="fw-semibold me-1">{{ $actvty->user->name }}</a>
                                    <span class="fw-semibold">{{ $actvty->activity_type }}</span>
                                    <div class="d-flex">
                                        <a href="javascript:void(0);" class="text-primary ">{{ $actvty->ip_address }}</a>
                                        @if ($actvty->browser)
                                            <span class="text-muted ms-2">{{ $actvty->browser }}</span>
                                        @endif
                                        @if ($actvty->device)
                                            <span class="text-muted ms-2">{{ $actvty->device }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="text-end">
                                    <span class="text-muted d-block">{{ $actvty->created_at->timezone(setting('default_timezone'))->format('h:i:sA') }}</span>
                                    <span class="d-block">{{ $actvty->created_at->timezone(setting('default_timezone'))->format('d,M Y') }}</span>
                                </div>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>

    </div>
    <!--End Reports List-->
@endsection


@section('scripts')
    <!-- INTERNAL Apexchart js-->
    <script src="{{ asset('build/assets/plugins/apexchart/apexcharts.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL Data tables -->
    <script src="{{ asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/dataTables.responsive.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/datatablebutton.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/buttonbootstrap.min.js') }}?v=<?php echo time(); ?>"></script>

    <script type="text/javascript">
        $(function() {
            "use strict";
            class nodata {
                constructor(ele) {
                    let div = document.createElement('div');
                    div.classList.add("d-flex");
                    div.classList.add("justify-content-center");
                    div.classList.add("align-items-center");
                    div.classList.add("flex-column");
                    let img = document.createElement('img');
                    img.src = `{{ asset('build/assets/images/no-data.png') }}`;
                    img.style.width = "200px";
                    img.style.height = "200px";
                    img.rel = "no Data";
                    let hr = document.createElement('hr');
                    let title = document.createElement('div');
                    title.classList.add("text-muted");
                    title.classList.add("fs-20");
                    title.textContent = "No Data Available";
                    div.append(img, title);
                    ele.append(div);
                }
            }

            // User Chart
            if (({{ $agentactivec }} !== 0) || ({{ $agentinactive }} !== 0)) {
                var userchart = {
                    series: [{{ $agentactivec }}, {{ $agentinactive }}],
                    chart: {
                        height: 280,
                        type: 'donut',
                    },
                    dataLabels: {
                        enabled: false
                    },

                    legend: {
                        show: false,
                    },
                    stroke: {
                        show: true,
                        width: 0
                    },
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '65%',
                                background: 'transparent',
                                labels: {
                                    show: true,
                                    name: {
                                        show: true,
                                        fontSize: '29px',
                                        color: '#6c6f9a',
                                        offsetY: -10
                                    },
                                    value: {
                                        show: true,
                                        fontSize: '26px',
                                        color: undefined,
                                        offsetY: 16,
                                        formatter: function(val) {
                                            return val
                                        }
                                    },
                                    total: {
                                        show: true,
                                        showAlways: false,
                                        label: '{{ lang('Total') }}',
                                        fontSize: '22px',
                                        fontWeight: 600,
                                        color: '#373d3f',
                                    }

                                }
                            }
                        }
                    },
                    responsive: [{
                        options: {
                            legend: {
                                show: false,
                            }
                        }
                    }],
                    labels: ["Active", "Inactive"],
                    colors: ['#0dcd94', '#fbc518'],
                };
                var chart = new ApexCharts(document.querySelector("#userchart"), userchart);
                chart.render();
            } else {
                let noData = new nodata(document.querySelector("#userchart"));
            }
            // End User Chart

            // Customer Chart
            if (({{ $customeractive }} !== 0) || ({{ $customerinactive }} !== 0)) {
                var customerchart = {
                    series: [{{ $customeractive }}, {{ $customerinactive }}],
                    chart: {
                        height: 280,
                        type: 'donut',
                    },
                    dataLabels: {
                        enabled: false
                    },

                    legend: {
                        show: false,
                    },
                    stroke: {
                        show: true,
                        width: 0
                    },
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '65%',
                                background: 'transparent',
                                labels: {
                                    show: true,
                                    name: {
                                        show: true,
                                        fontSize: '29px',
                                        color: '#6c6f9a',
                                        offsetY: -10
                                    },
                                    value: {
                                        show: true,
                                        fontSize: '26px',
                                        color: undefined,
                                        offsetY: 16,
                                        formatter: function(val) {
                                            return val
                                        }
                                    },
                                    total: {
                                        show: true,
                                        showAlways: false,
                                        label: '{{ lang('Total') }}',
                                        fontSize: '22px',
                                        fontWeight: 600,
                                        color: '#373d3f',
                                    }

                                }
                            }
                        }
                    },
                    responsive: [{
                        options: {
                            legend: {
                                show: false,
                            }
                        }
                    }],
                    labels: ["Active", "Inactive"],
                    colors: ['#0dcd94', '#fbc518'],
                };
                var chart = new ApexCharts(document.querySelector("#customerchart"), customerchart);
                chart.render();
            } else {
                let noData = new nodata(document.querySelector("#customerchart"));
            }
            // End Customer Chart

            $(".allemployeerating").starRating({
                readOnly: true,
                starSize: 25,
                emptyColor: '#ffffff',
                activeColor: '#F2B827',
                strokeColor: '#F2B827',
                strokeWidth: 15,
                useGradient: false
            });

            let prev = {!! json_encode(lang('Previous')) !!};
            let next = {!! json_encode(lang('Next')) !!};
            let datanotavail = {!! json_encode(lang('No data available in table')) !!};
            let noentries = {!! json_encode(lang('No entries to show')) !!};
            let showing = {!! json_encode(lang('showing page')) !!};
            let ofval = {!! json_encode(lang('of')) !!};
            let maxRecordfilter = {!! json_encode(lang('- filtered from ')) !!};
            let maxRecords = {!! json_encode(lang('records')) !!};
            let entries = {!! json_encode(lang('entries')) !!};
            let show = {!! json_encode(lang('Show')) !!};
            let search = {!! json_encode(lang('Search')) !!};
            // Datatable
            $('#reports').dataTable({
                language: {
                    searchPlaceholder: search,
                    scrollX: "100%",
                    sSearch: '',
                    paginate: {
                        previous: prev,
                        next: next
                    },
                    emptyTable: datanotavail,
                    infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                    info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                    infoEmpty: noentries,
                    lengthMenu: `${show} _MENU_ ${entries} `,
                },
                order: [],
                columnDefs: [{
                    "orderable": false,
                    "targets": [0, 1, 4]
                }],
            });

            $('.form-select').select2({
                minimumResultsForSearch: Infinity,
                width: '100%'
            });


            // Article Chart
            if (({{ $articlepublished }} !== 0) || ({{ $articleunpublished }} !== 0)) {
                var articleChart = {
                    series: [{{ $articlepublished }}, {{ $articleunpublished }}],
                    chart: {
                        height: 280,
                        type: 'donut',
                    },
                    dataLabels: {
                        enabled: false
                    },

                    legend: {
                        show: true,
                        position: 'bottom',
                        horizontalAlign: 'center',
                    },
                    stroke: {
                        show: true,
                        width: 0
                    },
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '65%',
                                background: 'transparent',
                                labels: {
                                    show: true,
                                    name: {
                                        show: true,
                                        fontSize: '29px',
                                        color: '#6c6f9a',
                                        offsetY: -10
                                    },
                                    value: {
                                        show: true,
                                        fontSize: '26px',
                                        color: undefined,
                                        offsetY: 16,
                                        formatter: function(val) {
                                            return val
                                        }
                                    },
                                    total: {
                                        show: true,
                                        showAlways: false,
                                        label: '{{ lang('Total') }}',
                                        fontSize: '22px',
                                        fontWeight: 600,
                                        color: '#373d3f',
                                    }

                                }
                            }
                        }
                    },
                    responsive: [{
                        options: {
                            legend: {
                                show: true,
                                position: 'bottom',
                                horizontalAlign: 'center',
                            }
                        }
                    }],
                    labels: ["Published", "Unpublished"],
                    colors: ['#ff6f31', '#128af9'],
                };
                var chart = new ApexCharts(document.querySelector("#article"), articleChart);
                chart.render();
            } else {
                let noData = new nodata(document.querySelector("#article"));
            }
            // Article Chart

            // Priority Chart
            if (({{ $newchatcount }} != 0) || ({{ $myopenedcount }} != 0) || ({{ $solvedcount }} != 0)) {
                var chatdatavar = {
                    series: [{{ $newchatcount }}, {{ $myopenedcount }}, {{ $solvedcount }}],
                    colors: ['#0dcd94', '#128af9', '#f7284a'],
                    chart: {
                        height: 280,
                        type: 'donut',
                    },
                    labels: ["New", "My opened", "Solved"],
                    legend: {
                        show: true,
                        position: 'bottom',
                        horizontalAlign: 'center',
                    },
                    hover: {
                        mode: null
                    },
                    stroke: {
                        show: true,
                        width: 0
                    },
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '65%',
                                background: 'transparent',
                                labels: {
                                    show: true,
                                    name: {
                                        show: true,
                                        fontSize: '29px',
                                        color: '#6c6f9a',
                                        offsetY: -10
                                    },
                                    value: {
                                        show: true,
                                        fontSize: '26px',
                                        color: undefined,
                                        offsetY: 16,
                                        formatter: function(val) {
                                            return val
                                        }
                                    },
                                    total: {
                                        show: true,
                                        showAlways: false,
                                        label: '{{ lang('Total') }}',
                                        fontSize: '22px',
                                        fontWeight: 600,
                                        color: '#373d3f',
                                    }

                                },
                            }
                        }
                    },
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200,

                            },
                            legend: {
                                show: true,
                                position: 'bottom',
                                horizontalAlign: 'center',
                            }
                        }
                    }]
                };
                var chatdatachart = new ApexCharts(document.querySelector("#chatdata"), chatdatavar);
                chatdatachart.render();
            } else {
                let noData = new nodata(document.querySelector("#chatdata"));
            }
            // Priority Chart
            // Ticket Chart
            if (({{ $unassingedticketscount }} != 0) || ({{ $assignedticketscount }} != 0) || ({{ $myclosedticketscount }} != 0)) {
                var ticketchart = {
                    series: [{{ $unassingedticketscount }}, {{ $assignedticketscount }}, {{ $myclosedticketscount }}],
                    colors: ['#0dcd94', '#128af9', '#f7284a'],
                    chart: {
                        height: 280,
                        type: 'donut',
                    },
                    labels: ["Unassigned", "Assigned", "Solved"],
                    // dataLabels: {
                    //     enabled: false
                    // },
                    legend: {
                        show: true,
                        position: 'bottom',
                        horizontalAlign: 'center',
                    },
                    hover: {
                        mode: null
                    },
                    stroke: {
                        show: true,
                        width: 0
                    },
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '65%',
                                background: 'transparent',
                                labels: {
                                    show: true,
                                    name: {
                                        show: true,
                                        fontSize: '29px',
                                        color: '#6c6f9a',
                                        offsetY: -10
                                    },
                                    value: {
                                        show: true,
                                        fontSize: '26px',
                                        color: undefined,
                                        offsetY: 16,
                                        formatter: function(val) {
                                            return val
                                        }
                                    },
                                    total: {
                                        show: true,
                                        showAlways: false,
                                        label: '{{ lang('Total') }}',
                                        fontSize: '22px',
                                        fontWeight: 600,
                                        color: '#373d3f',
                                    }

                                }
                            }
                        }
                    },
                    responsive: [{
                        breakpoint: 480,
                        options: {
                            chart: {
                                width: 200,
                            },
                            legend: {
                                show: true,
                                position: 'bottom',
                                horizontalAlign: 'center',
                            }
                        }
                    }]
                };
                var chart = new ApexCharts(document.querySelector("#ticketchart"), ticketchart);
                chart.render();
            } else {
                let noData = new nodata(document.querySelector("#ticketchart"));
            }
            // Ticket Chart
        })
    </script>
@endsection
