@extends('layouts.adminmaster')

@section('styles')

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{ asset('build/assets/plugins/sweet-alert/sweetalert.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />
@endsection

@section('content')

    <div id="loadingDiv" class="d-none" style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 99;">
        <img src="https://laravelui.spruko.com/dayone/assets/images/svgs/loader.svg" alt="">
    </div>
    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{ lang('Translation') }} / {{ $language->languagename }}</span></h4>
        </div>
    </div>
    <!--End Page header-->
    <!-- row -->
    <div class="col-xl-12">
        <div class="card buttons-translate">
            <div class="card-header p-3 px-5">
                <h4 class="card-title mb-0">{{ lang('Translate') }}</h4>
                <div class="card-options">
                    <button class="btn btn-success me-3" id="autoTranslate">{{ lang('Auto Translate') }}</button>
                    <form action="{{ request()->url() }}" method="GET">
                        <div class="input-group translate-input">
                            <input type="text" class="form-control" name="search" placeholder="{{ lang('Search') }}" value="{{ request()->input('search') ?? '' }}">
                            <button type="submit" class="btn btn-outline-light"><i class="fe fe-search"></i></button>
                            <button type="button" class="btn btn-outline-light dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                <span>{{ lang('Filters') }} <i class="fa fa-angle-down ms-1"></i></span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item" href="{{ request()->url() . '?filter=missing' }}">{{ lang('Missing Translates') }}</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.languages.translate', $language->languagecode) }}">{{ lang('All Translates') }}</a>
                                </li>
                            </ul>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card-body p-0 pt-4">
                @if ($translates_count > 0)
                    <div class="px-5 mb-4">
                        <div class="alert alert-light-warning d-flex px-5 py-2" role="alert">
                            <div class="me-3">
                                <i class="fe fe-alert-circle fs-30"></i>
                            </div>
                            <div>
                                <h4 class="alert-heading fs-15 font-weight-semibold mb-0">
                                    {{ lang('This language is incomplete') }}</h4>
                                <p class="fs-13 mb-0">{{ $translates_count }}
                                    {{ lang('translations are missing. You can') }}
                                    <a
                                        href="{{ request()->url() . '?filter=missing' }}">{{ lang('filter this page') }}</a>
                                    {{ lang(' to show missing translations.') }}
                                </p>
                            </div>
                        </div>
                    </div>
                {{-- @else
                    <div class="px-5 mb-4">
                        <div class="alert alert-light-warning d-flex px-5 py-2" role="alert">
                            <div class="me-3">
                                <i class="fe fe-alert-circle fs-30"></i>
                            </div>
                            <span class="mt-1">{{ lang('Translations are not available') }}</span>
                        </div>
                    </div> --}}
                @endif
                <form action="{{ route('admin.languages.translates.update', $language->id) }}" id="translationsForm" method="POST">
                    @csrf
                </form>
            </div>
            {{-- @if ($translates_count > 0) --}}
                <div class="card-footer">
                    <div class="float-end">
                        <button form="translationsForm" class="btn btn-secondary" type="submit">{{ lang('Save Changes') }}</button>
                    </div>
                </div>
            {{-- @endif --}}
        </div>
    </div>
    <!-- row closed -->
@endsection

@section('scripts')

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{ asset('build/assets/plugins/sweet-alert/sweetalert.min.js') }}?v=<?php echo time(); ?>"></script>

    <script>
        'use strict';
        document.addEventListener('DOMContentLoaded', function() {

            let toastData = localStorage.getItem('success');
            if (toastData) {
                toastr.success(toastData)
            }
            let etoastData = localStorage.getItem('error');
            if (etoastData) {
                toastr.error(etoastData)
            }
            let groups = @json($groups);
            let language = @json($language);

            let createNav = document.createElement('nav');
            let navButtons = Object.keys(groups).map((group, index) => `
                <button class="nav-link${index === 0 ? ' active' : ''}"
                    id="nav-${group}-tab"
                    data-bs-toggle="tab"
                    data-bs-target="#nav-${group}"
                    type="button"
                    role="tab"
                    aria-controls="nav-${group}"
                    aria-selected="${index === 0 ? 'true' : 'false'}">
                    ${group.charAt(0).toUpperCase() + group.slice(1)}
                </button>
            `).join('');

            createNav.innerHTML = `
                <div class="px-5 py-0 nav nav-tabs tabs-div" id="nav-tab" role="tablist">
                    ${navButtons}
                </div>
            `;

            // Append the nav to the desired parent element
            const formElement = document.querySelector('.card-body form');

            // Insert createNav before the form
            if (formElement) {
                formElement.parentNode.insertBefore(createNav, formElement);
            }

            // Create tab content
            let tabContent = document.createElement('div');
            tabContent.className = "tab-content";
            tabContent.id = "nav-tabContent";

            // Build tab panes
            let tabPanes = Object.entries(groups).map(([group, translations], index) => {

                let translationAreas;
                if(Object.entries(translations).length > 0){
                    translationAreas = Object.entries(translations).map(([key, value]) => `
                        <div class="d-flex translation-area">
                            <div class="flex-grow-1">
                                <textarea class="form-control tranlation-height" aria-label="With textarea" rows="1" readonly>${key}</textarea>
                            </div>
                            <div class="p-2">
                                <i class="fe fe-chevron-right text-muted"></i>
                            </div>
                            <div class="flex-grow-1">
                                <textarea class="form-control tranlation-height" placeholder="{{ lang('Enter Translated Text') }}" aria-label="With textarea" rows="1" name="${key.replace(/\./g, '$')}">${value ?? ''}</textarea>
                            </div>
                        </div>
                    `).join('');
                }else{
                    translationAreas = `
                        <div class="d-flex translation-area text-center justify-content-center">
                            <span class="mt-1 text-align-center content-justify-center">{{ lang('Search data not available') }}</span>
                        </div>
                    `;

                    document.querySelector('.card-footer').remove();
                }


                return `
                    <div class="tab-pane fade${index === 0 ? ' show active' : ''}" id="nav-${group}" role="tabpanel" aria-labelledby="nav-${group}-tab" tabindex="0">
                        ${translationAreas}
                    </div>
                `;
            }).join('');

            // Set the tab panes innerHTML in one go
            tabContent.innerHTML = tabPanes;
            let parentDiv = document.createElement('div');
            parentDiv.className = 'p-5';
            parentDiv.appendChild(tabContent)
            formElement.appendChild(parentDiv);

            const lang = @json($language);
            let working = false;

            let autoTranslateBtn = document.querySelector('#autoTranslate');
            let controller = new AbortController(); // Create an AbortController
            autoTranslateBtn.onclick = async (e) =>{
                const willTranslate = await swal({
                    title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                    text: "{{ lang('This might take a while to be done. Please be patient for the next few minutes.', 'alerts') }}",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                });

                if (willTranslate) {
                    document.querySelector('#loadingDiv').classList.remove('d-none');
                    document.querySelector('.col-xl-12').style.filter = 'blur(1px)';
                    document.querySelector('.col-xl-12').style.pointerEvents = 'none';
                    try {
                        working = true;
                        const url = '{{ route("language.translate") }}';
                        const data = {
                            lang: lang.languagecode,
                        };
                        const response = await fetch(url, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify(data) ,
                            signal: controller.signal
                        });

                        if (!response.ok) {
                            throw new Error('Network response was not ok ' + response.statusText);
                        }

                        const responseData = await response.json();

                        if (responseData.success) {
                            working = false;
                            location.reload();
                            localstorage.setItem('success', responseData.success);
                        } else {
                            working = false;
                            location.reload();
                            localstorage.setItem('error', responseData.error);
                        }
                    } catch (error) {
                        if (error.name === 'AbortError') {
                            console.log('Translation process was cancelled.');
                        } else {
                            console.error('An error occurred:', error);
                        }
                        location.reload();
                    } finally {
                        document.querySelector('#loadingDiv').classList.add('d-none');
                        document.querySelector('.col-xl-12').style.filter = 'none';
                        document.querySelector('.col-xl-12').style.pointerEvents = '';
                    }
                };
            }
            window.addEventListener("beforeunload", (e) => {
                if (working) {
                    // This message is ignored in most browsers but required for the dialog to show.
                    const confirmationMessage = '{{ lang("Auto translation in progress. Are you sure you want to leave this page?") }}';

                    e.preventDefault(); // Prevent the default action
                    e.returnValue = confirmationMessage; // Display the confirmation message
                    return confirmationMessage; // For some browsers
                }
            });
        });
    </script>
@endsection
