
@extends('layouts.adminmaster')



@section('content')

<!--Page header-->
<div class="page-header d-xl-flex d-block">
    <div class="page-leftheader">
        <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Captcha Setting', 'menu')}}</span></h4>
    </div>
</div>
<!--End Page header-->

<!--Captcha Enable/Disable-->
<div class="col-xl-12 col-lg-12 col-md-12">
    <div class="card ">
        <div class="card-header border-0 flex-wrap gap-2">
            <h4 class="card-title">{{lang('Captcha Enable/Disable')}}</h4>
            <div class="card-options card-header-styles mt-sm-max-2">
                <small class="me-1 mt-1">{{lang('Captcha Disable', 'setting')}}</small>
                <div class="float-end mt-0">
                    <div class="switch-toggle">
                        <a class="onoffswitch2">
                        <input type="radio"  name="CAPTCHATYPE" id="myonoffswitch181" class=" toggle-class onoffswitch2-checkbox sprukocaptcha" value="off" @if(setting('CAPTCHATYPE') == 'off') checked="" @endif>
                        <label for="myonoffswitch181" class="toggle-class onoffswitch2-label"></label>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body" >
            <div class="switch_section">
                <div class="switch-toggle d-flex d-md-max-block">
                    <a class="onoffswitch2">
                        <input type="radio"  name="CAPTCHATYPE" id="myonoffswitch180" class=" toggle-class onoffswitch2-checkbox sprukocaptcha" value="manual"  @if(setting('CAPTCHATYPE') == 'manual') checked="" @endif>
                        <label for="myonoffswitch180" class="toggle-class onoffswitch2-label"></label>
                    </a>
                    <label class="form-label ps-3 ps-md-max-0">{{lang('Manual Captcha Enable', 'setting')}}</label>
                    <small class="text-muted ps-1 ps-md-max-0"><i>({{lang('This setting will enable the "Manual" captcha.', 'setting')}})</i></small>
                </div>
            </div>
            <div class="switch_section">
                <div class="switch-toggle d-flex d-md-max-block">
                    <a class="onoffswitch2">
                        <input type="radio"  name="CAPTCHATYPE" id="myonoffswitch182" class=" toggle-class onoffswitch2-checkbox sprukocaptcha" value="google"  @if(setting('CAPTCHATYPE') == 'google') checked="" @endif>
                        <label for="myonoffswitch182" class="toggle-class onoffswitch2-label"></label>
                    </a>
                    <label class="form-label ps-3 ps-md-max-0">{{lang('Google Captcha Enable', 'setting')}}</label>
                    <small class="text-muted ps-1 ps-md-max-0"><i>({{lang('This setting will enable the "Google" captcha.', 'setting')}})</i></small>
                </div>
            </div>
        </div>
    </div>
</div>
<!--End Captcha Enable/Disable-->

<!--Google Re-Captcha Setting-->
<div class="col-xl-12 col-lg-12 col-md-12" id="hidesettings">
    <div class="card ">
        <div class="card-header border-0">
            <h4 class="card-title">{{lang('Google Re-Captcha Setting')}}</h4>
        </div>
        <form method="POST" action="{{ route('settings.captcha.store') }}" enctype="multipart/form-data">
            <div class="card-body" >
                @csrf
                @honeypot
                <div class="row recaptcharowdiv">
                    <div class="col-sm-12 col-md-12 ">
                        <div class="form-group {{ $errors->has('googlerecaptchakey') ? ' has-danger' : '' }}">
                            <label class="form-label">{{lang('Site Key')}} <span class="text-red">*</span></label>
                            <input type="text" class="form-control {{ $errors->has('googlerecaptchakey') ? ' is-invalid' : '' }}"  name="googlerecaptchakey" placeholder="{{lang('Site key')}}" value="{{ old('googlerecaptchakey', setting('GOOGLE_RECAPTCHA_KEY')) }}" id="recaptcha-site-key-input">
                            @if ($errors->has('googlerecaptchakey'))
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $errors->first('googlerecaptchakey') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-12">
                        <div class="form-group {{ $errors->has('googlerecaptchasecret') ? ' has-danger' : '' }}">
                            <label class="form-label">{{lang('Secret Key')}} <span class="text-red">*</span></label>
                            <input type="text" class="form-control {{ $errors->has('googlerecaptchasecret') ? ' is-invalid' : '' }}" name="googlerecaptchasecret" placeholder="{{lang('Secret Key')}}" value="{{ old('googlerecaptchasecret', setting('GOOGLE_RECAPTCHA_SECRET')) }}">
                            @if ($errors->has('googlerecaptchasecret'))
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $errors->first('googlerecaptchasecret') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer ">
                <div class="form-group float-end">
                    <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                </div>
            </div>
        </form>
    </div>
</div>
<!--End Google Re-Captcha Setting-->

@endsection

@section('scripts')


<!-- Captcha js-->
<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script type="text/javascript">
    $(function() {
        "use strict";

        (function($)  {

            if(document.querySelector("#myonoffswitch181").checked || document.querySelector("#myonoffswitch180").checked){
                document.getElementById('hidesettings').classList.add('d-none');
            }

            document.querySelectorAll('#myonoffswitch182, #myonoffswitch180, #myonoffswitch181').forEach( e => {
                e.addEventListener('click', function(){
                    if(document.getElementById('myonoffswitch182').checked){
                    document.getElementById('hidesettings').classList.remove('d-none');
                    }
                    else{
                    document.getElementById('hidesettings').classList.add('d-none');
                    }
                })
            })

            // Csrf Field
            $.ajaxSetup({
                headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // enable on captcha type
            $('.sprukocaptcha').on('change', function(){
                var captchatype = $(this).val()
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: '{{url('admin/captchatype')}}',
                    data:{'captchatype':captchatype},

                    success:function(data){
                        toastr.success(data.success);
                    },
                    error:function(data){
                        toastr.error('{{lang('Setting Not Updated', 'alerts')}}');
                    }
                });

            });

        })(jQuery);
    })
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var recaptchaWidgetId;

        function renderRecaptchaWidget(siteKey) {
            if (!siteKey) {
                console.error('Site key is missing');
                return;
            }

            $('#recaptcha-widget').remove()
            let node = document.createElement('div')
            node.id = 'recaptcha-widget'
            node.setAttribute('data-sitekey',siteKey)
            document.querySelector(".recaptcharowdiv").appendChild(node)
            grecaptcha.render('recaptcha-widget', {
                'sitekey': siteKey
            });

        }

        var siteKeyInput = document.getElementById('recaptcha-site-key-input');
        siteKeyInput.addEventListener('input', function() {
            var newSiteKey = siteKeyInput.value;
            renderRecaptchaWidget(newSiteKey);
        });
        if (siteKeyInput.value) {
            renderRecaptchaWidget(siteKeyInput.value);
        }
    });
</script>

@endsection
