@extends('layouts.adminmaster')

		@section('styles')

		<!-- INTERNAl Summernote css -->
		<link rel="stylesheet" href="{{asset('build/assets/plugins/summernote/summernote.css')}}?v=<?php echo time(); ?>">

		<!-- INTERNAL Data table css -->
		<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
		<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

		<!-- INTERNAL Sweet-Alert css -->
		<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

        <style>
            #hideAfterloading {
                position: absolute;
                top: 100px;
                left: 45%;
            }
        </style>

		@endsection

							@section('content')

							<!--Page header-->
							<div class="page-header d-xl-flex d-block">
								<div class="page-leftheader">
									<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Pages', 'menu')}}</span></h4>
								</div>
							</div>
							<!--End Page header-->

							<!-- Privacy Policy & Terms of Use List -->
							<div class="col-xl-12 col-lg-12 col-md-12">
								<div class="card ">
									<div class="card-header border-0">
										<h4 class="card-title">{{lang('Pages', 'menu')}}</h4>
										<div class="card-options mt-sm-max-2">
											@can('Pages Create')
                                                <a href="{{route('pages.createpage')}}" class="btn btn-secondary me-3">{{lang('Create Page')}}</a>
											@endcan
										</div>
									</div>
									<div class="card-body" style="min-height: 250px;">
										@can('Pages Delete')
										  <button id="massdelete" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
										@endcan
										<div class="table-responsive">
											<table class="table table-bordered border-bottom text-nowrap w-100" id="support-articlelists">
												<thead>
													<tr>
														<th  width="10">{{lang('Sl.No')}}</th>
														@cannot('Pages Delete')

														<th>
															<input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
															<label  for="customCheckAll"></label>
														</th>
														@endcannot
														@can('Pages Delete')

														<th>
															<input type="checkbox"  id="customCheckAll" class="form-check-input" >
															<label  for="customCheckAll"></label>
														</th>
														@endcan
														<th >{{lang('Name')}}</th>
														<th >{{lang('Created Date')}} </th>
														<th >{{lang('Action')}}</th>
													</tr>
												</thead>
												<div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                                                    <p>{{lang('loading.. Please Wait')}}</p>
                                                </div>
											</table>
										</div>
									</div>
								</div>
							</div>
							<!-- End Privacy Policy & Terms of Use List -->

							@endsection

		@section('scripts')

		<!-- INTERNAL Summernote js  -->
		<script src="{{asset('build/assets/plugins/summernote/summernote.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Data tables -->
		<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
		<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>

		<!-- INTERNAL Index js-->
        @vite(['resources/assets/js/support/support-sidemenu.js'])
        @vite(['resources/assets/js/support/support-articles.js'])

		<!--File BROWSER -->
        @vite(['resources/assets/js/form-browser.js'])

		<!-- INTERNAL Sweet-Alert js-->
		<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>


        <script type="text/javascript">
            "use strict";

            document.addEventListener("DOMContentLoaded", (event) => {

                let tableData = @json($page);

                let dateFormat = @json(setting('date_format'));
                let delPerm = @json(Auth::user()->can('Pages Delete'));
                let editPerm = @json(Auth::user()->can('Pages Edit'));
                let viewPerm = @json(Auth::user()->can('Pages View'));

                var dataTable;
                var tableDropDown;

                loadTable(tableData);

                function truncateTitle(title) {
                    const maxLength = 40;
                    return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
                }

                function dateTime(createdTime) {

                    const jsDate = new Date(createdTime);

                    let format = @json(setting('date_format'));
                    switch (format) {
                        case 'd M, Y':
                            return jsDate.toLocaleDateString('en-GB', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric'
                            });
                        case 'm.d.y':
                            return jsDate.toLocaleDateString('en-US', {
                                day: '2-digit',
                                month: '2-digit',
                                year: '2-digit'
                            }).replace(/\//g, '.');
                        case 'Y-m-d':
                            return jsDate.toISOString().split('T')[0];
                        case 'd-m-Y':
                            return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                        case 'd/m/Y':
                            return jsDate.toLocaleDateString('en-GB');
                        case 'Y/m/d':
                            return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                        default:
                            return jsDate.toLocaleDateString(); // Default format
                    }

                }

                function loadTable(tableData) {
                    document.getElementById('hideAfterloading')?.classList.remove('d-none');
                    document.getElementById('theadShow')?.classList.add('d-none');
                    if (tableDropDown)
                        tableDropDown.destroy();

                    if (dataTable)
                        dataTable.destroy();

                    if (document.getElementById('tableBody'))
                        document.getElementById('tableBody').remove();

                    let createTbody = document.createElement('tbody');
                    createTbody.setAttribute('id', "tableBody");
                    let rows = tableData.map((data, index) => {
                        var showRouteUrl = "{{ route('pages.show', ['id' => ':id']) }}".replace(':id', data.id);
                        var pageslugRouteUrl = "{{ route('pageshow.pageslug', ['pageslug' => ':id']) }}".replace(':id', data.pageslug);

                        return `
                            <tr>
                                <td>${index + 1}</td>

                                <td>
                                    ${delPerm ? `<input type="checkbox" name="custom_checkbox[]" class="checkall form-check-input" value="${data.id}" />` : '~'}
                                </td>

                                <td>${truncateTitle(data.pagename)}</td>

                                <td>${dateTime(data.created_at)}</td>

                                <td>
                                    <div class = "d-flex">
                                        ${editPerm ? `<a href="${showRouteUrl}" class="action-btns1"><i class="feather feather-edit text-primary" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i></a>` : ''}

                                        ${viewPerm ? `<a href="${pageslugRouteUrl}"  class="action-btns1" target="_blank" ><i class="feather feather-eye text-primary"  data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('View')}}"></i></a>` : ''}

                                        ${delPerm ? `<a href="javascript:void(0)" class="action-btns1 delete-pages" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="" data-bs-original-title="{{lang('Delete')}}" aria-label="Delete"><i class="feather feather-trash-2 text-danger" data-id="${data.id}"></i></a>` : ''}
                                    </div>

                                </td>

                            </tr>
                        `;
                    });

                    if (tableData.length == 0)
                        createTbody.innerHTML = ` `;
                    else
                        createTbody.innerHTML = rows.join('');


                    // Append the tbody to your table
                    // Replace 'your-table-id' with the actual ID of your table element
                    document.getElementById('support-articlelists').appendChild(createTbody);

                    document.getElementById('hideAfterloading')?.classList.add('d-none');
                    document.getElementById('theadShow')?.classList.remove('d-none');

                    // var myTable = document.querySelector("#support-category");

                    $(document).ready(function() {

                        var SITEURL = '{{ url('') }}';

                        // Csrf field
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        let prev = {!! json_encode(lang("Previous")) !!};
                        let next = {!! json_encode(lang("Next")) !!};
                        let nodata = {!! json_encode(lang("No data available in table")) !!};
                        let noentries = {!! json_encode(lang("No entries to show")) !!};
                        let showing = {!! json_encode(lang("showing page")) !!};
                        let ofval = {!! json_encode(lang("of")) !!};
                        let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                        let maxRecords = {!! json_encode(lang("records")) !!};
                        let entries = {!! json_encode(lang("entries")) !!};
                        let show = {!! json_encode(lang("Show")) !!};
                        let search = {!! json_encode(lang("Search")) !!};
                        // Datatable
                        $('#support-articlelists').dataTable({
                            language: {
                                searchPlaceholder: search,
                                scrollX: "100%",
                                sSearch: '',
                                paginate: {
                                previous: prev,
                                next: next
                                },
                                emptyTable : nodata,
                                infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                                info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                                infoEmpty: noentries,
                                lengthMenu: `${show} _MENU_ ${entries} `,
                            },
                            order:[],
                            columnDefs: [
                                { "orderable": false, "targets":[ 0,1,4] }
                            ],
                        });

                        $('.form-select').select2({
                            minimumResultsForSearch: Infinity,
                            width: '100%'
                        });

                        $('.form-select').on('focus', function() {
                            $(this).attr('aria-hidden', 'false');
                        });
                    });


                    initializeTooltips();

                    function initializeTooltips() {
                        var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                        tooltipElements.forEach(function(element) {
                            new bootstrap.Tooltip(element);
                        });
                    }


                }

                $(function() {

                    (function($)  {

                        // Variables
                        var SITEURL = '{{url('')}}';

                        /* When click delete pages */
                        $('body').on('click', '.delete-pages', function () {
                            let parent = $(this).closest('tr');
                            var _id = $(this).data("id");
                            swal({
                                title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                                text: "{{lang('This might erase your records permanently', 'alerts')}}",
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                            })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        type: "post",
                                        url: SITEURL + "/admin/pagesdelete/"+_id,
                                        success: function (data) {
                                            toastr.success(data.success);
                                            $(parent[0]).addClass('fade-out');
                                            let newData = tableData.filter(item => item.id != parseInt(_id));
                                            tableData = newData;
                                            setTimeout(() => {
                                                parent[0].remove();
                                                if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                    $('#support-articlelists').DataTable().clear().destroy();
                                                }
                                                loadTable(tableData);
                                            }, 1500);
                                        },
                                        error: function (data) {
                                            console.log('Error:', data);
                                        }
                                    });
                                }
                            });
                        });

                        // Mass Delete Testimonial
                        $('body').on('click', '#massdelete', function () {
                            var parent = [];
                            var id = [];
                            $('.checkall:checked').each(function(){
                                parent.push($(this).closest('tr'));
                                id.push($(this).val());
                            });
                            if(id.length > 0){
                                swal({
                                    title: `{{lang('Are you sure you want to continue?')}}`,
                                    text: "{{lang('This might erase your records permanently')}}",
                                    icon: "warning",
                                    buttons: true,
                                    dangerMode: true,
                                })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        $.ajax({
                                            url:"{{ route('deleteall')}}",
                                            method:"post",
                                            data:{id:id},
                                            success:function(data)
                                            {
                                                toastr.success(data.success);
                                                parent.forEach(function(row) {
                                                    row.addClass('fade-out');
                                                });
                                                let newData = tableData.filter(item => !id.includes(String(item.id)));
                                                tableData = newData;
                                                setTimeout(() => {
                                                    parent.forEach(function(row) {
                                                        row.remove();
                                                    });
                                                    if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                        $('#support-articlelists').DataTable().clear().destroy();
                                                    }
                                                    $('#customCheckAll').prop('checked', false);
                                                    loadTable(tableData);
                                                }, 1500);

                                            },
                                            error:function(data){
                                                console.log(data);
                                            }
                                        });
                                    }
                                });
                            }else{
                                toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                            }


                        });

                        $(document).ready(function() {

                            $(document).on('click', '#customCheckAll', function() {
                                $('.checkall').prop('checked', this.checked);
                                updateMassDeleteVisibility();
                            });

                            // Handle individual checkboxes
                            $(document).on('click', '.checkall', function() {
                                updateCustomCheckAll();
                                updateMassDeleteVisibility();
                            });

                            // Handle pagination controls
                            $(document).on('click', '.pagination a', function() {
                                // Assuming '.pagination a' is the selector for your pagination controls
                                setTimeout(function() {
                                    updateMassDeleteVisibility();
                                }, 100);
                            });

                            // Initialize the "Select All" checkbox to unchecked
                            $('#customCheckAll').prop('checked', false);

                            // Function to update the visibility of the mass delete button
                            function updateMassDeleteVisibility() {
                                if ($('.checkall:checked').length == 0) {
                                    $('#massdelete').hide();
                                } else {
                                    $('#massdelete').show();
                                }
                            }

                            // Function to update the state of the "Select All" checkbox
                            function updateCustomCheckAll() {
                                var totalCheckboxes = $('.checkall').length;
                                var checkedCheckboxes = $('.checkall:checked').length;

                                if (checkedCheckboxes === totalCheckboxes) {
                                    $('#customCheckAll').prop('checked', true);
                                } else {
                                    $('#customCheckAll').prop('checked', false);
                                }
                            }
                        });
                    })(jQuery);
                })
            });

		</script>

		@endsection

		@section('modal')

    		@include('admin.generalpage.model')

		@endsection
