@extends('layouts.adminmaster')

@section('styles')
    <!-- INTERNAl Summernote css -->
    <link rel="stylesheet" href="{{asset('build/assets/plugins/summernote/summernote.css')}}">
@endsection

@section('styles')

    <!-- INTERNAL multiselecte css-->
    <link href="{{asset('build/assets/plugins/multipleselect/multiple-select.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
    <link href="{{asset('build/assets/plugins/multi/multi.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

@endsection

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{ lang('Create Campaign Template', 'menu') }}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card ">
            <form id="templateCreateForm" enctype="multipart/form-data">
                <div class="card-header border-0 d-md-max-block">
                    <h4 class="card-title">{{ lang('Create Campaign Template') }}</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="form-group">
                                <label class="form-label">{{lang('Title')}} <span class="text-red">*</span></label>
                                <input type="text" id="title" name="title" placeholder="{{ lang('Enter title') }}" class="form-control @error('title') is-valid @enderror">
                                <span class="text-danger" id="titleError"></span>
                                @error('title')
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ lang($message) }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-group">
                                <label class="form-label">{{lang('Email Subject')}} <span class="text-red">*</span></label>
                                <input type="text" id="subject" name="subject" placeholder="{{ lang('Enter subject for email') }}" class="form-control @error('subject') is-valid @enderror">
                                <span class="text-danger" id="emailSubjectError"></span>
                                @error('subject')
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ lang($message) }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xl-12">
                            <div class="form-group">
                                <label class="form-label">{{lang('Email Body')}} <span class="text-red">*</span></label>
                                <textarea rows="25" id="messageTextarea" class="summernote form-control @error('message') is-invalid @enderror" name="message">
                                    {{ setting('sampleTemplate') }}
                                </textarea>
                                <span class="text-danger" id="EmailMessageError"></span>
                                @error('message')
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ lang($message) }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xl-12">
                            <div class="form-group">
                                <label class="form-label">{{lang('Unsubscribe Link')}} </label>
                                <span class="badge badge-info" id="unsubscribeSpan">&#123;&#123;unsubscribe_link&#125;&#125;</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="form-group float-end">
                        <button class="btn btn-secondary" type="submit">{{ lang('Submit') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection

@section('scripts')

    <!-- INTERNAL Summernote js  -->
    <script src="{{asset('build/assets/plugins/summernote/summernote.js')}}"></script>

    <script>
        $(function() {
            "use strict";

            $('.summernote').summernote();
            (function($) {

                // Variables
                var SITEURL = '{{ url('') }}';

                // Csrf Field
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

            })(jQuery);

            document.getElementById('unsubscribeSpan').addEventListener('click', function() {
                // Get the text from the span
                var textToCopy = this.textContent;

                // Copy the text to the clipboard
                navigator.clipboard.writeText(textToCopy).then(function() {
                    toastr.success('{{ lang('Tect copied successfully.') }}')
                }).catch(function(error) {
                    console.error('Error copying text: ', error);
                });
            });

            document.querySelector('#templateCreateForm').onsubmit = async (e) => {
                e.preventDefault();

                e.target.querySelector('.btn.btn-secondary').innerHTML = '{{ lang('Sending ... ') }} <i class="fa fa-spinner fa-spin"></i>';
                e.target.querySelector('.btn.btn-secondary').classList.add('disabled');
                e.target.querySelector('.btn.btn-secondary').disabled = true;

                let title = document.querySelector('#title');
                let subject = document.querySelector('#subject');
                let message = document.querySelector('#messageTextarea');

                let titleError = document.querySelector('#titleError');
                let subjectError = document.querySelector('#emailSubjectError');
                let messageError = document.querySelector('#EmailMessageError');

                // Clear previous error messages
                titleError.innerHTML = '';
                subjectError.innerHTML = '';
                messageError.innerHTML = '';

                let formData = {
                    title: title.value.trim(),
                    subject: subject.value.trim(),
                    message: message.value.trim(),
                };

                // Validation
                let isValid = true;

                if (formData.message == '') {
                    messageError.innerHTML = '{{ lang('Email body field is required') }}';
                    isValid = false;
                }

                if (formData.subject == '') {
                    subjectError.innerHTML = '{{ lang('Subject field is required') }}';
                    isValid = false;
                }

                if (formData.title == '') {
                    titleError.innerHTML = '{{ lang('Title field is required') }}';
                    isValid = false;
                }
                // If the form is valid, submit it (you can add your form submission logic here)
                if (isValid) {

                    const response = await fetch(SITEURL+'/admin/emailCampaigns/templates/create', {
                        method: "POST",
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'X-Requested-With' : 'XMLHttpRequest',
                            'Accept':'application/json, text/javascript, */*; q=0.01',
                        },
                        body: JSON.stringify(formData),
                    });
                    const data = await response.json();

                    if (data.success) {
                        // toastr.success(data.success);
                        e.target.querySelector('.btn.btn-secondary').innerHTML = '{{ lang('Submit') }}';
                        e.target.querySelector('.btn.btn-secondary').classList.remove('disabled');
                        e.target.querySelector('.btn.btn-secondary').disabled = false;
                        localStorage.setItem('success', data.success);
                        location.href = SITEURL + '/admin/emailCampaigns/templates'
                    }
                    if (data.errors) {
                        if (data.errors?.title) {
                            e.target.querySelector('.btn.btn-secondary').innerHTML = '{{ lang('Submit') }}';
                            e.target.querySelector('.btn.btn-secondary').classList.remove('disabled');
                            e.target.querySelector('.btn.btn-secondary').disabled = false;
                            titleError.innerHTML = '{{ lang('The title has already been taken.') }}';
                        }
                    }
                } else {
                    e.target.querySelector('.btn.btn-secondary').innerHTML = '{{ lang('Submit') }}';
                    e.target.querySelector('.btn.btn-secondary').classList.remove('disabled');
                    e.target.querySelector('.btn.btn-secondary').disabled = false;
                }

            }

            const textarea = document.getElementById("messageTextarea");
            const outputArea = document.getElementById("outputArea");
            let debounceTimer;

            textarea.addEventListener("input", function () {
                clearTimeout(debounceTimer);
                debounceTimer = setTimeout(function () {
                    // Update the output area with the current textarea value
                    outputArea.innerHTML = textarea.value;
                }, 3000); // 5000 milliseconds = 5 seconds
            });
        });
    </script>
@endsection
