@extends('layouts.adminmaster')

@section('styles')
    <!-- INTERNAL Data table css -->
    <link href="{{ asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />
    <link href="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{ asset('build/assets/plugins/sweet-alert/sweetalert.css') }}?v=<?php echo time(); ?>" rel="stylesheet" />
    <style>
        #hideAfterloading {
            position: absolute;
            top: 100px;
            left: 45%;
        }
    </style>
@endsection

@section('content')
    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{ lang('Users', 'menu') }}</span>
            </h4>
        </div>
    </div>
    <!--End Page header-->

    <!-- Customer List -->
    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card ">
            <div class="card-header border-0 d-md-max-block">
                <h4 class="card-title">{{ lang('Users List') }}</h4>
                <div class="card-options mt-sm-max-2 d-md-max-block">
                    @can('Users Create')
                        <a href="javascript:void(0)" id="showModalPopup" class="btn btn-success mb-md-max-2 me-3"><i class="feather feather-user-plus"></i> {{ lang('Add User') }}</a>
                    @endcan
                    @can('Users List Import')
                        <a href="{{ url('admin/emailCampaigns/userImport') }}" class="btn btn-info mb-md-max-2 me-3"><i class="feather feather-download"></i> {{ lang('Import Users List') }}</a>
                    @endcan
                </div>
            </div>
            <div class="card-body overflow-scroll custom-show-data" style="min-height: 250px;">
                <div class="spruko-delete">
                    @can('Users Delete')
                        <button id="massdelete" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{ lang('Delete') }}</button>
                    @endcan
                    {{-- <div class="sprukoloader-img"><i class="fa fa-spinner fa-spin"></i> <span>{{ lang('Loading....') }}</span></div>
                <div class="fetchedtabledata">
                    @include('admin.customers.custtableinclude')
                </div> --}}
                    <table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100"
                        id="support-customerlist">
                        <thead>
                            <tr>
                                <th width="10">{{ lang('Sl.No') }}</th>
                                @can('Users Delete')
                                    <th width="10">
                                        <input type="checkbox" id="customCheckAll">
                                        <label for="customCheckAll"></label>
                                    </th>
                                @endcan
                                @cannot('Users Delete')
                                    <th width="10">
                                        <input type="checkbox" disabled>
                                        <label for="customCheckAll"></label>
                                    </th>
                                @endcannot

                                <th>{{ lang('Email') }}</th>
                                <th>{{ lang('Source') }}</th>
                                <th>{{ lang('Batch Name') }}</th>
                                <th>{{ lang('Created At') }}</th>
                                <th>{{ lang('Subscription Status') }}</th>
                                <th>{{ lang('Actions') }}</th>
                            </tr>
                        </thead>
                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                            <p>{{lang('loading.. Please Wait')}}</p>
                        </div>
                    </table>
                </div>
            </div>
        </div>
    </div>
    {{-- {{ $customers->links('admin.viewticket.pagination') }} --}}
    <!-- End Customer List -->
    @include('admin.emailCampaigns.customer.modal')
@endsection

@section('scripts')
    <!-- INTERNAL Vertical-scroll js-->
    <script src="{{ asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js') }}?v=<?php echo time(); ?>">
    </script>

    <!-- INTERNAL Data tables -->
    <script src="{{ asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/dataTables.responsive.min.js') }}?v=<?php echo time(); ?>">
    </script>
    <script src="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js') }}?v=<?php echo time(); ?>">
    </script>

    <!-- INTERNAL Index js-->
    @vite(['resources/assets/js/support/support-sidemenu.js'])

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{ asset('build/assets/plugins/sweet-alert/sweetalert.min.js') }}?v=<?php echo time(); ?>"></script>
    <script type="text/javascript">

        document.addEventListener("DOMContentLoaded", (event) => {

            let tableData = @json($users);

            let delPerm = @json(Auth::user()->can('Users Delete'));
            let editPerm = @json(Auth::user()->can('Users Status'));
            let SITEURL = "{{ url('') }}"

            var dataTable;
            var tableDropDown;

            let format = @json(setting('date_format'));

            loadTable(tableData);

            function dateTime(createdTime) {

                const jsDate = new Date(createdTime);

                switch (format) {
                    case 'd M, Y':
                        return jsDate.toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: 'short',
                            year: 'numeric'
                        });
                    case 'm.d.y':
                        return jsDate.toLocaleDateString('en-US', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '.');
                    case 'Y-m-d':
                        return jsDate.toISOString().split('T')[0];
                    case 'd-m-Y':
                        return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                    case 'd/m/Y':
                        return jsDate.toLocaleDateString('en-GB');
                    case 'Y/m/d':
                        return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                    default:
                        return jsDate.toLocaleDateString(); // Default format
                }

            }

            function loadTable(tableData) {
                document.querySelector('.card-body').style.setProperty('filter', 'blur(1px)');
                document.getElementById('hideAfterloading')?.classList.remove('d-none');
                document.getElementById('theadShow')?.classList.add('d-none');
                if (tableDropDown)
                    tableDropDown.destroy();

                if (dataTable)
                    dataTable.destroy();

                if (document.getElementById('tableBody'))
                    document.getElementById('tableBody').remove();

                let createTbody = document.createElement('tbody');
                createTbody.setAttribute('id', "tableBody");
                let rows = tableData.map((data, index) => {

                    // Format the date and time in JavaScript
                    let formattedDate = new Date(data.created_at).toLocaleString('en-US', {
                        year: 'numeric',
                        month: '2-digit',
                        day: '2-digit',
                    });

                    return `
                        <tr>
                            <td>${index + 1}</td>
                            <td class="text-center">
                                <input type="checkbox" ${delPerm ? `name="customer_checkbox[]" class="checkall" value=${data.id}` : ''} />
                            </td>
                            <td>${data.email}</td>
                            <td>${data.source}</td>
                            <td>${data.batchName ? data.batchName : '~'}</td>
                            <td>${dateTime(data.created_at)}</td>
                            <td>
                                ${editPerm ? `<label class="custom-switch form-switch mb-0">
                                    <input type="checkbox" name="status" data-id="${data.id}" id="statusChange" class="custom-switch-input" ${data.status == '1' ? 'checked' : ''}>
                                    <span class="custom-switch-indicator"></span>
                                </label>` : ''}

                            </td>
                            <td>
                                ${delPerm  ?
                                    `<a href="javascript:void(0)" class="action-btns1" data-id="${data.id}" id="show-delete" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Delete') }}"> <i class="feather feather-trash-2 text-danger"></i> </a>`
                                :
                                    '~'
                            }
                            </td>
                        </tr>
                    `;
                });

                createTbody.innerHTML = rows.length ? rows.join('') : '';
                document.getElementById('support-customerlist').appendChild(createTbody);
                let prev = {!! json_encode(lang('Previous')) !!};
                let next = {!! json_encode(lang('Next')) !!};
                let nodata = {!! json_encode(lang('No data available in table')) !!};
                let noentries = {!! json_encode(lang('No entries to show')) !!};
                let showing = {!! json_encode(lang('showing page')) !!};
                let ofval = {!! json_encode(lang('of')) !!};
                let maxRecordfilter = {!! json_encode(lang('- filtered from ')) !!};
                let maxRecords = {!! json_encode(lang('records')) !!};
                let entries = {!! json_encode(lang('entries')) !!};
                let show = {!! json_encode(lang('Show')) !!};
                let search = {!! json_encode(lang('Search...')) !!};
                // Reinitialize DataTable
                dataTable = $('#support-customerlist').DataTable({
                    language: {
                        searchPlaceholder: search,
                        scrollX: "100%",
                        sSearch: '',
                        paginate: {
                            previous: prev,
                            next: next
                        },
                        emptyTable: nodata,
                        infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                        info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                        infoEmpty: noentries,
                        lengthMenu: `${show} _MENU_ ${entries}`,
                    },
                    order: [],
                    columnDefs: [{
                        "orderable": false,
                        "targets": [0, 1, 3]
                    }],
                });

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });
                $('.form-select').on('focus', function() {
                    $(this).attr('aria-hidden', 'false');
                });
                document.getElementById('hideAfterloading')?.classList.add('d-none');
                document.querySelector('.card-body').style.setProperty('filter', '');
                document.getElementById('theadShow')?.classList.remove('d-none');

                initializeTooltips();
                // checkboxNoLabel()
                // buttonAlertFunctions();
                // Pagenate();

                function initializeTooltips() {
                    var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                    tooltipElements.forEach(function(element) {
                        new bootstrap.Tooltip(element);
                    });
                }


            }
            let custModal = new bootstrap.Modal('#custModal');
            if (document.querySelector('#showModalPopup')) {
                document.querySelector('#showModalPopup').onclick = () => {
                    custModal.show();
                }
            }
            document.querySelector('#addUsersForm').onsubmit = (e) => {
                e.preventDefault();
                $('#btnsave').html('{{ lang('Sending ...') }} <i class="fa fa-spinner fa-spin"></i>');
                $('#btnsave').prop('disabled', true);
                var formData = new FormData(e.target);
                $.ajax({
                    type: "post",
                    url: SITEURL + "/admin/emailCampaigns/users/save",
                    data: formData,
                    cache: false,
                    processData: false,
                    contentType: false,
                    success: function(data) {
                        if (data?.message == 'userexisted') {
                            $('#emailUserError').html(data.error);
                            $('#btnsave').html('{{ lang('Save Changes') }}');
                            $('#btnsave').prop('disabled', false);
                            return
                        }
                        if (data?.errors?.email) {
                            $('#emailUserError').html(data.errors.email[0]);
                            $('#btnsave').html('{{ lang('Save Changes') }}');
                            $('#btnsave').prop('disabled', false);
                            return
                        }
                        if (data.success) {
                            toastr.success(data.success);
                            loadTable(data.data);
                            custModal.hide();
                            e.target.reset();
                            $('#btnsave').html('{{ lang('Save Changes') }}');
                            $('#btnsave').prop('disabled', false);
                        }
                    },
                    error: function(data) {
                        console.log('Error:', data);

                    }
                });
            }

            $(function() {
                "use strict";

                (function($) {

                    // Variables
                    var SITEURL = '{{ url('') }}';

                    // Csrf Field
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    // Delete the customer
                    $('body').on('click', '#show-delete', function(event) {
                        var _id = $(this).data("id");
                        let parent = $(event.target).closest('tr');
                        swal({
                            title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                            text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/emailCampaigns/users/delete/" + _id,
                                    success: function(data) {
                                        if (data.error == true) {
                                            location.reload();
                                            return
                                        }
                                        $(parent[0]).addClass('fade-out');
                                        toastr.success(data.success);
                                        let originalData = tableData.filter(item => item.id !== _id);
                                        document.querySelector('.card-body').style.setProperty('filter', 'blur(1px)');
                                        document.getElementById('hideAfterloading')?.classList.remove('d-none');

                                        setTimeout(() => {
                                            parent[0].remove();
                                            loadTable(originalData);
                                        }, 1500);
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                        if (data.responseJSON.message == 'The payload is invalid.') {
                                            toastr.error('You are not allow to delete this customer.');
                                        }
                                    }
                                });
                            }
                        });
                    });

                    // Mass Delete
                    $('body').on('click', '#massdelete', function() {
                        var id = [];
                        var parent = [];
                        $('.checkall:checked').each(function() {
                            id.push($(this).val());
                            parent.push($(this).closest('tr'));
                        });
                        if (id.length > 0) {
                            swal({
                                title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                                text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                            })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        url: "{{ url('admin/emailCampaigns/users/massdelete') }}",
                                        method: "POST",
                                        data: {
                                            id: id
                                        },
                                        success: function(data) {
                                            toastr.success(data.success);
                                            let originalData = tableData.filter(item => !id.includes(String(item.id)));
                                            parent.forEach(function(row) {
                                                row.addClass('fade-out');
                                            });
                                            document.querySelector('.card-body').style.setProperty('filter', 'blur(1px)');
                                            document.getElementById('hideAfterloading')?.classList.remove('d-none');
                                            // Remove rows from the DOM
                                            setTimeout(() => {
                                                parent.forEach(function(row) {
                                                    row.remove();
                                                });
                                                loadTable(originalData);
                                            }, 1500);

                                        },
                                        error: function(data) {
                                            if (data.responseJSON.message == 'The payload is invalid.') {
                                                toastr.error('You are not allow to delete this customer.');
                                            }
                                        }
                                    });
                                }
                            });
                        } else {
                            toastr.error(
                                '{{ lang('Please select at least one check box.', 'alerts') }}'
                            );
                        }

                    });

                    // Status change article
                    $('body').on('click', '#statusChange', function () {
                        var _id = $(this).data("id");
                        var status = $(this).prop('checked');
                        $.ajax({
                            type: "post",
                            url: SITEURL + "/admin/emailCampaigns/users/status",
                            data: {'status': status, 'id': _id},
                            success: function (data) {
                                toastr.success(data.success);
                            },
                            error: function (data) {
                                console.log('Error:', data);
                            }
                        });
                    });

                    $('.form-select').select2({
                        minimumResultsForSearch: Infinity,
                        width: '100%'
                    });

                    $('#batchnames').select2({
                        minimumResultsForSearch: Infinity,
                        width: '100%'
                    });

                    $(document).ready(function() {

                        $(document).on('click', '#customCheckAll', function() {
                            $('.checkall').prop('checked', this.checked);
                            updateMassDeleteVisibility();
                        });

                        // Handle individual checkboxes
                        $(document).on('click', '.checkall', function() {
                            updateCustomCheckAll();
                            updateMassDeleteVisibility();
                        });

                        // Handle pagination controls
                        $(document).on('click', '.pagination a', function() {
                            // Assuming '.pagination a' is the selector for your pagination controls
                            setTimeout(function() {
                                updateMassDeleteVisibility();
                            }, 100);
                        });

                        // Initialize the "Select All" checkbox to unchecked
                        $('#customCheckAll').prop('checked', false);

                        // Function to update the visibility of the mass delete button
                        function updateMassDeleteVisibility() {
                            if ($('.checkall:checked').length == 0) {
                                $('#massdelete').hide();
                            } else {
                                $('#massdelete').show();
                            }
                        }

                        // Function to update the state of the "Select All" checkbox
                        function updateCustomCheckAll() {
                            var totalCheckboxes = $('.checkall').length;
                            var checkedCheckboxes = $('.checkall:checked').length;

                            if (checkedCheckboxes === totalCheckboxes) {
                                $('#customCheckAll').prop('checked', true);
                            } else {
                                $('#customCheckAll').prop('checked', false);
                            }
                        }
                    });

                })(jQuery);
            });
        });
    </script>
@endsection
