@extends('layouts.adminmaster')

@section('styles')

    <!-- INTERNAL Data table css -->
    <link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
    <link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}" rel="stylesheet" />

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}" rel="stylesheet" />

    <style>
        #hideAfterloading {
            position: absolute;
            top: 100px;
            left: 45%;
        }
    </style>
@endsection

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Canned Response')}}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card ">
            <div class="card-header border-0 d-sm-flex">
                <h4 class="card-title">{{lang('Canned Response List')}}</h4>
                <div class="card-options mt-sm-max-2">
                    @can('Canned Response Create')

                    <a href="{{route('admin.cannedmessages.create')}}" class="btn btn-secondary me-3" >{{lang('Add Canned Response')}}</a>
                    @endcan

                </div>
            </div>
            <div class="card-body" style="min-height: 250px;">
                <div class="table-responsive spruko-delete">
                    @can('Canned Response Delete')

                    <button id="massdeletenotify" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
                    @endcan

                    <table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100" id="cannedmessages">
                        <thead>
                            <tr>
                                <th  width="10">{{lang('Sl.No')}}</th>
                                @can('Canned Response Delete')

                                <th width="10" >
                                    <input type="checkbox"  id="customCheckAll" class="form-check-input">
                                    <label  for="customCheckAll"></label>
                                </th>
                                @endcan
                                @cannot('Canned Response Delete')

                                <th width="10" >
                                    <input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
                                    <label  for="customCheckAll"></label>
                                </th>
                                @endcannot

                                <th class="w-50">{{lang('Title')}}</th>
                                <th class="w-50">{{lang('Response Type')}}</th>
                                <th class="w-50">{{lang('Status')}}</th>
                                <th class="w-50">{{lang('Actions')}}</th>
                            </tr>
                        </thead>
                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                            <p>{{lang('loading.. Please Wait')}}</p>
                        </div>
                    </table>
                </div>
            </div>
        </div>
    </div>


@endsection

@section('scripts')
    <!-- INTERNAL Data tables -->
    <script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}"></script>
    <script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}"></script>
    <script src="{{asset('build/assets/plugins/datatable/datatablebutton.min.js')}}"></script>
    <script src="{{asset('build/assets/plugins/datatable/buttonbootstrap.min.js')}}"></script>

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}"></script>

    <script type="text/javascript">
        "use strict";

        document.addEventListener("DOMContentLoaded", (event) => {

            let tableData = @json($cannedmessages);

            let dateFormat = @json(setting('date_format'));
            let delPerm = @json(Auth::user()->can('Canned Response Delete'));
            let editPerm = @json(Auth::user()->can('Canned Response Edit'));

            var dataTable;
            var tableDropDown;

            loadTable(tableData);

            function truncateTitle(title) {
                const maxLength = 40;
                return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
            }

            function loadTable(tableData) {
                document.getElementById('hideAfterloading')?.classList.remove('d-none');
                document.getElementById('theadShow')?.classList.add('d-none');
                if (tableDropDown)
                    tableDropDown.destroy();

                if (dataTable)
                    dataTable.destroy();

                if (document.getElementById('tableBody'))
                    document.getElementById('tableBody').remove();

                let createTbody = document.createElement('tbody');
                createTbody.setAttribute('id', "tableBody");
                let rows = tableData.map((data, index) => {
                    var editRouteUrl = "{{ route('admin.cannedmessages.edit', ['id' => ':id']) }}".replace(':id', data.id);

                    return `
                        <tr>
                            <td>${index + 1}</td>

                            <td>
                                ${delPerm ? `<input type="checkbox" name="spruko_checkbox[]" class="checkall form-check-input" value="${data.id}" />` : '~'}
                            </td>

                            <td>${data.title}</td>

                            <td>${data.responsetype ? "{{ lang('Livechat') }}" : "{{ lang('Ticket') }}"}</td>

                            <td>
                                ${editPerm ?
                                    (data.status == '1' ?
                                    `<label class="custom-switch form-switch mb-0">
                                        <input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="1" class="custom-switch-input tswitch" checked>
                                        <span class="custom-switch-indicator"></span>
                                    </label>`
                                    :
                                    `<label class="custom-switch form-switch mb-0">
                                        <input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="1" class="custom-switch-input tswitch">
                                        <span class="custom-switch-indicator"></span>
                                    </label>`
                                    )
                                :
                                '~'
                                }
                            </td>

                            <td>
                                <div class = "d-flex">
                                    ${editPerm ? `<a href="${editRouteUrl}" class="action-btns1 edit-testimonial"><i class="feather feather-edit text-primary" data-id="${data.id}"data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i></a>` : ''}

                                    ${delPerm ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1" id="delete-cannedmessages" ><i class="feather feather-trash-2 text-danger" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"></i></a>` : ''}
                                </div>

                            </td>

                        </tr>
                    `;
                });

                if (tableData.length == 0)
                    createTbody.innerHTML = ` `;
                else
                    createTbody.innerHTML = rows.join('');


                // Append the tbody to your table
                // Replace 'your-table-id' with the actual ID of your table element
                document.getElementById('cannedmessages').appendChild(createTbody);

                document.getElementById('hideAfterloading')?.classList.add('d-none');
                document.getElementById('theadShow')?.classList.remove('d-none');

                // var myTable = document.querySelector("#support-category");

                $(document).ready(function() {

                    var SITEURL = '{{ url('') }}';

                    // Csrf field
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });


                    let prev = {!! json_encode(lang("Previous")) !!};
                    let next = {!! json_encode(lang("Next")) !!};
                    let nodata = {!! json_encode(lang("No data available in table")) !!};
                    let noentries = {!! json_encode(lang("No entries to show")) !!};
                    let showing = {!! json_encode(lang("showing page")) !!};
                    let ofval = {!! json_encode(lang("of")) !!};
                    let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                    let maxRecords = {!! json_encode(lang("records")) !!};
                    let entries = {!! json_encode(lang("entries")) !!};
                    let show = {!! json_encode(lang("Show")) !!};
                    let search = {!! json_encode(lang("Search")) !!};
                    // Datatable
                    $('#cannedmessages').dataTable({
                        language: {
                            searchPlaceholder: search,
                            scrollX: "100%",
                            sSearch: '',
                            paginate: {
                            previous: prev,
                            next: next
                            },
                            emptyTable : nodata,
                            infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                            info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                            infoEmpty: noentries,
                            lengthMenu: `${show} _MENU_ ${entries} `,
                        },
                        order:[],
                        columnDefs: [
                            { "orderable": false, "targets":[ 0,1,4] }
                        ],
                    });

                    $('.form-select').select2({
                        minimumResultsForSearch: Infinity,
                        width: '100%'
                    });

                    $('.form-select').on('focus', function() {
                        $(this).attr('aria-hidden', 'false');
                    });
                });


                initializeTooltips();

                function initializeTooltips() {
                    var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                    tooltipElements.forEach(function(element) {
                        new bootstrap.Tooltip(element);
                    });
                }


            }

            $(function() {

                (function($)  {

                    // Variables
                    var SITEURL = '{{url('')}}';

                    //checkbox script
                    $(document).ready(function() {

                        $(document).on('click', '#customCheckAll', function() {
                            $('.checkall').prop('checked', this.checked);
                            updateMassDeleteVisibility();
                        });

                        $(document).on('click', '.checkall', function() {
                            updateCustomCheckAll();
                            updateMassDeleteVisibility();
                        });


                        $(document).on('click', '.pagination a', function() {

                            setTimeout(function() {
                                updateMassDeleteVisibility();
                            }, 100);
                        });


                        $('#customCheckAll').prop('checked', false);


                        function updateMassDeleteVisibility() {
                            if ($('.checkall:checked').length == 0) {
                                $('#massdeletenotify').hide();
                            } else {
                                $('#massdeletenotify').show();
                            }
                        }


                        function updateCustomCheckAll() {
                            var totalCheckboxes = $('.checkall').length;
                            var checkedCheckboxes = $('.checkall:checked').length;

                            if (checkedCheckboxes === totalCheckboxes) {
                                $('#customCheckAll').prop('checked', true);
                            } else {
                                $('#customCheckAll').prop('checked', false);
                            }
                        }
                    });

                    // Status change article
                    $('body').on('click', '.tswitch', function () {
                        var _id = $(this).data("id");
                        var status = $(this).prop('checked') == true ? '1' : '0';

                        $.ajax({
                            type: "post",
                            url: SITEURL + "/admin/cannedmessages/status/"+_id,
                            data: {'status': status},
                            success: function (data) {
                                toastr.success(data.success);
                            },
                            error: function (data) {
                                console.log('Error:', data);
                            }
                        });
                    });

                    // Delete Testimonial
                    $('body').on('click', '#delete-cannedmessages', function () {
                        let parent = $(this).closest('tr');
                        var _id = $(this).data("id");
                        swal({
                            title: `{{lang('Are you sure you want to continue?')}}`,
                            text: "{{lang('This might erase your records permanently')}}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/cannedmessages/delete/"+_id,
                                    success: function (data) {

                                        toastr.success(data.success);
                                        $(parent[0]).addClass('fade-out');
                                        let newData = tableData.filter(item => item.id != parseInt(_id));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent[0].remove();
                                            if ($.fn.DataTable.isDataTable('#cannedmessages')) {
                                                $('#cannedmessages').DataTable().clear().destroy();
                                            }
                                            loadTable(tableData);
                                        }, 1500);
                                    },
                                    error: function (data) {
                                    console.log('Error:', data);
                                    }
                                });
                            }
                        });
                    });

                    // Mass Delete Testimonial
                    $('body').on('click', '#massdeletenotify', function () {
                        var parent = [];
                        var id = [];
                        $('.checkall:checked').each(function(){
                            parent.push($(this).closest('tr'));
                            id.push($(this).val());
                        });
                        if(id.length > 0){
                            swal({
                                title: `{{lang('Are you sure you want to continue?')}}`,
                                text: "{{lang('This might erase your records permanently')}}",
                                icon: "warning",
                                buttons: true,
                                dangerMode: true,
                            })
                            .then((willDelete) => {
                                if (willDelete) {
                                    $.ajax({
                                        url:"{{ route('admin.cannedmessages.deleteall')}}",
                                        method:"post",
                                        data:{id:id},
                                        success:function(data)
                                        {

                                            toastr.success(data.success);
                                            parent.forEach(function(row) {
                                                row.addClass('fade-out');
                                            });
                                            let newData = tableData.filter(item => !id.includes(String(item.id)));
                                            tableData = newData;
                                            setTimeout(() => {
                                                parent.forEach(function(row) {
                                                    row.remove();
                                                });
                                                if ($.fn.DataTable.isDataTable('#cannedmessages')) {
                                                    $('#cannedmessages').DataTable().clear().destroy();
                                                }
                                                $('#customCheckAll').prop('checked', false);
                                                loadTable(tableData);
                                            }, 1500);

                                        },
                                        error:function(data){
                                            console.log(data);
                                        }
                                    });
                                }
                            });
                        }else{
                            toastr.error('{{lang('Please select at least one check box.')}}');
                        }
                    });

                })(jQuery);
            });
        });

    </script>
@endsection
