@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAL Sweet-Alert css -->
<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

@endsection

@section('content')

<!--Page header-->
<div class="page-header d-xl-flex d-block">
    <div class="page-leftheader">
        <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Business Hours',
                'menu')}}</span></h4>
    </div>
</div>
<!--End Page header-->

<div class="col-xl-12 col-lg-12 col-md-12">
    <div class="card ">
        <div class="card-header border-0">
            <h4 class="card-title">{{lang('Business Hours', 'menu')}}</h4>
            <div class="card-header-styles">
                <label class="me-1 mt-1"><b>{{lang('Enable 24/7')}}</b></label>
                <div class="float-end mt-0">
                    <div class="switch-toggle">
                        <a class="onoffswitch2">
                            <input type="checkbox" name="24hoursbusinessswitch" id="24hoursbusinessswitch"
                                class=" toggle-class onoffswitch2-checkbox" value="on"
                                {{setting('24hoursbusinessswitch')=='on' ? 'checked' : '' }}>
                            <label for="24hoursbusinessswitch" class="toggle-class onoffswitch2-label"></label>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <form action="{{route('admin.bussinesshour.store')}}" method="POST" id="businessform">
            @csrf
            <div class="card-body">
                <div class="table-responsive table-bussiness-hours">
                    <table class="table card-table table-vcenter text-nowrap mb-0">
                        <thead>
                            <tr class="">
                                <th class="w-20 border-bottom-0 ">{{lang('Days')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Closed/Open')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Start-time')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('End-time')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Break Start Time')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Break End Time')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $timestart = ['12:00 AM','12:30 AM','1:00 AM','1:30 AM','2:00 AM','2:30 AM','3:00 AM','3:30 AM','4:00 AM','4:30 AM','5:00 AM','5:30 AM','6:00 AM','6:30 AM','7:00 AM','7:30 AM','8:00 AM','8:30 AM','9:00 AM','9:30 AM','10:00 AM','10:30 AM','11:00 AM','11:30 AM','12:00 PM','12:30 PM','1:00 PM','1:30 PM','2:00 PM','2:30 PM','3:00 PM','3:30 PM','4:00 PM','4:30 PM','5:00 PM','5:30 PM','6:00 PM','6:30 PM','7:00 PM','7:30 PM','8:00 PM','8:30 PM','9:00 PM','9:30 PM','10:00 PM','10:30 PM','11:00 PM','11:30 PM'];

                                $breaktime1 = $bussiness1 != null ? $bussiness1->breakstarttime : null;
                                $breaktime2 = $bussiness2 != null ? $bussiness2->breakstarttime : null;
                                $breaktime3 = $bussiness3 != null ? $bussiness3->breakstarttime : null;
                                $breaktime4 = $bussiness4 != null ? $bussiness4->breakstarttime : null;
                                $breaktime5 = $bussiness5 != null ? $bussiness5->breakstarttime : null;
                                $breaktime6 = $bussiness6 != null ? $bussiness6->breakstarttime : null;
                                $breaktime7 = $bussiness7 != null ? $bussiness7->breakstarttime : null;

                                $breakendtime1 = $bussiness1 != null ? $bussiness1->breakendtime : null;
                                $breakendtime2 = $bussiness2 != null ? $bussiness2->breakendtime : null;
                                $breakendtime3 = $bussiness3 != null ? $bussiness3->breakendtime : null;
                                $breakendtime4 = $bussiness4 != null ? $bussiness4->breakendtime : null;
                                $breakendtime5 = $bussiness5 != null ? $bussiness5->breakendtime : null;
                                $breakendtime6 = $bussiness6 != null ? $bussiness6->breakendtime : null;
                                $breakendtime7 = $bussiness7 != null ? $bussiness7->breakendtime : null;
                            @endphp
                            <tr class="border-bottom-transparent">
                                <td class="">
                                    <input type="hidden" name="bussinessid1" value="1">
                                    <select name="bussiness1"
                                        class="form-control select2 select2-show-search sprukoweeks"
                                        data-placeholder="{{lang('Select Days')}}">
                                        <option label="{{lang('Select Days')}}"></option>
                                        <option value="Mon" {{$bussiness1 !=null ? $bussiness1->weeks == 'Mon' ?
                                            'selected': '' :''}}>{{lang('Mon')}}</option>
                                        <option value="Tue" {{$bussiness1 !=null ? $bussiness1->weeks == 'Tue' ?
                                            'selected': '' :''}}>{{lang('Tue')}}</option>
                                        <option value="Wed" {{$bussiness1 !=null ? $bussiness1->weeks == 'Wed' ?
                                            'selected': '' :''}}>{{lang('Wed')}}</option>
                                        <option value="Thu" {{$bussiness1 !=null ? $bussiness1->weeks == 'Thu' ?
                                            'selected': '' :''}}>{{lang('Thu')}}</option>
                                        <option value="Fri" {{$bussiness1 !=null ? $bussiness1->weeks == 'Fri' ?
                                            'selected': '' :''}}>{{lang('Fri')}}</option>
                                        <option value="Sat" {{$bussiness1 !=null ? $bussiness1->weeks == 'Sat' ?
                                            'selected': '' :''}}>{{lang('Sat')}}</option>
                                        <option value="Sun" {{$bussiness1 !=null ? $bussiness1->weeks == 'Sun' ?
                                            'selected': '' :''}}>{{lang('Sun')}}</option>
                                    </select>
                                </td>
                                <td class="">
                                    <select name="status1" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness1 !=null ? $bussiness1->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness1 !=null ? $bussiness1->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime1"
                                        class="form-control select2 select2-show-search sprukostarttime" data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness1 !=null ? $bussiness1->starttime == '24H' ? 'selected' : '' :''}}>24H</option>

                                        </optgroup>

                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness1 !=null ? $bussiness1->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach

                                    </select>
                                </td>

                                <td class="tr_clone">
                                    <select name="endtime1" @if($bussiness1 != null && $bussiness1->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness1 !=null ? $bussiness1->endtime == $time ? 'selected' : '' :''}} >{{$time}}</option>
                                        @endforeach

                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart1" @if($bussiness1 != null && $bussiness1->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart1">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend1" @if($bussiness1 != null && $bussiness1->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend1">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid2" value="2">
                                    <input name="bussiness2" class="form-control sprukoweeks" value="{{ $bussiness2->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status2" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness2 !=null ? $bussiness2->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness2 !=null ? $bussiness2->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime2"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness2 !=null ? $bussiness2->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>

                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness2 !=null ? $bussiness2->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach

                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime2" @if($bussiness2 != null && $bussiness2->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness2 !=null ? $bussiness2->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart2" @if($bussiness2 != null && $bussiness2->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart2">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend2" @if($bussiness2 != null && $bussiness2->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend2">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid3" value="3">
                                    <input name="bussiness3" class="form-control sprukoweeks" value="{{ $bussiness3->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status3" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness3 !=null ? $bussiness3->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness3 !=null ? $bussiness3->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime3"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness3 !=null ? $bussiness3->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness3 !=null ? $bussiness3->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime3" @if($bussiness3 != null && $bussiness3->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness3 !=null ? $bussiness3->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart3" @if($bussiness3 != null && $bussiness3->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart3">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend3" @if($bussiness3 != null && $bussiness3->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend3">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid4" value="4">
                                    <input name="bussiness4" class="form-control sprukoweeks" value="{{ $bussiness4->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status4" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness4 !=null ? $bussiness4->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness4 !=null ? $bussiness4->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime4"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness4 !=null ? $bussiness4->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness4 !=null ? $bussiness4->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime4" @if($bussiness4 != null && $bussiness4->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness4 !=null ? $bussiness4->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart4" @if($bussiness4 != null && $bussiness4->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart4">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend4" @if($bussiness4 != null && $bussiness4->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend4">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid5" value="5">
                                    <input name="bussiness5" class="form-control sprukoweeks" value="{{ $bussiness5->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status5" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness5 !=null ? $bussiness5->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness5 !=null ? $bussiness5->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime5"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness5 !=null ? $bussiness5->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness5 !=null ? $bussiness5->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime5" @if($bussiness5 != null && $bussiness5->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness5 !=null ? $bussiness5->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart5" @if($bussiness5 != null && $bussiness5->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart5">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend5" @if($bussiness5 != null && $bussiness5->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend5">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid6" value="6">
                                    <input name="bussiness6" class="form-control sprukoweeks" value="{{ $bussiness6->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status6" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness6 !=null ? $bussiness6->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness6 !=null ? $bussiness6->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime6"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness6 !=null ? $bussiness6->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness6 !=null ? $bussiness6->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime6" @if($bussiness6 != null && $bussiness6->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness6 !=null ? $bussiness6->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart6" @if($bussiness6 != null && $bussiness6->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart6">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend6" @if($bussiness6 != null && $bussiness6->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend6">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid7" value="7">
                                    <input name="bussiness7" class="form-control sprukoweeks" value="{{ $bussiness7->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status7" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness7 !=null ? $bussiness7->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness7 !=null ? $bussiness7->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime7"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness7 !=null ? $bussiness7->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness7 !=null ? $bussiness7->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime7" @if($bussiness7 != null && $bussiness7->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness7 !=null ? $bussiness7->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart7" @if($bussiness7 != null && $bussiness7->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart7">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend7" @if($bussiness7 != null && $bussiness7->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend7">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer">
                <div class="form-group float-end">
                    <button  id="bussinesshourRest" class="btn btn-danger mx-2">{{lang('Reset')}}</button>

                    <button id="bussinesshourSubmit" disabled="disabled" type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save')}}</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')

@vite(['resources/assets/js/select2.js'])

<!-- INTERNAL Sweet-Alert js-->
<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>

<script type="text/javascript">
    $(function() {
        "use strict";

        let timedata = @json($timestart);
        let breaktime1 = @json($breaktime1);
        let breaktime2 = @json($breaktime2);
        let breaktime3 = @json($breaktime3);
        let breaktime4 = @json($breaktime4);
        let breaktime5 = @json($breaktime5);
        let breaktime6 = @json($breaktime6);
        let breaktime7 = @json($breaktime7);

        let breakendtime1 = @json($breakendtime1);
        let breakendtime2 = @json($breakendtime2);
        let breakendtime3 = @json($breakendtime3);
        let breakendtime4 = @json($breakendtime4);
        let breakendtime5 = @json($breakendtime5);
        let breakendtime6 = @json($breakendtime6);
        let breakendtime7 = @json($breakendtime7);

        function breaktimeupdate(){
            if(timestart1 && timeend1){
                let startIndex = timedata.indexOf(timestart1);
                let endIndex = timedata.indexOf(timeend1);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart1').append(new Option(data, data));
                        if (data == breaktime1) {
                            $('#breakstart1 option:last').prop('selected', true);
                        }
                        $('#breakend1').append(new Option(data, data));
                        if (data == breakendtime1) {
                            $('#breakend1 option:last').prop('selected', true);
                        }
                        $('#breakstart1').prop('disabled', false);
                        $('#breakend1').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart1').val('0').trigger('change.select2');
                $('#breakend1').val('0').trigger('change.select2');
                $('#breakstart1').prop('disabled', true);
                $('#breakend1').prop('disabled', true);
            }

            if(timestart2 && timeend2){
                let startIndex = timedata.indexOf(timestart2);
                let endIndex = timedata.indexOf(timeend2);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart2').append(new Option(data, data));
                        if (data == breaktime2) {
                            $('#breakstart2 option:last').prop('selected', true);
                        }
                        $('#breakend2').append(new Option(data, data));
                        if (data == breakendtime2) {
                            $('#breakend2 option:last').prop('selected', true);
                        }
                        $('#breakstart2').prop('disabled', false);
                        $('#breakend2').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart2').val('0').trigger('change.select2');
                $('#breakend2').val('0').trigger('change.select2');
                $('#breakstart2').prop('disabled', true);
                $('#breakend2').prop('disabled', true);
            }

            if(timestart3 && timeend3){
                let startIndex = timedata.indexOf(timestart3);
                let endIndex = timedata.indexOf(timeend3);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart3').append(new Option(data, data));
                        if (data == breaktime3) {
                            $('#breakstart3 option:last').prop('selected', true);
                        }
                        $('#breakend3').append(new Option(data, data));
                        if (data == breakendtime3) {
                            $('#breakend3 option:last').prop('selected', true);
                        }
                        $('#breakstart3').prop('disabled', false);
                        $('#breakend3').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart3').val('0').trigger('change.select2');
                $('#breakend3').val('0').trigger('change.select2');
                $('#breakstart3').prop('disabled', true);
                $('#breakend3').prop('disabled', true);
            }

            if(timestart4 && timeend4){
                let startIndex = timedata.indexOf(timestart4);
                let endIndex = timedata.indexOf(timeend4);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart4').append(new Option(data, data));
                        if (data == breaktime4) {
                            $('#breakstart4 option:last').prop('selected', true);
                        }
                        $('#breakend4').append(new Option(data, data));
                        if (data == breakendtime4) {
                            $('#breakend4 option:last').prop('selected', true);
                        }
                        $('#breakstart4').prop('disabled', false);
                        $('#breakend4').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart4').val('0').trigger('change.select2');
                $('#breakend4').val('0').trigger('change.select2');
                $('#breakstart4').prop('disabled', true);
                $('#breakend4').prop('disabled', true);
            }

            if(timestart5 && timeend5){
                let startIndex = timedata.indexOf(timestart5);
                let endIndex = timedata.indexOf(timeend5);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart5').append(new Option(data, data));
                        if (data == breaktime5) {
                            $('#breakstart5 option:last').prop('selected', true);
                        }
                        $('#breakend5').append(new Option(data, data));
                        if (data == breakendtime5) {
                            $('#breakend5 option:last').prop('selected', true);
                        }
                        $('#breakstart5').prop('disabled', false);
                        $('#breakend5').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart5').val('0').trigger('change.select2');
                $('#breakend5').val('0').trigger('change.select2');
                $('#breakstart5').prop('disabled', true);
                $('#breakend5').prop('disabled', true);
            }

            if(timestart6 && timeend6){
                let startIndex = timedata.indexOf(timestart6);
                let endIndex = timedata.indexOf(timeend6);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart6').append(new Option(data, data));
                        if (data == breaktime6) {
                            $('#breakstart6 option:last').prop('selected', true);
                        }
                        $('#breakend6').append(new Option(data, data));
                        if (data == breakendtime6) {
                            $('#breakend6 option:last').prop('selected', true);
                        }
                        $('#breakstart6').prop('disabled', false);
                        $('#breakend6').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart6').val('0').trigger('change.select2');
                $('#breakend6').val('0').trigger('change.select2');
                $('#breakstart6').prop('disabled', true);
                $('#breakend6').prop('disabled', true);
            }

            if(timestart7 && timeend7){
                let startIndex = timedata.indexOf(timestart7);
                let endIndex = timedata.indexOf(timeend7);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart7').append(new Option(data, data));
                        if (data == breaktime7) {
                            $('#breakstart7 option:last').prop('selected', true);
                        }
                        $('#breakend7').append(new Option(data, data));
                        if (data == breakendtime7) {
                            $('#breakend7 option:last').prop('selected', true);
                        }
                        $('#breakstart7').prop('disabled', false);
                        $('#breakend7').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart7').val('0').trigger('change.select2');
                $('#breakend7').val('0').trigger('change.select2');
                $('#breakstart7').prop('disabled', true);
                $('#breakend7').prop('disabled', true);
            }
        }

        function bussinesshourSubmit(){
            breaktimeupdate();
            let startStatus = 0,
            endStatus = 0,
            openEle = 0;
            document.querySelectorAll('.sprukoopen').forEach((ele, ind)=>{
                if(ele.value){
                    if(ele.value === "Opened"){
                        openEle += 1;
                    }
                    let currentEle = ele;
                    if(currentEle.closest('td').nextElementSibling.querySelector('.sprukostarttime').value){
                        startStatus += 1;
                        if(currentEle.closest('td').nextElementSibling.querySelector('.sprukostarttime').value === "24H"){
                            endStatus += 1;
                        }
                    }
                    if(currentEle.closest('td').nextElementSibling.nextElementSibling.querySelector('.sprukoendtime').value){
                        endStatus += 1;
                    }
                }
            })
            if((openEle == startStatus) && (openEle == endStatus)){
                let subBtn = document.querySelector('#bussinesshourSubmit');
                subBtn.disabled = false;
            }
            else{
                let subBtn = document.querySelector('#bussinesshourSubmit');
                subBtn.disabled = true;
            }
        }
        bussinesshourSubmit();


        let dayListEle = document.querySelectorAll('.sprukoweeks');
        let dayListArr = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
        $('.sprukoweeks').on('change', daySort);
        function daySort(){
            let startDay =  dayListEle[0].value;
            if(startDay){
                for(let i = 0; i<= dayListArr.length; i++){
                    if(dayListArr[i] === startDay){
                        let newDayList = reorder(dayListArr, i);
                        dayListEle.forEach((element, ind) => {
                            if(ind >= 1){
                                element.value = newDayList[ind]
                            }
                        });

                    }
                }
                $('.sprukoopen').val('Opened').trigger('change.select2');
                $('.sprukostarttime').val('0').trigger('change.select2');
                $('.sprukostarttime').prop('disabled', false);
                $('.sprukoendtime').val('0').trigger('change.select2');
                $('.sprukoendtime').prop('disabled', false);
            }
            bussinesshourSubmit();
            timestart1 = timestart2 = timestart3 = timestart4 = timestart5 = timestart6 = timestart7 = timeend1 = timeend2 = timeend3 = timeend4 = timeend4 = timeend5 = timeend6 = timeend7 = null;
            breaktimeupdate();
        }


        function reorder(data, index) {
            return data.slice(index).concat(data.slice(0, index))
        };

        var timestart1, timestart2, timestart3, timestart4, timestart5, timestart6, timestart7, timeend1, timeend2, timeend3, timeend4, timeend4, timeend5, timeend6, timeend7;

        $('.sprukostarttime').on('change', function(e){

            let value = e.target.value,
            tdfind = $(this).closest('tr').find('.tr_clone');

            if(e.target.name == 'starttime1'){
                timestart1 = value;
            }else if(e.target.name == 'starttime2'){
                timestart2 = value;
            }else if(e.target.name == 'starttime3'){
                timestart3 = value;
            }else if(e.target.name == 'starttime4'){
                timestart4 = value;
            }else if(e.target.name == 'starttime5'){
                timestart5 = value;
            }else if(e.target.name == 'starttime6'){
                timestart6 = value;
            }else{
                timestart7 = value;
            }

            let find = tdfind[0];
            let selectEle = find.firstElementChild;
            if(value == '24H'){
                $(this).closest('tr').find('.tr_clone select').val('').trigger('change');
                selectEle.disabled = true;
            }else{
                selectEle.disabled = false;
            }

            bussinesshourSubmit();
        });
        $('.sprukoendtime').on('change', function(e){

            if(e.target.name == 'endtime1'){
                timeend1 = e.target.value;
            }else if(e.target.name == 'endtime2'){
                timeend2 = e.target.value;
            }else if(e.target.name == 'endtime3'){
                timeend3 = e.target.value;
            }else if(e.target.name == 'endtime4'){
                timeend4 = e.target.value;
            }else if(e.target.name == 'endtime5'){
                timeend5 = e.target.value;
            }else if(e.target.name == 'endtime6'){
                timeend6 = e.target.value;
            }else{
                timeend7 = e.target.value;
            }

            bussinesshourSubmit();
        });

        $('.sprukoopen').on('change', function(e){

            let sprukovalue = e.target.value,
            tdfind1 = $(this).closest('tr').find('.tr_clone1'),
            tdfind2 = $(this).closest('tr').find('.tr_clone'),
            tdfind3 = $(this).closest('tr').find('.tr_clone2'),
            tdfind4 = $(this).closest('tr').find('.tr_clone3');

            let find1 = tdfind1[0];
            let selectEle1 = find1.firstElementChild;
            let find2 = tdfind2[0];
            let selectEle2 = find2.firstElementChild;
            let find3 = tdfind3[0];
            let selectEle3 = find3.firstElementChild;
            let find4 = tdfind4[0];
            let selectEle4 = find4.firstElementChild;

            if(sprukovalue == 'Closed'){
                $(this).closest('tr').find('.tr_clone select').val('').trigger('change');
                $(this).closest('tr').find('.tr_clone1 select').val('').trigger('change');
                $(this).closest('tr').find('.tr_clone2 select').val('').trigger('change');
                $(this).closest('tr').find('.tr_clone3 select').val('').trigger('change');
                selectEle1.disabled = true;
                selectEle2.disabled = true;
                selectEle3.disabled = true;
                selectEle4.disabled = true;

                selectEle2.value = null;
                selectEle3.value = null;
                selectEle4.value = null;
            }else{

                selectEle1.disabled = false;
                selectEle2.disabled = false;
                selectEle3.disabled = false;
                selectEle4.disabled = false;
            }
            bussinesshourSubmit();
        });

        $(window).on('load', function(){
            let startDay =  dayListEle[0].value;
            if(startDay){
                for(let i = 0; i<= dayListArr.length; i++){
                    if(dayListArr[i] === startDay){
                        let newDayList = reorder(dayListArr, i);
                        dayListEle.forEach((element, ind) => {
                            if(ind >= 1){
                                element.value = newDayList[ind]
                            }
                        });

                    }
                }
            }
            let starttimevalue = $('.sprukostarttime');

            $.map(starttimevalue, function( val, i ) {
                // Do something
                let value = $(val).val(),
                    tdfind = $(val).closest('tr').find('.tr_clone');

                if(i == 0){
                    timestart1 = value;
                }else if(i == 1){
                    timestart2 = value;
                }else if(i == 2){
                    timestart3 = value;
                }else if(i == 3){
                    timestart4 = value;
                }else if(i == 4){
                    timestart5 = value;
                }else if(i == 5){
                    timestart6 = value;
                }else{
                    timestart7 = value;
                }

                let find = tdfind[0];
                let selectEle = find.firstElementChild;

                if(selectEle.name == 'endtime1'){
                    timeend1 = selectEle.value;
                }else if(selectEle.name == 'endtime2'){
                    timeend2 = selectEle.value;
                }else if(selectEle.name == 'endtime3'){
                    timeend3 = selectEle.value;
                }else if(selectEle.name == 'endtime4'){
                    timeend4 = selectEle.value;
                }else if(selectEle.name == 'endtime5'){
                    timeend5 = selectEle.value;
                }else if(selectEle.name == 'endtime6'){
                    timeend6 = selectEle.value;
                }else{
                    timeend7 = selectEle.value;
                }

                breaktimeupdate();

                if(value == '24H'){
                    selectEle.disabled = true;
                }
            });

            let sprukoopen = $('.sprukoopen');
            $.map(sprukoopen, function( value, i ) {
                // Do something
                let val = $(value).val(),
                    tdfind1 = $(value).closest('tr').find('.tr_clone1'),
                    tdfind2 = $(value).closest('tr').find('.tr_clone');

                let find1 = tdfind1[0];
                let selectEle1 = find1.firstElementChild;
                let find2 = tdfind2[0];
                let selectEle2 = find2.firstElementChild;

                if(val == 'Closed'){

                    selectEle1.disabled = true;
                    selectEle2.disabled = true;
                }
            });

            // Logos Delete
            $('body').on('click', '.logosdelete', function(e){
                e.preventDefault();
                let id = $(this).data('id');
                let logo = $(this).val();
                swal({
                    title: `{{lang('Are you sure want to remove this logo?')}}`,
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                if (willDelete) {
                        $.ajax({
                            type: "post",
                            url: "{{route('admin.bussinesslogodelete')}}",
                            data: {
                                'supporticonimage': 'supporticonimage',

                            },
                            success: function (data) {
                            toastr.success(data.success);
                            location.reload();
                            },
                            error: function (data) {
                            console.log('Error:', data);
                            }
                        });
                    }
                });
            });

            $('body').on('click', '#bussinesshourRest', function(e){
                e.preventDefault();
                // $('.sprukoweeks').html('')
                // dayListEle.forEach( e => {e.value = ''})
                // $('.sprukoopen').html('')
                // $('.sprukostarttime').html('')
                // $('.sprukoendtime').html('')
                // $('.sprukobreakstarttime').html('')
                // $('.sprukobreakendtime').html('')

                $('#bussinesshourRest').html('Reseting ... <i class="fa fa-spinner fa-spin"></i>');

                swal({
                    title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                    text: "{{lang('This might erase your records permanently', 'alerts')}}",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                    if (willDelete) {

                        $.ajax({
                            type: "post",
                            dataType: "json",
                            url: '{{ route('admin.businesshours.reset') }}',
                            data: {
                                'authid': "{{ Auth::id() }}",
                            },
                            success: function(data) {
                                if (data?.success) {
                                    toastr.success(data.success);
                                    location.reload();
                                }
                            },
                            error: function(data) {
                                $('#bussinesshourRest').html('Reset');
                                console.log(data);
                            }
                        });
                    }else{
                        $('#bussinesshourRest').html('Reset');
                    }
                });
            })
        });

        // Csrf Field
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var elementToToggle;
        $('#24hoursbusinessswitch').on('change', function(e){
            elementToToggle = e.target;
            let fullhours = $('#24hoursbusinessswitch').prop('checked') == true ? 'on' : 'off';

            let swalText = fullhours === 'on'
                ? '{{ lang('If you enable this all business hours are set to be 24/7 format, then holidays are not showing anymore.', 'alerts') }}'
                : '{{ lang('If you disable this, the 24/7 timings are disclosed you can change business hour timings accordingly to your concern.', 'alerts') }}'
            ;

            swal({
                title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                text: swalText,
                icon: "warning",
                buttons: {
                    cancel: {
                        text: "Cancel",
                        value: null,
                        visible: true,
                        className: "bg-danger",
                        closeModal: true,
                    },
                    confirm: {
                        text: "Reset User Hours",
                        value: 'erase',
                        visible: true,
                        className: "bg-success border-success",
                        closeModal: true,
                    },
                    customButton: {
                        text: "Skip User Hours",
                        value: "except",
                        visible: true,
                        className: "bg-info",
                        closeModal: true,
                    },
                },
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete != null) {
                    $.ajax({
                        type: "post",
                        dataType: "json",
                        url: '{{ url('/admin/bussinesshour/fullhours') }}',
                        data: {
                            'fullhours': fullhours,
                            'removetype': willDelete,
                        },
                        success: function(data) {
                            if (toastr.success('{{ lang('Updated successfully', 'alerts') }}')) {
                                location.reload();
                            }
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                } else {
                    elementToToggle.checked = !elementToToggle.checked;
                }
            });


        });

        @if (setting('24hoursbusinessswitch') == 'on')
            setInterval(()=>{
                document.querySelectorAll(".table-bussiness-hours select,#businessform .float-end button").forEach((ele)=>{
                    if(!ele.disabled){
                        ele.disabled = true
                    }
                })
            },100)
        @endif
    })
</script>


@endsection
