@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAl Summernote css -->
<link rel="stylesheet" href="{{asset('build/assets/plugins/summernote/summernote.css')}}?v=<?php echo time(); ?>">

<link href="{{asset('build/assets/plugins/dropzone/dropzone.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<link href="{{asset('build/assets/plugins/taginput/bootstrap-tagsinput.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

@endsection

@section('content')

<!--Page header-->
<div class="page-header d-xl-flex d-block">
	<div class="page-leftheader">
		<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Ticket To Article')}}</span></h4>
	</div>
</div>
<!--End Page header-->

<div class="row">
	<div class="col-xl-12 col-lg-12 col-md-12">
	<div class="card ">
		<div class="card-header border-0">
			<h4 class="card-title">{{lang('Ticket To Article')}}</h4>
		</div>
		<form method="post"  enctype="multipart/form-data" id="adminarticle_forms">

			@honeypot
			<div class="card-body">
				<div class="form-group">
					<label class="form-label">{{lang('Title')}}</label>
					<input type="text" class="form-control @error('title') is-invalid @enderror"  name="title" value="{{$articleticket->subject}}">
					<span id="TitleError" class="text-danger alert-message"></span>
					@error('title')

						<span class="invalid-feedback d-block" role="alert">
							<strong>{{ lang($message) }}</strong>
						</span>
					@enderror

				</div>
				<div class="form-group">
					<label class="form-label">{{lang('Category')}}</label>
					<select class="form-control select2-show-search  select2 @error('category') is-invalid @enderror" data-placeholder="{{lang('Select Category')}}" name="category" id="category">
						<option label="{{lang('Select Category')}}"></option>
						@foreach ($category as $category)

							<option value="{{ $category->id }}" @if ($category->id === 	$articleticket->category_id) selected @endif >{{ $category->name }}</option>
						@endforeach

					</select>
					<span id="CategoryError" class="text-danger alert-message"></span>
					@error('category')

						<span class="invalid-feedback d-block" role="alert">
							<strong>{{ lang($message) }}</strong>
						</span>
					@enderror

				</div>
				<div class="form-group" id="selectssSubCategory" style="display: none;">
					<label class="form-label mb-0 mt-2">{{lang('Subcategory')}}</label>
					<select  class="form-control select2-show-search  select2"  data-placeholder="{{lang('Select SubCategory')}}" name="subscategory" id="subscategory">
					</select>
					<span id="subsCategoryError" class="text-danger alert-message"></span>
				</div>
				<div class="form-group">
					<label class="form-label">{{lang('Description')}}:</label>
					<textarea class="summernote @error('message') is-invalid @enderror" name="message">
						@foreach($finalcomment as $finalcomments)
							<p>{{$finalcomments}}</p>
						@endforeach
					</textarea>
					@error('message')

						<span class="invalid-feedback d-block" role="alert">
							<strong>{{ lang($message) }}</strong>
						</span>
					@enderror

				</div>
				<div class="form-group">
					<label class="form-label">{{lang('Feature Image')}}</label>
					<div class="input-group file-browser">
						<div class="needsclick dropzone" id="feature-image"></div>
						@error('featureimage')

							<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
							</span>
						@enderror
						<span id="FeatureimageError" class="text-danger alert-message"></span>

					</div>
					<small class="text-muted"><i>{{lang('The file size should not be more than 5MB')}}</i></small>
				</div>
				@if ($articleticket->featureimage != null)
				@if($articleticket->featureimage == 'frontend.jpg')

				<div class="file-image-1 removesprukoi{{$articleticket->id}}">
					<div class="product-image custom-ul">
						<img src="{{asset('uploads/featureimage/demo/frontend.jpg')}}" class="br-5" alt="{{$articleticket->featureimage}}">

					</div>
				</div>
				@else

				<div class="file-image-1 removesprukoi{{$articleticket->id}}">
					<div class="product-image custom-ul">
						<a href="#">
							<img src="{{asset('uploads/featureimage/' .$articleticket->featureimage)}}" class="br-5" alt="{{$articleticket->featureimage}}">
						</a>
						<ul class="icons">
							<li><a href="javascript:void(0);" class="bg-danger imagefdel" data-id="{{$articleticket->id}}"><i class="fe fe-trash"></i></a></li>
						</ul>
					</div>
				</div>
				@endif

				@endif

				<div class="form-group">
					<label class="form-label">{{lang('Tags')}} <span class="text-red">*</span></label>
					<input type="text" id = "tags" class="form-control @error('tags') is-invalid @enderror" name="tags" value="{{old('tags')}}" data-role="tagsinput" />
					@error('tags')

						<span class="invalid-feedback d-block" role="alert">
							<strong>{{ lang($message) }}</strong>
						</span>
					@enderror
					<span id="TagsError" class="text-danger alert-message"></span>

				</div>

				<div class="form-group">
					<div class="custom-controls-stacked d-md-flex">
						<label class="form-label mt-1 me-5">{{lang('Status')}} : <span class="text-red">*</span></label>
						<label class="custom-control form-radio success me-4">
							<input type="radio" class="custom-control-input" name="status" value="Published" {{ $articleticket->status == 'Published' ? 'checked' : '' }}>
							<span class="custom-control-label">{{lang('Publish')}}</span>
						</label>
						<label class="custom-control form-radio success me-4">
							<input type="radio" class="custom-control-input" name="status" value="UnPublished" {{ $articleticket->status == 'UnPublished' ? 'checked' : '' }}>
							<span class="custom-control-label">{{lang('UnPublish')}}</span>
						</label>
					</div>
					<span id="StatusError" class="text-danger alert-message"></span>
				</div>
				<div class="form-group">
					<label class="form-label">{{lang('Upload File', 'filesetting')}}</label>
					<div class="needsclick dropzone" id="document-dropzone"></div>
					<small class="text-muted"><i>{{lang('The file size should not be more than', 'filesetting')}} {{setting('FILE_UPLOAD_MAX')}}{{lang('MB', 'filesetting')}}</i></small>
				</div>

				<div class="d-flex flex-wrap align-items-center">
					@foreach ($articleticket->getMedia('article') as $articles)

					<div class="file-image-1 m-1 removespruko{{$articles->id}}">
						<div class="product-image">


							<a href="javascript:void(0);">
								<img src="{{$articles->getFullUrl()}}" class="br-5" alt="{{$articles->file_name}}">
							</a>
							<ul class="icons">
								<li><a href="javascript:void(0);" class="bg-danger imagedel" data-id="{{$articles->id}}"><i class="fe fe-trash"></i></a></li>
							</ul>
						</div>

					</div>

					@endforeach
				</div>



			</div>
			<div class="card-footer clearfix">
				<div class="form-group float-end mb-0">
					<a href="{{ url('/admin/article') }}" class="btn btn-outline-danger mx-2" >{{lang('Close')}}</a>
					<button type="submit" class="btn btn-secondary" id="btnsave">{{lang('Save')}}</button>
				</div>
			</div>
		</form>
	</div>
</div>

@endsection


@section('scripts')

<!-- INTERNAL Vertical-scroll js-->
<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Summernote js  -->
<script src="{{asset('build/assets/plugins/summernote/summernote.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])
@vite(['resources/assets/js/select2.js'])

<script src="{{asset('build/assets/plugins/dropzone/dropzone.js')}}?v=<?php echo time(); ?>"></script>

<script src="{{asset('build/assets/plugins/taginput/bootstrap-tagsinput.js')}}?v=<?php echo time(); ?>"></script>


<script type="text/javascript">

    Dropzone.autoDiscover = false;
    $(function() {
        "use strict";

        // Variables
        var SITEURL = '{{url('')}}';

        // Csrf Field
        $.ajaxSetup({
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Attachment Image Upload
        var uploadedDocumentMap = {}
        var dropzoneElements = document.querySelectorAll("#document-dropzone");
        dropzoneElements.forEach((element)=>{
            new Dropzone(element,{
                url: '{{route('admin.imageupload')}}',
                maxFiles: parseInt('{{setting('USER_MAX_FILE_UPLOAD')}}')-parseInt(document.querySelectorAll("#adminarticle_forms [name='comments[]']").length),
                maxFilesize: '{{setting('USER_FILE_UPLOAD_MAX_SIZE')}}', // MB
                addRemoveLinks: true,
                acceptedFiles: '{{setting('USER_FILE_UPLOAD_TYPES')}}',
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                },
                success: function (file, response) {
                    if(element.closest('form').querySelectorAll("[name='article[]'").length){
                        element.closest('form').querySelectorAll("[name='article[]'").forEach((eleimg)=>{
                            if(eleimg.getAttribute('orinalName') == response.original_name){
                                toastr.error("You are already selected this.");
                                this.removeFile(file);
                                return;
                            }
                        })
                    }
                    $('form').append('<input type="hidden" name="article[]" orinalName="' + response.original_name + '" value="' + response.name + '">')
                    uploadedDocumentMap[file.name] = response.name
                },
                removedfile: function (file) {
                    file.previewElement.remove()
                    var name = ''
                    if (typeof file.file_name !== 'undefined') {
                        name = file.file_name
                    } else {
                            name = uploadedDocumentMap[file.name]
                    }
                    $('form').find('input[name="article[]"][value="' + name + '"]').remove()
                },
                init: function () {
                    @if(isset($project) && $project->document)
                        var files =
                            {!! json_encode($project->document) !!}
                        for (var i in files) {
                            var file = files[i]
                            this.options.addedfile.call(this, file)
                            file.previewElement.classList.add('dz-complete')
                            $('form').append('<input type="hidden" name="article[]" value="' + file.file_name + '">')
                        }
                    @endif

                    this.on('error', function(file, errorMessage) {
                        if (errorMessage.message) {
                            var errorDisplay = document.querySelectorAll('[data-dz-errormessage]');
                            errorDisplay[errorDisplay.length - 1].innerHTML = errorMessage.message;
                        }
                    });
                }
            })
        })

        // Feature Image
        // Dropzone.options.featureImage = {
        $("#feature-image").dropzone({
            url: '{{route('admin.featureimageupload')}}',
            maxFiles: '{{setting('MAX_FILE_UPLOAD')}}',
            maxFilesize: '5', // MB
            addRemoveLinks: true,
            acceptedFiles: '.jpeg,.jpg,.png',
                maxFiles: 1,
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            },
            success: function (file, response) {
                $('form').append('<input type="hidden" name="featureimage" value="' + response.name + '">')
                uploadedDocumentMap[file.name] = response.name
            },
            removedfile: function (file) {
                file.previewElement.remove()
                var name = ''
                if (typeof file.file_name !== 'undefined') {
                    name = file.file_name
                } else {
                        name = uploadedDocumentMap[file.name]
                }
                $('form').find('input[name="featureimage"][value="' + name + '"]').remove()
            },
            init: function () {
                @if(isset($project) && $project->document)
                    var files =
                        {!! json_encode($project->document) !!}
                    for (var i in files) {
                        var file = files[i]
                        this.options.addedfile.call(this, file)
                        file.previewElement.classList.add('dz-complete')
                        $('form').append('<input type="hidden" name="featureimage" value="' + file.file_name + '">')
                    }
                @endif
                this.on('error', function(file, errorMessage) {
                    if (errorMessage.message) {
                        var errorDisplay = document.querySelectorAll('[data-dz-errormessage]');
                        errorDisplay[errorDisplay.length - 1].innerHTML = errorMessage.message;
                    }
                });
            }

        });

        // Bootstrap tag js
        $('#tags').tagsinput({
            maxTags: 10
        });

        // Bootstrap tag js
        $('#tags').tagsinput({
            maxTags: 10
        });

        // Summernote js
        $('.summernote').summernote({
            placeholder: '',
            tabsize: 1,
            height: 120,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['fontname', ['fontname']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen']],
                ['help', ['help']]
            ],
        });

        // Attachment delete
        $('.imagedel').on('click', function () {
            let id = $(this).data("id");
            let _url = `{{url('/admin/image/delete/${id}')}}`;
            let _token   = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                type: "DELETE",
                url: _url,
                data: {_token: _token},
                success: function (data) {
                $(".removespruko"+id).remove();
                toastr.success(data.success);
                },
                error: function (data) {
                console.log('Error:', data);
                }
            });
        });

        // Feature Image delete
        $('.imagefdel').on('click', function () {
            let id = $(this).data("id");
            let _url = `{{url('/admin/article/featureimage/${id}')}}`;
            let _token   = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                type: "post",
                url: _url,
                data: {_token: _token},
                success: function (data) {
                $(".removesprukoi"+id).remove();
                toastr.success(data.success);
                },
                error: function (data) {
                console.log('Error:', data);
                }
            });
        });

        // when category change its get the subcat list
        $('#category').on('change',function(e) {
            e.preventDefault();
            var cat_id = e.target.value;
            $('#selectssSubCategory').hide();
            $.ajax({
                url:"{{ route('guest.subcategorylist') }}",
                type:"POST",
                dataType: "json",
                    data: {
                    cat_id: cat_id
                    },
                success:function (data) {
                    if(data.subcategoriess){

                        $('#selectssSubCategory').hide()
                        $('#subscategory').html(data.subcategoriess)
                        $('.subcategoryselect').select2();
                        $('#selectssSubCategory').show()
                    }
                    else{
                        $('#selectssSubCategory').hide();
                        $('#subscategory').html('')
                    }
                }
            })
        });

        // onload get the data from local
        $(window).on('load', function(){
            if(localStorage.getItem('articlesubject') || localStorage.getItem('articlemessage')){

                document.querySelector('#subject').value = localStorage.getItem('articlesubject');
                document.querySelector('.summernote').innerHTML = localStorage.getItem('articlemessage');
                document.querySelector('.note-editable').innerHTML = localStorage.getItem('articlemessage');
            }
        })

        // store subject to local
        $('#subject').on('keyup', function(e){
            localStorage.setItem('articlesubject', e.target.value)
        })

        // summernote
        $('.note-editable').on('keyup', function(e){
            localStorage.setItem('articlemessage', e.target.innerHTML)
        })


        // Create Ticket
        $('body').on('submit', '#adminarticle_forms', function (e) {
            e.preventDefault();
            $('#TitleError').html('');
            $('#CategoryError').html('');
            $('#MessageError').html('');
            $('#TagsError').html('');
            $('#StatusError').html('');
            var actionType = $('#btnsave').val();
            var fewSeconds = 2;
            $('#btnsave').html('Sending ... <i class="fa fa-spinner fa-spin"></i>');
            $('#btnsave').prop('disabled', true);
                setTimeout(function(){
                    $('#btnsave').prop('disabled', false);
                }, fewSeconds*1000);
            var formData = new FormData(this);

            $.ajax({
                type:'post',
                url: '{{url('/admin/article/create')}}',
                data: formData,
                cache:false,
                contentType: false,
                processData: false,

                success: (data) => {


                    $('#btnsave').html('{{lang('Save Changes')}}');
                    $('#TitleError').html('');
                    $('#CategoryError').html('');
                    $('#MessageError').html('');
                    $('#TagsError').html('');
                    $('#StatusError').html('');
                    toastr.success(data.success);
                    if(localStorage.getItem('articlesubject') || localStorage.getItem('articlemessage')){
                        localStorage.removeItem("articlesubject");
                        localStorage.removeItem("articlemessage");
                    }
                    window.location.replace('{{url('admin/article')}}');




                },
                error: function(data){
                    $('#btnsave').html('{{lang('Save Changes')}}');
                    $('#TitleError').html(data.responseJSON.errors.title);
                    $('#CategoryError').html(data.responseJSON.errors.category);
                    $('#MessageError').html(data.responseJSON.errors.message);
                    $('#TagsError').html(data.responseJSON.errors.tags);
                    $('#StatusError').html(data.responseJSON.errors.status);

                }
            });

        });
    })
</script>

@endsection
