@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAl Summernote css -->
<link rel="stylesheet" href="{{asset('build/assets/plugins/summernote/summernote.css')}}?v=<?php echo time(); ?>">

<!-- INTERNAL Data table css -->
<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<!-- INTERNAL Sweet-Alert css -->
<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<style>
    #hideAfterloading {
        position: absolute;
        top: 100px;
        left: 45%;
    }
</style>

@endsection

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Articles')}}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card ">
            <form method="POST" action="{{url('/admin/article')}}" enctype="multipart/form-data">
                @csrf

                @honeypot

                <div class="card-header d-sm-max-flex  border-0">
                    <h4 class="card-title">{{lang('Article Section')}}</h4>
                    <div class="card-options mt-sm-max-2 card-header-styles">
                        <small class="me-1 mt-1">{{lang('Show Section')}}</small>
                        <div class="float-end mt-0">
                            <div class="switch-toggle">
                                <a class="onoffswitch2">
                                    <input type="checkbox"  name="articlecheck" id="articlechecks" class=" toggle-class onoffswitch2-checkbox" value="on" @if($basic->articlecheck == 'on')  checked=""  @endif>
                                    <label for="articlechecks" class="toggle-class onoffswitch2-label" ></label>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body" >
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <input type="hidden" class="form-control " name="id" value="{{$basic->id}}">
                            <div class="form-group">
                                <label class="form-label">{{lang('Title')}}</label>
                                <input type="text" class="form-control @error('articletitle') is-invalid @enderror" name="articletitle" value="{{$basic->articletitle}}">
                                @error('articletitle')

                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ lang($message) }}</strong>
                                    </span>
                                @enderror

                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label class="form-label">{{lang('Subtitle')}}</label>
                                <input type="text" class="form-control @error('articlesub') is-invalid @enderror" name="articlesub" value="{{$basic->articlesub}}">
                                @error('articlesub')

                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ lang($message) }}</strong>
                                    </span>
                                @enderror

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 card-footer ">
                    <div class="form-group float-end">
                        <button type="submit" class="btn btn-secondary" value="{{lang('Save Changes')}}" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Save Changes')}}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card mb-0">
            <div class="card-header d-sm-max-flex border-0">
                <h4 class="card-title">{{lang('Article List')}}</h4>
                <div class="card-options mt-sm-max-2">
                    @can('Article Create')

                    <a href="{{url('/admin/article/create')}}" class="btn btn-secondary me-3" >{{lang('Add Article')}}</a>
                    @endcan

                </div>
            </div>
            <div class="card-body" style="min-height: 250px;">
                <div class="table-responsive spruko-delete">
                    @can('Article Delete')

                    <button id="massdelete" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
                    @endcan

                    <table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100" id="articlelist">
                        <thead>
                            <tr>
                                <th  width="9">{{lang('Sl.No')}}</th>
                                @can('Article Delete')

                                <th width="10" >
                                    <input type="checkbox"  id="customCheckAll" class="form-check-input">
                                    <label  for="customCheckAll"></label>
                                </th>
                                @endcan
                                @cannot('Article Delete')

                                <th width="10" >
                                    <input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
                                    <label  for="customCheckAll"></label>
                                </th>
                                @endcannot

                                <th  >{{lang('Article Title')}}</th>
                                <th >{{lang('Category')}}</th>
                                <th class="w-5">{{lang('Status')}}</th>
                                <th class="w-5">{{lang('Actions')}}</th>
                            </tr>
                        </thead>
                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                            <p>{{lang('loading.. Please Wait')}}</p>
                        </div>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts')


<!-- INTERNAL Vertical-scroll js-->
<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}"></script>

<!-- INTERNAL Summernote js  -->
<script src="{{asset('build/assets/plugins/summernote/summernote.js')}}"></script>

<!-- INTERNAL Data tables -->
<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}"></script>
<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}"></script>
<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}"></script>


<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])
@vite(['resources/assets/js/support/support-articles.js'])

<!-- INTERNAL Sweet-Alert js-->
<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}"></script>

<script type="text/javascript">

    "use strict";

    document.addEventListener("DOMContentLoaded", (event) => {

        let tableData = @json($articles);

        let dateFormat = @json(setting('date_format'));
        let delPerm = @json(Auth::user()->can('Article Delete'));
        let editPerm = @json(Auth::user()->can('Article Edit'));
        let viewPerm = @json(Auth::user()->can('Article View'));
        var SITEURL = '{{ url('') }}';

        var dataTable;
        var tableDropDown;

        loadTable(tableData);

        function truncateTitle(title) {
            const maxLength = 40;
            return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
        }

        function loadTable(tableData) {
            document.getElementById('hideAfterloading')?.classList.remove('d-none');
            document.getElementById('theadShow')?.classList.add('d-none');
            if (tableDropDown)
                tableDropDown.destroy();

            if (dataTable)
                dataTable.destroy();

            if (document.getElementById('tableBody'))
                document.getElementById('tableBody').remove();

            let createTbody = document.createElement('tbody');
            createTbody.setAttribute('id', "tableBody");
            let rows = tableData.map((data, index) => {

                return `
                    <tr>
                        <td>${index + 1}</td>
                        <td class="text-center">
                            ${delPerm
                                ? `<input type="checkbox" name="article_checkbox[]" class="checkall" value="${data.id}">`
                                : '~'
                            }

                        </td>

                        <td>${truncateTitle(data.title)}</td>

                        <td>
                        ${ data.category != null
                                ? truncateTitle(data.category.name)
                                : '~'
                            }
                        </td>

                        <td>

                            ${editPerm ? (data.status == 'Published' ? `<label class="custom-switch form-switch mb-0">
                                        <input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="Published" class="custom-switch-input tswitch" checked>
                                        <span class="custom-switch-indicator"></span>
                                    </label>` : ` <label class="custom-switch form-switch mb-0">
                                        <input type="checkbox"  name="status" data-id="${data.id}" id="myonoffswitch${data.id}" class="custom-switch-input tswitch" value="Published">
                                        <span class="custom-switch-indicator"></span>
                                    </label>` ) : '~'
                            }

                        </td>

                        <td>
                            <div class="btn-list">
                                ${editPerm ? `<a href="${SITEURL}/admin/article/${data.id}/edit" class="action-btns1">
                                    <i class="feather feather-edit text-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i>
                                    </a>` : '~'
                                }
                                ${delPerm ? `<a href="javascript:void(0)" class="action-btns1" data-id="${data.id}" id="show-delete" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"><i class="feather feather-trash-2 text-danger"></i></a>`
                                    : '~'
                                }
                                ${viewPerm ?
                                    (data.articleslug != null ? `<a href="${SITEURL}/article/${data.articleslug}" class="action-btns1" target="_blank" >
                                        <i class="feather feather-eye text-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('View')}}"></i></a>`
                                    : `<a href="{{url('article/${data.id}' )}}" class="action-btns1" target="_blank" >
                                        <i class="feather feather-eye text-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('View')}}"></i></a>` )
                                    : '~'
                                }
                            </div>
                        </td>

                    </tr>
                `;
            });

            if (tableData.length == 0)
                createTbody.innerHTML = ` `;
            else
                createTbody.innerHTML = rows.join('');


            // Append the tbody to your table
            // Replace 'your-table-id' with the actual ID of your table element
            document.getElementById('articlelist').appendChild(createTbody);

            document.getElementById('hideAfterloading')?.classList.add('d-none');
            document.getElementById('theadShow')?.classList.remove('d-none');

            // var myTable = document.querySelector("#support-category");

            $(document).ready(function() {

                var SITEURL = '{{ url('') }}';

                // Csrf field
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                let prev = {!! json_encode(lang('Previous')) !!};
                let next = {!! json_encode(lang('Next')) !!};
                let nodata = {!! json_encode(lang('No data available in table')) !!};
                let noentries = {!! json_encode(lang('No entries to show')) !!};
                let showing = {!! json_encode(lang('showing page')) !!};
                let ofval = {!! json_encode(lang('of')) !!};
                let maxRecordfilter = {!! json_encode(lang('- filtered from ')) !!};
                let maxRecords = {!! json_encode(lang('records')) !!};
                let entries = {!! json_encode(lang('entries')) !!};
                let show = {!! json_encode(lang('Show')) !!};
                let search = {!! json_encode(lang('Search...')) !!};

                // Datatable
                dataTable = $('#articlelist').DataTable({
                    language: {
                        searchPlaceholder: search,
                        scrollX: "100%",
                        sSearch: '',
                        paginate: {
                            previous: prev,
                            next: next
                        },
                        emptyTable: nodata,
                        infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                        info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                        infoEmpty: noentries,
                        lengthMenu: `${show} _MENU_ ${entries} `,
                    },
                    order: [],
                    columnDefs: [{
                        "orderable": false,
                        "targets": [0, 1, 4]
                    }],
                });

                // select2 js
                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

                $('.form-select').on('focus', function() {
                    $(this).attr('aria-hidden', 'false');
                });
            });


            initializeTooltips();

            function initializeTooltips() {
                var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                tooltipElements.forEach(function(element) {
                    new bootstrap.Tooltip(element);
                });
            }


        }


        $(function() {
            (function($)  {

                // Variables
                var SITEURL = '{{url('')}}';

                // Delete button article
                $('body').on('click', '#show-delete', function () {
                    let parent = $(this).closest('tr');
                    var _id = $(this).data("id");
                    swal({
                        title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                        text: "{{lang('This might erase your records permanently', 'alerts')}}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                type: "get",
                                url: SITEURL + "/admin/article/"+_id,
                                success: function (data) {
                                    toastr.success(data.success);
                                    $(parent[0]).addClass('fade-out');
                                    let newData = tableData.filter(item => item.id != parseInt(_id));
                                    tableData = newData;
                                    setTimeout(() => {
                                        parent[0].remove();
                                        loadTable(tableData);
                                    }, 1500);

                                },
                                error: function (data) {
                                    console.log('Error:', data);
                                }
                            });
                        }
                    });

                });

                // Status change article
                $('body').on('click', '.tswitch', function () {
                    var _id = $(this).data("id");
                    var status = $(this).prop('checked') == true ? 'Published' : 'UnPublished';
                    $.ajax({
                        type: "post",
                        url: SITEURL + "/admin/article/status"+_id,
                        data: {'status': status},
                        success: function (data) {
                            toastr.success(data.success);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                });

                // Mass Delete
                $('body').on('click', '#massdelete', function () {
                    var id = [];
                    var parent = [];
                    $('.checkall:checked').each(function(event){
                        parent.push($(this).closest('tr'));
                        id.push($(this).val());
                    });
                    if(id.length > 0){
                        swal({
                            title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                            text: "{{lang('This might erase your records permanently', 'alerts')}}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    url:"{{ url('admin/massarticle/delete')}}",
                                    method:"GET",
                                    data:{id:id},
                                    success:function(data)
                                    {
                                        toastr.success(data.success);
                                        parent.forEach(function(row) {
                                            row.addClass('fade-out');
                                        });
                                        let newData = tableData.filter(item => !id.includes(String(item.id)));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent.forEach(function(row) {
                                                row.remove();
                                            });
                                            $('#customCheckAll').prop('checked', false);
                                            loadTable(tableData);
                                        }, 1500);
                                    },
                                    error:function(data){

                                    }
                                });
                            }
                        });
                    }else{
                        toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                    }

                });

                $(document).ready(function() {

                    $(document).on('click', '#customCheckAll', function() {
                        $('.checkall').prop('checked', this.checked);
                        updateMassDeleteVisibility();
                    });

                    // Handle individual checkboxes
                    $(document).on('click', '.checkall', function() {
                        updateCustomCheckAll();
                        updateMassDeleteVisibility();
                    });

                    // Handle pagination controls
                    $(document).on('click', '.pagination a', function() {
                        // Assuming '.pagination a' is the selector for your pagination controls
                        setTimeout(function() {
                            updateMassDeleteVisibility();
                        }, 100);
                    });

                    // Initialize the "Select All" checkbox to unchecked
                    $('#customCheckAll').prop('checked', false);

                    // Function to update the visibility of the mass delete button
                    function updateMassDeleteVisibility() {
                        if ($('.checkall:checked').length == 0) {
                            $('#massdelete').hide();
                        } else {
                            $('#massdelete').show();
                        }
                    }

                    // Function to update the state of the "Select All" checkbox
                    function updateCustomCheckAll() {
                        var totalCheckboxes = $('.checkall').length;
                        var checkedCheckboxes = $('.checkall:checked').length;

                        if (checkedCheckboxes === totalCheckboxes) {
                            $('#customCheckAll').prop('checked', true);
                        } else {
                            $('#customCheckAll').prop('checked', false);
                        }
                    }
                });

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

            })(jQuery);
        })
    });
</script>

@endsection
