@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAl Summernote css -->
<link rel="stylesheet" href="{{asset('build/assets/plugins/summernote/summernote.css')}}?v=<?php echo time(); ?>">

<!-- INTERNAL Data table css -->
<link href="{{asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
<link href="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<!-- INTERNAL Datepicker css-->
<link href="{{asset('build/assets/plugins/modal-datepicker/datepicker.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<!-- INTERNAL Sweet-Alert css -->
<link href="{{asset('build/assets/plugins/sweet-alert/sweetalert.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

<style>
    #hideAfterloading {
        position: absolute;
        top: 100px;
        left: 45%;
    }
</style>

@endsection

@section('content')

<!--Page header-->
<div class="page-header d-xl-flex d-block">
	<div class="page-leftheader">
		<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Announcements')}}</span></h4>
	</div>
</div>
<!--End Page header-->
<div class="row">
    <!--Announcement List -->
    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card ">
            <div class="card-header border-0">

                <h4 class="card-title mb-md-max-2">{{lang('Announcements')}}</h4>
                <div class="card-options">
                    @can('Announcements Create')

                    <a href="{{route('announcement.create')}}" class="btn btn-secondary me-3">{{lang('Add New Announcement')}}</a>
                    @endcan

                </div>
            </div>
            <div class="card-body" style="min-height: 250px;">
                <div class="table-responsive">
                    @can('Announcements Delete')

                    <button id="massdeletenotify" class="btn btn-outline-light btn-sm mb-4 data-table-btn" style="display: none;"><i class="fe fe-trash"></i> {{lang('Delete')}}</button>
                    @endcan

                    <table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100 " id="support-articlelists">
                        <thead>
                            <tr>
                                <th  width="10">{{lang('Sl.No')}}</th>
                                @can('Announcements Delete')

                                <th width="10" >
                                    <input type="checkbox"  id="customCheckAll" class="form-check-input">
                                    <label  for="customCheckAll"></label>
                                </th>
                                @endcan
                                @cannot('Announcements Delete')

                                <th width="10" >
                                    <input type="checkbox"  id="customCheckAll" class="form-check-input" disabled>
                                    <label  for="customCheckAll"></label>
                                </th>
                                @endcannot

                                <th >{{lang('Title')}}</th>
                                <th >{{lang('Start Date')}}</th>
                                <th >{{lang('End Date')}}</th>
                                <th >{{lang('Selected Day')}}</th>
                                <th >{{lang('Status')}}</th>
                                <th >{{lang('Actions')}}</th>
                            </tr>
                        </thead>
                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                            <p>{{lang('loading.. Please Wait')}}</p>
                        </div>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- End Announcement List -->
</div>

@endsection

@section('modal')

@include('admin.announcement.model')

@endsection

@section('scripts')

<!-- INTERNAL Summernote js  -->
<script src="{{asset('build/assets/plugins/summernote/summernote.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Data tables -->
<script src="{{asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/dataTables.responsive.min.js')}}?v=<?php echo time(); ?>"></script>
<script src="{{asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])
@vite(['resources/assets/js/support/support-articles.js'])

<!-- INTERNAL Sweet-Alert js-->
<script src="{{asset('build/assets/plugins/sweet-alert/sweetalert.min.js')}}?v=<?php echo time(); ?>"></script>

<script src="{{asset('build/assets/plugins/jquery/jquery-ui.js')}}?v=<?php echo time(); ?>"></script>

<!-- INTERNALdatepicker js-->

<script type="text/javascript">
    "use strict";

    document.addEventListener("DOMContentLoaded", (event) => {

        let tableData = @json($announcements);

        let dateFormat = @json(setting('date_format'));
        let delPerm = @json(Auth::user()->can('Announcements Delete'));
        let editPerm = @json(Auth::user()->can('Announcements Edit'));

        var dataTable;
        var tableDropDown;

        loadTable(tableData);

        function truncateTitle(title) {
            const maxLength = 40;
            return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
        }

        function dateTime(createdTime) {

            const jsDate = new Date(createdTime);

            let format = @json(setting('date_format'));
            switch (format) {
                case 'd M, Y':
                    return jsDate.toLocaleDateString('en-GB', {
                        day: '2-digit',
                        month: 'short',
                        year: 'numeric'
                    });
                case 'm.d.y':
                    return jsDate.toLocaleDateString('en-US', {
                        day: '2-digit',
                        month: '2-digit',
                        year: '2-digit'
                    }).replace(/\//g, '.');
                case 'Y-m-d':
                    return jsDate.toISOString().split('T')[0];
                case 'd-m-Y':
                    return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                case 'd/m/Y':
                    return jsDate.toLocaleDateString('en-GB');
                case 'Y/m/d':
                    return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                default:
                    return jsDate.toLocaleDateString(); // Default format
            }

        }

        function loadTable(tableData) {
            document.getElementById('hideAfterloading')?.classList.remove('d-none');
            document.getElementById('theadShow')?.classList.add('d-none');
            if (tableDropDown)
                tableDropDown.destroy();

            if (dataTable)
                dataTable.destroy();

            if (document.getElementById('tableBody'))
                document.getElementById('tableBody').remove();

            let createTbody = document.createElement('tbody');
            createTbody.setAttribute('id', "tableBody");
            let rows = tableData.map((data, index) => {
                var editRouteUrl = "{{ route('announcement.edit', ['id' => ':id']) }}".replace(':id', data.id);

                return `
                    <tr>
                        <td>${index + 1}</td>

                        <td>
                            ${delPerm ? `<input type="checkbox" name="custom_checkbox[]" class="checkall form-check-input" value="${data.id}" />` : '~'}
                        </td>

                        <td>${truncateTitle(data.title)}</td>

                        ${data.announcementday ?
                            `
                            <td>~</td>
                            <td>~</td>
                            <td>${data.announcementday}</td>
                            `
                            :
                            `
                            <td>${dateTime(data.startdate)}</td>
                            <td>${dateTime(data.enddate)}</td>
                            <td>~</td>
                            `
                        }

                        <td>
                            ${editPerm ?
                                (data.status == '1' ?
                                    `<label class="custom-switch form-switch mb-0">
                                        <input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="1" class="custom-switch-input tswitch" checked>
                                        <span class="custom-switch-indicator"></span>
                                    </label>`
                                    :
                                    `<label class="custom-switch form-switch mb-0">
                                        <input type="checkbox" name="status" data-id="${data.id}" id="myonoffswitch${data.id}" value="1" class="custom-switch-input tswitch" >
                                        <span class="custom-switch-indicator"></span>
                                    </label>`
                                )
                                :
                                '~'
                            }
                        </td>

                        <td>
                            <div class = "d-flex">
                                ${editPerm ? `<a href="${editRouteUrl}" data-id="${data.id}" class="action-btns1"><i class="feather feather-edit text-primary" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Edit')}}"></i></a>` : ''}

                                ${delPerm ? `<a href="javascript:void(0)" data-id="${data.id}" class="action-btns1" id="delete-testimonial" ><i class="feather feather-trash-2 text-danger" data-id="${data.id}" data-bs-toggle="tooltip" data-bs-placement="top" title="{{lang('Delete')}}"></i></a>` : ''}
                            </div>

                        </td>

                    </tr>
                `;
            });

            if (tableData.length == 0)
                createTbody.innerHTML = ` `;
            else
                createTbody.innerHTML = rows.join('');


            // Append the tbody to your table
            // Replace 'your-table-id' with the actual ID of your table element
            document.getElementById('support-articlelists').appendChild(createTbody);

            document.getElementById('hideAfterloading')?.classList.add('d-none');
            document.getElementById('theadShow')?.classList.remove('d-none');

            $(document).ready(function() {

                var SITEURL = '{{ url('') }}';

                // Csrf field
                $.ajaxSetup({
                    headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });


                let prev = {!! json_encode(lang("Previous")) !!};
                let next = {!! json_encode(lang("Next")) !!};
                let nodata = {!! json_encode(lang("No data available in table")) !!};
                let noentries = {!! json_encode(lang("No entries to show")) !!};
                let showing = {!! json_encode(lang("showing page")) !!};
                let ofval = {!! json_encode(lang("of")) !!};
                let maxRecordfilter = {!! json_encode(lang("- filtered from ")) !!};
                let maxRecords = {!! json_encode(lang("records")) !!};
                let entries = {!! json_encode(lang("entries")) !!};
                let show = {!! json_encode(lang("Show")) !!};
                let search = {!! json_encode(lang("Search")) !!};
                // Datatable
                $('#support-articlelists').dataTable({
                    language: {
                        searchPlaceholder: search,
                        scrollX: "100%",
                        sSearch: '',
                        paginate: {
                        previous: prev,
                        next: next
                        },
                        emptyTable : nodata,
                        infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                        info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                        infoEmpty: noentries,
                        lengthMenu: `${show} _MENU_ ${entries} `,
                    },
                    order:[],
                    columnDefs: [
                        { "orderable": false, "targets":[ 0,1,4] }
                    ],
                });

                $('.form-select').select2({
                    minimumResultsForSearch: Infinity,
                    width: '100%'
                });

                $('.form-select').on('focus', function() {
                    $(this).attr('aria-hidden', 'false');
                });
            });


            initializeTooltips();

            function initializeTooltips() {
                var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                tooltipElements.forEach(function(element) {
                    new bootstrap.Tooltip(element);
                });
            }


        }

        $(function() {
            (function($)  {

                // Variables
                var SITEURL = '{{url('')}}';
                var now = Date.now();

                /*  When user click add announcement button */
                $('#create-new-testimonial').on('click', function () {
                    // Datepicker
                    $('#startdate').datepicker({
                        dateFormat: 'yy-mm-dd',
                        prevText: '<i class="fa fa-angle-left"></i>',
                        nextText: '<i class="fa fa-angle-right"></i>',
                        minDate: 0,
                        firstDay: {{setting('start_week')}},

                        onSelect: function (selectedDate) {

                            var diff = ($("#enddate").datepicker("getDate") -
                                $("#startdate").datepicker("getDate")) /
                                1000 / 60 / 60 / 24 + 1; // days
                            if ($("#enddate").datepicker("getDate") != null) {
                                $('#count').html(diff);
                                $('#days').val(diff);
                            }
                            $('#enddate').datepicker('option', 'minDate', selectedDate);
                        }
                    });
                    $('#enddate').datepicker({
                        dateFormat: 'yy-mm-dd',
                        prevText: '<i class="fa fa-angle-left"></i>',
                        nextText: '<i class="fa fa-angle-right"></i>',
                        firstDay: {{setting('start_week')}},
                        onSelect: function (selectedDate) {

                            $('#startdate').datepicker('option', 'maxDate', selectedDate);

                            var diff = ($("#enddate").datepicker("getDate") -
                                $("#startdate").datepicker("getDate")) /
                                1000 / 60 / 60 / 24 + 1; // days
                            if ($("#startdate").datepicker("getDate") != null) {
                                $('#count').html(diff);
                                $('#days').val(diff);
                            }
                        }
                    });

                    $('#btnsave').val("create-product");
                    $('#testimonial_id').val('');
                    $('#description').summernote({
                        height: 100,
                    });
                    $('#description').summernote('code','');
                    // Select2
                    $('.form-select').select2({
                        multiple: true,
                        minimumResultsForSearch: Infinity,
                        width:'100%',
                        closeOnSelect: false
                    });
                    $('#testimonial_form').trigger("reset");
                    $('.modal-title').html("{{lang('Add Announcement')}}");
                    $('#addtestimonial').modal('show');

                });

                /* When click delete announcement */
                $('body').on('click', '#delete-testimonial', function () {
                    let parent = $(this).closest('tr');
                    var _id = $(this).data("id");
                    swal({
                        title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                        text: "{{lang('This might erase your records permanently', 'alerts')}}",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                type: "get",
                                url: SITEURL + "/admin/announcement/delete/"+_id,
                                success: function (data) {
                                    toastr.success(data.success);
                                    $(parent[0]).addClass('fade-out');
                                    let newData = tableData.filter(item => item.id != parseInt(_id));
                                    tableData = newData;
                                    setTimeout(() => {
                                        parent[0].remove();
                                        if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                            $('#support-articlelists').DataTable().clear().destroy();
                                        }
                                        loadTable(tableData);
                                    }, 1500);
                                },
                                error: function (data) {
                                console.log('Error:', data);
                                }
                            });
                        }
                    });

                });

                //Mass Delete
                $('body').on('click', '#massdeletenotify', function () {
                    var parent = [];
                    var id = [];
                    $('.checkall:checked').each(function(){
                        parent.push($(this).closest('tr'));
                        id.push($(this).val());
                    });
                    if(id.length > 0){
                        swal({
                            title: `{{lang('Are you sure you want to continue?', 'alerts')}}`,
                            text: "{{lang('This might erase your records permanently', 'alerts')}}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    url:"{{ route('announcementall.delete')}}",
                                    method:"post",
                                    data:{id:id},
                                    success:function(data)
                                    {
                                        toastr.success(data.success);
                                        parent.forEach(function(row) {
                                            row.addClass('fade-out');
                                        });
                                        let newData = tableData.filter(item => !id.includes(String(item.id)));
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent.forEach(function(row) {
                                                row.remove();
                                            });
                                            if ($.fn.DataTable.isDataTable('#support-articlelists')) {
                                                $('#support-articlelists').DataTable().clear().destroy();
                                            }
                                            $('#customCheckAll').prop('checked', false);
                                            loadTable(tableData);
                                        }, 1500);

                                    },
                                    error:function(data){
                                        console.log(data);
                                    }
                                });
                            }
                        });
                    }else{
                        toastr.error('{{lang('Please select at least one check box.', 'alerts')}}');
                    }
                });

                // Announcement submit form
                $('body').on('submit', '#testimonial_form', function (e) {
                    e.preventDefault();
                    var actionType = $('#btnsave').val();

                    var fewSeconds = 2;
                    $('#btnsave').html('Sending..');
                    $('#btnsave').prop('disabled', true);
                        setTimeout(function(){
                            $('#btnsave').prop('disabled', false);
                        }, fewSeconds*1000);

                    var formData = new FormData(this);
                    $.ajax({
                        type:'POST',
                        url: SITEURL + "/admin/announcement/create",
                        data: formData,
                        cache:false,
                        contentType: false,
                        processData: false,
                        success: (data) => {
                            $('#testimonial_form').trigger("reset");
                            $('#addtestimonial').modal('hide');
                            $('#btnsave').html('{{lang('Save Changes')}}');
                            toastr.success(data.success);
                            location.reload();
                            $('#nameError').html('');
                            $('#descriptionError').html('');
                            $('#startdateError').html('');
                            $('#enddateError').html('');
                        },
                        error: function(data){
                            $('#nameError').html('');
                            $('#descriptionError').html('');
                            $('#startdateError').html('');
                            $('#enddateError').html('');
                            $('#nameError').html(data.responseJSON.errors.title);
                            $('#descriptionError').html(data.responseJSON.errors.notice);
                            $('#startdateError').html(data.responseJSON.errors.startdate);
                            $('#enddateError').html(data.responseJSON.errors.enddate);
                            $('#btnsave').html('{{lang('Save Changes')}}');
                        }
                    });
                });

                // Announcement  status
                $('body').on('click', '.tswitch', function () {
                    var _id = $(this).data("id");
                    var status = $(this).prop('checked') == true ? '1' : '0';
                        $.ajax({
                            type: "post",
                            url: SITEURL + "/admin/announcement/status"+_id,
                            data: {'status': status},
                            success: function (data) {
                                toastr.success(data.success);
                                location.reload();
                            },
                            error: function (data) {
                                console.log('Error:', data);
                            }
                        });
                });

                //checkbox script
                $(document).ready(function() {

                    $(document).on('click', '#customCheckAll', function() {
                        $('.checkall').prop('checked', this.checked);
                        updateMassDeleteVisibility();
                    });

                    $(document).on('click', '.checkall', function() {
                        updateCustomCheckAll();
                        updateMassDeleteVisibility();
                    });


                    $(document).on('click', '.pagination a', function() {

                        setTimeout(function() {
                            updateMassDeleteVisibility();
                        }, 100);
                    });


                    $('#customCheckAll').prop('checked', false);


                    function updateMassDeleteVisibility() {
                        if ($('.checkall:checked').length == 0) {
                            $('#massdeletenotify').hide();
                        } else {
                            $('#massdeletenotify').show();
                        }
                    }


                    function updateCustomCheckAll() {
                        var totalCheckboxes = $('.checkall').length;
                        var checkedCheckboxes = $('.checkall:checked').length;

                        if (checkedCheckboxes === totalCheckboxes) {
                            $('#customCheckAll').prop('checked', true);
                        } else {
                            $('#customCheckAll').prop('checked', false);
                        }
                    }
                });


            })(jQuery);
        });
    });

</script>


@endsection
