@extends('layouts.adminmaster')

@section('styles')
    <!-- INTERNAL Data table css -->
    <link href="{{ asset('build/assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />
    <link href="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />
    <link href="{{ asset('build/assets/plugins/datatable/buttonbootstrap.min.css') }}?v=<?php echo time(); ?>"
        rel="stylesheet" />

    <!-- INTERNAL Sweet-Alert css -->
    <link href="{{ asset('build/assets/plugins/sweet-alert/sweetalert.css') }}" rel="stylesheet" />

    <style>
        #hideAfterloading {
            position: absolute;
            top: 100px;
            left: 45%;
        }
    </style>
@endsection

@section('content')

    <!--Page header-->
    <div class="page-header d-xl-flex d-block">
        <div class="page-leftheader">
            <h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{ lang('Employees') }}</span></h4>
        </div>
    </div>
    <!--End Page header-->

    <div class="col-xl-12 col-lg-12 col-md-12">
        <div class="card ">
            <div class="card-header border-0 d-md-max-block">
                <h4 class="card-title  mb-md-max-2">{{ lang('Employees List') }}</h4>
                <div class="card-options  d-md-max-block">
                    @can('Employee Create')
                        <a href="{{ url('admin/employee/create') }}" class="btn btn-success me-3  mb-md-max-2 mw-12"><i
                                class="feather feather-user-plus"></i> {{ lang('Add Employee') }}</a>
                    @endcan
                    @can('Employee Importlist')
                        <a href="{{ route('user.userimport') }}" class="btn btn-info me-3  mb-md-max-2 mw-12"><i
                                class="feather feather-download"></i> {{ lang('Import Employees List') }}</a>
                    @endcan

                </div>
            </div>
            <div class="card-body" style="min-height: 250px;">
                <div class="table-responsive spruko-delete">
                    @can('Employee Delete')
                        <button id="massdelete" class="btn btn-outline-light btn-sm mb-4 data-table-btn"
                            style="display: none;"><i class="fe fe-trash"></i> {{ lang('Delete') }}</button>
                    @endcan

                    <table class="table table-bordered border-bottom text-nowrap ticketdeleterow w-100"
                        id="supportuserlist">
                        <thead>
                            <tr>
                                <th width="10">{{ lang('Sl.No') }}</th>
                                @can('Employee Delete')
                                    <th width="10">
                                        <input type="checkbox" id="customCheckAll" class="form-check-input">
                                        <label for="customCheckAll"></label>
                                    </th>
                                @endcan
                                @cannot('Employee Delete')
                                    <th width="10">
                                        <input type="checkbox" id="customCheckAll" class="form-check-input" disabled>
                                        <label for="customCheckAll"></label>
                                    </th>
                                @endcannot

                                <th> {{ lang('Employee Name') }}</th>
                                <th> {{ lang('Roles') }}</th>
                                <th> {{ lang('Register Date') }}</th>
                                <th class="w-5"> {{ lang('Status') }}</th>
                                <th> {{ lang('Actions') }}</th>
                            </tr>
                        </thead>
                        <div id="hideAfterloading"><img src="{{ asset('build/assets/images/loader.svg') }}" alt="">
                            <p>{{lang('loading.. Please Wait')}}</p>
                        </div>
                        {{-- <tbody>
                            @php $i = 1; @endphp
                            @foreach ($users as $user)
                                <tr id="row_id{{ $user->id }}">
                                    <td>{{ $i++ }}</td>
                                    <td>
                                        @if (Auth::user()->can('Employee Delete'))
                                            @if (Auth::check() && Auth::user()->id == '1')
                                                @if (Auth::user()->id != $user->id)
                                                    <input type="checkbox" name="customer_checkbox[]" class="checkall form-check-input"
                                                        value="{{ encrypt($user->id) }}" />
                                                @endif
                                            @else
                                                @if (Auth::user()->id != $user->id && !empty($user->getRoleNames()[0]) && $user->getRoleNames()[0] != 'superadmin')
                                                    <input type="checkbox" name="customer_checkbox[]" class="checkall form-check-input"
                                                        value="{{ encrypt($user->id) }}" />
                                                @endif
                                            @endif
                                        @else
                                            @if (Auth::check() && Auth::user()->id == '1')
                                                @if (Auth::user()->id != $user->id)
                                                    <input type="checkbox" name="customer_checkbox[]" class="checkall form-check-input"
                                                        value="{{ encrypt($user->id) }}" disabled />
                                                @endif
                                            @else
                                                @if (Auth::user()->id != $user->id && !empty($user->getRoleNames()[0]) && $user->getRoleNames()[0] != 'superadmin')
                                                    <input type="checkbox" name="customer_checkbox[]" class="checkall form-check-input"
                                                        value="{{ encrypt($user->id) }}" disabled />
                                                @endif
                                            @endif
                                        @endif
                                    </td>
                                    <td>
                                        <div>
                                            <a href="#" class="h5">{{ Str::limit($user->name, '40') }}</a>

                                        </div>
                                        <small class="fs-12 text-muted"> <span
                                                class="font-weight-normal1">{{ Str::limit($user->email, '40') }}</span></small>
                                    </td>
                                    <td>
                                        @if (!empty($user->getroleNames()[0]))
                                            <span>{{ Str::limit($user->getroleNames()[0], '40') }}</span>
                                        @else
                                            ~
                                        @endif
                                    </td>
                                    <td>
                                        <span
                                            class="badge badge-success-light">{{ \Carbon\Carbon::parse($user->created_at)->format(setting('date_format')) }}</span>
                                    </td>

                                    <td>
                                        @if (Auth::user()->can('Employee Status'))
                                            @if (Auth::check() && Auth::user()->id == '1')
                                                @if (Auth::user()->id != $user->id)
                                                    <label class="custom-switch form-switch mb-0">
                                                        <input type="checkbox" name="status"
                                                            data-id="{{ encrypt($user->id) }}"
                                                            id="myonoffswitch{{ encrypt($user->id) }}" value="1"
                                                            class="custom-switch-input tswitch"
                                                            {{ $user->status == 1 ? 'checked' : '' }}>
                                                        <span class="custom-switch-indicator"></span>
                                                    </label>
                                                @endif
                                            @else
                                                @if (Auth::user()->id != $user->id && !empty($user->getRoleNames()[0]) && $user->getRoleNames()[0] != 'superadmin')
                                                    <label class="custom-switch form-switch mb-0">
                                                        <input type="checkbox" name="status"
                                                            data-id="{{ encrypt($user->id) }}"
                                                            id="myonoffswitch{{ encrypt($user->id) }}" value="1"
                                                            class="custom-switch-input tswitch"
                                                            {{ $user->status == 1 ? 'checked' : '' }}>
                                                        <span class="custom-switch-indicator"></span>
                                                    </label>
                                                @endif
                                            @endif

                                            @if ($user->id != '1')
                                            @endif
                                        @else
                                            ~
                                        @endif
                                    </td>
                                    <td>
                                        <div class = "d-flex">
                                            @if (Auth::user()->can('Employee Edit'))
                                                @if (Auth::check() && Auth::user()->id == '1')
                                                    <a href="{{ url('/admin/agentprofile/' . encrypt($user->id)) }}"
                                                        class="action-btns1" data-bs-toggle="tooltip"
                                                        data-bs-placement="top" title="{{ lang('Edit') }}"><i
                                                            class="feather feather-edit text-primary"></i></a>
                                                @else
                                                    @if ($user->id != '1' && !empty($user->getRoleNames()[0]))
                                                        @if ($user->id == Auth::user()->id || $user->getRoleNames()[0] != 'superadmin')
                                                            <a href="{{ url('/admin/agentprofile/' . encrypt($user->id)) }}"
                                                                class="action-btns1" data-bs-toggle="tooltip"
                                                                data-bs-placement="top" title="{{ lang('Edit') }}"><i
                                                                    class="feather feather-edit text-primary"></i></a>
                                                        @endif
                                                    @endif
                                                @endif
                                            @else
                                                ~
                                            @endif
                                            @if (Auth::user()->can('Employee Delete'))
                                                @if (Auth::check() && Auth::user()->id == '1')
                                                    @if (Auth::user()->id != $user->id)
                                                        <a href="javascript:void(0)" class="action-btns1"
                                                            data-id="{{ encrypt($user->id) }}" id="show-delete"
                                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                                            title="{{ lang('Delete') }}"><i
                                                                class="feather feather-trash-2 text-danger"></i></a>
                                                    @endif
                                                @else
                                                    @if (Auth::user()->id != $user->id && !empty($user->getRoleNames()[0]) && $user->getRoleNames()[0] != 'superadmin')
                                                        <a href="javascript:void(0)" class="action-btns1"
                                                            data-id="{{ encrypt($user->id) }}" id="show-delete"
                                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                                            title="{{ lang('Delete') }}"><i
                                                                class="feather feather-trash-2 text-danger"></i></a>
                                                    @endif
                                                @endif
                                            @else
                                                ~
                                            @endif
                                            @if (Auth::user()->can('Reset Password'))
                                                @if (Auth::check() && Auth::user()->id == '1')
                                                    <a href="javascript:void(0)" class="action-btns1"
                                                        data-id="{{ encrypt($user->id) }}" id="reset-password"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="{{ lang('Reset Password') }}"><i
                                                            class="feather feather-lock text-info"></i></a>
                                                @else
                                                    @if ($user->id != '1' && !empty($user->getRoleNames()[0]))
                                                        @if ($user->id == Auth::user()->id || $user->getRoleNames()[0] != 'superadmin')
                                                            <a href="javascript:void(0)" class="action-btns1"
                                                                data-id="{{ encrypt($user->id) }}" id="reset-password"
                                                                data-bs-toggle="tooltip" data-bs-placement="top"
                                                                title="{{ lang('Reset Password') }}"><i
                                                                    class="feather feather-lock text-info"></i></a>
                                                        @endif
                                                    @endif
                                                @endif
                                            @endif


                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody> --}}
                    </table>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('scripts')
    <!-- INTERNAL Data tables -->
    <script src="{{ asset('build/assets/plugins/datatable/js/jquery.dataTables.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/js/dataTables.bootstrap5.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/dataTables.responsive.min.js') }}?v=<?php echo time(); ?>">
    </script>
    <script src="{{ asset('build/assets/plugins/datatable/responsive.bootstrap5.min.js') }}?v=<?php echo time(); ?>">
    </script>
    <script src="{{ asset('build/assets/plugins/datatable/datatablebutton.min.js') }}?v=<?php echo time(); ?>"></script>
    <script src="{{ asset('build/assets/plugins/datatable/buttonbootstrap.min.js') }}?v=<?php echo time(); ?>"></script>

    <!-- INTERNAL Sweet-Alert js-->
    <script src="{{ asset('build/assets/plugins/sweet-alert/sweetalert.min.js') }}?v=<?php echo time(); ?>"></script>

    <script type="text/javascript">
        "use strict";

        document.addEventListener("DOMContentLoaded", (event) => {

            let tableData = @json($users);
            let dateFormat = @json(setting('date_format'));
            let timeZone = @json(Auth::user()->timezone);
            let delPerm = @json(Auth::user()->can('Employee Delete'));
            let editPerm = @json(Auth::user()->can('Employee Edit'));
            let satusPerm = @json(Auth::user()->can('Employee Status'));
            let pswdPerm = @json(Auth::user()->can('Reset Password'));
            let baseUrl = "{{ url('/admin/agentprofile/') }}";
            let check = @json(Auth::check());
            let user = @json(Auth::user()->id);

            var dataTable;
            var tableDropDown;

            loadTable(tableData);

            function truncateTitle(title) {
                const maxLength = 40;
                return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
            }

            function dateTime(createdTime) {

                const jsDate = new Date(createdTime);

                let format = @json(setting('date_format'));
                switch (format) {
                    case 'd M, Y':
                        return jsDate.toLocaleDateString('en-GB', {
                            day: '2-digit',
                            month: 'short',
                            year: 'numeric'
                        });
                    case 'm.d.y':
                        return jsDate.toLocaleDateString('en-US', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        }).replace(/\//g, '.');
                    case 'Y-m-d':
                        return jsDate.toISOString().split('T')[0];
                    case 'd-m-Y':
                        return jsDate.toLocaleDateString('en-GB').replace(/\//g, '-');
                    case 'd/m/Y':
                        return jsDate.toLocaleDateString('en-GB');
                    case 'Y/m/d':
                        return jsDate.toISOString().split('T')[0].replace(/-/g, '/');
                    default:
                        return jsDate.toLocaleDateString(); // Default format
                }

            }

            function loadTable(tableData) {
                document.getElementById('hideAfterloading')?.classList.remove('d-none');
                document.getElementById('theadShow')?.classList.add('d-none');
                if (tableDropDown)
                    tableDropDown.destroy();

                if (dataTable)
                    dataTable.destroy();

                if (document.getElementById('tableBody'))
                    document.getElementById('tableBody').remove();

                let createTbody = document.createElement('tbody');
                createTbody.setAttribute('id', "tableBody");
                let rows = tableData.map((data, index) => {

                    return `
                        <tr>
                            <td>${index + 1}</td>

                            <td>
                                ${delPerm ?
                                    (check && user == '1' ?
                                        (user != data.id ? `<input type="checkbox" name="customer_checkbox[]" class="checkall form-check-input" value="${data.encrypted_id}" />` : '~')
                                        :
                                        (user != data.id && data.roles[0].name && data.roles[0].name != 'superadmin' ?`<input type="checkbox" name="customer_checkbox[]" class="checkall form-check-input" value="${data.encrypted_id}" />` : '~')
                                    )
                                    :
                                    '~'
                                }
                            </td>

                            <td>
                                <div>${truncateTitle(data.name)} </div>
                                <small class="fs-12 text-muted"> <span class="font-weight-normal1">${truncateTitle(data.email)}</span></small>
                            </td>

                            <td>
                                ${data.roles[0].name ? `<span>${truncateTitle(data.roles[0].name)}</span>` : '~'}
                            </td>

                            <td>
                                <span class="badge badge-success-light">${dateTime(data.created_at)}</span>
                            </td>

                            <td>
                                ${ satusPerm ? ( check && user == '1' ? (user != data.id ? `<label class="custom-switch form-switch mb-0">
                                                        <input type="checkbox" name="status"
                                                            data-id="${data.encrypted_id}"
                                                            id="myonoffswitch${data.encrypted_id}" value="1"
                                                            class="custom-switch-input tswitch"
                                                            ${data.status == 1 ? 'checked' : '' }>
                                                        <span class="custom-switch-indicator"></span>
                                                    </label>`  : '~')
                                 : `<label class="custom-switch form-switch mb-0">
                                                        <input type="checkbox" name="status"
                                                            data-id="${data.encrypted_id}"
                                                            id="myonoffswitch${data.encrypted_id}" value="1"
                                                            class="custom-switch-input tswitch"
                                                            ${data.status == 1 ? 'checked' : '' }>
                                                        <span class="custom-switch-indicator"></span>
                                                    </label>`)
                                 : '~' }
                            </td>


                            <td>
                                <div class="btn-list">
                                    ${editPerm ?
                                        (check && user == '1' || (user != '1' && data.roles[0].name && (user == data.id || data.roles[0].name != 'superadmin')) ?
                                            `<a href="${baseUrl}/${data.encrypted_id}"
                                                data-id="${data.encrypted_id}" class="action-btns1" data-bs-toggle="tooltip"
                                                data-bs-toggle="tooltip" data-bs-placement="top"
                                                data-bs-original-title="{{ lang('Edit') }}"><i
                                                    data-id="${data.encrypted_id}" class="feather feather-edit text-primary"></i></a>` : '~'
                                        )
                                        :
                                        '~'
                                    }

                                    ${delPerm ?
                                        ((check && user == '1' ?
                                        (user != data.id ? `<a href="javascript:void(0)" class="action-btns1" data-id="${data.encrypted_id}" id="show-delete" data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"><i data-id="${data.encrypted_id}" class="feather feather-trash-2 text-danger"></i></a>` : '~') : (user != data.id && data.roles[0].name && data.roles[0].name != 'superadmin' ? `<a href="javascript:void(0)" class="action-btns1" data-id="${data.encrypted_id}" id="show-delete" data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"><i data-id="${data.encrypted_id}" class="feather feather-trash-2 text-danger"></i></a>` : '~'))

                                        )
                                        : '~'
                                    }

                                    ${pswdPerm ?
                                        (check && user == '1' ? `<a href="javascript:void(0)" class="action-btns1" data-id="${data.encrypted_id}" id="reset-password" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Reset Password') }}"><i data-id="${data.encrypted_id}" class="feather feather-lock text-info"></i></a>` : (data.id != '1' && data.roles[0].name && data.roles[0].name != 'superadmin' && (data.id == user || data.resetPassPermission != 'exists') ? `<a href="javascript:void(0)" class="action-btns1" data-id="${data.encrypted_id}" id="reset-password" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ lang('Reset Password') }}"><i data-id="${data.encrypted_id}" class="feather feather-lock text-info"></i></a>` : '~'))
                                        :
                                        '~'
                                    }

                                </div>
                            </td>

                        </tr>
                    `;
                });

                if (tableData.length == 0)
                    createTbody.innerHTML = ` `;
                else
                    createTbody.innerHTML = rows.join('');


                document.getElementById('supportuserlist').appendChild(createTbody);

                document.getElementById('hideAfterloading')?.classList.add('d-none');
                document.getElementById('theadShow')?.classList.remove('d-none');

                $(document).ready(function() {

                    var SITEURL = '{{ url('') }}';

                    // Csrf field
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    let prev = {!! json_encode(lang('Previous')) !!};
                    let next = {!! json_encode(lang('Next')) !!};
                    let nodata = {!! json_encode(lang('No data available in table')) !!};
                    let noentries = {!! json_encode(lang('No entries to show')) !!};
                    let showing = {!! json_encode(lang('showing page')) !!};
                    let ofval = {!! json_encode(lang('of')) !!};
                    let maxRecordfilter = {!! json_encode(lang('- filtered from ')) !!};
                    let maxRecords = {!! json_encode(lang('records')) !!};
                    let entries = {!! json_encode(lang('entries')) !!};
                    let show = {!! json_encode(lang('Show')) !!};
                    let search = {!! json_encode(lang('Search')) !!};
                    // Datatable
                    $('#supportuserlist').dataTable({
                        language: {
                            searchPlaceholder: search,
                            scrollX: "100%",
                            sSearch: '',
                            paginate: {
                                previous: prev,
                                next: next
                            },
                            emptyTable: nodata,
                            infoFiltered: `${maxRecordfilter} _MAX_ ${maxRecords}`,
                            info: `${showing} _PAGE_ ${ofval} _PAGES_`,
                            infoEmpty: noentries,
                            lengthMenu: `${show} _MENU_ ${entries} `,
                        },
                        order: [],
                        columnDefs: [{
                            "orderable": false,
                            "targets": [0, 1, 4]
                        }],
                    });

                    // __Select2 js
                    $('.form-select').select2({
                        minimumResultsForSearch: Infinity,
                        width: '100%'
                    });

                    $('.form-select').on('focus', function() {
                        $(this).attr('aria-hidden', 'false');
                    });
                });


                initializeTooltips();

                function initializeTooltips() {
                    var tooltipElements = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                    tooltipElements.forEach(function(element) {
                        new bootstrap.Tooltip(element);
                    });
                }
            }

            $(function() {
                var SITEURL = '{{ url('') }}';
                (function($) {
                    $(document).ready(function() {

                        $(document).on('click', '#customCheckAll', function() {
                            $('.checkall').prop('checked', this.checked);
                            updateMassDeleteVisibility();
                        });

                        // Handle individual checkboxes
                        $(document).on('click', '.checkall', function() {
                            updateCustomCheckAll();
                            updateMassDeleteVisibility();
                        });

                        // Handle pagination controls
                        $(document).on('click', '.pagination a', function() {
                            // Assuming '.pagination a' is the selector for your pagination controls
                            setTimeout(function() {
                                updateMassDeleteVisibility();
                            }, 100);
                        });

                        // Initialize the "Select All" checkbox to unchecked
                        $('#customCheckAll').prop('checked', false);

                        // Function to update the visibility of the mass delete button
                        function updateMassDeleteVisibility() {
                            if ($('.checkall:checked').length == 0) {
                                $('#massdelete').hide();
                            } else {
                                $('#massdelete').show();
                            }
                        }

                        // Function to update the state of the "Select All" checkbox
                        function updateCustomCheckAll() {
                            var totalCheckboxes = $('.checkall').length;
                            var checkedCheckboxes = $('.checkall:checked').length;

                            if (checkedCheckboxes === totalCheckboxes) {
                                $('#customCheckAll').prop('checked', true);
                            } else {
                                $('#customCheckAll').prop('checked', false);
                            }
                        }
                    });


                    // Delete Button
                    $('body').on('click', '#show-delete', function() {
                        let parent = $(this).closest('tr');
                        var _id = $(this).data("id");

                        swal({
                            title: `{{ lang('Are you sure you want to delete?', 'alerts') }}`,
                            text: "{{ lang('This will erase all chats aswell.', 'alerts') }}",
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                $.ajax({
                                    type: "post",
                                    url: SITEURL + "/admin/agent/" + _id,
                                    success: function(data) {
                                        toastr.success(data.success);
                                        // location.reload();
                                        $(parent[0]).addClass('fade-out');

                                        let newData = tableData.filter(item => item.encrypted_id != _id);
                                        tableData = newData;
                                        setTimeout(() => {
                                            parent[0].remove();
                                            if ($.fn.DataTable.isDataTable('#supportuserlist')) {
                                                $('#supportuserlist').DataTable().clear().destroy();
                                            }
                                            loadTable(tableData);
                                        }, 1500);
                                    },
                                    error: function(data) {
                                        console.log('Error:', data);
                                        if(data.responseJSON.message == 'The payload is invalid.'){
                                            toastr.error('You are not allow to delete this profile.');
                                        }else{
                                            toastr.error(data.error);
                                        }
                                    }
                                });
                            }
                        });

                    });

                    // status switch
                    $('body').on('click', '.tswitch', function() {
                        var _id = $(this).data("id");
                        var status = $(this).prop('checked') == true ? '1' : '0';
                        $.ajax({
                            type: "post",
                            url: SITEURL + "/admin/agent/status/" + _id,
                            data: {
                                'status': status
                            },
                            success: function(data) {

                                toastr.success(data.success);
                            },
                            error: function(data) {
                                console.log('Error:', data);
                                if(data.responseJSON.message == 'The payload is invalid.'){
                                    toastr.error('You are not allow to change this status.');
                                }else{
                                    toastr.error(data.error);
                                }
                            }
                        });
                    });

                    //Mass Delete
                    $('body').on('click', '#massdelete', function() {
                        var parent = [];
                        var id = [];
                        $('.checkall:checked').each(function() {
                            parent.push($(this).closest('tr'));
                            id.push($(this).val());
                        });
                        if (id.length > 0) {
                            swal({
                                    title: `{{ lang('Are you sure you want to continue?', 'alerts') }}`,
                                    text: "{{ lang('This might erase your records permanently', 'alerts') }}",
                                    icon: "warning",
                                    buttons: true,
                                    dangerMode: true,
                                })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        $.ajax({
                                            url: "{{ url('admin/massuser/deleteall') }}",
                                            method: "post",
                                            data: {
                                                id: id
                                            },
                                            success: function(data) {

                                                toastr.success(data.success);
                                                parent.forEach(function(row) {
                                                    row.addClass('fade-out');
                                                });
                                                let newData = tableData.filter(item => !id.includes(String(item.encrypted_id)));
                                                tableData = newData;
                                                setTimeout(() => {
                                                    parent.forEach(function(row) {
                                                        row.remove();
                                                    });
                                                    if ($.fn.DataTable.isDataTable('#supportuserlist')) {
                                                        $('#supportuserlist').DataTable().clear().destroy();
                                                    }
                                                    $('#customCheckAll').prop('checked', false);
                                                    loadTable(tableData);
                                                }, 1500);

                                            },
                                            error: function(data) {

                                            }
                                        });
                                    }
                                });
                        } else {
                            toastr.error('{{ lang('Please select at least one check box.', 'alerts') }}');
                        }
                    });

                    $('body').on('click', '#reset-password', function() {
                        let psdsprukochange = $(this).data('id');

                        $('.modal-title').html('{{ lang('Change Password') }}')
                        $('#sprukopasswordreset_form').trigger('reset')

                        $('.sprukopasswordreset_id').val(psdsprukochange)
                        $('#addpasswordreset').modal('show');
                    });
                    $('body').on('submit', '#sprukopasswordreset_form', function(e) {
                        e.preventDefault();

                        var actionType = $('#sprukoempchange').val();
                        var fewSeconds = 2;
                        $('#sprukoempchange').html('Sending ... <i class="fa fa-spinner fa-spin"></i>');
                        $('#sprukoempchange').prop('disabled', true);
                        setTimeout(function() {
                            $('#sprukoempchange').prop('disabled', false);
                            $('#sprukoempchange').html('Save');
                        }, fewSeconds * 1000);
                        var formData = new FormData(this);
                        $.ajax({
                            type: 'POST',
                            url: '{{ url('admin/employeepasswordreset') }}',
                            data: formData,
                            cache: false,
                            contentType: false,
                            processData: false,

                            success: (data) => {
                                toastr.success(data.success);
                                $('#sprukopasswordreset_form').trigger("reset");
                                $('#addpasswordreset').modal('hide');
                            },
                            error: function(data) {
                                if(data.responseJSON.message == 'The payload is invalid.'){
                                    toastr.error('You are not allow to change this password.');
                                }else{
                                    toastr.error(data.error);
                                }
                            }
                        });

                    })

                })(jQuery);
            });
        });
    </script>
@endsection

@section('modal')
    @include('admin.agent.passwordresetmodal')
@endsection
