
@extends('layouts.adminmaster')

@section('styles')

<!-- INTERNAl Tag css -->
<link href="{{asset('build/assets/plugins/taginput/bootstrap-tagsinput.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

@endsection

@section('content')


<!--Page header-->
<div class="page-header d-xl-flex d-block">
	<div class="page-leftheader">
		<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{lang('Employee')}}</span></h4>
	</div>
</div>
<!--End Page header-->

<!-- Employee Create -->
<div class="col-xl-12 col-lg-12 col-md-12">
	<div class="card ">
        <form method="POST" action="{{url('/admin/agent')}}" enctype="multipart/form-data">
            @csrf
            @honeypot

            <div class="card-header border-0">
                <h4 class="card-title">{{lang('Create Employee')}}</h4>
            </div>
			<div class="card-body" >
				<div class="row">
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('First Name')}} <span class="text-red">*</span></label>
							<input type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname"  value="{{old('firstname')}}" placeholder="Enter first name">
							@error('firstname')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Last Name')}} <span class="text-red">*</span></label>
							<input type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname"  value="{{old('lastname')}}"placeholder="Enter last name">
							@error('lastname')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Select Role')}} <span class="text-red">*</span></label>
							<select id="roleID" class="form-control select2-show-search  select2 @error('role') is-invalid @enderror" data-placeholder="{{lang('Select Roles')}}" name="role"  >
								<option label="{{lang('Select Role')}}"></option>
								@foreach($roles as $role)

									<option  value="{{$role->name}}" {{ old('role') == $role->name ? "selected" : "" }}> {{$role->name}}</option>
								@endforeach

							</select>
							@error('role')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Employee ID')}} <span class="text-red">*</span></label>
							<input type="text" class="form-control @error('empid') is-invalid @enderror" placeholder="EMPID-001" name="empid"  value="{{old('empid')}}">
							@error('empid')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Email')}} <span class="text-red">*</span></label>
							<input type="email" class="form-control @error('email') is-invalid @enderror" name="email"  value="{{old('email')}}"placeholder="Enter Email Id">
							@error('email')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Password')}} <small class="text-muted"><i>{{lang('(Please copy the Password)')}}</i></small></label>
							<input class="form-control @error('password') is-invalid @enderror" type="text"  name="password" value="{{str_random(10)}}"  readonly>
							@error('password')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror
						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Mobile Number')}} </label>
							<input type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" placeholder="Enter Mobile Number" value="{{old('phone')}}">
							@error('phone')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Languages')}}</label>
							<input type="text"  class="form-control @error('languages') is-invalid @enderror" value="{{old('languages')}}" name="languages" placeholder="Enter language" data-role="tagsinput"/>
							@error('languages')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Skills')}}</label>
							<input type="text"  class="form-control @error('skills') is-invalid @enderror" value="{{old('skills')}}" name="skills" data-role="tagsinput" placeholder="Enter skills"/>
							@error('skills')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
							@enderror

						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Country')}}</label>
							<select name="country" class="form-control select2 select2-show-search" id="">
								@foreach($countries as $country)
								<option value=""></option>
								<option value="{{$country->name}}">{{$country->name}}</option>
								@endforeach
							</select>


						</div>
					</div>
					<div class="col-sm-6 col-md-6">
						<div class="form-group">
							<label class="form-label">{{lang('Timezone')}}</label>
							<select name="timezone" class="form-control select2 select2-show-search" id="">
								@foreach($timezones  as $group => $timezoness)
									<option value=""></option>
									<option value="{{$timezoness->timezone}}">{{$timezoness->timezone}} {{$timezoness->utc}}</option>

								@endforeach
							</select>
						</div>
					</div>
					<div class="col-md-12">
						<div class="form-group">
							<label class="form-label">{{lang('Upload Image')}}</label>
							<div class="input-group file-browser">
								<input class="form-control @error('image') is-invalid @enderror" name="image" type="file" accept="image/png, image/jpeg,image/jpg" >
								@error('image')

								<span class="invalid-feedback d-block" role="alert">
									<strong>{{ lang($message) }}</strong>
								</span>
								@enderror

							</div>
							<small class="text-muted"><i>{{lang('The file size should not be more than 5MB', 'filesetting')}}</i></small>
						</div>
					</div>
				</div>
                <div class="d-flex">
                    <h4 class="card-title">{{lang('Personal Business Hours :', 'menu')}}</h4>
                    <div class="ms-5">
                        <label class="me-1 mt-1"><b>{{lang('Enable 24/7')}}</b></label>
                        <div class="float-end mt-0">
                            <div class="switch-toggle">
                                <a class="onoffswitch2">
                                    <input type="checkbox" name="24hoursbusinessswitch" id="24hoursbusinessswitch"
                                        class=" toggle-class onoffswitch2-checkbox" value="on"
                                        {{setting('24hoursbusinessswitch')=='on' ? 'checked' : '' }}>
                                    <label for="24hoursbusinessswitch" class="toggle-class onoffswitch2-label"></label>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="table-responsive table-bussiness-hours">
                    <table class="table card-table table-vcenter text-nowrap mb-0">
                        <thead>
                            <tr class="">
                                <th class="w-20 border-bottom-0 ">{{lang('Days')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Closed/Open')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Start-time')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('End-time')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Break Start Time')}}</th>
                                <th class="w-20 border-bottom-0">{{lang('Break End Time')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $timestart = ['12:00 AM','12:30 AM','1:00 AM','1:30 AM','2:00 AM','2:30 AM','3:00 AM','3:30 AM','4:00 AM','4:30 AM','5:00 AM','5:30 AM','6:00 AM','6:30 AM','7:00 AM','7:30 AM','8:00 AM','8:30 AM','9:00 AM','9:30 AM','10:00 AM','10:30 AM','11:00 AM','11:30 AM','12:00 PM','12:30 PM','1:00 PM','1:30 PM','2:00 PM','2:30 PM','3:00 PM','3:30 PM','4:00 PM','4:30 PM','5:00 PM','5:30 PM','6:00 PM','6:30 PM','7:00 PM','7:30 PM','8:00 PM','8:30 PM','9:00 PM','9:30 PM','10:00 PM','10:30 PM','11:00 PM','11:30 PM'];

                                $breaktime1 = $bussiness1 != null ? $bussiness1->breakstarttime : null;
                                $breaktime2 = $bussiness2 != null ? $bussiness2->breakstarttime : null;
                                $breaktime3 = $bussiness3 != null ? $bussiness3->breakstarttime : null;
                                $breaktime4 = $bussiness4 != null ? $bussiness4->breakstarttime : null;
                                $breaktime5 = $bussiness5 != null ? $bussiness5->breakstarttime : null;
                                $breaktime6 = $bussiness6 != null ? $bussiness6->breakstarttime : null;
                                $breaktime7 = $bussiness7 != null ? $bussiness7->breakstarttime : null;

                                $breakendtime1 = $bussiness1 != null ? $bussiness1->breakendtime : null;
                                $breakendtime2 = $bussiness2 != null ? $bussiness2->breakendtime : null;
                                $breakendtime3 = $bussiness3 != null ? $bussiness3->breakendtime : null;
                                $breakendtime4 = $bussiness4 != null ? $bussiness4->breakendtime : null;
                                $breakendtime5 = $bussiness5 != null ? $bussiness5->breakendtime : null;
                                $breakendtime6 = $bussiness6 != null ? $bussiness6->breakendtime : null;
                                $breakendtime7 = $bussiness7 != null ? $bussiness7->breakendtime : null;
                            @endphp
                            <tr class="border-bottom-transparent">
                                <td class="">
                                    <input type="hidden" name="bussinessid1" value="1">
                                    <select name="bussiness1"
                                        class="form-control select2 select2-show-search sprukoweeks"
                                        data-placeholder="{{lang('Select Days')}}">
                                        <option label="{{lang('Select Days')}}"></option>
                                        <option value="Mon" {{$bussiness1 !=null ? $bussiness1->weeks == 'Mon' ?
                                            'selected': '' :''}}>{{lang('Mon')}}</option>
                                        <option value="Tue" {{$bussiness1 !=null ? $bussiness1->weeks == 'Tue' ?
                                            'selected': '' :''}}>{{lang('Tue')}}</option>
                                        <option value="Wed" {{$bussiness1 !=null ? $bussiness1->weeks == 'Wed' ?
                                            'selected': '' :''}}>{{lang('Wed')}}</option>
                                        <option value="Thu" {{$bussiness1 !=null ? $bussiness1->weeks == 'Thu' ?
                                            'selected': '' :''}}>{{lang('Thu')}}</option>
                                        <option value="Fri" {{$bussiness1 !=null ? $bussiness1->weeks == 'Fri' ?
                                            'selected': '' :''}}>{{lang('Fri')}}</option>
                                        <option value="Sat" {{$bussiness1 !=null ? $bussiness1->weeks == 'Sat' ?
                                            'selected': '' :''}}>{{lang('Sat')}}</option>
                                        <option value="Sun" {{$bussiness1 !=null ? $bussiness1->weeks == 'Sun' ?
                                            'selected': '' :''}}>{{lang('Sun')}}</option>
                                    </select>
                                </td>
                                <td class="">
                                    <select name="status1" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness1 !=null ? $bussiness1->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness1 !=null ? $bussiness1->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime1"
                                        class="form-control select2 select2-show-search sprukostarttime" data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness1 !=null ? $bussiness1->starttime == '24H' ? 'selected' : '' :''}}>24H</option>

                                        </optgroup>

                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness1 !=null ? $bussiness1->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach

                                    </select>
                                </td>

                                <td class="tr_clone">
                                    <select name="endtime1" @if($bussiness1 != null && $bussiness1->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness1 !=null ? $bussiness1->endtime == $time ? 'selected' : '' :''}} >{{$time}}</option>
                                        @endforeach

                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart1" @if($bussiness1 != null && $bussiness1->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart1">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend1" @if($bussiness1 != null && $bussiness1->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend1">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid2" value="2">
                                    <input name="bussiness2" class="form-control sprukoweeks" value="{{ $bussiness2->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status2" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness2 !=null ? $bussiness2->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness2 !=null ? $bussiness2->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime2"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness2 !=null ? $bussiness2->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>

                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness2 !=null ? $bussiness2->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach

                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime2" @if($bussiness2 != null && $bussiness2->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness2 !=null ? $bussiness2->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart2" @if($bussiness2 != null && $bussiness2->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart2">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend2" @if($bussiness2 != null && $bussiness2->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend2">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid3" value="3">
                                    <input name="bussiness3" class="form-control sprukoweeks" value="{{ $bussiness3->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status3" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness3 !=null ? $bussiness3->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness3 !=null ? $bussiness3->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime3"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness3 !=null ? $bussiness3->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness3 !=null ? $bussiness3->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime3" @if($bussiness3 != null && $bussiness3->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness3 !=null ? $bussiness3->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart3" @if($bussiness3 != null && $bussiness3->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart3">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend3" @if($bussiness3 != null && $bussiness3->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend3">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid4" value="4">
                                    <input name="bussiness4" class="form-control sprukoweeks" value="{{ $bussiness4->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status4" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness4 !=null ? $bussiness4->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness4 !=null ? $bussiness4->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime4"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness4 !=null ? $bussiness4->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness4 !=null ? $bussiness4->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime4" @if($bussiness4 != null && $bussiness4->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness4 !=null ? $bussiness4->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart4" @if($bussiness4 != null && $bussiness4->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart4">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend4" @if($bussiness4 != null && $bussiness4->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend4">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid5" value="5">
                                    <input name="bussiness5" class="form-control sprukoweeks" value="{{ $bussiness5->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status5" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness5 !=null ? $bussiness5->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness5 !=null ? $bussiness5->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime5"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness5 !=null ? $bussiness5->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness5 !=null ? $bussiness5->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime5" @if($bussiness5 != null && $bussiness5->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness5 !=null ? $bussiness5->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart5" @if($bussiness5 != null && $bussiness5->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart5">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend5" @if($bussiness5 != null && $bussiness5->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend5">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid6" value="6">
                                    <input name="bussiness6" class="form-control sprukoweeks" value="{{ $bussiness6->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status6" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness6 !=null ? $bussiness6->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness6 !=null ? $bussiness6->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime6"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness6 !=null ? $bussiness6->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness6 !=null ? $bussiness6->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime6" @if($bussiness6 != null && $bussiness6->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness6 !=null ? $bussiness6->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart6" @if($bussiness6 != null && $bussiness6->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart6">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend6" @if($bussiness6 != null && $bussiness6->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend6">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td class="tr_weeks">
                                    <input type="hidden" name="bussinessid7" value="7">
                                    <input name="bussiness7" class="form-control sprukoweeks" value="{{ $bussiness7->weeks ?? '' }}" readonly>

                                </td>
                                <td class="">
                                    <select name="status7" class="form-control select2 select2-show-search sprukoopen"
                                        data-placeholder="{{lang('Select Status')}}">
                                        <option label="{{lang('Select Status')}}"></option>
                                        <option value="Opened" {{$bussiness7 !=null ? $bussiness7->status == 'Opened' ?
                                            'selected' :'' :''}}>{{lang('Opened')}}</option>
                                        <option value="Closed" {{$bussiness7 !=null ? $bussiness7->status == 'Closed' ?
                                            'selected' :'' :''}}>{{lang('Closed')}}</option>
                                    </select>
                                </td>
                                <td class="tr_clone1">
                                    <select name="starttime7"
                                        class="form-control select2 select2-show-search sprukostarttime"
                                        data-placeholder="{{lang('Select StartTime')}}">
                                        <option label="{{lang('Select StartTime')}}"></option>
                                        <optgroup>
                                            <option value="24H" {{$bussiness7 !=null ? $bussiness7->starttime == '24H' ?
                                                'selected' : '' :''}}>24H</option>

                                        </optgroup>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness7 !=null ? $bussiness7->starttime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone">
                                    <select name="endtime7" @if($bussiness7 != null && $bussiness7->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukoendtime"
                                        data-placeholder="{{lang('Select EndTime')}}">
                                        <option label="{{lang('Select EndTime')}}"></option>
                                        @foreach($timestart as $time)
                                        <option value="{{$time}}" {{ $bussiness7 !=null ? $bussiness7->endtime == $time ? 'selected' : '' :''}}>{{$time}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="tr_clone2">
                                    <select name="breakstart7" @if($bussiness7 != null && $bussiness7->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakstarttime"
                                        data-placeholder="{{lang('Select Break Start Time')}}" id="breakstart7">
                                        <option label="{{lang('Select Break Start Time')}}"></option>
                                    </select>
                                </td>
                                <td class="tr_clone3">
                                    <select name="breakend7" @if($bussiness7 != null && $bussiness7->starttime == '24H') disabled='true' @endif
                                        class="form-control select2 select2-show-search sprukobreakendtime"
                                        data-placeholder="{{lang('Select Break End Time')}}" id="breakend7">
                                        <option label="{{lang('Select Break End Time')}}"></option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
			</div>
			<div class="col-md-12 card-footer">
				<div class="form-group float-end">
                    <button type="button" id="bussinesshourRest" class="btn btn-danger mx-2">{{lang('Reset')}}</button>
                    <button type="submit" class="btn btn-secondary" onclick="this.disabled=true;this.innerHTML=`Saving <i class='fa fa-spinner fa-spin'></i>`;this.form.submit();">{{lang('Create Employee')}}</button>
				</div>
			</div>
		</form>
	</div>
</div>
<!-- End Employee Create -->
@endsection

@section('scripts')

<!--File BROWSER -->
@vite(['resources/assets/js/form-browser.js'])

<!-- INTERNAL Vertical-scroll js-->
<script src="{{asset('build/assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}?v=<?php echo time(); ?>"></script>
@vite(['resources/assets/js/select2.js'])

<!-- INTERNAL Index js-->
@vite(['resources/assets/js/support/support-sidemenu.js'])

<!-- INTERNAL TAG js-->
<script src="{{asset('build/assets/plugins/taginput/bootstrap-tagsinput.js')}}?v=<?php echo time(); ?>"></script>

<script type="text/javascript">
    $(function() {
        var SITEURL = '{{url('')}}';
        (function($) {
            "use strict";

            // Csrf Field
            $.ajaxSetup({
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
            });

        })(jQuery);

        let timedata = @json($timestart);
        let breaktime1 = @json($breaktime1);
        let breaktime2 = @json($breaktime2);
        let breaktime3 = @json($breaktime3);
        let breaktime4 = @json($breaktime4);
        let breaktime5 = @json($breaktime5);
        let breaktime6 = @json($breaktime6);
        let breaktime7 = @json($breaktime7);

        let breakendtime1 = @json($breakendtime1);
        let breakendtime2 = @json($breakendtime2);
        let breakendtime3 = @json($breakendtime3);
        let breakendtime4 = @json($breakendtime4);
        let breakendtime5 = @json($breakendtime5);
        let breakendtime6 = @json($breakendtime6);
        let breakendtime7 = @json($breakendtime7);

        function breaktimeupdate(){
            if(timestart1 && timeend1){
                let startIndex = timedata.indexOf(timestart1);
                let endIndex = timedata.indexOf(timeend1);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart1').append(new Option(data, data));
                        if (data == breaktime1) {
                            $('#breakstart1 option:last').prop('selected', true);
                        }
                        $('#breakend1').append(new Option(data, data));
                        if (data == breakendtime1) {
                            $('#breakend1 option:last').prop('selected', true);
                        }
                        $('#breakstart1').prop('disabled', false);
                        $('#breakend1').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart1').val('0').trigger('change.select2');
                $('#breakend1').val('0').trigger('change.select2');
                $('#breakstart1').prop('disabled', true);
                $('#breakend1').prop('disabled', true);
            }

            if(timestart2 && timeend2){
                let startIndex = timedata.indexOf(timestart2);
                let endIndex = timedata.indexOf(timeend2);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart2').append(new Option(data, data));
                        if (data == breaktime2) {
                            $('#breakstart2 option:last').prop('selected', true);
                        }
                        $('#breakend2').append(new Option(data, data));
                        if (data == breakendtime2) {
                            $('#breakend2 option:last').prop('selected', true);
                        }
                        $('#breakstart2').prop('disabled', false);
                        $('#breakend2').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart2').val('0').trigger('change.select2');
                $('#breakend2').val('0').trigger('change.select2');
                $('#breakstart2').prop('disabled', true);
                $('#breakend2').prop('disabled', true);
            }

            if(timestart3 && timeend3){
                let startIndex = timedata.indexOf(timestart3);
                let endIndex = timedata.indexOf(timeend3);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart3').append(new Option(data, data));
                        if (data == breaktime3) {
                            $('#breakstart3 option:last').prop('selected', true);
                        }
                        $('#breakend3').append(new Option(data, data));
                        if (data == breakendtime3) {
                            $('#breakend3 option:last').prop('selected', true);
                        }
                        $('#breakstart3').prop('disabled', false);
                        $('#breakend3').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart3').val('0').trigger('change.select2');
                $('#breakend3').val('0').trigger('change.select2');
                $('#breakstart3').prop('disabled', true);
                $('#breakend3').prop('disabled', true);
            }

            if(timestart4 && timeend4){
                let startIndex = timedata.indexOf(timestart4);
                let endIndex = timedata.indexOf(timeend4);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart4').append(new Option(data, data));
                        if (data == breaktime4) {
                            $('#breakstart4 option:last').prop('selected', true);
                        }
                        $('#breakend4').append(new Option(data, data));
                        if (data == breakendtime4) {
                            $('#breakend4 option:last').prop('selected', true);
                        }
                        $('#breakstart4').prop('disabled', false);
                        $('#breakend4').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart4').val('0').trigger('change.select2');
                $('#breakend4').val('0').trigger('change.select2');
                $('#breakstart4').prop('disabled', true);
                $('#breakend4').prop('disabled', true);
            }

            if(timestart5 && timeend5){
                let startIndex = timedata.indexOf(timestart5);
                let endIndex = timedata.indexOf(timeend5);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart5').append(new Option(data, data));
                        if (data == breaktime5) {
                            $('#breakstart5 option:last').prop('selected', true);
                        }
                        $('#breakend5').append(new Option(data, data));
                        if (data == breakendtime5) {
                            $('#breakend5 option:last').prop('selected', true);
                        }
                        $('#breakstart5').prop('disabled', false);
                        $('#breakend5').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart5').val('0').trigger('change.select2');
                $('#breakend5').val('0').trigger('change.select2');
                $('#breakstart5').prop('disabled', true);
                $('#breakend5').prop('disabled', true);
            }

            if(timestart6 && timeend6){
                let startIndex = timedata.indexOf(timestart6);
                let endIndex = timedata.indexOf(timeend6);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart6').append(new Option(data, data));
                        if (data == breaktime6) {
                            $('#breakstart6 option:last').prop('selected', true);
                        }
                        $('#breakend6').append(new Option(data, data));
                        if (data == breakendtime6) {
                            $('#breakend6 option:last').prop('selected', true);
                        }
                        $('#breakstart6').prop('disabled', false);
                        $('#breakend6').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart6').val('0').trigger('change.select2');
                $('#breakend6').val('0').trigger('change.select2');
                $('#breakstart6').prop('disabled', true);
                $('#breakend6').prop('disabled', true);
            }

            if(timestart7 && timeend7){
                let startIndex = timedata.indexOf(timestart7);
                let endIndex = timedata.indexOf(timeend7);
                if (startIndex !== -1 && endIndex !== -1 && startIndex < endIndex) {
                    let timeBetween = timedata.slice(startIndex, endIndex + 1);
                    Object.values(timeBetween).forEach((data) => {
                        $('#breakstart7').append(new Option(data, data));
                        if (data == breaktime7) {
                            $('#breakstart7 option:last').prop('selected', true);
                        }
                        $('#breakend7').append(new Option(data, data));
                        if (data == breakendtime7) {
                            $('#breakend7 option:last').prop('selected', true);
                        }
                        $('#breakstart7').prop('disabled', false);
                        $('#breakend7').prop('disabled', false);
                    })
                } else {
                    toastr.error('Invalid start or end time');
                }
            }else{
                $('#breakstart7').val('0').trigger('change.select2');
                $('#breakend7').val('0').trigger('change.select2');
                $('#breakstart7').prop('disabled', true);
                $('#breakend7').prop('disabled', true);
            }
        }

        function bussinesshourSubmit(){
            breaktimeupdate();
            let startStatus = 0,
            endStatus = 0,
            openEle = 0;
            document.querySelectorAll('.sprukoopen').forEach((ele, ind)=>{
                if(ele.value){
                    if(ele.value === "Opened"){
                        openEle += 1;
                    }
                    let currentEle = ele;
                    if(currentEle.closest('td').nextElementSibling.querySelector('.sprukostarttime').value){
                        startStatus += 1;
                        if(currentEle.closest('td').nextElementSibling.querySelector('.sprukostarttime').value === "24H"){
                            endStatus += 1;
                        }
                    }
                    if(currentEle.closest('td').nextElementSibling.nextElementSibling.querySelector('.sprukoendtime').value){
                        endStatus += 1;
                    }
                }
            })
        }
        bussinesshourSubmit();


        let dayListEle = document.querySelectorAll('.sprukoweeks');
        let dayListArr = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
        $('.sprukoweeks').on('change', daySort);
        function daySort(){
            let startDay =  dayListEle[0].value;
            if(startDay){
                for(let i = 0; i<= dayListArr.length; i++){
                    if(dayListArr[i] === startDay){
                        let newDayList = reorder(dayListArr, i);
                        dayListEle.forEach((element, ind) => {
                            if(ind >= 1){
                                element.value = newDayList[ind]
                            }
                        });

                    }
                }
                $('.sprukoopen').val('Opened').trigger('change.select2');
                $('.sprukostarttime').val('0').trigger('change.select2');
                $('.sprukostarttime').prop('disabled', false);
                $('.sprukoendtime').val('0').trigger('change.select2');
                $('.sprukoendtime').prop('disabled', false);
            }
            bussinesshourSubmit();
            timestart1 = timestart2 = timestart3 = timestart4 = timestart5 = timestart6 = timestart7 = timeend1 = timeend2 = timeend3 = timeend4 = timeend4 = timeend5 = timeend6 = timeend7 = null;
            breaktimeupdate();
        }


        function reorder(data, index) {
            return data.slice(index).concat(data.slice(0, index))
        };

        var timestart1, timestart2, timestart3, timestart4, timestart5, timestart6, timestart7, timeend1, timeend2, timeend3, timeend4, timeend4, timeend5, timeend6, timeend7;

        $('.sprukostarttime').on('change', function(e){
            let value = e.target.value,
            tdfind = $(this).closest('tr').find('.tr_clone');

            if(e.target.name == 'starttime1'){
                timestart1 = value;
            }else if(e.target.name == 'starttime2'){
                timestart2 = value;
            }else if(e.target.name == 'starttime3'){
                timestart3 = value;
            }else if(e.target.name == 'starttime4'){
                timestart4 = value;
            }else if(e.target.name == 'starttime5'){
                timestart5 = value;
            }else if(e.target.name == 'starttime6'){
                timestart6 = value;
            }else{
                timestart7 = value;
            }

            let find = tdfind[0];
            let selectEle = find.firstElementChild;
            if(value == '24H'){
                $(this).closest('tr').find('.tr_clone select').val('').trigger('change');
                selectEle.disabled = true;
            }else{
                selectEle.disabled = false;
                $('#24hoursbusinessswitch').prop('checked', false);
            }


            bussinesshourSubmit();
        });
        $('.sprukoendtime').on('change', function(e){

            if(e.target.name == 'endtime1'){
                timeend1 = e.target.value;
            }else if(e.target.name == 'endtime2'){
                timeend2 = e.target.value;
            }else if(e.target.name == 'endtime3'){
                timeend3 = e.target.value;
            }else if(e.target.name == 'endtime4'){
                timeend4 = e.target.value;
            }else if(e.target.name == 'endtime5'){
                timeend5 = e.target.value;
            }else if(e.target.name == 'endtime6'){
                timeend6 = e.target.value;
            }else{
                timeend7 = e.target.value;
            }

            bussinesshourSubmit();
        });


        $('.sprukoopen').on('change', function(e){

            let sprukovalue = e.target.value,
            tdfind1 = $(this).closest('tr').find('.tr_clone1'),
            tdfind2 = $(this).closest('tr').find('.tr_clone'),
            tdfind3 = $(this).closest('tr').find('.tr_clone2'),
            tdfind4 = $(this).closest('tr').find('.tr_clone3');

            let find1 = tdfind1[0];
            let selectEle1 = find1.firstElementChild;
            let find2 = tdfind2[0];
            let selectEle2 = find2.firstElementChild;
            let find3 = tdfind3[0];
            let selectEle3 = find3.firstElementChild;
            let find4 = tdfind4[0];
            let selectEle4 = find4.firstElementChild;

            if(sprukovalue == 'Closed'){
                $(this).closest('tr').find('.tr_clone select').val('').trigger('change');
                $(this).closest('tr').find('.tr_clone1 select').val('').trigger('change');
                $(this).closest('tr').find('.tr_clone2 select').val('').trigger('change');
                $(this).closest('tr').find('.tr_clone3 select').val('').trigger('change');
                selectEle1.disabled = true;
                selectEle2.disabled = true;
                selectEle3.disabled = true;
                selectEle4.disabled = true;

                selectEle2.value = null;
                selectEle3.value = null;
                selectEle4.value = null;
            }else{

                selectEle1.disabled = false;
                selectEle2.disabled = false;
                selectEle3.disabled = false;
                selectEle4.disabled = false;
            }
            bussinesshourSubmit();
        });

        $(window).on('load', function(){
            let startDay =  dayListEle[0].value;
            if(startDay){
                for(let i = 0; i<= dayListArr.length; i++){
                    if(dayListArr[i] === startDay){
                        let newDayList = reorder(dayListArr, i);
                        dayListEle.forEach((element, ind) => {
                            if(ind >= 1){
                                element.value = newDayList[ind]
                            }
                        });

                    }
                }
            }
            let starttimevalue = $('.sprukostarttime');

            $.map(starttimevalue, function( val, i ) {

                // Do something
                let value = $(val).val(),
                    tdfind = $(val).closest('tr').find('.tr_clone');

                if(i == 0){
                    timestart1 = value;
                }else if(i == 1){
                    timestart2 = value;
                }else if(i == 2){
                    timestart3 = value;
                }else if(i == 3){
                    timestart4 = value;
                }else if(i == 4){
                    timestart5 = value;
                }else if(i == 5){
                    timestart6 = value;
                }else{
                    timestart7 = value;
                }

                let find = tdfind[0];
                let selectEle = find.firstElementChild;

                if(selectEle.name == 'endtime1'){
                    timeend1 = selectEle.value;
                }else if(selectEle.name == 'endtime2'){
                    timeend2 = selectEle.value;
                }else if(selectEle.name == 'endtime3'){
                    timeend3 = selectEle.value;
                }else if(selectEle.name == 'endtime4'){
                    timeend4 = selectEle.value;
                }else if(selectEle.name == 'endtime5'){
                    timeend5 = selectEle.value;
                }else if(selectEle.name == 'endtime6'){
                    timeend6 = selectEle.value;
                }else{
                    timeend7 = selectEle.value;
                }

                breaktimeupdate();

                if(value == '24H'){
                    selectEle.disabled = true;
                }
            });

            let sprukoopen = $('.sprukoopen');
            $.map(sprukoopen, function( value, i ) {
                // Do something
                let val = $(value).val(),
                    tdfind1 = $(value).closest('tr').find('.tr_clone1'),
                    tdfind2 = $(value).closest('tr').find('.tr_clone');

                let find1 = tdfind1[0];
                let selectEle1 = find1.firstElementChild;
                let find2 = tdfind2[0];
                let selectEle2 = find2.firstElementChild;

                if(val == 'Closed'){

                    selectEle1.disabled = true;
                    selectEle2.disabled = true;
                }
            });

        });

        $('body').on('click', '#bussinesshourRest', function(e){
            e.preventDefault();
            $('tr').each(function() {
                $(this).find('.sprukoweeks').val('').trigger('change');
                $(this).find('.sprukoopen').val('').trigger('change');
                $(this).find('.sprukostarttime').val('').trigger('change');
                $(this).find('.sprukoendtime').val('').trigger('change');
            });
            $('#24hoursbusinessswitch').prop('checked', false);
            bussinesshourSubmit();
        })

        $('#24hoursbusinessswitch').on('change', function() {
            let fullhours = $('#24hoursbusinessswitch').prop('checked') === true ? 'on' : 'off';

            if (fullhours === 'on') {
                $('.sprukoweeks').val("Mon").trigger('change');
                $('.sprukoopen').val('Opened').trigger('change');
                $('.sprukostarttime').each(function() {
                    $(this).val('24H');
                });
                $('.sprukostarttime').trigger('input').trigger('change');
            }else{
                $('tr').each(function() {
                    $(this).find('.sprukoweeks').val('').trigger('change');
                    $(this).find('.sprukoopen').val('').trigger('change');
                    $(this).find('.sprukostarttime').val('').trigger('change');
                    $('#24hoursbusinessswitch').prop('checked', false);
                });
            }

            bussinesshourSubmit();
        });
    })
</script>

@endsection
