<?php

namespace Database\Seeders;

use App\Models\CampaignUserList;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\EmailTemplate;
use App\Models\LiveChatCustomers;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\Footertext;
use App\Models\Translate;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;

class UpdateV2 extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('settings')->insert([
            [
                'key' => 'sampleTemplate',
                'value' => '',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chat_header_bg_image',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chat_header_bg_image_selected',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chat_header_bg_image_storage_disk',
                'value' => 'public',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chat_icon_bg_image',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chat_icon_bg_image_storage_disk',
                'value' => 'public',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'whatsAppGraphAPIVersion',
                'value' => 'v21.0',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'enableWhatsapp',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'whatsappNumber',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'whatsappToken',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'whatsPhoneNumberId',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'businessAccId',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'whatsappVerifyToken',
                'value' => 'verify-Token',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'enableInstagram',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'instagramAccountId',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'InstagramAccessToken',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'InstagramVerifyToken',
                'value' => 'verify-Token',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'newTicketCreateWebNot',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'newTicketCreateSound',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'ticketNewMessaegeWebNot',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'ticketNewMessageCreateSound',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'instagramGraphAPIVersion',
                'value' => 'v21.0',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'instagramUsername',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'fbPageAccessToken',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'livechat_icon_draggable',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'liveChatAgentToCustFileUpload',
                'value' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'AgentToCustLivechatMaxFileUpload',
                'value' => 3,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'AgentToCustLivechatFileUploadMax',
                'value' => 3,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'AgentToCustLivechatFileUploadTypes',
                'value' => '.jpg,.png,.jpeg',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'CHAT_TEXT_TO_SPEACH_ENABLE',
                'value' => 'on',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'CHAT_TEXT_TRANSLATE_ENABLE',
                'value' => 'on',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'employeeVoiceChat',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'customerVoiceChat',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'geminiApiKey',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'spellCheck',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'wordSuggestion',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);
        DB::table('customizeerrors')->insert([
            [
                'errorname' => 'redirectionURL',
                'errorvalue' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'errorname' => 'MAINTENANCE_MODE',
                'errorvalue' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);

        $emailtemplates = [
            'customer_send_ticket_created',
            'admin_send_email_ticket_created',
            'customer_send_ticket_reply',
            'customer_rating',
            'customer_send_ticket_overdue',
            'customer_send_ticket_response',
            'customer_send_ticket_autoclose',
            'admin_send_email_ticket_reply',
            'when_ticket_assign_to_other_employee',
            'send_mail_to_customer_when_ticket_closed_by_admin',
            'send_mail_to_agent_when_ticket_closed_by_admin_or_agent',
            'send_mail_admin_panel_users_when_category_changed',
            'send_mail_to_admin_when_ticket_note_created',
            'customer_send_guestticket_created',
            'customer_send_guestticket_created_with_attachment_failed',
            'customer_send_ticket_created_that_holiday_or_announcement',
            'send_a_reply_to_the_customer_when_a_customer_responds_to_a_closed_email_ticket',
            'send_mail_admin_panel_users_when_status_changed',
            'send_mail_customer_when_status_changed',
        ];

        $deleteemailtemplate = EmailTemplate::where('code', 'send_mail_customer_when_category_changed')->first();
        if ($deleteemailtemplate) {
            $deleteemailtemplate->delete();
        }

        foreach ($emailtemplates as $emailtemplate) {
            $emailtemplate = EmailTemplate::where('code', $emailtemplate)->first();
            $emailtemplate->variables_used = $emailtemplate->variables_used . ',' . 'ticket_category,item_name';
            $emailtemplate->save();
        }

        $existingUsersEmails = LiveChatCustomers::pluck('email')->toArray();
        foreach ($existingUsersEmails as $email) {
            CampaignUserList::create([
                'email' => $email,
                'source' => 'Livechat',
                'batchName' => '',
            ]);
        }

        $permission1 = Permission::where('name', 'Under Maintanance Page Access')->first();
        if ($permission1) {
            $permission1->delete();
        }

        $permission2 = Permission::where('name', 'Bussiness Hours Access')->first();
        if ($permission2) {
            $permission2->delete();
        }

        $addsubemailtemp = EmailTemplate::where('code', 'admin_send_email_ticket_created')->first();
        if ($addsubemailtemp) {
            if(str_contains($addsubemailtemp->body, '{{ticket_id}}.&nbsp;<br></p>')){
                $addsubemailtemp->body = Str::replace('{{ticket_id}}.&nbsp;<br></p>', '{{ticket_id}}.&nbsp;</p><p>The ticket title : {{ticket_title}}</p>', $addsubemailtemp->body);
                $addsubemailtemp->save();
            }
        }

        $updateclosedemailtemplate = EmailTemplate::where('code', 'send_a_reply_to_the_customer_when_a_customer_responds_to_a_closed_email_ticket')->first();
        if ($updateclosedemailtemplate) {
            $updateclosedemailtemplate->title = 'Send a reply to the customer, when a customer responds to a closed ticket';
            $updateclosedemailtemplate->subject = 'This is Information for closed ticket.';
            $updateclosedemailtemplate->save();
        }

        $chatbotnameexists = Setting::where('key','chat_bot_name')->first();
        if($chatbotnameexists != null && $chatbotnameexists->value == null){
            $chatbotnameexists->value = 'SPK BOT';
            $chatbotnameexists->save();
        }

        $footerText = Footertext::first();
        if(Str::contains($footerText->copyright, '<a href="https://projects.spruko.com/livachat">') === true){
            $footerText->copyright = Str::replace('<a href="https://projects.spruko.com/livachat">', '<a href="https://projects.spruko.com/laravel/livachat/preview">', $footerText->copyright);
            $footerText->save();
        }

        $addnewfolderone = public_path('uploads/livechatbgimages/iconimage');
        if (!File::exists($addnewfolderone)) {
            File::makeDirectory($addnewfolderone, 0755, true);
        }

        $languages = Translate::distinct()->pluck('lang_code');
        if($languages){
            foreach ($languages as $lang) {
                $this->seedTranslations($lang);
            }
        }
    }

    function seedTranslations($lang)
    {
        // Path to the JSON language file
        $path = base_path("lang/{$lang}.json");
        $langDirectory = dirname($path);

        // Create directory if it doesn't exist
        if (!File::exists($langDirectory)) {
            File::makeDirectory($langDirectory, 0755, true);
        }

        // Initialize translations as an empty array
        $translations = [];

        // Load existing translations from the JSON file if it exists
        if (File::exists($path)) {
            $translations = json_decode(File::get($path), true);

            // Ensure translations is an array
            if (!is_array($translations)) {
                $translations = [];
            }
        }

        // Get all translations from the database for the specified language
        $dbTranslations = Translate::where('lang_code', $lang)->get();

        // Populate the translations array with database values
        foreach ($dbTranslations as $translation) {
            $group = $translation->group_langname;
            $key = $translation->key;
            $value = $translation->value;

            // Initialize group if it doesn't exist
            if (!isset($translations[$group])) {
                $translations[$group] = [];
            }

            // Update the translation or add it if it doesn't exist
            $translations[$group][$key] = $value;
        }

        // Prepare the content for the file with double quotations
        $content = json_encode($translations, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

        // Save the updated translations to the JSON file
        File::put($path, $content);
    }
}
