<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use DB;

class SettingTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('settings')->insert([
        [
            'key' => 'date_format',
            'value' => 'd M, Y',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'time_format',
            'value' => 'h:i A',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'site_title',
            'value' => env('APP_NAME'),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'site_description',
            'value' => 'Description for your portal !',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'update_setting',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'site_logo',
            'value' => 'default.png',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'site_favicon',
            'value' => 'favicon.png',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'CAPTCHATYPE',
            'value' => 'off',
            // 'value' => '6LdIWswUAAAAAMRp6xt2wBu7V59jUvZvKWf_rbJc',
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'GOOGLE_RECAPTCHA_KEY',
            'value' => '',
            // 'value' => '6LdIWswUAAAAAMRp6xt2wBu7V59jUvZvKWf_rbJc',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'GOOGLE_RECAPTCHA_SECRET',
            'value' => '',
            // 'value' => '6LdIWswUAAAAAIsdboq_76c63PHFsOPJHNR-z-75',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'AUTO_CLOSE_TICKET',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ],  [
            'key' => 'AUTO_CLOSE_TICKET_TIME',
            'value' => '1',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'AUTO_OVERDUE_TICKET',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ],  [
            'key' => 'AUTO_OVERDUE_TICKET_TIME',
            'value' => '1',
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'AUTO_RESPONSETIME_TICKET',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ],  [
            'key' => 'AUTO_RESPONSETIME_TICKET_TIME',
            'value' => '1',
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'CUSTOMER_TICKETID',
            'value' => 'SP',
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'PRIORITY_ENABLE',
            'value' => 'no',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'CUSTOMER_CLOSE_TICKET',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'GOOGLE_ANALYTICS_ENABLE',
            'value' => 'no',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AUTO_NOTIFICATION_DELETE_ENABLE',
            'value' => 'on',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AUTO_NOTIFICATION_DELETE_DAYS',
            'value' => '60',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'GOOGLE_ANALYTICS',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'KNOWLEDGE_ENABLE',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'FAQ_ENABLE',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'MAINTENANCE_MODE',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'MAINTENANCE_MODE_VALUE',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],[
            'key' => 'PROFILE_AGENT_ENABLE',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'COUNTRY_BLOCKTYPE',
            'value' => 'block',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'COUNTRY_LIST',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ],

        [
            'key' => 'ADMIN_COUNTRY_BLOCKTYPE',
            'value' => 'block',
            'created_at' => now(),
            'updated_at' => now()
        ],

        [
            'key' => 'ADMIN_COUNTRY_LIST',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'DOS_Enable',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IPMAXATTEMPT',
            'value' => '10',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IPSECONDS',
            'value' => '30',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IPBLOCKTYPE',
            'value' => 'captcha',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'GOOGLEFONT_DISABLE',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'FORCE_SSL',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'DARK_MODE',
            'value' => '0',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'SPRUKOADMIN_P',
            'value' => 'on',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'ticket_default_assigned_user_id',
            'value' => 2,
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'social_media_facebook',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'social_media_instagram',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'social_media_twitter',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'social_media_youtube',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'social_media_pinterest',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'social_media_envato',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'default_lang',
            'value' => 'en',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'theme_color',
            'value' => 'rgba(118, 74, 243, 1)',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'theme_color_dark',
            'value' => 'rgba(255, 135, 93, 1)',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'popular_categories',
            'value' => '[]',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'home_featured_categories',
            'value' => '[]',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'home_categories',
            'value' => '[]',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'home_max_articles',
            'value' => '10',
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'mail_driver',
            'value' => env('MAIL_DRIVER', 'sendmail'),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'mail_host',
            'value' => env('MAIL_HOST', 'smtp.mailtrap.io'),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'mail_port',
            'value' => env('MAIL_PORT', '2525'),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'mail_from_address',
            'value' => env('MAIL_FROM_ADDRESS', 'admin@example.com'),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'mail_from_name',
            'value' => env('MAIL_FROM_NAME', 'smtp'),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'mail_encryption',
            'value' => env('MAIL_ENCRYPTION', 'ssl'),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'MAIL_USERNAME',
            'value' => env('MAIL_USERNAME', ''),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'MAIL_PASSWORD',
            'value' => env('MAIL_PASSWORD', ''),
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IMAP_STATUS',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IMAP_HOST',
            'value' => env('IMAP_HOST', null),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'IMAP_PORT',
            'value' => env('IMAP_PORT', null),
            'created_at' => now(),
            'updated_at' => now()
        ],  [
            'key' => 'IMAP_PROTOCOL',
            'value' => env('IMAP_PROTOCOL', null),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'IMAP_ENCRYPTION',
            'value' => env('IMAP_ENCRYPTION', null),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'IMAP_USERNAME',
            'value' => env('IMAP_USERNAME', ''),
            'created_at' => now(),
            'updated_at' => now()
        ], [
            'key' => 'IMAP_PASSWORD',
            'value' => env('IMAP_PASSWORD', ''),
            'created_at' => now(),
            'updated_at' => now()
        ],

        // SettingtableTableSeeder
        [
            'key' => 'ENVATO_ON',
            'value' => 'on',
            'created_at' => now(),
            'updated_at' => now()
        ],

        // Setting1TableSeeder
        [
            'key' => 'ENVATO_EXPIRED_BLOCK',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'purchasecode_on',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'time_format',
            'value' => 'h:i A',
            'created_at' => now(),
            'updated_at' => now()
        ],


        // SettingUpdateSeeder
        [
            'key' => 'start_week',
            'value' => '0',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'TICKET_CHARACTER',
            'value' => '10',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'default_timezone',
            'value' => 'UTC',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'supporticonimage',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'admin_reply_mail',
            'value' => 'yes',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'customer_panel_employee_protect',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'employeeprotectname',
            'value' => 'Support',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'ticketrating',
            'value' => 'on',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'sidemenu_icon_style',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],

        [
            'key' => 'EMAILDOMAIN_BLOCKTYPE',
            'value' => 'blockemail',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'EMAILDOMAIN_LIST',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'article_count',
            'value' => 'on',
            'created_at' => now(),
            'updated_at' => now()
        ],

        [
            'key' => 'trashed_ticket_autodelete',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'trashed_ticket_delete_time',
            'value' => '7',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'SUPPORT_POLICY_URL',
            'value' => '#',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'NOTE_CREATE_MAILS',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'CUSTOMER_RESTICT_TO_DELETE_TICKET',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],

        // NewUpdateSeederV3_1
        [
            'key' => 'cronjob_set',
            'value' => 'installed',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'enable_gpt',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'openai_api',
            'value' => '',
            'created_at' => now(),
            'updated_at' => now()
        ],

        // UpdateVersion3_2
        [
            'key' => 'Employe_google_two_fact',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'Employe_email_two_fact',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],

        [
            'key' => 'max_tic_to_violation',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'admin_users_inactive_auto_logout',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'admin_users_inactive_auto_logout_time',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AUTO_OVERDUE_CUSTOMER',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],

        //
        [
            'key' => 'USER_MAX_FILE_UPLOAD',
            'value' => '2',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'USER_FILE_UPLOAD_MAX_SIZE',
            'value' => '3',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'USER_FILE_UPLOAD_TYPES',
            'value' => '.jpg,.png,.jpeg',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'MAX_FILE_UPLOAD',
            'value' => '2',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'FILE_UPLOAD_MAX',
            'value' => '3',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'FILE_UPLOAD_TYPES',
            'value' => '.jpg,.png,.jpeg',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'mail_key_set',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'application_key',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],



        // livechat settings
        [
            'key' => 'All_Online_Users',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'notificationsSounds',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'newMessageWebNot',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'newMessageSound',
            'value' => 'sound2.mp3',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'newChatRequestWebNot',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'newChatRequestSound',
            'value' => 'sound2.mp3',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'liveChatFlowload',
            'value' => "for-a-single-unique-user",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'liveChatFileUpload',
            'value' => false,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'livechatMaxFileUpload',
            'value' => '2',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'livechatFileUploadMax',
            'value' => "3",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'livechatFileUploadTypes',
            'value' => ".jpg,.jpeg,.png",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'liveChatAgentFileUpload',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AgentlivechatMaxFileUpload',
            'value' => '2',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AgentlivechatFileUploadMax',
            'value' => "3",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AgentlivechatFileUploadTypes',
            'value' => ".jpg,.jpeg,.png",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'livechatIconSize',
            'value' => "small",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'livechatPosition',
            'value' => "right",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'offlineDisplayLiveChat',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'OfflineStatusMessage',
            'value' => "Live chat offline. Leave message, we'll reply soon.",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'OnlineStatusMessage',
            'value' => 'Chat’s live. How can I help?',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'OfflineMessage',
            'value' => "our support team will get back to you promptly during our next business hours. In the meantime, you may find helpful resources",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'operatorsNotificationsSounds',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'operatorsAgentToAgentWebNot',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'operatorsGroupChatWebNot',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'operatorsAgentToAgentSound',
            'value' => 'sound2.mp3',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'operatorsGroupChatSound',
            'value' => 'sound2.mp3',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'liveChatHidden',
            'value' => 'true',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'liveChatPort',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'liveChatScript',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'enableAutoSlove',
            'value' => true,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'autoSloveEmailTimer',
            'value' => 15,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'autoSloveCloseTimer',
            'value' => 30,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'liveChatCustomerOnlineUsers',
            'value' => "",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'notificationType',
            'value' => "Single",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'livechatFeedbackDropdown',
            'value' => "Resolved in one chat.,Resolved in multiple chats.,Not resolved (first contact).,Not resolved (multiple contacts).",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'inspectDisable',
            'value' => "off",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'selectDisabled',
            'value' => "off",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'botresponseenable',
            'value' => "off",
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'bot_name',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'botsresponse_time',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'time_detection',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'response_description',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'response_description_exclude_business_hours',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'bot_image',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IMAP_EMAIL_AUTO_DELETE',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IMAP_EMAIL_PROCESS_LIMIT_SWITCH',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'IMAP_EMAIL_TEMPLATE_LIMIT',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'isToken',
            'value' => false,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => '24hoursbusinessswitch',
            'value' => 'off',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AUTO_DELETE_LIVECHAT_ENABLE',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'AUTO_DELETE_LIVECHAT_IN_MONTHS',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'serversslcertificate',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'serversslkey',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'serverssldomainname',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'LivechatCustFeedbackQuestion',
            'value' => 'Satisfied with resolution today?',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'LivechatCustWelcomeMsg',
            'value' => 'Hello 👋',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'STATIC_NAME_FOR_ICON',
            'value' => 'Livechat Users',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'livechatthemecolor',
            'value' => '51 ,102 ,255',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'LIVECHAT_POPUP_TITLE',
            'value' => 'Support Chat',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'LIVECHAT_POPUP_SUB_TITLE',
            'value' => 'Welcome to SPRUKO. Feel free to ask us anything 🎉.',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'chat_bot_name',
            'value' => 'SPK BOT',
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'chat_bot_image',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
        [
            'key' => 'chat_bot_storage_disk',
            'value' => null,
            'created_at' => now(),
            'updated_at' => now()
        ],
    ]);
    }
}
