<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\PermissionRegistrar;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        $this->createPermissions();

        $this->assignPermissions();
    }

    public function createPermissions()
    {

        $permissions = [
            //Edit Profile
            ['name' => 'Profile Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Profile Edit'],
            ['name' => 'Email Update'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Profile Edit'],

            // LiveChat
            ['name' => 'Livechat Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['name' => 'Customer Chat Process', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['name' => 'Operators', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['name' => 'Chat Flows', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['name' => 'Livechat Settings', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['name' => 'Livechat Ratings', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['name' => 'Livechat Appearance', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['name' => 'Livechat Integrations', 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],

            //Ticket Permission
            ['name' => 'Ticket Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'All Tickets', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Unassigned Tickets', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'My Tickets', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Solved', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Trashed', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Ticket Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Ticket Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Ticket Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Ticket Assign', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Closed Ticket Process', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Ticket Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['name' => 'Ticket Restore', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],

            // Category Permission
            ['name' => 'Category Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Category Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Category Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Category Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Categories Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Subcategory Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Subcategory Create'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Subcategory Edit'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Subcategory Delete'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['name' => 'Category Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],

            //Knowoldge permision
            ['name' => 'Knowledge Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            //Article permision
            ['name' => 'Article Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['name' => 'Article Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['name' => 'Article View', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['name' => 'Article Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['name' => 'Article Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],

            //Manage Roles
            ['name' => 'Managerole Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],
            //Roles & Permission
            ['name' => 'Roles & Permission Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],
            ['name' => 'Roles & Permission Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],
            ['name' => 'Roles & Permission Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],

            //Employee permision
            ['name' => 'Employee Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['name' => 'Employee Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['name' => 'Employee Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['name' => 'Employee Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['name' => 'Employee Importlist', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['name' => 'Reset Password', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['name' => 'Employee Status', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],

            //Landing Page permision
            ['name' => 'Landing Page Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Landing Page Setting'],
            //Banner Access
            ['name' => 'Banner Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Landing Page Setting'],
            //Feature Box
            ['name' => 'Feature Box Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            ['name' => 'Feature Box Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            ['name' => 'Feature Box Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            ['name' => 'Feature Box Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            //Call To Action
            ['name' => 'Call To Action Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Landing Page Setting'],
            //Testimonial Permission
            ['name' => 'Testimonial Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            ['name' => 'Testimonial Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            ['name' => 'Testimonial Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            ['name' => 'Testimonial Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            //FAQs Permission
            ['name' => 'FAQs Access', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'FAQs Create', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'FAQs Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'FAQs Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'Main FAQ Access', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'FAQ Category Access', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'FAQ Category Create', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'FAQ Category Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['name' => 'FAQ Category Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],

            //Customers Permission
            ['name' => 'Customers Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['name' => 'Customer List Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['name' => 'Visitors Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['name' => 'Customers Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],

            //  Canned Response
            ['name' => 'Canned Response Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],
            ['name' => 'Canned Response Create'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],
            ['name' => 'Canned Response Edit'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],
            ['name' => 'Canned Response Delete'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],

            // Envato
            ['name' => 'Envato Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Envato'],
            ['name' => 'Envato API Token Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Envato'],
            ['name' => 'Envato License Details Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Envato'],

            // App Info
            ['name' => 'App Info Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'App Info'],
            ['name' => 'App Purchase Code Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'App Info'],

            //Custom Pages
            ['name' => 'Custom Pages Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            //Pages
            ['name' => 'Pages Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['name' => 'Pages Create'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['name' => 'Pages View', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['name' => 'Pages Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['name' => 'Pages Delete'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            // 404 page
            ['name' => '404 Error Page Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            // Under Maintanance page
            ['name' => 'Under Maintenance Page Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],

            // Holidays
            ['name' => 'Holidays Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['name' => 'Holidays Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['name' => 'Holidays Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['name' => 'Holidays Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['name' => 'Holidays Import Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],

            // Business hours
            ['name' => 'Business Hours Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Business Hours'],

            // Languages
            ['name' => 'Languages Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['name' => 'Languages Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['name' => 'Languages Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['name' => 'Languages Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['name' => 'Languages Translate', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],

            // App Setting
            ['name' => 'App Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'General Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'SEO Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'Google Analytics Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'Custom JS & CSS Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'Captcha Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'Email Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'Maintenance Mode Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'SecruitySetting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['name' => 'Bot Response Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],

            // IpList block
            ['name' => 'IpBlock Access', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],
            ['name' => 'IpBlock Add', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],
            ['name' => 'IpBlock Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],
            ['name' => 'IpBlock Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],

            //Announcements
            ['name' => 'Announcements Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Announcements'],
            ['name' => 'Announcements Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Announcements'],
            ['name' => 'Announcements Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Announcements'],
            ['name' => 'Announcements Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Announcements'],

            //Email Template
            ['name' => 'Email Template Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Template'],
            ['name' => 'Email Template Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Template'],

            //Reports Template
            ['name' => 'Addon Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Addons'],

            //Reports Template
            ['name' => 'Reports Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Reports'],

            //Domain Transfer
            ['name' => 'Domain Transfer Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Domain Transfer'],

            // Email Campaigns permissions
            ['name' => 'Email Campaigns Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'All Email Campaigns Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Email Campaigns Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Campaigns Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Users List Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Users Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Users List Import', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Users Status', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Users Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Templates Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Templates Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Templates Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],
            ['name' => 'Templates Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Campaign'],

        ];
        foreach ($permissions as $permission) {
            $permissionexist = Permission::where('name', $permission['name'])->first();

            if (isset($permissionexist)) {
                $permissionexist->update($permission);
            } else {
                Permission::create($permission);
            }
        }

    }

    public function assignPermissions()
    {

        $role = Role::where('name', 'superadmin')->first();

        if(!isset($role)){
            $role = Role::create(['name' => 'superadmin', 'guard_name' => 'web',]);
        }

        $permissions = Permission::get();
        foreach ($permissions as $code) {
            $role->givePermissionTo($code);
        };

    }
}
