<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use DB;
use App\Models\EmailTemplate;
use Illuminate\Support\Facades\Artisan;

class AddonsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('storage_disks')->insert([
            [
                'name' => 'local',
                'storage_disk' => 'public',
                'provider' => 'App\Http\Controllers\Storage\LocalStorageController',
                'credentials_data' => '{"access_key_id":null, "secret_access_key":null, "default_region":null, "bucket":null, "endpoint":null}',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'S3',
                'storage_disk' => 'S3',
                'provider' => 'Livachat\Addons\App\Http\Controllers\Storage\S3Controller',
                'credentials_data' => '{"access_key_id":null, "secret_access_key":null, "default_region":null, "bucket":null, "endpoint":null}',
                'status' => 0,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Storj',
                'storage_disk' => 'storj',
                'provider' => 'Livachat\Addons\App\Http\Controllers\Storage\StorjController',
                'credentials_data' => '{"access_key_id":null, "secret_access_key":null, "default_region":null, "bucket":null, "endpoint":null}',
                'status' => 0,
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);

        DB::table('addons')->insert([
            [
                'name' => 'Storj cloud storage',
                'type' => 'Storage',
                'image' => 'public/build/assets/images/storj.png',
                'version' => 'v 1.0',
                'handler' => 'Livachat\Addons\App\Http\Controllers\Storage\StorjController',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'S3 cloud storage',
                'type' => 'Storage',
                'image' => 'public/build/assets/images/S3.png',
                'version' => 'v 1.0',
                'handler' => 'Livachat\Addons\App\Http\Controllers\Storage\S3Controller',
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);

    }
}
