<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('live_chat_customers', function (Blueprint $table) {
            $table->string('email')->nullable()->change();
            $table->string('name')->nullable();
            $table->string('browser_info')->nullable()->change();
            $table->string('mobile_number')->nullable()->change();
            $table->string('userId')->nullable();
            $table->unique('cust_unique_id');
            $table->dropUnique(['email']);
        });
        Schema::table('live_chat_conversations', function (Blueprint $table) {
            $table->string('messageId')->nullable()->after('message');
            $table->string('messageDeleted')->nullable()->after('message');
            $table->string('replyToMessage')->nullable()->after('message');
        });
        Schema::table('personal_business_hours', function (Blueprint $table) {
            $table->string('breakstarttime')->nullable();
            $table->string('breakendtime')->nullable();
        });
        Schema::table('bussinesshours', function (Blueprint $table) {
            $table->string('breakstarttime')->nullable();
            $table->string('breakendtime')->nullable();
        });
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('dashboard');
        });
        Schema::table('live_visitors', function (Blueprint $table) {
            $table->string('banstatus')->nullable()->after('username');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('dashboard')->nullable();
        });
        Schema::table('live_chat_customers', function (Blueprint $table) {
            $table->dropUnique(['cust_unique_id']);
            $table->unique('email');
        });
    }
};
