<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSendmailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sendmails', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('mailsubject');
            $table->longtext('mailtext');
            $table->string('tag')->nullable();
            $table->string('selecttagcolor')->nullable();
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on('users')->onCascade('UPDATE')->onCascade('DELETE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sendmails');
    }
}
