<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Tickets extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('cust_id')->unsigned()->nullable();
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->string('ticket_id')->unique()->nullable();
            $table->bigInteger('category_id')->nullable()->unsigned();
            $table->bigInteger('subcategory')->nullable();
            $table->text('note')->nullable();
            $table->string('subject');
            $table->string('employeesreplying')->nullable();
            $table->timestamp('employeereplytime')->nullable();
            $table->string('usernameverify')->nullable();
            $table->string('emailticketfile')->nullable();
            $table->string('autoresponse')->nullable();
            $table->string('tickettype')->nullable();
            $table->integer('imap_id')->nullable();
            $table->string('ticketreopen')->nullable();
            $table->string('storage_disk')->nullable();
            $table->string('importantticket')->nullable();
            $table->string('item_name')->nullable();
            $table->string('MessageID')->nullable();
            $table->string('ticketviolation')->nullable();
            $table->string('ticketviolationnote')->nullable();
            $table->string('priority')->nullable();
            $table->string('project')->nullable();
            $table->string('purchasecode')->nullable();
            $table->string('purchasecodesupport')->nullable();
            $table->longtext('message');
            $table->longtext('mark_as_unread')->nullable();
            $table->string('status');
            $table->string('replystatus')->nullable();
            $table->string('profile_bg_color')->nullable();
            $table->bigInteger('myassignuser_id')->unsigned()->nullable();
            $table->datetime('last_reply')->nullable();
            $table->bigInteger('lastreply_mail')->unsigned()->nullable();
            $table->datetime('auto_replystatus')->nullable();
            $table->datetime('closing_ticket')->nullable();
            $table->datetime('auto_close_ticket')->nullable();
            $table->string('overduestatus')->nullable();
            $table->datetime('auto_overdue_ticket')->nullable();
            $table->bigInteger('selfassignuser_id')->unsigned()->nullable();
            $table->bigInteger('closedby_user')->unsigned()->nullable();
            $table->foreign('cust_id')->references('id')->on('live_chat_customers')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tickets');
    }
}
