<?php

namespace App\Models\Ticket;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Ticket\Ticket;
use App\Models\Articles\Article;
use App\Models\Articles\Category_articles;
use App\Models\CategoryEnvato;
use App\Models\CategoryUser;
use App\Models\Subcategorychild;
use App\Models\User;

class Category extends Model
{
    use HasFactory;

    protected $fillable = ['name','display','status','project_id','categoryslug','priority','parent_id'];

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }

    public function articles()
    {
        return $this->hasMany(Article::class, 'category_id');
    }

    public function catagent()
    {
        return $this->belongsToMany(CategoryUser::class);
    }

    public function catagents()
    {
        return $this->hasMany(CategoryUser::class, 'category_id');
    }

    public function user(){
        return $this->hasMany(User::class);
    }

    public function envato()
    {
        return $this->hasMany(CategoryEnvato::class, 'category_id');

    }

    public function childs()
    {
    	return $this->hasMany(Category::class, 'parent_id');
    }

    public function parent()
    {
    	return $this->belongsTo(Category::class, 'parent_id');
    }

    public function subcategorydata()
    {
    	return $this->hasMany(Subcategorychild::class, 'category_id');
    }
}
