<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\LiveChatCustomers;

class LiveVisitors extends Model
{
    use HasFactory;

    protected $fillable = [
        'visitor_unique_id',
        'cust_id',
        'user_id',
        'username',
        'browser_info',
        'login_ip',
        'city',
        'state',
        'countrycode',
        'country',
        'Login_url',
    ];

    public function scopeToday($query)
    {
        return $query->whereDate('visit_date', now()->format('Y-m-d'));
    }

    public function users()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function cust()
    {
        return $this->belongsTo(LiveChatCustomers::class, 'cust_id');
    }
}
