<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class BulkMails implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $email, $message, $subject;
    /**
     * Create a new job instance.
     */
    public function __construct($email, $message, $subject)
    {
        $this->email = $email;
        $this->message = $message;
        $this->subject = $subject;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $email = $this->email;
        $subject = $this->subject;
        $fromEmail = setting('mail_from_address');
        $fromName = setting('mail_from_name');

        $unsubRoute = url('/unsubscribe' . '/' . $this->email);
        $updatedMessage = str_replace('{{unsubscribe_link}}', $unsubRoute, $this->message);

        Mail::send([], [], function ($mail) use ($email, $subject, $updatedMessage, $fromEmail, $fromName) {
            $mail->to($email)
                ->subject($subject)
                ->from($fromEmail, $fromName)
                ->html($updatedMessage);
        });
    }
}
