<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Seosetting;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Pages;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class SeopageController extends Controller
{
	public function index()
	{

	  $this->authorize('SEO Access');

		$title = Apptitle::first();
		$data['title'] = $title;

		$footertext = Footertext::first();
		$data['footertext'] = $footertext;

		$seopage = Seosetting::first();
		$data['seopage'] = $seopage;

		$post = Pages::all();
		$data['page'] = $post;

		return view('admin.seopage.index')->with($data);
	}

	public function store(Request $request){

		$request->validate([
			'author'=> 'required|max:255',
			'description' => 'required|max:255',
			'keywords' => 'required',

		  ]);

		  $boxID = ['id' => $request->seo_id];
		  $boxdetails = [
			'author' => $request->author,
			'description' => $request->description,
			'keywords' => $request->keywords,
		  ];

		  $feature = Seosetting::updateOrCreate(['id' => $boxID], $boxdetails);

          $geolocation = GeoIP::getLocation(request()->getClientIp());
          $agent = new Agent();
          $activity = new EmployeeActivity();
          $activity->user_id = Auth::user()->id;
          $activity->activity_type = 'SEO Setting Updated';
          $activity->ip_address = $geolocation->ip;
          $activity->browser = $agent->browser();
          $activity->device = $agent->device();
          $activity->save();

		return redirect()->back()->with('success', lang('Updated Successfully', 'alerts'));
	}
}
