<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\Setting;
use Artisan;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class MaintanancemodeController extends Controller
{
    public function index(){

        $this->authorize('Maintenance Mode Access');

        $basic = Apptitle::first();
        $data['basic'] = $basic;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.maintanancemode.index')->with($data);
    }

    public function store(Request $request){

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $request->input('maintenancemode') == 'off' ? 'Maintenance Mode Off' : 'Maintenance Mode On';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if($request->input('maintenancemode') == 'off'){

            $data['MAINTENANCE_MODE']  =  $request->maintenancemode;
            $data['MAINTENANCE_MODE_VALUE']  =  null;
            $this->updateSettings($data);

            Artisan::call('up');

            return redirect()->back()->with('success', lang('Updated Successfully', 'alerts'));

        }
        if($request->input('maintenancemode') == 'on'){

            $data['MAINTENANCE_MODE']  =  $request->maintenancemode;
            $data['MAINTENANCE_MODE_VALUE']  =  $request->input('maintenancemode_value');
            $this->updateSettings($data);

            Artisan::call('down --secret="'.setting('MAINTENANCE_MODE_VALUE').'" ');

            return redirect()->back()->with('success', lang('Updated Successfully', 'alerts'));

        }

    }

    /**
     *  Settings Save/Update.
     *
     * @return \Illuminate\Http\Response
     */
    private function updateSettings($data)
    {
        foreach($data as $key => $val){
        	$setting = Setting::where('key', $key);
        	if( $setting->exists() )
        	$setting->first()->update(['value' => $val]);
        }

    }
}
