<?php

namespace App\Http\Controllers\Admin;


use Log;
use Tickets;
use Exception;
use App\Models\User;
use App\Models\Setting;
use App\Models\Apptitle;
use App\Models\Customer;
use App\Jobs\SocketWorker;
use App\Models\Footertext;
use App\Models\Seosetting;
use Illuminate\Support\Str;
use Jenssegers\Agent\Agent;
use Illuminate\Http\Request;
use App\Models\livechat_flow;
use App\Models\Ticket\Ticket;
use App\Models\Bussinesshours;
use App\Models\Cannedmessages;
use App\Models\Ticket\Comment;
use App\Models\livechatReviews;
use App\Models\Ticket\Category;
use Torann\GeoIP\Facades\GeoIP;
use App\Events\ChatMessageEvent;
use App\Models\EmployeeActivity;
use App\Events\AgentMessagingEvent;
use App\Models\AgentConversation;
use App\Models\LiveChatCustomers;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;


use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use App\Models\LiveChatConversations;
use App\Models\PersonalBusinessHours;
use Illuminate\Support\Facades\Crypt;
use App\Models\AgentGroupConversation;
use App\Models\CampaignUserList;
use App\Models\LiveVisitors;
use Symfony\Component\Process\Process;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;

use Spatie\SslCertificate\SslCertificate;
use Illuminate\Database\Eloquent\Collection;

class LiveChatController extends Controller
{
    public function index(Request $request)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $user = User::where('id', '!=', Auth::id())->where('status', 1)->get();
        $data['user'] = $user;

        $livecust = LiveChatCustomers::latest('updated_at')->with('livechatconversation')->get();
        $data['livecust'] = $livecust;

        $filteredLiveCust = $livecust->filter(function ($item) {
            if ($item->livechatconversation->last() != null) {
                return ($item->engage_conversation === null || $item->engage_conversation === '') && $item->status != 'solved' && $item->livechatconversation->last()->delete == null;
            } else {
                $convers = LiveChatConversations::where('unique_id', $item->cust_unique_id)->first();
                if ($convers != null && $convers->delete == null) {
                    return ($item->engage_conversation === null || $item->engage_conversation === '') && $item->status != 'solved';
                }
            }
        });

        if ($request->operatorID) {
            $filteredLiveCust = $livecust->filter(function ($customer) use ($request) {
                $engageConversation = json_decode($customer->engage_conversation, true);
                return collect($engageConversation)->contains('id', $request->operatorID);
            });
        }
        $data['operatorID'] = $request->operatorID;

        foreach ($filteredLiveCust as $customer) {
            $livechatdata = LiveChatConversations::where('unique_id', $customer->cust_unique_id)->get();
            $unreadIndexNumber = 0;
            foreach ($livechatdata as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "seen" && !$message->delete) {
                    $unreadIndexNumber = $unreadIndexNumber + 1;
                }
            }
            $customer->unreadIndexNumber = $unreadIndexNumber;
            $customer->lastMessage = $livechatdata->isNotEmpty() ? $livechatdata->last() : null;
            if ($livechatdata->count() == 1) {
                $customer->singlecomment = $livechatdata->first()->status == 'comment' ? 'notallow' : 'allowed';
            }
        }

        $filteredLiveCust = $filteredLiveCust->sortByDesc(function ($customer) {
            return optional($customer->lastMessage)->created_at ? $customer->lastMessage->created_at->timestamp : null;
        });

        $data['filteredLiveCust'] = $filteredLiveCust;

        $categories = Category::whereIn('display', ['ticket', 'both'])->where('status', '1')->get();
        $data['categories'] = $categories;

        $userdatas = User::where('status', 1)->get();
        $data['userdatas'] = $userdatas;

        return view('admin.livechat.index')->with($data);
    }

    public function customerdata(Request $request)
    {
        $cust = LiveChatCustomers::where('cust_unique_id', $request->visitoruniqueid)->first();
        if ($request->visitoruniqueid != null && $cust != null && $cust->userType == 'livevisitor') {
            $cust->username = $request->name;
            $cust->email = $request->email;
            $cust->chat_flow_messages = $request->flowChatMessages;
            $cust->mobile_number = $request->mobilenumber;
            $cust->userType = 'livechat';
            $cust->login_at = now();
            $cust->timezone = $request->timezone;
            $cust->full_address = $request->fullAddress;
            $cust->Login_url = $request->loginurl;
            $cust->login_ip = $request->loginIp;
            $cust->save();

            $latestcon = LiveChatConversations::where('unique_id', $cust->cust_unique_id)->first();
            $cust->latestConversation = $latestcon != null ? $latestcon->message : $request->message;

            event(new ChatMessageEvent($request->name, 'newUser', $cust->id, null, null, null, null, null));
            return response()->json(['success' => 'your live chat process is started.', 'custdata' => $cust]);
        } else {

            $email = $request->email;
            $completeDomain = substr(strrchr($email, "@"), 1);
            $emaildomainlist = setting('EMAILDOMAIN_LIST');
            $emaildomainlistArray = explode(",", $emaildomainlist);

            if (setting('EMAILDOMAIN_BLOCKTYPE') == 'blockemail' && setting('EMAILDOMAIN_LIST') != null && in_array($completeDomain, $emaildomainlistArray)) {
                return response()->json(['message' => 'domainblock', 'error' => lang('Domain is Blocked List', 'alerts')], 500);
            }

            if (setting('EMAILDOMAIN_BLOCKTYPE') == 'allowemail' && setting('EMAILDOMAIN_LIST') != null && !in_array($completeDomain, $emaildomainlistArray)) {
                return response()->json(['message' => 'domainblock', 'error' => lang('Domain is Blocked List', 'alerts')], 500);
            }

            $cust = LiveChatCustomers::where('email', $request->email)->first();
            if ($cust != null && $cust->banstatus != 'banned') {
                // if ($cust && $cust->count()) {
                $cust->Login_url = $request->loginurl;
                $cust->login_ip = $request->loginIp;
                $cust->banstatus = null;
                $cust->save();
                return response()->json(['success' => 'your live chat process is started.', 'custdata' => $cust]);
            } else {
                $cust = new LiveChatCustomers();
                $cust->cust_unique_id = Str::random(9);
                $cust->username = $request->name;
                $cust->email = $request->email;
                $cust->chat_flow_messages = $request->flowChatMessages;
                $cust->mobile_number = $request->mobilenumber;
                $cust->userType = 'livechat';
                $cust->login_at = now();
                $cust->browser_info = $request->browserAndOSInfo;
                $cust->login_ip = $request->loginIp;
                $cust->city = $request->city;
                $cust->state = $request->state;
                $cust->timezone = $request->timezone;
                $cust->country = $request->country;
                $cust->Login_url = $request->loginurl;
                $cust->full_address = $request->fullAddress;
                $cust->profile_bg_color = randomColorGenerator(0.5);
                $cust->save();

                CampaignUserList::create([
                    'email' => $cust->email,
                    'source' => 'Livechat',
                    'batchName' => '',
                ]);

                $cust->encrypted_id = Crypt::encrypt($cust->id);

                $latestcon = LiveChatConversations::where('unique_id', $cust->cust_unique_id)->first();
                $cust->latestConversation = $latestcon != null ? $latestcon->message : $request->message;

                event(new ChatMessageEvent($request->name, 'newUser', $cust->id, null, null, null, null, null, null, null, null, null, null, null, null, $cust));
                return response()->json(['success' => 'your live chat process is started.', 'custdata' => $cust]);
            }
        }
    }

    public function updateEmail(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
        ]);
        if ($validator->passes()) {
            $livecust = LiveChatCustomers::find($id);
            $livecust->email = $request->email;
            $livecust->save();
            return response()->json(['success' => lang('Email updated successfully.')]);
        }
        return response()->json(['error' => $validator->errors()]);
    }

    public function singlecustdata(Request $request, $id)
    {
        $livecust = LiveChatCustomers::find($id);

        if ($livecust == null) {
            return response()->json(['nocustomerdatafound' => true]);
        }
        if (LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->first() != null && LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->first()->delete != null) {
            $livecust->chat_flow_messages = null;
        }

        $chat_flow_messages = json_decode($livecust->chat_flow_messages, true) ?? [];
        foreach ($chat_flow_messages as &$chat_flow_message) {
            if (setting('chat_bot_image') != null) {
                $chat_flow_message['profileurl'] = route('getprofile.url', ['imagePath' => setting('chat_bot_image'), 'storage_disk' => setting('chat_bot_storage_disk') ?? 'public']);
            } else {
                $chat_flow_message['profileurl'] = asset('/uploads/profile/user-profile.png');
            }
            $chat_flow_message['username'] = setting('chat_bot_name');
        }

        $livecust->chat_flow_messages = json_encode($chat_flow_messages);

        $livechatdata = LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->get();
        $currentUserId = Auth::id();
        $filteredLiveChatData = $livechatdata->reject(function ($message) use ($currentUserId) {
            return $message->delete != null;
        });

        if ($currentUserId && strpos($request->header('referer'), 'livechat-flow/test-it-out') == false && $request->author == 'agent') {
            foreach ($filteredLiveChatData as $message) {
                if ($message->livechat_user_id == '741741741') {
                    $botimagename = setting('bot_image');
                    $message->profileurl = asset('/uploads/profile/botprofile/' . $botimagename);
                } else {
                    if ($message->livechat_user_id != null) {
                        $userdata = User::find($message->livechat_user_id);
                        if ($userdata != null) {
                            $message->profileurl = userprofileimage($userdata);
                        } else {
                            $message->profileurl = asset('/uploads/profile/user-profile.png');
                        }
                    }
                }

                if ($message->livechat_cust_id !== null && $message->status != "comment") {
                    $message->status = 'seen';
                    $message->save();
                }
            }
        }

        $engageConversations = json_decode($livecust->engage_conversation, true) ?? [];
        foreach ($engageConversations as &$engageConversation) {
            $userdata = User::find($engageConversation['id']);
            if ($userdata != null) {
                $engageConversation['profileimage'] = userprofileimage($userdata);
            } else {
                $engageConversation['profileimage'] = asset('/uploads/profile/user-profile.png');
            }
        }

        $livecust->engage_conversation = json_encode($engageConversations);

        if ($filteredLiveChatData->count() != $livechatdata->count()) {
            $livecust->deletedMessage = true;
        }
        $filteredLiveChatData = $filteredLiveChatData->sortBy('created_at')->values();
        $livecust->onlineUsers = $this->personalworkhours();
        $livecust->livechatMaxFileUpload = setting('livechatMaxFileUpload');
        $livecust->livechatFileUploadMax = setting('livechatFileUploadMax');
        $livecust->livechatFileUploadTypes = setting('livechatFileUploadTypes');
        $livecust->liveChatFlowload = setting('liveChatFlowload');
        $livecust->livechatIconSize = setting('livechatIconSize');
        $livecust->livechatPosition = setting('livechatPosition');
        $livecust->isonlineoroffline = $this->isonlineoroffline();
        $livecust->OfflineMessage = setting('OfflineMessage');
        $livecust->OfflineStatusMessage = setting('OfflineStatusMessage');
        $livecust->OnlineStatusMessage = setting('OnlineStatusMessage');
        $livecust->offlineDisplayLiveChat = setting('offlineDisplayLiveChat');
        $livecust->liveChatHidden = setting('liveChatHidden');
        $livecust->liveChatCustomerOnlineUsers = setting('liveChatCustomerOnlineUsers');
        $livecust->livechatFeedbackDropdown = setting('livechatFeedbackDropdown');
        $livecust->LivechatCustFeedbackQuestion = setting('LivechatCustFeedbackQuestion');
        $livecust->LivechatCustWelcomeMsg = setting('LivechatCustWelcomeMsg');
        $livecust->livechatthemecolor = setting('livechatthemecolor');
        $livecust->beforechatshowdata = setting('STATIC_NAME_FOR_ICON');
        $livecust->livechatpopuptitle = setting('LIVECHAT_POPUP_TITLE');
        $livecust->livechatpopupsubtitle = setting('LIVECHAT_POPUP_SUB_TITLE');
        $livecust->maintenance = settingpages('MAINTENANCE_MODE');
        $livecust->chatheaderimage = chatheaderimageurl();
        $livecust->chaticonimage = setting('chat_icon_bg_image') != null ? route('getImage.url', ['imagePath' => 'uploads*livechatbgimages*iconimage*' . setting('chat_icon_bg_image'), 'storage_disk' => setting('chat_icon_bg_image_storage_disk') ?? 'public']) : null;
        $livecust->chaticondraggableswitch = setting('livechat_icon_draggable');
        $livecust->whatsappEnabled = setting('enableWhatsapp');
        $livecust->instagramEnabled = setting('enableInstagram');
        $livecust->whatsappNumber = setting('whatsappNumber');
        $livecust->instagramUsername = setting('instagramUsername');
        $livecust->inspectDisable = setting('inspectDisable');
        $livecust->selectDisabled = setting('selectDisabled');
        $livecust->customerVoiceChat = setting('customerVoiceChat');

        $customer = LiveChatCustomers::where('cust_unique_id', $livecust->cust_unique_id)->first();
        if ($customer) {
            $livecust->gustId = $customer->id;
            $livecust->livechatTickets = Ticket::where('cust_id', $customer->id)->get()->count();
        }

        return response()->json(['livechatcust' => $livecust, 'livechatdata' => $filteredLiveChatData]);
    }

    public function singleticketdata(Request $request, $id)
    {
        if ($request->tickettype == 'trashedticketslocalstore') {
            $ticket = Ticket::onlyTrashed()->with('users')->find($id);
        } else {
            $ticket = Ticket::with('users')->find($id);
        }
        $user = Auth::user();
        $replypermission = 'notpermitted';
        if ($request->tickettype == 'unassignedticketslocalstore') {
            if (($ticket->status == 'Closed' && $user->can('Closed Ticket Process') && $user->can('Unassigned Tickets')) || ($ticket->myassignuser_id == null && $ticket->selfassignuser_id == null && $user->can('Unassigned Tickets')) || $ticket->selfassignuser_id == $user->id) {
                $replypermission = 'permitted';
            }
        } elseif ($request->tickettype == 'myticketslocalstore') {
            if (($ticket->status == 'Closed' && $user->can('Closed Ticket Process') && $user->can('My Tickets')) || ($ticket->selfassignuser_id == $user->id && $user->can('My Tickets')) || $ticket->selfassignuser_id == $user->id) {
                $replypermission = 'permitted';
            }
        } elseif ($request->tickettype == 'myclosedticketslocalstore') {
            if (($ticket->status == 'Closed' && $user->can('Closed Ticket Process') && $user->can('Solved')) || ($ticket->closedby_user == $user->id && $user->can('Solved')) || $ticket->selfassignuser_id == $user->id) {
                $replypermission = 'permitted';
            }
        } elseif ($request->tickettype == 'trashedticketslocalstore') {
            $replypermission = 'notpermitted';
        } else {
            if ($ticket->selfassignuser_id == $user->id || ($ticket->myassignuser_id == null && $ticket->selfassignuser_id == null && $user->can('Unassigned Tickets') && $user->can('All Tickets')) || ($ticket->status == 'Closed' && $user->can('Closed Ticket Process')) || $user->can('All Tickets')) {
                $replypermission = 'permitted';
            }
        }
        $livecust = $ticket->cust;
        $livechatdata = Comment::with('ticket', 'user', 'cust')->where('ticket_id', $ticket->id)->get();
        foreach ($livechatdata as $comment) {
            if ($comment->user_id != null) {
                $imageurl = [];
                if ($comment->getMedia('comments')->count() != 0) {
                    foreach ($comment->getMedia('comments') as $img) {
                        array_push($imageurl, $img->geturl());
                    }
                }
                $comment->image_url = $imageurl;
            } else {
                if ($comment->emailcommentfile != null) {
                    if ($comment->emailcommentfile == 'mismatch') {
                        $comment->image_url = null;
                    } elseif ($comment->emailcommentfile == 'nopermission') {
                        $comment->image_url = null;
                    } else {
                        $emailcommentfiles = explode(',', $comment->emailcommentfile);
                        $imageurl = [];
                        foreach ($emailcommentfiles as $emailcommentfile) {
                            $provider  = existprovider($comment->storage_disk ?? 'public')->provider;
                            array_push($imageurl, asset('/uploads/emailtoticketcomment/' . $emailcommentfile));
                        }
                        $comment->image_url = $imageurl;
                    }
                }
            }
            if (strpos($request->header('referer'), 'livechat-flow/test-it-out') == false && $request->author == 'agent' && $comment->cust_id !== null && $comment->status != "comment") {
                $comment->status = 'seen';
            }
            $comment->save();

            if ($comment->user_id == '741741741') {
                $botimagename = setting('bot_image');
                $comment->profileurl = asset('/uploads/profile/botprofile/' . $botimagename);
            } else {
                if ($comment->user_id != null) {
                    $userdata = User::find($comment->user_id);
                    $comment->profileurl = userprofileimage($userdata);
                }
            }
        }

        $ticketinfo = view('admin.superadmindashboard.allticketsinfo', compact('ticket'))->render();

        if ($ticket != null && $ticket->users != null) {
            $ticket->users->profileurl = userprofileimage($ticket->users);
        }

        $ticketimageurl = [];
        if ($ticket->getMedia('ticket')->count() != 0) {
            foreach ($ticket->getMedia('ticket') as $img) {
                array_push($ticketimageurl, $img->geturl());
            }
        }
        $ticket->image_url = $ticketimageurl;

        return response()->json(['livechatcust' => $livecust, 'livechatdata' => $livechatdata, 'ticketinfo' => $ticketinfo, 'ticket' => $ticket, 'replypermission' => $replypermission]);
    }

    public function broadcastMessage(Request $request)
    {
        if ($request->cust_id != null) {
            $user = Auth::user();
            if ($user != null) {
                $user['profileurl'] = userprofileimage($user);
            } else {
                $user['profileurl'] = asset('/uploads/profile/user-profile.png');
            }
            $user['newMessageSound'] = setting('newMessageSound') != null ? asset('/uploads/livechatsounds/' . setting('newMessageSound')) : null;
            $user['notificationType'] = setting('notificationType');
            $cust = LiveChatCustomers::find($request->cust_id);
            if ($cust->status == 'solved') {
                $cust->status = "";
                $cust->save();
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Responded To Livechat';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            $messageId = null;
            if ($request->userType == 'WhatsApp') {
                if ($request->has('messageType') && $request->messageType == 'image') {

                    $imageContent = file_get_contents($request->message);
                    $tempFilePath = tempnam(sys_get_temp_dir(), 'whatsapp_image');
                    file_put_contents($tempFilePath, $imageContent);

                    $imageResponse = Http::withHeaders([
                        'Authorization' => 'Bearer ' . setting('whatsappToken'),
                    ])->attach(
                        'file',
                        fopen($tempFilePath, 'r'),
                        'image.jpg'
                    )->post('https://graph.facebook.com/' . setting('whatsAppGraphAPIVersion') . '/' . setting('whatsPhoneNumberId') . '/media', [
                        'messaging_product' => 'whatsapp',
                        'type' => 'image/jpeg',
                    ]);
                    unlink($tempFilePath);
                    if (!$imageResponse->successful()) {
                        return response()->json(['error' => 'Image upload failed'], $imageResponse->status());
                    }

                    $mediaId = $imageResponse->json()['id'];

                    $response = Http::withHeaders([
                        'Authorization' => 'Bearer ' . setting('whatsappToken'),
                        'Content-Type' => 'application/json',
                    ])->post('https://graph.facebook.com/' . setting('whatsAppGraphAPIVersion') . '/' . setting('whatsPhoneNumberId') . '/messages', [
                        'messaging_product' => 'whatsapp',
                        'to' => '+' . $cust->mobile_number, // Phone number of the recipient
                        'type' => 'image',
                        'image' => [
                            'id' => $mediaId,
                        ]
                    ]);
                    if (!$response->successful()) {
                        return response()->json(['error' => 'Image upload failed'], $response->status());
                    }
                    $messageId = $response->json()['messages'][0]['id'];

                } else {
                    $response = Http::withHeaders([
                        'Authorization' => 'Bearer ' . setting('whatsappToken'),
                        'Content-Type' => 'application/json',
                    ])->post('https://graph.facebook.com/' . setting('whatsAppGraphAPIVersion') . '/' . setting('whatsPhoneNumberId') . '/messages', [
                        'messaging_product' => 'whatsapp',
                        'to' => '+' . $cust->mobile_number,
                        'preview_url' => false,
                        'recipient_type' => 'individual',
                        'type' => 'text',
                        'text' => [
                            'body' => $request->message,
                        ]
                    ]);
                    if (!$response->successful()) {
                        return response()->json(['error' => 'Image upload failed'], $response->status());
                    }
                    $messageId = $response->json()['messages'][0]['id'];
                }
            } elseif ($request->userType == 'Instagram') {
                $accessToken = setting('fbPageAccessToken');
                $graphVersion = setting('instagramGraphAPIVersion');
                $url = "https://graph.facebook.com/$graphVersion/me/messages?access_token=$accessToken";
                $messageText = $request->message;
                $recieverId = '1059663475833672';
                $headers = [
                    'Content-Type' => 'application/json',
                ];

                $payload = [
                    'recipient' => [
                        'id' => $recieverId,
                    ],
                    'messaging_type' => 'RESPONSE',
                    'message' => [
                        'text' => $messageText,
                    ],
                ];

                $response = Http::withHeaders($headers)->post($url, $payload);
                // if ($response->failed()) {
                //     $error = $response->json();
                //     if (isset($error['error'])) {
                //         throw new \Exception("Error: {$error['error']['message']} - {$error['error']['error_user_msg']}");
                //     }
                // }
                $messageId = $response->json()['message_id'];
            }
            $newconversation = new LiveChatConversations();
            $newconversation->unique_id = $cust->cust_unique_id;
            $newconversation->livechat_user_id = $user->id;
            $newconversation->livechat_username = $user->name;
            $newconversation->message = $request->message;
            $newconversation->status = 'delivered';
            $newconversation->messageId = $request->userType == 'livechat' ? '' : $messageId;
            $newconversation->sender_image = $user->image;
            if ($request->messageType) {
                $newconversation->message_type = $request->messageType;
                event(new ChatMessageEvent($user->name, $request->message, $user->id, $request->customerId, null, null, null, $user, null, null, $request->messageType, null, null, $cust->cust_unique_id, null, $cust, null, null, null, null, null, null, $messageId));
            } else {
                event(new ChatMessageEvent($user->name, $request->message, $user->id, $request->customerId, null, null, null, $user, null, null, null, null, null, $cust->cust_unique_id, null, $cust, null, null, null, null, null, null, $messageId));
            };
            $newconversation->save();

            if ($request->userType == 'livechat') {
                return Response::json(['MessageSent' => $newconversation]);
            } else {
                return Response::json(['messageId' => $messageId]);
            }
        } else {
            $cust = LiveChatCustomers::find($request->id);
            if ($request->messageType == 'welcomeMessage') {

                if ($cust->status == 'solved') {
                    $cust->status = "";
                    $cust->save();
                }

                $data['chatbotimage'] = setting('chat_bot_image') != null ? route('getprofile.url', ['imagePath' => setting('chat_bot_image'), 'storage_disk' => setting('chat_bot_storage_disk') ?? 'public']) : null;
                $data['chatbotname'] = setting('chat_bot_name') != null ? setting('chat_bot_name') : null;

                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $cust->cust_unique_id;
                $newconversation->livechat_user_id = $request->id;
                $newconversation->livechat_username = setting('chat_bot_name') != null ? setting('chat_bot_name') : 'chatBot';
                $newconversation->message = $request->message;
                $newconversation->message_type = 'welcomeMessage';
                $newconversation->save();
                event(new ChatMessageEvent('chatBot', $request->message, $request->id, $request->customerId, null, null, null, null, null, null, 'welcomeMessage', $data));
            } else {
                if ($cust->status == 'solved') {
                    $cust->status = "";

                    $custeventdata = LiveChatCustomers::find($cust->id);
                    $custeventdata->encrypted_id = Crypt::encrypt($custeventdata->id);

                    $latestcon = LiveChatConversations::where('unique_id', $custeventdata->cust_unique_id)->first();
                    $custeventdata->latestConversation = $latestcon != null ? $latestcon->message : $request->message;

                    event(new ChatMessageEvent($request->username, 'newUser', $custeventdata->id, null, null, null, null, null, null, null, null, null, null, null, null, $custeventdata));
                }
                $cust->updated_at = now();
                $cust->save();

                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $cust->cust_unique_id;
                $newconversation->livechat_cust_id = $request->id;
                $newconversation->livechat_username = $request->username;
                $newconversation->message = $request->message;
                if ($request->messageType) {
                    $newconversation->message_type = $request->messageType;
                    event(new ChatMessageEvent($request->username, $request->message, $request->id, $request->customerId, null, null, null, null, null, null, $request->messageType));
                } else {
                    event(new ChatMessageEvent($request->username, $request->message, $request->id, $request->customerId));
                }
                $newconversation->save();
            }
        }

        if ($request->messageType == "feedBack") {
            $cust = LiveChatCustomers::find($request->id);
            $liveChatEngageConversation = json_decode($cust->engage_conversation, true);
            foreach ($liveChatEngageConversation as $EngageUser) {
                $feedBackRating = json_decode($request->message, true);
                $ratingModel = new livechatReviews();
                $ratingModel->users_id = $EngageUser['id'];
                $ratingModel->cust_id = $request->customerId;
                $ratingModel->starRating = $feedBackRating['starRating'];
                $ratingModel->problemRectified = $feedBackRating['problemRectified'];
                $ratingModel->feedBackData = $feedBackRating['feedBackData'];
                $ratingModel->save();
            }

            // For Slove
            $solvedUser = User::find(1);
            $newconversation = new LiveChatConversations();
            $newconversation->unique_id = $cust->cust_unique_id;
            $newconversation->livechat_user_id = $solvedUser->id;
            $newconversation->livechat_username = $solvedUser->name;
            $newconversation->message = 'The customer given feedback to the chat, and as a result, the discussion was automatically marked as solved at';
            $newconversation->status = 'comment';
            $newconversation->save();
            event(new ChatMessageEvent(null, null, $solvedUser->id, $cust->id, null, null, true, $cust->engage_conversation, $newconversation->message));

            // For Left chat
            if ($cust->engage_conversation) {
                foreach (json_decode($cust->engage_conversation) as $engageusers) {
                    // For the Left User comment
                    $user = $engageusers;
                    $newconversation = new LiveChatConversations();
                    $newconversation->unique_id = $cust->cust_unique_id;
                    $newconversation->livechat_user_id = $user->id;
                    $newconversation->livechat_username = $user->name;
                    $newconversation->message = $user->name . ' left the discussion at';
                    $newconversation->status = 'comment';
                    $newconversation->save();
                    event(new ChatMessageEvent(null, null, $user->id, $cust->id, null, null, true, $cust->engage_conversation, $newconversation->message));
                }
            }

            $cust->engage_conversation = '';
            $cust->status = 'solved';
            $cust->save();
        }
    }

    public function liveChatFlow($id)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $flow = livechat_flow::find($id);
        if ($flow && $flow->active == 1 && $flow->active_draft) {
            $flow->liveChatFlow = $flow->active_draft;
        }
        $data['flow'] = $flow;

        $flowChatId = $id;
        $data['flowChatId'] = $flowChatId;


        return view('admin.livechat.livechat-flow')->with($data);
    }

    public function operators(Request $request)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $livecust = LiveChatCustomers::latest('updated_at')->get();
        $data['livecust'] = $livecust;

        $user = User::where('id', '!=', Auth::id())->where('status', 1)->get();
        $data['user'] = $user;

        $userId = AgentConversation::where('sender_user_id', Auth::id())->first();
        if ($userId != null) {
            $userconversation = AgentConversation::where('unique_id', $userId->unique_id)->get();
            $data['userconversation'] = $userconversation;
        }

        $agenconver = AgentConversation::where(function ($query) {
            $query->where('sender_user_id', Auth::id())
                ->orWhere('receiver_user_id', Auth::id());
        })->latest('created_at')->get()->groupBy(function ($group) {
            return $group->unique_id;
        });


        $group_conver = AgentGroupConversation::get()->groupBy(function ($group) {
            return $group->unique_id;
        });

        $filteredGroups = $group_conver->map(function ($conversationGroup) {
            $filteredConversations = $conversationGroup->filter(function ($conversation) {
                // To make the seen status
                $markAsUnread = json_decode($conversation->mark_as_unread, true) ?? [];
                $receiverUserId = json_decode($conversation->receiver_user_id, true) ?? [];

                if (count(array_intersect($markAsUnread, $receiverUserId)) === count($receiverUserId)) {
                    $conversation->update(['message_status' => 'seen']);
                }

                $authUserId = Auth::id();
                $deleteStatus = json_decode($conversation->delete_status, true) ?? []; // Ensure it's an array

                return !in_array($authUserId, $deleteStatus) && in_array($authUserId, $receiverUserId);
            });

            $conversationGroup = $filteredConversations;
            return $conversationGroup;
        });

        $finalFilteredGrouparray = $filteredGroups->filter(function ($item) {
            return !empty($item->all());
        });

        $sortedCollection = new Collection(array_merge($agenconver->toArray(), $finalFilteredGrouparray->toArray()));

        $allconver = $sortedCollection->sortByDesc(function ($item) {
            return isset($item[0]['created_user_id']) ? $item[count($item) - 1]['created_at'] : $item[0]['created_at'];
        });

        $data['allconver'] = $allconver;

        return view('admin.livechat.operator')->with($data);
    }

    public function groupconversion(Request $request, $id)
    {
        $group_conver = AgentGroupConversation::where('unique_id', $id)->get();
        foreach ($group_conver as $group_convers) {
            if (!$group_convers->mark_as_unread) {
                $group_convers->mark_as_unread = [Auth::user()->id];
                $group_convers->save();
            } else {
                if (!in_array(Auth::id(), json_decode($group_convers->mark_as_unread))) {
                    $existingData = [];
                    $existingData = json_decode($group_convers->mark_as_unread, true);

                    $newUserId = Auth::user()->id;
                    $existingData[] = $newUserId;
                    $group_convers->mark_as_unread = json_encode($existingData);

                    $group_convers->save();
                }
            }
        }

        $receiverUsersInfo = null;

        foreach ($group_conver as $group) {
            if ($group->sender_username != $group->reciever_username) {
                $receiverUsersInfo = $group->sender_username . ', ' . $group->reciever_username;
            }
        }

        // Filter the remove the messages
        $filteredConversations = $group_conver->filter(function ($conversation) {
            $authUserId = Auth::id();
            $receiverUserIds = json_decode($conversation->receiver_user_id);
            $deleteStatus = json_decode($conversation->delete_status);
            $senderdata = User::find($conversation->sender_user_id);
            $conversation->senderimage_url = userprofileimage($senderdata);
            return in_array($authUserId, $receiverUserIds) && (empty($deleteStatus) || !in_array($authUserId, $deleteStatus));
        });

        $conversationGroup = $filteredConversations->values()->all();

        try {
            event(new AgentMessagingEvent(null, null, Auth::id(), null, null, $id));
        } catch (\Exception $e) {
            // return response()->json(['code'=>500, 'error'=> $e->getMessage()], 500);
        }


        return response()->json(['groupconversion' => $conversationGroup, 'receiverUsersInfo' => $receiverUsersInfo]);
    }

    public function singleoperator(Request $request, $id)
    {
        $seenconversation = AgentConversation::where('receiver_user_id', Auth::id())->where('sender_user_id', $id)->get();
        foreach ($seenconversation as $seenconversations) {
            if ($seenconversations->message_status != 'seen') {
                $seenconversations->message_status = 'seen';
                $seenconversations->save();
            }
        }

        $userId = AgentConversation::where('sender_user_id', Auth::id())->where('receiver_user_id', $id)->first();
        if ($userId == null) {
            $userId = AgentConversation::where('receiver_user_id', Auth::id())->where('sender_user_id', $id)->first();
        }

        if ($userId != null) {
            $userconversation = AgentConversation::where('unique_id', $userId->unique_id)
                ->where(function ($query) {
                    $query->whereJsonDoesntContain('delete_status', Auth::id())
                        ->orWhereNull('delete_status');
                })
                ->get();
        } else {
            $userconversation = null;
        }

        $user = Auth::user();
        if ($user != null) {
            $user->image_url = userprofileimage($user);
        }
        $receiverdata = User::find($id);
        if ($receiverdata != null) {
            $receiverdata->image_url = userprofileimage($receiverdata);
        }

        try {
            event(new AgentMessagingEvent(null, null, $user->id, null, null, $id));
        } catch (\Exception $e) {
        }

        if ($userId != null) {
            $this->markasread($userId->unique_id);
        }

        return response()->json(['senderdata' => $user, 'receiverdata' => $receiverdata, 'userconversation' => $userconversation]);
    }

    public function conversationdelete(Request $request, $id)
    {
        $allconver = AgentConversation::where('unique_id', $id)->get();
        foreach ($allconver as $allconvers) {

            if (!$allconvers->delete_status) {
                $allconvers->delete_status = [Auth::user()->id];
                $allconvers->save();
            } else {
                if (!in_array(Auth::id(), json_decode($allconvers->delete_status))) {
                    $existingData = [];
                    $existingData = json_decode($allconvers->delete_status, true);

                    $newUserId = Auth::user()->id;
                    $existingData[] = $newUserId;
                    $allconvers->delete_status = json_encode($existingData);


                    $allconvers->save();
                }
            }
        }

        $this->markasread($id);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Conversation Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => lang('Chat deleted successfully.')], 200);
        // return redirect()->route('admin.operators')->with('success', lang('Conversations deleted successfully.'));
    }

    public function broadcastoperator(Request $request)
    {
        $user = Auth::user();

        $receiverdata = User::find($request->receiverId);

        $uniqueId = AgentConversation::where('sender_user_id', $user->id)->where('receiver_user_id', $request->receiverId)->first();

        if ($uniqueId == null) {
            $uniqueId = AgentConversation::where('sender_user_id', $request->receiverId)->where('receiver_user_id', $user->id)->first();
        }

        $newconversation = new AgentConversation();
        $newconversation->unique_id = $uniqueId != null ? $uniqueId->unique_id : Str::random(9);
        $newconversation->sender_username = $user->name;
        $newconversation->reciever_username = $receiverdata->name;
        $newconversation->sender_user_id = $user->id;
        $newconversation->receiver_user_id = $request->receiverId;
        $newconversation->message = $request->message;
        $newconversation->message_status = $request->messageStatus;
        if ($request->messageType) {
            $newconversation->message_type = $request->messageType;
            $newconversation->storage_disk = storage()->storage_disk;
        }
        $newconversation->save();

        $newconversation->encrypted_unique_id = Crypt::encrypt($newconversation->unique_id);

        event(new AgentMessagingEvent($request->message, $request->receiverId, $user->id, $user->name, null, null, userprofileimage(Auth::user()), null, $request->messageType ?? null, $newconversation));

        if ($uniqueId) {
            $this->markasread($uniqueId->unique_id);
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Message Sent To Operators';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        $newconversation->encrypted_unique_id = Crypt::encrypt($newconversation->unique_id);

        return response()->json(['MessageSent' => $newconversation,]);
    }

    public function markasunread(Request $request, $id)
    {
        $agentconver =  AgentConversation::where('unique_id', $id)->latest('updated_at')->latest('id')->first();
        if (!$agentconver->mark_as_unread) {
            $agentconver->mark_as_unread = [Auth::id()];
            $agentconver->save();
        } else {
            if (!in_array(Auth::id(), json_decode($agentconver->mark_as_unread))) {
                $existingData = [];
                $existingData = json_decode($agentconver->mark_as_unread, true);

                $newUserId = Auth::id();
                $existingData[] = $newUserId;
                $agentconver->mark_as_unread = json_encode($existingData);

                $agentconver->save();
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Mark As Unread';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect()->route('admin.operators')->with('success', lang('Mark As Unread.'));
    }

    public function markasread($id)
    {
        $agentconver =  AgentConversation::where('unique_id', $id)->get();
        $agentconver->each(function ($message) {
            if (is_array(json_decode($message->mark_as_unread))) {
                $message->update([
                    'mark_as_unread' => array_diff(json_decode($message->mark_as_unread), [auth()->id()])
                ]);
            }
        });

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Mark As Read';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect()->route('admin.operators');
    }

    public function groupbroadcastoperator(Request $request)
    {
        $group = new AgentGroupConversation();
        $group->unique_id = Str::random(9);
        $group->message = 'Group created by' . ' ' . Auth::user()->name;
        $group->sender_username = Auth::user()->name;
        $group->reciever_username = $request->recieverUsersNames;
        $group->receiver_user_id = $request->usersId;
        $group->sender_user_id = Auth::id();
        $group->created_user_id = Auth::id();
        $group->mark_as_unread = "[" . Auth::user()->id . "]";
        $group->save();

        $groupIncludeUsers = json_decode($group->receiver_user_id, true);

        $avatarsHtml = '';
        $conversationIncludeUsers = '';
        $extraCount = max(0, count($groupIncludeUsers) - 2); // Count for extra users beyond 2

        foreach ($groupIncludeUsers as $index => $IncludeuserId) {
            $groupincludemembers = \App\Models\User::find($IncludeuserId);

            if ($groupincludemembers != null) {
                if ($index >= 2) {
                    $conversationIncludeUsers .= $groupincludemembers->name . ', ';
                }
                if ($index < 2) {
                    // Append avatar HTML for the first two users
                    $avatarsHtml .= "
                        <span class='avatar avatar-sm brround'
                              style='background-image: url(" . userprofileimage($groupincludemembers) . ")'
                              data-bs-toggle='tooltip'
                              data-bs-placement='top'
                              title='" . e($groupincludemembers->name) . "'>
                        </span>
                    ";
                }
            }
        }

        // Add an extra count if there are more than two users
        if ($extraCount > 0) {
            $avatarsHtml .= "
                <span class='avatar avatar-sm brround bg-light text-dark'
                      data-bs-toggle='tooltip'
                      data-bs-placement='top'
                      title='" . e(rtrim($conversationIncludeUsers, ', ')) . "'>+{$extraCount}</span>
            ";
        }

        $group->groupincludeusersdata = $avatarsHtml;
        $group->encrypted_unique_id = Crypt::encrypt($group->unique_id);

        event(new AgentMessagingEvent($group->message, $group->unique_id, Auth::id(), Auth::user()->name, null, null, userprofileimage(Auth::user()), $request->usersId,null,$group));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Group Chat created';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['group' => $group,]);
    }

    public function groupconversionstore(Request $request, $id)
    {
        $createdId = AgentGroupConversation::where('unique_id', $id)->first();
        if ($createdId->receiver_user_id != $createdId->mark_as_unread) {
            $createdId->mark_as_unread = $createdId->receiver_user_id;
            $createdId->save();
        }

        $group = new AgentGroupConversation();
        $group->unique_id = $id;
        $group->sender_username = Auth::user()->name;
        $group->sender_image = Auth::user()->image;
        $group->reciever_username = $request->recieverUsersNames;
        $group->message = $request->message;
        $group->sender_user_id = Auth::id();
        $group->receiver_user_id = $request->usersId;
        $group->created_user_id = $createdId->created_user_id;
        $group->mark_as_unread = $request->seenUserIds;
        $group->message_status = $request->messageStatus;
        if ($request->messageType) {
            $group->message_type = $request->messageType;
            event(new AgentMessagingEvent($request->message, $id, Auth::id(), Auth::user()->name, null, null, userprofileimage(Auth::user()), $request->usersId, $request->messageType));
        } else {
            event(new AgentMessagingEvent($request->message, $id, Auth::id(), Auth::user()->name, null, null, userprofileimage(Auth::user()), $request->usersId));
        }
        $group->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Message Sent In Group Chat';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
    }

    public function groupconversiondelete($id)
    {
        $groupConversations = AgentGroupConversation::where('unique_id', $id)->get();

        $authId = Auth::id();

        foreach ($groupConversations as $key => $conversation) {
            if (!$conversation->delete_status) {
                $conversation->delete_status = [Auth::user()->id];
                $conversation->save();
            } else {
                if (!in_array(Auth::id(), json_decode($conversation->delete_status))) {
                    $existingData = [];
                    $existingData = json_decode($conversation->delete_status, true);
                    $newUserId = Auth::user()->id;
                    $existingData[] = $newUserId;
                    $conversation->delete_status = json_encode($existingData);
                    $conversation->save();
                }
            }

            $existingRecieverDatas = json_decode($conversation->receiver_user_id, true);
            $newReceiverUserIds = [];
            foreach($existingRecieverDatas as $existingRecieverData){
                if($existingRecieverData != $authId){
                    $newReceiverUserIds[] = $existingRecieverData;
                }
            }
            $existingMarkAsDatas = json_decode($conversation->mark_as_unread, true);
            $newMarkAsIds = [];
            foreach($existingMarkAsDatas as $existingMarkAsData){
                if($existingMarkAsData != $authId){
                    $newMarkAsIds[] = $existingMarkAsData;
                }
            }

            $conversation->receiver_user_id = json_encode($newReceiverUserIds);
            $conversation->mark_as_unread = json_encode($newMarkAsIds);
            $conversation->save();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Group Conversation Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => lang('Group chat deleted successfully.')], 200);
        // return redirect()->route('admin.operators')->with('success', lang('Delete Successfully.'));
    }

    public function chatmassdelete(Request $request)
    {
        if (!empty($request->id)) {
            foreach ($request->id as $requestdata) {
                if ($requestdata['dataId'] == 'group') {
                    $uniqueid = decrypt($requestdata['value']);
                    $groupConversations = AgentGroupConversation::where('unique_id', $uniqueid)->get();
                    foreach ($groupConversations as $key => $conversation) {
                        if (!$conversation->delete_status) {
                            $conversation->delete_status = [Auth::user()->id];
                            $conversation->save();
                        } else {
                            if (!in_array(Auth::id(), json_decode($conversation->delete_status))) {
                                $existingData = [];
                                $existingData = json_decode($conversation->delete_status, true);
                                $newUserId = Auth::user()->id;
                                $existingData[] = $newUserId;
                                $conversation->delete_status = json_encode($existingData);
                                $conversation->save();
                            }
                        }
                    }
                } else {
                    $uniqueid = decrypt($requestdata['value']);
                    $allconver = AgentConversation::where('unique_id', $uniqueid)->get();
                    foreach ($allconver as $allconvers) {
                        if (!$allconvers->delete_status) {
                            $allconvers->delete_status = [Auth::user()->id];
                            $allconvers->save();
                        } else {
                            if (!in_array(Auth::id(), json_decode($allconvers->delete_status))) {
                                $existingData = [];
                                $existingData = json_decode($allconvers->delete_status, true);

                                $newUserId = Auth::user()->id;
                                $existingData[] = $newUserId;
                                $allconvers->delete_status = json_encode($existingData);
                                $allconvers->save();
                            }
                        }
                    }

                    $this->markasread($uniqueid);
                }
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Multiple Chats Deleted';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['code' => 200, 'success' => lang('Chat deleted successfully.')], 200);
        } else {
            return response()->json(['code' => 500, 'error' => lang('Please select at least one check box.')], 500);
        }
    }

    public function ChatFlowSave(Request $req)
    {
        livechat_flow::where('active', 1)->update(['active' => 0]);

        $ActiveChat = livechat_flow::where('id', $req->chatId)->first();
        if ($req->chat) {
            $ActiveChat->liveChatFlow = $req->chat;
        }
        $ActiveChat->active = 1;
        $ActiveChat->active_draft = null;
        $ActiveChat->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Chatfolw Saved';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Livechat flow saved successfully'), 'flow' => $ActiveChat]);
    }

    public function activeChatFlow(Request $req)
    {
        livechat_flow::where('active', 1)->update(['active' => 0]);
        if ($req->checked) {
            $ActiveChat = livechat_flow::where('id', $req->chatId)->first();
            $ActiveChat->active = 1;
            $ActiveChat->save();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Active Chatfolw Saved';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Livechat flow saved')]);
    }

    function deleteChatFlow(Request $req, $id)
    {
        $flow = livechat_flow::find($id);
        if ($req->query('active-draft-delete')) {
            $flow->active_draft = null;
            $flow->save();
        } else {
            $flow->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Chatfolw Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect()->route('admin.chatResponses')->with('success', lang('Chat Flow Deleted'));
    }

    public function ChatFlowData(Request $request, $id, $ipdata)
    {
        if ($ipdata != null) {
            $customer = LiveChatCustomers::where('login_ip', $ipdata)->first();
            if ($customer != null) {
                $banstatus = $customer->banstatus == 'banned' ? 'banned' : null;
            } else {
                $banstatus = null;
            }
        } else {
            $banstatus = null;
        }

        $requaredchart = null;
        if ($id != 'null') {
            $requaredchart = livechat_flow::find($id);
            if ($requaredchart->active_draft) {
                $requaredchart->liveChatFlow = $requaredchart->active_draft;
            }
            $requaredchart->onlineUsers = $this->personalworkhours();
            $requaredchart->isonlineoroffline = $this->isonlineoroffline();
            $requaredchart->OnlineStatusMessage = setting('OnlineStatusMessage');
            $requaredchart->OfflineStatusMessage = setting('OfflineStatusMessage');
            $requaredchart->OfflineMessage = setting('OfflineMessage');
            $requaredchart->offlineDisplayLiveChat = setting('offlineDisplayLiveChat');
            $requaredchart->livechatIconSize = setting('livechatIconSize');
            $requaredchart->livechatPosition = setting('livechatPosition');
            $requaredchart->liveChatHidden = setting('liveChatHidden');
            $requaredchart->LivechatCustWelcomeMsg = setting('LivechatCustWelcomeMsg');
            $requaredchart->livechatthemecolor = setting('livechatthemecolor');
            $requaredchart->beforechatshowdata = setting('STATIC_NAME_FOR_ICON');
            $requaredchart->livechatpopuptitle = setting('LIVECHAT_POPUP_TITLE');
            $requaredchart->livechatpopupsubtitle = setting('LIVECHAT_POPUP_SUB_TITLE');
            $requaredchart->ipbannedstatus = $banstatus;
            $requaredchart->maintenance = settingpages('MAINTENANCE_MODE');
            $requaredchart->chatheaderimage = chatheaderimageurl();
            $requaredchart->chaticonimage = setting('chat_icon_bg_image') != null ? route('getImage.url', ['imagePath' => 'uploads*livechatbgimages*iconimage*' . setting('chat_icon_bg_image'), 'storage_disk' => setting('chat_icon_bg_image_storage_disk') ?? 'public']) : null;
            $requaredchart->chaticondraggableswitch = setting('livechat_icon_draggable');
            $requaredchart->whatsappEnabled = setting('enableWhatsapp');
            $requaredchart->instagramEnabled = setting('enableInstagram');
            $requaredchart->whatsappNumber = setting('whatsappNumber');
            $requaredchart->instagramUsername = setting('instagramUsername');
            $requaredchart->inspectDisable = setting('inspectDisable');
            $requaredchart->selectDisabled = setting('selectDisabled');
            $requaredchart->customerVoiceChat = setting('customerVoiceChat');
        }

        $activeChatData = livechat_flow::where('active', 1)->first();

        $activeChatDataArray = [
            'onlineUsers' => $this->personalworkhours(),
            'isonlineoroffline' => $this->isonlineoroffline(),
            'OnlineStatusMessage' => setting('OnlineStatusMessage'),
            'OfflineStatusMessage' => setting('OfflineStatusMessage'),
            'OfflineMessage' => setting('OfflineMessage'),
            'offlineDisplayLiveChat' => setting('offlineDisplayLiveChat'),
            'livechatIconSize' => setting('livechatIconSize'),
            'livechatPosition' => setting('livechatPosition'),
            'liveChatHidden' => setting('liveChatHidden'),
            'LivechatCustWelcomeMsg' => setting('LivechatCustWelcomeMsg'),
            'livechatthemecolor' => setting('livechatthemecolor'),
            'beforechatshowdata' => setting('STATIC_NAME_FOR_ICON'),
            'livechatpopuptitle' => setting('LIVECHAT_POPUP_TITLE'),
            'livechatpopupsubtitle' => setting('LIVECHAT_POPUP_SUB_TITLE'),
            'ipbannedstatus' => $banstatus,
            'maintenance' => settingpages('MAINTENANCE_MODE'),
            'chatheaderimage' => chatheaderimageurl(),
            'chaticonimage' => setting('chat_icon_bg_image') != null ? route('getImage.url', ['imagePath' => 'uploads*livechatbgimages*iconimage*' . setting('chat_icon_bg_image'), 'storage_disk' => setting('chat_icon_bg_image_storage_disk') ?? 'public']) : null,
            'chaticondraggableswitch' => setting('livechat_icon_draggable'),
            'whatsappEnabled' => setting('enableWhatsapp'),
            'whatsappNumber' => setting('whatsappNumber'),
            'instagramEnabled' => setting('enableInstagram'),
            'instagramUsername' => setting('instagramUsername'),
            'inspectDisable' => setting('inspectDisable'),
            'selectDisabled' => setting('selectDisabled'),
            'customerVoiceChat' => setting('customerVoiceChat'),
        ];

        if ($activeChatData) {
            $activeChatDataArray = array_merge($activeChatDataArray, $activeChatData->toArray());
        }

        $flow = $id != 'null' ? $requaredchart : $activeChatDataArray;
        return response()->json(['success' => $flow]);
    }

    public function chatResponses()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $flow = livechat_flow::where('active', 1)->first();
        $data['flow'] = $flow;

        $allDraftflow = livechat_flow::where('active', 0)->get();
        $data['allDraftflow'] = $allDraftflow;

        return view('admin.livechat.chat-responses')->with($data);
    }

    public function testItOut($id)
    {
        $flowChatId = $id;
        $data['flowChatId'] = $flowChatId;

        return view('admin.livechat.livechat-test-it-out')->with($data);
    }

    public function engageConversation(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->custId);

        $existingEngageConversation = json_decode($livecust->engage_conversation, true);
        if ($existingEngageConversation === null) {
            $existingEngageConversation = [];
        }
        $newUsers = is_array($request->users) ? $request->users : json_decode($request->users, true);
        $existingIds = array_column($existingEngageConversation, 'id');
        foreach ($newUsers as $user) {
            if (!in_array($user['id'], $existingIds)) {
                $existingEngageConversation[] = $user;
            }
        }
        $livecust->engage_conversation = json_encode($existingEngageConversation);
        $livecust->save();

        $livechatdata = LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->get();
        $currentUserId = Auth::id();
        $filteredLiveChatData = $livechatdata->reject(function ($message) use ($currentUserId) {
            return $message->delete != null;
        });
        if ($currentUserId && strpos($request->header('referer'), 'livechat-flow/test-it-out') == false) {
            foreach ($filteredLiveChatData as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "comment") {
                    $message->status = 'seen';
                    $message->save();
                }
            }
        }

        // For the Joined comment
        $user = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $user->id;
        $newconversation->livechat_username = $user->name;
        $newconversation->message = $user->name . ' joined the discussion at';
        $newconversation->status = 'comment';
        $newconversation->save();

        $livecust->encrypted_id = Crypt::encrypt($livecust->id);

        $conversationData = json_decode($livecust->engage_conversation, true);
        foreach ($conversationData as &$conversation) {
            if (is_object($conversation)) {
                $conversation = (array) $conversation;
            }
        }

        $conversationCount = count($conversationData);

        $namesString = implode(', ', array_map(fn($item) => $item['name'], $conversationData));

        $avatarHtml = '';

        foreach ($conversationData as $key => $LiveCustmer) {
            if ($key < 2) {
                if($LiveCustmer['image']){
                    $baseUrl = route('getprofile.url', ['imagePath' => $LiveCustmer['image'], 'storage_disk' => $LiveCustmer['storage_disk']]);
                }else{
                    $baseUrl = asset('/uploads/profile/user-profile.png');
                }
                $avatarHtml .= '<span class="avatar brround avatar-sm" '
                    . 'style="background-image: url(' . $baseUrl  . ')" '
                    . 'data-bs-toggle="tooltip" data-bs-placement="top" '
                    . 'data-bs-title="' . htmlspecialchars($LiveCustmer['name']) . '" '
                    . 'title="' . htmlspecialchars($LiveCustmer['firstname']) . '"></span>';
            }
        }

        if ($conversationCount > 2) {
            $avatarHtml .= '<span class="avatar brround bg-light text-dark avatar-sm" '
                . 'data-bs-toggle="tooltip" data-bs-placement="top" '
                . 'data-bs-title="' . htmlspecialchars($namesString) . '">+' . ($conversationCount - 2) . '</span>';
        }

        $livecust->engagedUserdetailsCont = $avatarHtml;
        $livecust->reassigncreated = $newconversation->created_at;

        event(new ChatMessageEvent(null, null, $user->id, $request->custId, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null, null, null, null, $livecust));

        // event(new ChatMessageEvent(null, null, $user->id, $request->custId, null, null, true, $livecust->engage_conversation, $newconversation->message));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Engaged The Conversation';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
    }

    public function solvedChats()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $user = User::where('id', '!=', Auth::id())->where('status', 1)->get();
        $data['user'] = $user;

        $livecust = LiveChatCustomers::latest('updated_at')->with('livechatconversation')->get();
        $data['livecust'] = $livecust;

        $filteredLiveCust = $livecust->filter(function ($item) {
            return ($item->engage_conversation === null || $item->engage_conversation === '') && $item->status == 'solved' && $item->banstatus !== 'banned';
        });

        foreach ($filteredLiveCust as $customer) {
            $livechatdata = LiveChatConversations::where('unique_id', $customer->cust_unique_id)->get();
            $unreadIndexNumber = 0;
            foreach ($livechatdata as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "seen" && !$message->delete) {
                    $unreadIndexNumber = $unreadIndexNumber + 1;
                }
            }
            $customer->unreadIndexNumber = $unreadIndexNumber;
            $customer->lastMessage = $livechatdata->isNotEmpty() ? $livechatdata->last() : null;
        }

        $filteredLiveCust = $filteredLiveCust->sortByDesc(function ($customer) {
            return optional($customer->lastMessage)->created_at->timestamp;
        });

        $data['filteredLiveCust'] = $filteredLiveCust;

        $categories = Category::whereIn('display', ['ticket', 'both'])->where('status', '1')->get();
        $data['categories'] = $categories;

        $userdatas = User::where('status', 1)->get();
        $data['userdatas'] = $userdatas;

        return view('admin.livechat.solvedchat')->with($data);
    }

    public function myOpenedChats()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $livecust = LiveChatCustomers::with('livechatconversation')->get();
        $data['livecust'] = $livecust;

        $filteredLiveCust = $livecust->filter(function ($customer) {
            $engageConversation = json_decode($customer->engage_conversation, true);
            return $customer->banstatus !== 'banned' && collect($engageConversation)->contains('id', auth()->id());
        });


        foreach ($filteredLiveCust as $customer) {
            $livechatdata = LiveChatConversations::where('unique_id', $customer->cust_unique_id)->get();
            $unreadIndexNumber = 0;
            foreach ($livechatdata as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "seen" && !$message->delete) {
                    $unreadIndexNumber = $unreadIndexNumber + 1;
                }
            }
            $customer->unreadIndexNumber = $unreadIndexNumber;
            $customer->lastMessage = $livechatdata->isNotEmpty() ? $livechatdata->last() : null;
        }

        $filteredLiveCust = $filteredLiveCust->sortByDesc(function ($customer) {
            return optional($customer->lastMessage)->created_at->timestamp;
        });

        $data['filteredLiveCust'] = $filteredLiveCust;
        $user = User::where('id', '!=', Auth::id())->where('status', 1)->get();
        $data['user'] = $user;

        $userCurrent = User::find(Auth::user()->id);
        $userCurrent->getRoleNames()[0] == "superadmin";
        $data['superadmin'] = $userCurrent;

        $categories = Category::whereIn('display', ['ticket', 'both'])->where('status', '1')->get();
        $data['categories'] = $categories;

        $userdatas = User::where('status', 1)->get();
        $data['userdatas'] = $userdatas;

        $data['chatsourcefrom'] = request()->chatsourcefrom != null ? request()->chatsourcefrom : null;

        return view('admin.livechat.myopenedchats')->with($data);
    }

    public function getCannedmessages()
    {
        $cannedmessages = Cannedmessages::latest()->where('responsetype', 'livechat')->where('status', 1)->get();
        $data['cannedmessages'] = $cannedmessages;
        return response()->json(['success' => true, 'message' => $data]);
    }

    public function getticketCannedmessages(Request $request)
    {
        $ticket = Ticket::find($request->id);
        if ($ticket) {
            $cannedmessages = Cannedmessages::tickedetails($ticket->ticket_id);
        } else {
            $cannedmessages = null;
        }

        $data['cannedmessages'] = $cannedmessages;
        return response()->json(['success' => true, 'message' => $data]);
    }

    public function conversationLeave(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->id);
        $engageConversation = json_decode($livecust->engage_conversation, true);
        $engageConversation = array_filter($engageConversation, function ($conversation) use ($request) {
            return $conversation['id'] != auth()->id();
        });
        $livecust->engage_conversation = json_encode(array_values($engageConversation));
        $livecust->save();

        // For the Joined comment
        $user = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $user->id;
        $newconversation->livechat_username = $user->name;
        $newconversation->message = $user->name . ' left the discussion at';
        $newconversation->status = 'comment';
        $newconversation->save();
        event(new ChatMessageEvent(null, null, $user->id, $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Left The Conversation';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => true, 'message' => 'You Left the Conversation successfully.']);
    }

    public function bancustomer(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->id);
        $livecust->banstatus = 'banned';
        $livecust->save();

        // For the Joined comment
        $user = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $user->id;
        $newconversation->livechat_username = $user->name;
        $newconversation->message = $user->name . ' banned this customer at';
        $newconversation->status = 'comment';
        $newconversation->save();
        event(new ChatMessageEvent(null, null, $user->id, $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null, null, null, null, $livecust));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Banned The Customer';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        // return redirect()->route('admin.myOpenedChats');
        return response()->json(['success' => true, 'message' => 'Cusomer banned successfully.']);
    }

    public function unbancustomer(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->id);
        $livecust->banstatus = null;
        $livecust->save();

        // For the Joined comment
        $user = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $user->id;
        $newconversation->livechat_username = $user->name;
        $newconversation->message = $livecust->username . ' remove from banned customer list by ' . $user->name . 'at';
        $newconversation->status = 'comment';
        $newconversation->save();
        event(new ChatMessageEvent(null, null, $user->id, $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Unbanned The Customer';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect()->back()->with('success', lang('Successfully removed from banned list'));
    }

    public function conversationReassign(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->custId);
        $user = User::find($request->assignUser);

        if($user == null){
            return response()->json(['message' => 'notselected', 'error' => lang('Please select any user to assign chat.', 'alerts')], 500);
        }

        $authUser  = Auth::user();

        if ($livecust) {
            $engageConversation = $livecust->engage_conversation
                ? json_decode($livecust->engage_conversation, true)
                : [];
            $engageConversation = array_filter($engageConversation, function ($participant) use ($authUser) {
                return $participant['id'] !== $authUser->id;
            });
            $userInArray = collect($engageConversation)->first(function ($participant) use ($user) {
                return $participant['id'] === $user->id;
            });
            if (!$userInArray) {
                $engageConversation[] = $user->toArray();
            }
            $livecust->engage_conversation = json_encode(array_values($engageConversation));
            $livecust->save();

            // For the Joined comment
            $newconversation = new LiveChatConversations();
            $newconversation->unique_id = $livecust->cust_unique_id;
            $newconversation->livechat_user_id = $authUser->id;
            $newconversation->livechat_username = $authUser->name;
            $newconversation->message = $authUser->name . ' Reassign discussion to ' . $user->name . ' at ';
            $newconversation->status = 'comment';
            $newconversation->save();
        }

        $livecust->encrypted_id = Crypt::encrypt($livecust->id);

        $conversationData = json_decode($livecust->engage_conversation, true);
        foreach ($conversationData as &$conversation) {
            if (is_object($conversation)) {
                $conversation = (array) $conversation;
            }
        }

        $conversationCount = count($conversationData);

        $namesString = implode(', ', array_map(fn($item) => $item['name'], $conversationData));

        $avatarHtml = '';

        foreach ($conversationData as $key => $LiveCustmer) {
            if ($key < 2) {
                if($LiveCustmer['image']){
                    $baseUrl = route('getprofile.url', ['imagePath' => $LiveCustmer['image'], 'storage_disk' => $LiveCustmer['storage_disk']]);
                }else{
                    $baseUrl = asset('/uploads/profile/user-profile.png');
                }
                $avatarHtml .= '<span class="avatar brround avatar-sm" '
                    . 'style="background-image: url(' . $baseUrl  . ')" '
                    . 'data-bs-toggle="tooltip" data-bs-placement="top" '
                    . 'data-bs-title="' . htmlspecialchars($LiveCustmer['name']) . '" '
                    . 'title="' . htmlspecialchars($LiveCustmer['firstname']) . '"></span>';
            }
        }

        if ($conversationCount > 2) {
            $avatarHtml .= '<span class="avatar brround bg-light text-dark avatar-sm" '
                . 'data-bs-toggle="tooltip" data-bs-placement="top" '
                . 'data-bs-title="' . htmlspecialchars($namesString) . '">+' . ($conversationCount - 2) . '</span>';
        }

        $livecust->engagedUserdetailsCont = $avatarHtml;
        $livecust->reassigncreated = $newconversation->created_at;

        event(new ChatMessageEvent(null, null, $user->id, $request->custId, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null, null, null, null, $livecust));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Reassign The Conversation';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
    }

    function livechatConversationDelete(Request $request)
    {

        $unqid = $request->unqid;
        $userId = Auth::id();
        $liveChatMessages = LiveChatConversations::where('unique_id', $unqid)->get();
        $livecust = LiveChatCustomers::where('cust_unique_id', $liveChatMessages[0]->unique_id)->first();
        $livecust->update(['engage_conversation' => null]);

        foreach ($liveChatMessages as $message) {
            $deleteArray = json_decode($message->delete, true) ?? [];
            if (!in_array($userId, $deleteArray)) {
                $deleteArray[] = $userId;
                $message->update(['delete' => json_encode($deleteArray)]);
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Conversation Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return Redirect::back()->with('success', lang('Updated successfully'));
    }

    function ConversationMassDelete(Request $request)
    {

        $student_id_arrays = $request->input('id');

        $student_id_array = array_map(function ($encryptedValue) {
            return decrypt($encryptedValue);
        }, $student_id_arrays);

        $livecusts = LiveChatCustomers::whereIn('cust_unique_id', $student_id_array)->get();
        foreach ($livecusts as $livecust) {
            $userId = Auth::id();
            $livecust->update(['engage_conversation' => null]);
            $liveChatMessages = LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->get();
            foreach ($liveChatMessages as $message) {
                $deleteArray = json_decode($message->delete, true) ?? [];
                if (!in_array($userId, $deleteArray)) {
                    $deleteArray[] = $userId;
                    $message->update(['delete' => json_encode($deleteArray)]);
                }
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple Livechat Conversations Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => true, 'message' => 'Conversations deleted successfully.']);
    }

    function markAsSolved(Request $request)
    {
        // return response()->json(['success' => true, 'message' => 'Added as solved chat.']);
        $livecust = LiveChatCustomers::find($request->id);

        $solvedUser = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $solvedUser->id;
        $newconversation->livechat_username = $solvedUser->name;
        $newconversation->message = $solvedUser->name . ' Solved the discussion at';
        $newconversation->status = 'comment';
        $newconversation->save();

        $livecust->encrypted_id = Crypt::encrypt($livecust->id);
        $livecust->solveddiscreated = $newconversation->created_at;

        event(new ChatMessageEvent(null, null, $solvedUser->id, $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null, null, null, null, $livecust));

        if (json_decode($livecust->engage_conversation) != null) {
            foreach (json_decode($livecust->engage_conversation) as $engageusers) {
                // For the Left User comment
                $user = $engageusers;
                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $livecust->cust_unique_id;
                $newconversation->livechat_user_id = $user->id;
                $newconversation->livechat_username = $user->name;
                $newconversation->message = $user->name . ' left the discussion at';
                $newconversation->status = 'comment';
                $newconversation->save();
                event(new ChatMessageEvent(null, null, $user->id, $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message));
            }
        }

        $livecustupdate = LiveChatCustomers::find($livecust->id);
        $livecustupdate->engage_conversation = '';
        $livecustupdate->status = 'solved';
        $livecustupdate->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Mark As Solved';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if ($request->solvedsourcefrom == 'directsolved') {
            return response()->json(['success' => true, 'message' => 'Added as solved chat.']);
        } else {
            return redirect()->route('admin.solvedChats');
        }
    }

    public function addticketasUnread(Request $request)
    {
        $livecust = Ticket::find($request->id);
        $userId = Auth::id();
        $unreadArray = json_decode($livecust->mark_as_unread, true) ?? [];
        if (!in_array($userId, $unreadArray)) {
            $unreadArray[] = $userId;
            $livecust->update(['mark_as_unread' => json_encode($unreadArray)]);
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Ticket Mark As Unread';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => true, 'message' => 'Mark as unread successfully.']);
    }

    public function removeticketFromUnread(Request $request)
    {
        $livecust = Ticket::find($request->id);
        $userId = Auth::id();
        $unreadArray = json_decode($livecust->mark_as_unread, true) ?? [];
        if (($key = array_search($userId, $unreadArray)) !== false) {
            unset($unreadArray[$key]);
            $livecust->update(['mark_as_unread' => json_encode($unreadArray)]);
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Ticket Mark As Read';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => true, 'message' => 'Remove from mark as unread successfully.']);
    }

    function livechatSettings()
    {

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $flow = livechat_flow::where('active', 1)->first();
        $data['flow'] = $flow;

        $soundPath = public_path('uploads/livechatsounds');

        if (file_exists($soundPath)) {
            $soundNames = File::files($soundPath);
        } else {
            $soundNames = [];
        }

        $sounds = [];
        foreach ($soundNames as $soundName) {
            $sounds[] = (object)['name' => $soundName->getFilename()];
        }
        $data['sounds'] = $sounds;
        if (setting('serversslcertificate') != null) {
            $settingcert = SslCertificate::createFromString(setting('serversslcertificate'));
        } else {
            $settingcert = null;
        }
        $data['settingcert'] = $settingcert;

        return view('admin.livechat.livechat-settings')->with($data);
    }

    function livechatappearance()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $flow = livechat_flow::where('active', 1)->first();
        $data['flow'] = $flow;

        $soundPath = public_path('uploads/livechatsounds');

        if (file_exists($soundPath)) {
            $soundNames = File::files($soundPath);
        } else {
            $soundNames = [];
        }

        $sounds = [];
        foreach ($soundNames as $soundName) {
            $sounds[] = (object)['name' => $soundName->getFilename()];
        }
        $data['sounds'] = $sounds;

        return view('admin.livechat.livechatappearance')->with($data);
    }

    function appearancestore(Request $request)
    {
        $request->validate([
            'livechatPosition' => 'required',
            'livechatIconSize' => 'required',
            'LivechatCustWelcomeMsg' => 'max:20',
            'STATIC_NAME_FOR_ICON' => 'max:20',
            'LIVECHAT_POPUP_TITLE' => 'max:25',
            'LIVECHAT_POPUP_SUB_TITLE' => 'max:60',
        ]);

        $data['livechatthemecolor']  =  $request->chat_theme_primary != null ? $request->chat_theme_primary : setting('livechatthemecolor');
        $data['livechatPosition']  =  $request->livechatPosition;
        $data['livechatIconSize'] = $request->livechatIconSize;
        $data['LivechatCustWelcomeMsg'] = $request->LivechatCustWelcomeMsg;
        $data['STATIC_NAME_FOR_ICON'] = $request->STATIC_NAME_FOR_ICON;
        $data['LIVECHAT_POPUP_TITLE'] = $request->LIVECHAT_POPUP_TITLE;
        $data['LIVECHAT_POPUP_SUB_TITLE'] = $request->LIVECHAT_POPUP_SUB_TITLE;
        $data['chat_header_bg_image_selected'] = $request->chat_header_bg_image_selected;
        $data['livechat_icon_draggable'] = $request->has('livechat_icon_draggable') ? 'on' : 'off';

        if ($files = $request->file('chat_icon_bg_image')) {
            //delete old file
            if (setting('chat_icon_bg_image_storage_disk') != null) {
                $provider  = existprovider(setting('chat_icon_bg_image_storage_disk'))->provider;
            } else {
                $provider  = existprovider('public')->provider;
            }
            $provider::delete('/uploads/livechatbgimages/iconimage/' . setting('chat_icon_bg_image'));

            //insert new file
            $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
            $provider = storage()->provider;
            $provider::uploadImage($files, '/uploads/livechatbgimages/iconimage/', $profileImage);
            $data['chat_icon_bg_image'] = "$profileImage";
            $data['chat_icon_bg_image_storage_disk'] = storage()->storage_disk ?? 'public';
        }

        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Appearance Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    public function appearanceMedia(Request $request)
    {
        if ($request->file('file')) {
            $path = public_path('uploads/livechatbgimages');

            if (!file_exists($path)) {
                mkdir($path, 0777, true);
            }

            $file = $request->file('file');

            $name = uniqid() . '_' . trim($file->getClientOriginalName());

            $file->move($path, $name);

            $filepath = asset('uploads/livechatbgimages/' . $name);

            $data['chat_header_bg_image'] = setting('chat_header_bg_image') != null ? setting('chat_header_bg_image') . ',' . $name : $name;
            $this->updateSettings($data);

            return response()->json([
                'files' => $filepath,
                'original_name' => $file->getClientOriginalName(),
            ]);
        }
    }

    public function appearanceMediadelete(Request $request)
    {

        $path = $request->imgurl;

        if (setting('chat_header_bg_image') != null) {
            $newdata = [];
            $staticbgimages = setting('chat_header_bg_image');
            $bgimages = explode(',', setting('chat_header_bg_image'));
            foreach ($bgimages as $bgimage) {
                if ($bgimage != $request->imgname) {
                    array_push($newdata, $bgimage);
                }
            }

            $finaldata = implode(',', $newdata);
            $data['chat_header_bg_image'] = $finaldata;
            $this->updateSettings($data);
        }

        if (\File::exists($path)) {
            \File::delete($path);
        }

        return response()->json([
            'success' => lang('Image deleted successfully.'),
        ]);
    }

    public function appearanceicondelete(Request $request)
    {

        //delete old file
        $provider  = existprovider(setting('chat_icon_bg_image_storage_disk') ?? 'public')->provider;
        $provider::delete('/uploads/livechatbgimages/iconimage/' . setting('chat_icon_bg_image'));

        $data['chat_icon_bg_image'] = null;
        $data['chat_icon_bg_image_storage_disk'] = null;

        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Appearance Icon Image Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json([
            'success' => lang('Icon image deleted successfully.'),
        ]);
    }

    function liveChatNotificationsSetting(Request $request)
    {
        $data['notificationsSounds']  =  $request->notificationsSounds ? true : false;
        $data['notificationType'] = $request->notificationType;
        $data['newMessageWebNot'] = $request->newMessageWebNot ? true : false;
        $data['newMessageSound'] = $request->newMessageSound;
        $data['newChatRequestWebNot'] = $request->newChatRequestWebNot ? true : false;
        $data['newChatRequestSound'] = $request->newChatRequestSound;
        $data['newTicketCreateWebNot'] = $request->newTicketCreateWebNot ? true : false;
        $data['newTicketCreateSound'] = $request->newTicketCreateSound;
        $data['ticketNewMessaegeWebNot'] = $request->ticketNewMessaegeWebNot ? true : false;
        $data['ticketNewMessageCreateSound'] = $request->ticketNewMessageCreateSound;
        $this->updateSettings($data);
        return back()->with('success', lang('Updated successfully'));
    }

    function liveChatNotificationsSound(Request $request)
    {
        $request->validate([
            'uploadSound' => 'required|mimes:mp3,audio/*',
        ]);
        $path = public_path('uploads/livechatsounds');
        $file = $request->file('uploadSound');
        $filename = $file->getClientOriginalName();
        $file->move($path, $filename);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Sound Uploaded';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Sound uploaded successfully'));
    }

    function liveChatFlowSettings(Request $request)
    {
        $data['liveChatFlowload']  =  $request->liveChatFlowload;
        $this->updateSettings($data);
        return back()->with('success', lang('Updated successfully'));
    }


    function liveChatImageUpload(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'chatFileUpload' => 'required|file',
        ]);

        if ($validator->passes()) {
            $file = $request->file('chatFileUpload');
            $filename = time() . '' . $file->getClientOriginalName();
            $provider = storage()->provider;
            $provider::uploadImage($file, '/uploads/livechat/', $filename);
            $imageurl = route('getImage.url', ['imagePath' => 'uploads*livechat*' . $filename, 'storage_disk' => storage()->storage_disk ?? 'public']);

            if(Auth::check()){
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = $file->getClientOriginalName() == 'recording.webm' ? 'Livechat Audio File Uploaded' : 'Livechat Image Uploaded';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
            }

            return response()->json(['success' => true, 'message' => 'Image Upload', 'uploadedfilename' => $filename, 'imageurl' => $imageurl]);
        }
        return response()->json(['uploadError' => lang('The given file is invalid.')]);
    }

    function removeChatImage(Request $request)
    {
        $path = public_path('uploads/comment');
        $filepath = $path . '/' . $request->filename;

        if (File::exists($filepath)) {
            File::delete($filepath);

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Livechat Background Image Deleted';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => true, 'message' => 'File removed']);
        } else {
            return response()->json(['success' => false, 'message' => 'File not found']);
        }
    }

    public function voiceChat(Request $request)
    {
        $data['employeeVoiceChat'] = $request->employeeVoiceChat ? $request->employeeVoiceChat : "off";
        $data['customerVoiceChat'] = $request->customerVoiceChat ? $request->customerVoiceChat : "off";
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Voice Chat settings Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    function liveChatFileSettings(Request $request)
    {
        $userfileuploadtypes = explode(',', $request->livechatFileUploadTypes);
        $fileuploadtypes = explode(',', $request->AgentlivechatFileUploadTypes);
        $allowedFormats = ['.xlsx', '.csv', '.docx', '.pdf', '.jpg', '.jpeg', '.png', '.mp3', '.wav', '.mp4', '.zip', '.webp'];
        if ($request->livechatFileUploadTypes != null) {
            foreach ($userfileuploadtypes as $userfileuploadtype) {
                if (!in_array($userfileuploadtype, $allowedFormats)) {
                    return back()->with('error', lang('You are enter wrong file formats please enter correct format.'));
                }
            }
        }
        if ($request->AgentlivechatFileUploadTypes != null) {
            foreach ($fileuploadtypes as $fileuploadtype) {
                if (!in_array($fileuploadtype, $allowedFormats)) {
                    return back()->with('error', lang('You are enter wrong file formats please enter correct format.'));
                }
            }
        }

        if ($request->has('liveChatFileUpload')) {
            $request->validate([
                'livechatMaxFileUpload' => 'required|numeric|gt:0',
                'livechatFileUploadMax' => 'required|numeric|gt:0',
            ]);
        }

        if ($request->has('liveChatAgentFileUpload')) {
            $request->validate([
                'AgentlivechatMaxFileUpload' => 'required|numeric|gt:0',
                'AgentlivechatFileUploadMax' => 'required|numeric|gt:0',
            ]);
        }

        $livecust = LiveChatCustomers::all();
        if ($request->livechatMaxFileUpload) {
            $data['liveChatFileUpload']  =  $request->liveChatFileUpload ? true : false;
            if ($request->liveChatFileUpload) {
                foreach ($livecust as $cust) {
                    $cust->update(['file_upload_permission' => $request->liveChatFileUpload ? true : false]);
                }
            } else {
                foreach ($livecust as $cust) {
                    $cust->update(['file_upload_permission' => false]);
                }
            }
            $data['livechatMaxFileUpload'] = $request->livechatMaxFileUpload;
            $data['livechatFileUploadMax'] = $request->livechatFileUploadMax;
            $data['livechatFileUploadTypes'] = $request->livechatFileUploadTypes;
        } else {

            $data['liveChatAgentFileUpload']  =  $request->liveChatAgentFileUpload ? true : false;
            $data['AgentlivechatMaxFileUpload'] = $request->AgentlivechatMaxFileUpload;
            $data['AgentlivechatFileUploadMax'] = $request->AgentlivechatFileUploadMax;
            $data['AgentlivechatFileUploadTypes'] = $request->AgentlivechatFileUploadTypes;

            $group = [
                'agenttoagentfilesettingupdateddata' => 'agentToagentFilesettingUpdated',
                'agenttoagentfilesettingupdatedvalue' => $request->liveChatAgentFileUpload ? 'on' : 'off',
            ];

            event(new AgentMessagingEvent(null, null, null, null, null, null, null, null,null,$group));

        }
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Fileupload Settings Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    function agentToCustsetting(Request $request)
    {
        $fileuploadtypes = explode(',', $request->AgentToCustLivechatFileUploadTypes);
        $allowedFormats = ['.xlsx', '.csv', '.docx', '.pdf', '.jpg', '.jpeg', '.png', '.mp3', '.wav', '.mp4', '.zip', '.webp'];
        if ($request->AgentToCustLivechatFileUploadTypes != null) {
            foreach ($fileuploadtypes as $fileuploadtype) {
                if (!in_array($fileuploadtype, $allowedFormats)) {
                    return back()->with('error', lang('You are enter wrong file formats please enter correct format.'));
                }
            }
        }

        if ($request->has('liveChatAgentToCustFileUpload')) {
            $request->validate([
                'AgentToCustLivechatMaxFileUpload' => 'required|numeric|gt:0',
                'AgentToCustLivechatFileUploadMax' => 'required|numeric|gt:0',
            ]);
        }

        $data['liveChatAgentToCustFileUpload']  =  $request->liveChatAgentToCustFileUpload ? true : false;
        $data['AgentToCustLivechatMaxFileUpload'] = $request->AgentToCustLivechatMaxFileUpload;
        $data['AgentToCustLivechatFileUploadMax'] = $request->AgentToCustLivechatFileUploadMax;
        $data['AgentToCustLivechatFileUploadTypes'] = $request->AgentToCustLivechatFileUploadTypes;

        $this->updateSettings($data);

        event(new ChatMessageEvent(null, null, null, null, null, null, null, null, null, null, 'agentToCustomerFilesettingUpdated', null, null, null, null, $request->liveChatAgentToCustFileUpload ? 'on' : 'off'));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Agent To Customer Fileupload Settings Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    function liveChatCustFileUpload(Request $request)
    {

        $livecust = LiveChatCustomers::find($request->custUser);
        $livecust->file_upload_permission = $request->permission == 'true' ? 1 : 0;
        $livecust->save();

        if(isset($request->ticketId)){
            $ticket = Ticket::find($request->ticketId);

            $comment = Comment::create([
                'ticket_id' => $ticket->id,
                'user_id' => Auth::user()->id,
                'cust_id' => null,
                'comment' => $request->permission == 'true' ? 'File upload permission has been enabled' : 'File upload permission has been disabled',
                'commenttype' => 'tickethistory',
            ]);

            event(new ChatMessageEvent(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$ticket->id,$ticket->cust->id,$comment,'tickethistory',Auth::user()->name));
        }


        event(new ChatMessageEvent(null, null, null, null, null, null, null, null, null, null, 'fileuploadermision', null, null, null, null, $livecust));

        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function livechatNotificationsSonds()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $flow = livechat_flow::where('active', 1)->first();
        $data['flow'] = $flow;

        $soundPath = public_path('uploads/livechatsounds');
        if (file_exists($soundPath)) {
            $soundNames = File::files($soundPath);
        } else {
            $soundNames = [];
        }

        $sounds = [];
        foreach ($soundNames as $soundName) {
            $sounds[] = (object)['name' => $soundName->getFilename()];
        }
        $data['sounds'] = $sounds;

        return view('admin.livechat.livechat-notifications-sonds')->with($data);
    }

    function livechatNotificationsSondsDelete(Request $request)
    {
        $path = public_path('uploads/livechatsounds');
        $filepath = $path . '/' . $request->id;

        if (File::exists($filepath)) {
            File::delete($filepath);

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Livechat Notification Sound Deleted';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => lang('Notification sound deleted successfully'), 200]);
        } else {
            return response()->json(['success' => false, 'message' => 'File not found']);
        }
    }

    function livechatNotificationsMassSondsDelete(Request $request)
    {
        $path = public_path('uploads/livechatsounds');
        foreach ($request->id as $soung) {
            $filepath = $path . '/' . $soung;
            if (File::exists($filepath)) {
                File::delete($filepath);
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple Livechat Notification Sounds Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function liveChatOfflineSetting(Request $request)
    {
        $data['offlineDisplayLiveChat']  =  $request->offlineDisplayLiveChat ? true : false;
        $data['OfflineStatusMessage']  =  $request->OfflineStatusMessage;
        $data['OnlineStatusMessage']  =  $request->OnlineStatusMessage;
        $data['OfflineMessage']  =  $request->OfflineMessage;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Offline Or Online Settings Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    private function isonlineoroffline()
    {
        $status = null;
        $users = $this->personalworkhours();
        if (!empty(json_decode($users))) {
            $now = now();
            $holidays = $holidays = \App\Models\Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
            if ($holidays->isNotEmpty() && setting('24hoursbusinessswitch') != 'on') {
                $status = 'offline';
            }

            foreach (bussinesshour() as $bussiness) {
                if (now()->timezone(setting('default_timezone'))->format('D') == $bussiness->weeks) {
                    $currentTime = strtotime(now()->timezone(setting('default_timezone'))->format('h:i A'));
                    $startTime = strtotime($bussiness->starttime);
                    $endTime = strtotime($bussiness->endtime);
                    $breakStartTime = strtotime($bussiness->breakstarttime);
                    $breakEndTime = strtotime($bussiness->breakendtime);

                    if (($startTime <= $currentTime && $currentTime <= $endTime && !($breakStartTime <= $currentTime && $currentTime <= $breakEndTime)) || $bussiness->starttime == "24H") {
                        $status = 'online';
                    } else {
                        $status = 'offline';
                    }
                }
            }
        } else {
            $status = 'offline';
        }

        return $status;
    }

    public function personalworkhours()
    {
        $status = null;
        $online = Setting::where("key", 'All_Online_Users')->first();
        $dataArrays = json_decode($online->value, true);
        $onlineusers = [];
        if ($dataArrays != null) {
            foreach ($dataArrays as $dataArray) {
                $userdata = User::find($dataArray['id']);
                if ($userdata != null) {
                    $dataArray['profileurl'] = userprofileimage($userdata);
                } else {
                    $dataArray['profileurl'] = asset('/uploads/profile/user-profile.png');
                }
                if (isset($dataArray['personalworkhours']) && $dataArray['personalworkhours'] == 'on') {
                    $now = now();
                    $holidays = \App\Models\Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
                    if ($holidays->isNotEmpty() && $dataArray['personal24hours'] != 'on') {
                        $status = 'offline';
                    }

                    foreach (PersonalBusinessHours::where('user_id', $dataArray['id'])->get() as $bussiness) {
                        if (now()->timezone(setting('default_timezone'))->format('D') == $bussiness->weeks) {
                            $currentTime = strtotime(now()->timezone(setting('default_timezone'))->format('h:i A'));
                            $startTime = strtotime($bussiness->starttime);
                            $endTime = strtotime($bussiness->endtime);
                            $breakStartTime = strtotime($bussiness->breakstarttime);
                            $breakEndTime = strtotime($bussiness->breakendtime);

                            if (($startTime <= $currentTime && $currentTime <= $endTime && !($breakStartTime <= $currentTime && $currentTime <= $breakEndTime)) || $bussiness->starttime == "24H") {
                                array_push($onlineusers, $dataArray);
                            }
                        }
                    }
                } else {
                    array_push($onlineusers, $dataArray);
                }
            }
        }

        return json_encode($onlineusers);
    }

    function operatorsNotificationsSetting(Request $request)
    {

        $data['operatorsNotificationsSounds']  =  $request->operatorsNotificationsSounds ? true : false;
        $data['operatorsAgentToAgentWebNot'] = $request->operatorsAgentToAgentWebNot ? true : false;
        $data['operatorsGroupChatWebNot'] = $request->operatorsGroupChatWebNot ? true : false;
        $data['operatorsAgentToAgentSound'] = $request->operatorsAgentToAgentSound;
        $data['operatorsGroupChatSound'] = $request->operatorsGroupChatSound;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Operators Notification Sound Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    function livechatssldstore(Request $request)
    {

        $request->validate([
            'sslcertificate' => 'required',
            'sslkey' => 'required',
        ]);

        $domainname = parse_url(url('/'));
        $appurl = url('/');
        if (setting('serversslcertificate') != null) {
            $settingcert = SslCertificate::createFromString(setting('serversslcertificate'));
        } else {
            $settingcert = null;
        }
        if (setting('serverssldomainname') == $appurl && $settingcert != null && $settingcert->isValid()) {
            return redirect()->back()->with('error', lang('Your ssl certificate details all ready working, do not edit it.'));
        } else {
            file_put_contents(base_path('config/localhost/server.key'), $request->sslkey);
            file_put_contents(base_path('config/localhost/server.crt'), $request->sslcertificate);

            $localCertPath = base_path('config/localhost/server.crt');
            $localKeyPath = base_path('config/localhost/server.key');

            try {
                if ($domainname['host'] == 'localhost') {
                    $certContent = file_get_contents($localCertPath);
                    $keyContent = file_get_contents($localKeyPath);

                    $certDetails = openssl_x509_parse($certContent);

                    if ($certDetails === false) {
                        return redirect()->back()->with('error', 'Failed to parse certificate: ' . openssl_error_string());
                    } else {
                        $keyValid = openssl_x509_check_private_key($certContent, $keyContent);

                        if ($keyValid) {
                            $data['serversslcertificate'] = $request->sslcertificate;
                            $data['serversslkey'] = $request->sslkey;
                            $data['serverssldomainname'] = $appurl;
                            $this->updateSettings($data);
                            return redirect()->back()->with('success', 'SSL certificate data has been saved successfully.');
                        } else {
                            return redirect()->back()->with('error', 'The private key does not correspond to the given certificate');
                        }
                    }
                } else {
                    $remoteCert = SslCertificate::createForHostName($domainname['host']);
                    $remoteCertArray = $remoteCert->toArray();

                    if ($remoteCert->isValid()) {
                        $certContent = file_get_contents($localCertPath);
                        $keyContent = file_get_contents($localKeyPath);

                        $certDetails = openssl_x509_parse($certContent);

                        if ($certDetails === false) {
                            return redirect()->back()->with('error', 'Failed to parse certificate: ' . openssl_error_string());
                        } else {
                            $keyValid = openssl_x509_check_private_key($certContent, $keyContent);

                            if ($keyValid) {
                                $data['serversslcertificate'] = $request->sslcertificate;
                                $data['serversslkey'] = $request->sslkey;
                                $data['serverssldomainname'] = $appurl;
                                $this->updateSettings($data);

                                return redirect()->back()->with('success', 'SSL certificate data has been saved successfully.');
                            } else {
                                return redirect()->back()->with('error', 'The private key does not correspond to the given certificate');
                            }
                        }
                    } else {
                        return redirect()->back()->with('error', 'Your ssl certificate is not valid.');
                    }
                }
            } catch (Exception $e) {
                return redirect()->back()->with('error', $e->getMessage());
            }
        }
    }

    function livechatCredentials(Request $request)
    {
        $businesshours = Bussinesshours::get();
        if (setting('serverssldomainname') == null || setting('serverssldomainname') != url('/')) {
            return response()->json(['code' => 500, 'error' => lang("You need to setup ssl cert and key details correctly.", "alerts")], 500);
        } elseif (setting('mail_host') == 'smtp.mailtrap.io') {
            return response()->json(['code' => 500, 'error' => lang("You need to setup email setting correctly.", "alerts")], 500);
        } elseif (setting('IMAP_STATUS') != 'on') {
            return response()->json(['code' => 500, 'error' => lang("You need to setup imap setting correctly.", "alerts")], 500);
        } elseif ($businesshours->isEmpty()) {
            return response()->json(['code' => 500, 'error' => lang("You need to setup business hours setting correctly.", "alerts")], 500);
        } else {
            $urllink = url('/');
            $livechatscriptcrating = "<script src='$urllink/MfIatXueATJr' wsPort='$request->liveChatPort' domainName='$urllink' defer></script>";
            if ($request->has('liveChat_hidden')) {
                $request->validate([
                    'liveChatPort' => 'required',
                ]);

                if ($request->liveChatPort != setting('liveChatPort')) {
                    try {
                        $data['liveChatHidden'] = $request->liveChat_hidden ? 'false' : 'true';
                        $data['liveChatPort'] = $request->liveChatPort;
                        $data['liveChatScript'] = $livechatscriptcrating;
                        $this->updateSettings($data);

                        if (parse_url($urllink)['host'] == 'localhost') {
                            $startport = $request->liveChatPort;
                            $command = "php artisan websockets:serve --port=$startport";

                            exec("$command > /dev/null 2>&1 &");
                        } else {
                            $startport = $request->liveChatPort;
                            $serveProcess = new Process(["php", "artisan", "websockets:serve", "--port=$startport"]);
                            $serveProcess->start();

                            sleep(3);
                        }

                        $geolocation = GeoIP::getLocation(request()->getClientIp());
                        $agent = new Agent();
                        $activity = new EmployeeActivity();
                        $activity->user_id = Auth::user()->id;
                        $activity->activity_type = 'Livechat Credentials Updated';
                        $activity->ip_address = $geolocation->ip;
                        $activity->browser = $agent->browser();
                        $activity->device = $agent->device();
                        $activity->save();

                        return response()->json(["code" => 200, "success" => lang("WebSocket server started on port $startport.", "alerts")], 200);
                    } catch (\Exception $e) {
                        return response()->json(['code' => 500, 'error' => $e->getMessage()], 500);
                    }
                }

                return response()->json(["code" => 200, "success" => lang("This websocket is already started, please re-start your server websokcet if it is not work. ", "alerts")], 200);
            } else {
                $data['liveChatHidden'] = $request->liveChat_hidden ? 'false' : 'true';
                $data['liveChatPort'] = $request->liveChatPort;
                $data['liveChatScript'] = $livechatscriptcrating;
                $this->updateSettings($data);

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Livechat Credentials Updated';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                return response()->json(["code" => 200, "success" => lang("Data updated successfully", "alerts")], 200);
            }
        }
    }

    function livechatAutoSave(Request $request)
    {
        $request->validate([
            'autoSloveEmailTimer' => 'required|numeric|gt:0',
            'autoSloveCloseTimer' => 'required|numeric|gt:0',
        ]);

        $data['enableAutoSlove']  =  $request->enableAutoSlove ? true : false;
        $data['autoSloveEmailTimer'] = $request->autoSloveEmailTimer;
        $data['autoSloveCloseTimer'] = $request->autoSloveCloseTimer;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Auto Solve Setting Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    function livechatAutoDelete(Request $request)
    {
        if ($request->has('AUTO_DELETE_LIVECHAT_ENABLE')) {
            $request->validate([
                'AUTO_DELETE_LIVECHAT_IN_MONTHS' => 'required|numeric|gt:0',
            ]);
        }

        $data['AUTO_DELETE_LIVECHAT_ENABLE']  =  $request->has('AUTO_DELETE_LIVECHAT_ENABLE') ? 'on' : 'off';
        $data['AUTO_DELETE_LIVECHAT_IN_MONTHS'] = $request->AUTO_DELETE_LIVECHAT_IN_MONTHS;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Auto Delete Setting Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    function livechatTickets(Request $request)
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $flow = livechat_flow::where('active', 1)->first();
        $data['flow'] = $flow;

        $livechatTickets = Ticket::with('ticketnote', 'category', 'cust', 'selfassign')->where('cust_id', $request->id)->get();
        $livechatTickets = $livechatTickets->each(function ($ticket) {
            $ticket->encrypted_id = Crypt::encrypt($ticket->id);
            $ticket->viewRouteUrl = fetchticketviewurl($ticket);
            return $ticket;
        });
        $data['livechatTickets'] = $livechatTickets;

        return view('admin.livechat.livechat-tickets')->with($data);
    }

    function livechatTicketMassDelete(Request $request)
    {
        foreach ($request->id as $ticketId) {
            Ticket::where('ticket_id', $ticketId)->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple Tickets Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function livechatTicketDelete(Request $request)
    {
        Ticket::where('ticket_id', $request->id)->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Ticket Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function livechatFeedbackDropdown(Request $request)
    {
        $request->validate([
            'LivechatCustFeedbackQuestion' => 'required|max:255',
        ]);

        $data['livechatFeedbackDropdown'] = $request->livechatFeedbackDropdown;
        $data['LivechatCustFeedbackQuestion'] = $request->LivechatCustFeedbackQuestion;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Livechat Feedback Data Setting Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    public function beforechatshowdata()
    {
        $data['beforechatshowdata'] = setting('STATIC_NAME_FOR_ICON');
        $data['livechatpopuptitle'] = setting('LIVECHAT_POPUP_TITLE');
        $data['livechatpopupsubtitle'] = setting('LIVECHAT_POPUP_SUB_TITLE');

        return response()->json($data);
    }

    function livechatAllRatings()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $userCurrent = User::all();
        $userCurrent->TotalAnsweredTicket = 0;
        $data['users'] = $userCurrent;

        $reviewsData = livechatReviews::all();
        $data['reviewsData'] = $reviewsData;

        $liveChatConversationData = LiveChatConversations::all();

        foreach ($userCurrent as $user) {
            foreach ($liveChatConversationData as $conversation) {
                if ($conversation->livechat_user_id == $user->id) {
                    $user->TotalAnsweredTicket++;
                }
            }
        }

        return view('admin.livechat.livechat-reviews')->with($data);
    }

    function livechatEmpliyerRatings(Request $req, $id)
    {

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $users = User::find($id);
        $data['users'] = $users;


        $reviewsData = livechatReviews::with('livechatcust')->where('users_id', $id)->get();
        $data['reviewsData'] = $reviewsData;

        return view('admin.livechat.livechat-employereview')->with($data);
    }

    function livechatDeleteFeedback($id)
    {
        $review = livechatReviews::find($id);
        if ($review != null) {
            $review->delete();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Livechat Review Deleted';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => 'Updated successfully'], 200);
        } else {
            return response()->json(['error' => 'Something is missing'], 500);
        }
    }

    public function downloadFile(Request $req)
    {
        $file = $req->file('file');
        $email = $req->input('email');
        try {
            Mail::send([], [], function ($message) use ($email, $file) {
                $message->to($email)
                    ->subject('Your LiveChat backup file')
                    ->attach($file->getRealPath(), [
                        'as' => $file->getClientOriginalName(),
                    ])
                    ->text('Your LiveChat backup file');
            });
        } catch (\Throwable $th) {
            return response()->json(['message' => 'Failed to send email'], 500);
        }

        return response()->json(['message' => 'Email sent successfully'], 200);
    }

    function securitySettings(Request $request)
    {
        $data['inspectDisable'] = $request->inspectDisable ? $request->inspectDisable : "off";
        $data['selectDisabled'] = $request->selectDisabled ? $request->selectDisabled : "off";
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Security Controls Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully'));
    }

    public function integrations()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        return view('admin.livechat.integrations')->with($data);
    }

    public function whatsappStore(Request $request)
    {
        if ($request->enableWhatsapp) {
            $this->validate($request, [
                'whatsappNumber' => 'required',
                'whatsappToken' => 'required|max:10000',
                'whatsPhoneNumberId' => 'required|max:10000',
                'businessAccId' => 'required|max:10000',
                'whatsappVerifyToken' => 'required|max:10000',
                'whatsAppGraphAPIVersion' => 'required|max:10000',
            ]);
        }
        $data['enableWhatsapp'] = $request->enableWhatsapp ? 'on' : 'off';
        $data['whatsappNumber'] = $request->whatsappNumber;
        $data['whatsappToken'] = $request->whatsappToken;
        $data['whatsPhoneNumberId'] = $request->whatsPhoneNumberId;
        $data['businessAccId'] = $request->businessAccId;
        $data['whatsappVerifyToken'] = $request->whatsappVerifyToken;
        $data['whatsAppGraphAPIVersion'] = $request->whatsAppGraphAPIVersion;

        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Whatsapp settings Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully', 'alerts'));
    }

    public function instagramStore(Request $request)
    {
        if ($request->has('enableInstagram')) {
            $this->validate($request, [
                'instagramAccountId' => 'required',
                'instagramUsername' => 'required',
                'InstagramAccessToken' => 'required|max:10000',
                'InstagramVerifyToken' => 'required|max:10000',
                'instagramGraphAPIVersion' => 'required|max:10000',
                'fbPageAccessToken' => 'required|max:10000',
            ]);
        }

        $url = "https://graph.instagram.com/$request->instagramGraphAPIVersion/$request->instagramAccountId?fields=id,name,username&access_token=$request->InstagramAccessToken";

        // Make the API request
        $response = Http::get($url);

        if ($response->successful()) {
            $data['enableInstagram'] = $request->has('enableInstagram') ? 'on' : 'off';
            $data['instagramAccountId'] = $request->instagramAccountId;
            $data['instagramUsername'] = $request->instagramUsername;
            $data['InstagramAccessToken'] = $request->InstagramAccessToken;
            $data['InstagramVerifyToken'] = $request->InstagramVerifyToken;
            $data['instagramGraphAPIVersion'] = $request->instagramGraphAPIVersion;
            $data['fbPageAccessToken'] = $request->fbPageAccessToken;

            $this->updateSettings($data);

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Instagram settings Updated';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return back()->with('success', lang('Updated successfully', 'alerts'));
        } else {
            return back()->with('error', lang('Please enter valid credentials.', 'alerts'));
        }
    }

    private function updateSettings($data)
    {
        foreach ($data as $key => $val) {
            $setting = Setting::where('key', $key);
            if ($setting->exists())
                $setting->first()->update(['value' => $val]);
        }
    }
}
