<?php

namespace App\Http\Controllers\Admin;

use App\Events\ChatMessageEvent;
use App\Http\Controllers\Controller;
use App\Models\LiveChatConversations;
use App\Models\LiveChatCustomers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log, Illuminate\Support\Str;


class InstagramController extends Controller
{

    public function verifyWebhook(Request $request)
    {
        Log::info('verifyWebhook:', $request->all());

        $mode = $request->query('hub_mode');
        $verifyToken = $request->query('hub_verify_token');
        $expectedVerifyToken = 'verify-Token'; // Fetch the expected token

        // Check the mode and verify token
        if ($mode === 'subscribe' && $verifyToken === $expectedVerifyToken) {
            // Send back the hub_challenge as plain text
            return response($request->query('hub_challenge'), 200)
                ->header('Content-Type', 'text/plain');
        } else {
            // Log a message for failed verification
            Log::warning('Webhook Verification Failed:', [
                'received_mode' => $mode,
                'received_verify_token' => $verifyToken
            ]);

            // Return a 403 response if verification fails
            return response('Forbidden', 403);
        }
    }

    public function handleIncomingMessage(Request $request)
    {

        $message = 'Incoming Instagram message: ' . json_encode($request->all());
        Log::info($message);

        // return response()->json([], 200);

        try {
            $data = json_decode($request->getContent(), true);

            // to add the read ticks to the message
            if (isset($data['entry'][0]['messaging'][0]['read'])) {
                $senderId = $data['entry'][0]['messaging'][0]['sender']['id'];
                $cust = LiveChatCustomers::where('userId', $senderId)->first();
                if (isset($cust)) {
                    // message read script
                    $originalMessages = LiveChatConversations::where('unique_id', $cust->cust_unique_id)->where('status', 'delivered')->get();
                    foreach ($originalMessages as $message) {
                        $message->status = 'seen';
                        $message->save();
                    }
                    event(new ChatMessageEvent(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 'read', (int)$cust->id));
                }

                return response()->json([], 200);
            }

            // when user sends an unsupported file in chat
            if (isset($data['entry'][0]['messaging']['is_unsupported']) && $data['entry'][0]['messaging']['is_unsupported'] == 'true') {
                // confirm wether to send back a message or stop process here



                return response()->json([], 200);
            }

            $messageId = $data['entry'][0]['messaging'][0]['message']['mid'];

            // to remove the deleted message from customer
            if (isset($data['entry'][0]['messaging'][0]['message']['is_deleted']) && $data['entry'][0]['messaging'][0]['message']['is_deleted'] == 'true') {
                $deletedMessage = LiveChatConversations::where('messageId' ,$messageId)->first();
                if (isset($deletedMessage)) {
                    $deletedMessage->messageDeleted = '1';
                    $deletedMessage->update();

                    event(new ChatMessageEvent(null, null, null, $deletedMessage->livechat_cust_id, null, null, null, null, null, null, $deletedMessage->id, null, null, null, null, null, null, null, null, null, null, 'deleted', $messageId));

                    return response()->json([], 200);
                }
            }

            $recieverId = $data['entry'][0]['messaging'][0]['recipient']['id'];
            $senderId = $data['entry'][0]['messaging'][0]['sender']['id'];
            $messageType = $data['entry'][0]['messaging'][0]['message']['text'] ? 'text' : $data['entry'][0]['messaging'][0]['message']['attachments'][0]['type'];
            $messageContent = $messageType == 'text' ? $data['entry'][0]['messaging'][0]['message']['text'] : $data['entry'][0]['messaging'][0]['message']['attachments'][0]['payload']['url'];
            if ($recieverId == setting('instagramAccountId')) {
                $user = LiveChatCustomers::where('userId', $senderId)->first();
                // if user already customer, create only message
                if (isset($user)) {
                    // $cust = LiveChatCustomers::find($user->id);
                    if ($user->status == 'solved') {
                        $user->status = "";

                        $userWithConversation = clone $user;
                        $userWithConversation->latestConversation = $messageContent;
                        event(new ChatMessageEvent($userWithConversation->username, 'newUser', null, null, null, null, null, null, null, null, null, null, null, null, null, $userWithConversation));
                    }
                    $user->updated_at = now();
                    $user->save();

                    $newconversation = new LiveChatConversations();
                    $newconversation->unique_id = $user->cust_unique_id;
                    $newconversation->livechat_cust_id = $user->id;
                    $newconversation->livechat_username = $user->username;
                    $newconversation->message = $messageContent;
                    $newconversation->message_type = $messageType;
                    $newconversation->messageId = $messageId;
                    $newconversation->save();
                    if ($messageType == 'image' || $messageType == 'video') {
                        // $newconversation->message_type = $messageType;
                        // $newconversation->save();
                        event(new ChatMessageEvent($user->username, $messageContent, $user->id, $user->id, null, null, null, null, null, $newconversation->id, $messageType,null, null, null, null, null, null, null, null, null, null, null, $messageId));
                    } else {
                        event(new ChatMessageEvent($user->username, $messageContent, $user->id, $user->id, null, null, null, null, null, $newconversation->id, null, null, null, null, null, null, null, null, null, null, null, null, $messageId));
                    }
                } else {
                    // if not user, then create customer and add message

                    $url = "https://graph.instagram.com/" . setting('instagramGraphAPIVersion') . "/$senderId?fields=id,name,username&access_token=" . setting('InstagramAccessToken');
                    $response = Http::get($url);
                    $name = $response->json()['name'];
                    $userName = $response->json()['username'];

                    $cust = new LiveChatCustomers();
                    $cust->cust_unique_id = Str::uuid();
                    $cust->username = $userName;
                    $cust->name = $name;
                    $cust->userId = $senderId;
                    $cust->file_upload_permission = 1;
                    $cust->userType = 'Instagram';
                    $cust->login_at = now();
                    $cust->profile_bg_color = randomColorGenerator(0.5);
                    $cust->save();

                    $userWithConversation = clone $cust;
                    $userWithConversation->latestConversation = $messageContent;

                    event(new ChatMessageEvent($cust->username, 'newUser', $cust->id, null, null, null, null, null, null, null, null, null, null, null, null, $userWithConversation));

                    $newconversation = new LiveChatConversations();
                    $newconversation->unique_id = $cust->cust_unique_id;
                    $newconversation->livechat_cust_id = $cust->id;
                    $newconversation->livechat_username = $cust->username;
                    $newconversation->message = $messageContent;
                    $newconversation->message_type = $messageType;
                    $newconversation->messageId = $messageId;
                    $newconversation->save();
                    if ($messageType == 'image' || $messageType == 'video') {
                        $newconversation->message_type = $messageType;
                        $newconversation->save();
                        event(new ChatMessageEvent($cust->username, $messageContent, null, $cust->id, null, null, null, null, null, $newconversation->id, $messageType,null, null, null, null, null, null, null, null, null, null, null, $messageId));
                    } else {
                        event(new ChatMessageEvent($cust->username, $messageContent, null, $cust->id, null, null, null, null, null, $newconversation->id, null, null, null, null, null, null, null, null, null, null, null, null, $messageId));
                    }
                    // if ($messageType == 'image' || $messageType == 'video') {
                    //     $newconversation->message_type = $messageType;
                    //     event(new ChatMessageEvent($cust->username, $messageContent, $cust->id, $cust->id, null, null, null, null, null, null, $messageType));
                    // } else {
                    //     event(new ChatMessageEvent($cust->username, $messageContent, $cust->id, $cust->id));
                    // }
                }
                return response()->json([], 200);
            } else {
                return response()->json([], 200);
            }
        } catch (\Throwable $th) {
            Log::info($th->getMessage());
            return response()->json([], 200);
        }

        return response()->json([], 200);
    }
}
