<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\customizeerror;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class CustomerrorpagesController extends Controller
{
    public function index()
    {

        $this->authorize('404 Error Page Access');
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.errorpages.error404')->with($data);
    }

    public function store(Request $request)
    {
        $this->authorize('404 Error Page Access');
        $request->validate([
			'404title'=> 'required|max:100',

		]);
        if($request->input('404subtitle')){
            $request->validate([
                '404subtitle'=> 'max:500',

            ]);
        }
        $data = $request->only(['404subtitle', '404title']);

        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = '404 Error Page Settings Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully', 'alerts'));
    }

    public function maintenancepage()
    {
        $this->authorize('Under Maintenance Page Access');
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return view('admin.errorpages.undermaintenance')->with($data);
    }

    public function maintenancepagestore(Request $request)
    {
        $this->authorize('Under Maintenance Page Access');
        $request->validate([
			'503title'=> 'required|max:100',
			'503subtitle'=> 'required|max:100',
            'redirectionURL' => $request->input('redirectionURL') != null ? 'url' : '',
            '503description' => $request->has('503description') ? 'max:500' : '',
		]);
        $data['503subtitle']  =  $request->input('503subtitle');
        $data['503title']  =  $request->input('503title');
        $data['503description']  =  $request->input('503description');
        $data['redirectionURL']  =  $request->input('redirectionURL');
        $data['MAINTENANCE_MODE']  =  $request->has('MAINTENANCE_MODE') ? 'on' : 'off';

        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Under Maintenance Page Settings Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return back()->with('success', lang('Updated successfully', 'alerts'));
    }

     /**
     *  Settings Save/Update.
     *
     * @return \Illuminate\Http\Response
     */
    private function updateSettings($data)
    {

        foreach($data as $errorname => $errorvalue){
        	$setting = customizeerror::where('errorname', $errorname);
        	if( $setting->exists() )
        		$setting->first()->update(['errorvalue' => $errorvalue]);
        }

    }
}
