<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Countries;
use App\Models\Timezone;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use App\Models\Ticket\Category;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\usersettings;
use App\Models\Seosetting;
use App\Models\Pages;
use Illuminate\Support\Str;
use App\Imports\UserImport;
use App\Jobs\MailSend;
use App\Models\Bussinesshours;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\senduserlist;
use App\Models\Ticket\Ticket;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Crypt;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use App\Models\PersonalBusinessHours;
use Illuminate\Support\Facades\Auth;

class AgentCreateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('Employee Access');

        $users = User::with('permissions', 'roles')->get();
        $users = $users->each(function ($user) {
            $user->encrypted_id = Crypt::encrypt($user->id);
            $user->editPermission = $user->can('Employee Edit') ? 'exists' : null;
            $user->deletePermission = $user->can('Employee Delete') ? 'exists' : null;
            $user->resetPassPermission = $user->can('Reset Password') ? 'exists' : null;
            return $user;
        });
        $data['users'] = $users;

        $roles = Role::get();
        $data['roles'] = $roles;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $categories = Category::whereIn('display', ['ticket', 'both'])->where('status', '1')->get();
        $data['categories'] = $categories;

        return view('admin.agent.index')->with($data)->with('i', (request()->input('page', 1) - 1) * 5);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('Employee Create');
        $country = Countries::all();
        $data['countries'] = $country;

        $timezones = Timezone::get();
        $data['timezones'] = $timezones;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $roles = Role::get();
        $data['roles'] = $roles;

        // $bussiness1 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '1')->first();
        // $data['bussiness1'] = $bussiness1;
        // $bussiness2 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '2')->first();
        // $data['bussiness2'] = $bussiness2;
        // $bussiness3 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '3')->first();
        // $data['bussiness3'] = $bussiness3;
        // $bussiness4 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '4')->first();
        // $data['bussiness4'] = $bussiness4;
        // $bussiness5 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '5')->first();
        // $data['bussiness5'] = $bussiness5;
        // $bussiness6 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '6')->first();
        // $data['bussiness6'] = $bussiness6;
        // $bussiness7 = PersonalBusinessHours::where('user_id', Auth::id())->where('no_id', '7')->first();
        // $data['bussiness7'] = $bussiness7;
        $bussiness1 = Bussinesshours::where('no_id', '1')->first();
        $data['bussiness1'] = $bussiness1;
        $bussiness2 = Bussinesshours::where('no_id', '2')->first();
        $data['bussiness2'] = $bussiness2;
        $bussiness3 = Bussinesshours::where('no_id', '3')->first();
        $data['bussiness3'] = $bussiness3;
        $bussiness4 = Bussinesshours::where('no_id', '4')->first();
        $data['bussiness4'] = $bussiness4;
        $bussiness5 = Bussinesshours::where('no_id', '5')->first();
        $data['bussiness5'] = $bussiness5;
        $bussiness6 = Bussinesshours::where('no_id', '6')->first();
        $data['bussiness6'] = $bussiness6;
        $bussiness7 = Bussinesshours::where('no_id', '7')->first();
        $data['bussiness7'] = $bussiness7;

        return view('admin.agent.agentprofilecreate')->with($data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('Employee Create');

        $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'empid' => 'required|max:255|unique:users',
            'email' => 'required|string|email|max:255|unique:users',
            'role' => 'required',
            'password' => 'required|string|min:8',
        ]);
        if ($request->phone) {
            $request->validate([
                'phone' => 'numeric',
            ]);
        }

        if ($request->file('image') != null) {
            $request->validate([
                'image' => 'mimes:jpeg,jpg,png|required|max:5120',
            ]);
        }

        $user = User::create([
            'firstname' => Str::ucfirst($request->input('firstname')),
            'lastname' => Str::ucfirst($request->input('lastname')),
            'empid' => Str::upper($request->empid),
            'email' => $request->email,
            'status' => '1',
            'password' => Hash::make($request->password),
            'skills' => $request->skills,
            'phone' => $request->phone,
            'country' => $request->country,
            'timezone' => $request->timezone,
            'image' => null,
            'verified' => '1',

        ]);

        $users = User::find($user->id);
        $users->name = $user->firstname . ' ' . $user->lastname;
        $users->languagues = $request->languages;
        $users->darkmode = setting('DARK_MODE');

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $fileArray = array('image' => $file);
            $rules = array(
                'image' => 'mimes:jpeg,jpg,png|required|max:5120' // max 10000kb
            );

            // Now pass the input and rules into the validator
            $validator = Validator::make($fileArray, $rules);

            if ($validator->fails()) {
                return redirect()->back()->with('error', lang('Please check the format and size of the file.', 'alerts'));
            } else {

                $image_name = time() . '.' . $file->getClientOriginalExtension();
                $provider = storage()->provider;
                $existprovider = existprovider($user->storage_disk);
                if($existprovider)
                   $existprovider->provider::delete('/uploads/profile' . "/" . $user->image);
                $upload =  $provider::uploadprofile($file,$image_name);
                if($upload)
                   $users->update(['image' => $image_name,'storage_disk' => storage()->storage_disk]);
                else
                   return redirect('admin/profile')->with('error', lang('Image upload failed please try again.', 'alerts'));
            }
        }


        $users->update();

        $user->assignRole([$request->role]);


        $usersetting = new usersettings();
        $usersetting->users_id = $users->id;
        $usersetting->emailnotifyon = '1';
        $usersetting->save();

        $ticketData = [
            'userpassword' => $request->password,
            'username' => $user->firstname . ' ' . $user->lastname,
            'useremail' => $user->email,
            'url' => url('/admin'),
        ];

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'New Employee Created';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if($request->has('24hoursbusinessswitch')){
            $this->personalfullhours($request->input('24hoursbusinessswitch'),$user);
        }elseif($request->starttime1 != null || $request->endtime1 != null ||$request->starttime2 != null || $request->endtime2 != null || $request->starttime3 != null || $request->endtime3 != null || $request->starttime4 != null || $request->endtime4 != null || $request->starttime5 != null || $request->endtime5 != null || $request->starttime6 != null || $request->endtime6 != null || $request->starttime7 != null || $request->endtime7 != null){
            $this->bussinesspersonalstore($request,$user);
        }else{
            $user->personalworkhours = null;
            $user->personal24hours = null;
            $user->save();
        }

        try {
            if ($user->usetting->emailnotifyon == 1) {
                dispatch((new MailSend($user->email, 'employee_send_registration_details', $ticketData)));
            }
        } catch (\Exception $e) {
            return redirect('admin/employee')->with('success', lang('A new employee was successfully added.', 'alerts'));
        }
        return redirect('admin/employee')->with('success', lang('A new employee was successfully added.', 'alerts'));
    }

    private function bussinesspersonalstore($request,$user)
    {
        $bussinessid1 = $request->bussinessid1;
        $bussiness1 = $request->bussiness1;
        $starttime1 = $request->starttime1;
        $endtime1 = $request->endtime1;
        $status1 = $request->status1;
        $breakstarttime1 = $request->breakstart1;
        $breakendtime1 = $request->breakend1;

        $ticket1 = [
            'user_id' => $user->id,
            'no_id' => $bussinessid1,
            'weeks' => $bussiness1,
            'starttime' => $starttime1,
            'endtime' => $endtime1,
            'status' => $status1,
            'breakstarttime' => $breakstarttime1,
            'breakendtime' => $breakendtime1,
        ];
        $buss1 = PersonalBusinessHours::where('user_id', $user->id)->updateOrCreate(['no_id' => $bussinessid1], $ticket1);

        $bussinessid2 = $request->bussinessid2;
        $bussiness2 = $request->bussiness2;
        $starttime2 = $request->starttime2;
        $endtime2 = $request->endtime2;
        $status2 = $request->status2;
        $breakstarttime2 = $request->breakstart2;
        $breakendtime2 = $request->breakend2;

        $ticket2 = [
            'user_id' => $user->id,
            'no_id' => $bussinessid2,
            'weeks' => $bussiness2,
            'starttime' => $starttime2,
            'endtime' => $endtime2,
            'status' => $status2,
            'breakstarttime' => $breakstarttime2,
            'breakendtime' => $breakendtime2,
        ];
        $buss2 = PersonalBusinessHours::where('user_id', $user->id)->updateOrCreate(['no_id' => $bussinessid2], $ticket2);

        $bussinessid3 = $request->bussinessid3;
        $bussiness3 = $request->bussiness3;
        $starttime3 = $request->starttime3;
        $endtime3 = $request->endtime3;
        $status3 = $request->status3;
        $breakstarttime3 = $request->breakstart3;
        $breakendtime3 = $request->breakend3;

        $ticket3 = [
            'user_id' => $user->id,
            'no_id' => $bussinessid3,
            'weeks' => $bussiness3,
            'starttime' => $starttime3,
            'endtime' => $endtime3,
            'status' => $status3,
            'breakstarttime' => $breakstarttime3,
            'breakendtime' => $breakendtime3,
        ];
        $buss3 = PersonalBusinessHours::where('user_id', $user->id)->updateOrCreate(['no_id' => $bussinessid3], $ticket3);

        $bussinessid4 = $request->bussinessid4;
        $bussiness4 = $request->bussiness4;
        $starttime4 = $request->starttime4;
        $endtime4 = $request->endtime4;
        $status4 = $request->status4;
        $breakstarttime4 = $request->breakstart4;
        $breakendtime4 = $request->breakend4;

        $ticket4 = [
            'user_id' => $user->id,
            'no_id' => $bussinessid4,
            'weeks' => $bussiness4,
            'starttime' => $starttime4,
            'endtime' => $endtime4,
            'status' => $status4,
            'breakstarttime' => $breakstarttime4,
            'breakendtime' => $breakendtime4,
        ];
        $buss4 = PersonalBusinessHours::where('user_id', $user->id)->updateOrCreate(['no_id' => $bussinessid4], $ticket4);

        $bussinessid5 = $request->bussinessid5;
        $bussiness5 = $request->bussiness5;
        $starttime5 = $request->starttime5;
        $endtime5 = $request->endtime5;
        $status5 = $request->status5;
        $breakstarttime5 = $request->breakstart5;
        $breakendtime5 = $request->breakend5;

        $ticket5 = [
            'user_id' => $user->id,
            'no_id' => $bussinessid5,
            'weeks' => $bussiness5,
            'starttime' => $starttime5,
            'endtime' => $endtime5,
            'status' => $status5,
            'breakstarttime' => $breakstarttime5,
            'breakendtime' => $breakendtime5,
        ];
        $buss5 = PersonalBusinessHours::where('user_id', $user->id)->updateOrCreate(['no_id' => $bussinessid5], $ticket5);

        $bussinessid6 = $request->bussinessid6;
        $bussiness6 = $request->bussiness6;
        $starttime6 = $request->starttime6;
        $endtime6 = $request->endtime6;
        $status6 = $request->status6;
        $breakstarttime6 = $request->breakstart6;
        $breakendtime6 = $request->breakend6;

        $ticket6 = [
            'user_id' => $user->id,
            'no_id' => $bussinessid6,
            'weeks' => $bussiness6,
            'starttime' => $starttime6,
            'endtime' => $endtime6,
            'status' => $status6,
            'breakstarttime' => $breakstarttime6,
            'breakendtime' => $breakendtime6,
        ];
        $buss6 = PersonalBusinessHours::where('user_id', $user->id)->updateOrCreate(['no_id' => $bussinessid6], $ticket6);

        $bussinessid7 = $request->bussinessid7;
        $bussiness7 = $request->bussiness7;
        $starttime7 = $request->starttime7;
        $endtime7 = $request->endtime7;
        $status7 = $request->status7;
        $breakstarttime7 = $request->breakstart7;
        $breakendtime7 = $request->breakend7;

        $ticket7 = [
            'user_id' => $user->id,
            'no_id' => $bussinessid7,
            'weeks' => $bussiness7,
            'starttime' => $starttime7,
            'endtime' => $endtime7,
            'status' => $status7,
            'breakstarttime' => $breakstarttime7,
            'breakendtime' => $breakendtime7,
        ];
        $buss7 = PersonalBusinessHours::where('user_id', $user->id)->updateOrCreate(['no_id' => $bussinessid7], $ticket7);

        $user->personalworkhours = 'on';
        $user->personal24hours = null;
        $user->save();

        return $user;
    }

    private function personalfullhours($fullhours,$user)
    {
        $businesshours = PersonalBusinessHours::where('user_id', $user->id)->get();
        $barray = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'];
        $dayIndex = 0;
        if($businesshours->isEmpty()){
            $no_id_Index = 0;
            foreach($barray as $barrays){
                $business = PersonalBusinessHours::where('user_id', $user->id)->create([
                    'user_id' => $user->id,
                    'no_id' => $no_id_Index + 1,
                    'weeks' => $barrays,
                    'status' => 'Opened',
                    'starttime' => '24H',
                    'endtime' => null,
                    'breakstarttime' => null,
                    'breakendtime' => null,
                ]);

                $no_id_Index = $no_id_Index + 1;
            }
        }else{
            foreach($businesshours as $businesshour){
                $businesshour->user_id = $user->id;
                $businesshour->weeks = $barray[$dayIndex];
                $dayIndex = ($dayIndex + 1) % count($barray);
                $businesshour->status = 'Opened';
                $businesshour->starttime = '24H';
                $businesshour->endtime = null;
                $businesshour->breakstarttime = null;
                $businesshour->breakendtime = null;
                $businesshour->save();
            }
        }

        $user->personalworkhours = $fullhours == 'off' ? null : 'on';
        $user->personal24hours = $fullhours;
        $user->save();

        return $user;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('Employee Edit');
        $id = decrypt($id);
        $user = User::where('id', $id)->first();
        $data['user'] = $user;

        $country = Countries::all();
        $data['countries'] = $country;

        $timezones = Timezone::get();
        $data['timezones'] = $timezones;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $roles = Role::get();
        $data['roles'] = $roles;

        $perbhrs = PersonalBusinessHours::where('user_id', $id)->get();
        if($perbhrs->isNotEmpty()){
            $bussiness1 = PersonalBusinessHours::where('user_id', $id)->where('no_id', '1')->first();
            $data['bussiness1'] = $bussiness1;
            $bussiness2 = PersonalBusinessHours::where('user_id', $id)->where('no_id', '2')->first();
            $data['bussiness2'] = $bussiness2;
            $bussiness3 = PersonalBusinessHours::where('user_id', $id)->where('no_id', '3')->first();
            $data['bussiness3'] = $bussiness3;
            $bussiness4 = PersonalBusinessHours::where('user_id', $id)->where('no_id', '4')->first();
            $data['bussiness4'] = $bussiness4;
            $bussiness5 = PersonalBusinessHours::where('user_id', $id)->where('no_id', '5')->first();
            $data['bussiness5'] = $bussiness5;
            $bussiness6 = PersonalBusinessHours::where('user_id', $id)->where('no_id', '6')->first();
            $data['bussiness6'] = $bussiness6;
            $bussiness7 = PersonalBusinessHours::where('user_id', $id)->where('no_id', '7')->first();
            $data['bussiness7'] = $bussiness7;
        }else{
            $bussiness1 = Bussinesshours::where('no_id', '1')->first();
            $data['bussiness1'] = $bussiness1;
            $bussiness2 = Bussinesshours::where('no_id', '2')->first();
            $data['bussiness2'] = $bussiness2;
            $bussiness3 = Bussinesshours::where('no_id', '3')->first();
            $data['bussiness3'] = $bussiness3;
            $bussiness4 = Bussinesshours::where('no_id', '4')->first();
            $data['bussiness4'] = $bussiness4;
            $bussiness5 = Bussinesshours::where('no_id', '5')->first();
            $data['bussiness5'] = $bussiness5;
            $bussiness6 = Bussinesshours::where('no_id', '6')->first();
            $data['bussiness6'] = $bussiness6;
            $bussiness7 = Bussinesshours::where('no_id', '7')->first();
            $data['bussiness7'] = $bussiness7;
        }

        return view('admin.agent.agentprofile')->with($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('Employee Edit');

        $id = decrypt($id);
        $employee = User::find($id);

        $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
        ]);
        if ($request->phone) {
            $request->validate([
                'phone' => 'numeric',
            ]);
        }
        if ($request->role) {
            $request->validate([
                'role' => 'required',
            ]);
        }
        if ($request->email == $employee->email) {
            $request->validate([
                'email' => 'required|string|email|max:255',
            ]);
        } else {
            $request->validate([
                'email' => 'required|string|email|max:255|unique:users',
            ]);
        }
        if ($request->empid == $employee->empid) {
            $request->validate([
                'empid' => 'required|max:255',
            ]);
        } else {
            $request->validate([
                'empid' => 'required|max:255||unique:users',
            ]);
        }



        $user = User::where('id', $id)->findOrFail($id);

        if(Auth::user()->id == 1){
            $editallow = 'allowed';
        }elseif($user->id == Auth::user()->id || $user->getRoleNames()[0] != 'superadmin'){
            $editallow = 'allowed';
        }else{
            $editallow = 'notallowed';
        }

        if($editallow == 'allowed'){
            $user->firstname = Str::ucfirst($request->input('firstname'));
            $user->lastname = Str::ucfirst($request->input('lastname'));
            if ($request->email != $employee->email) {
                $user->email = $request->email;
            }
            if ($request->empid != $employee->empid) {

                $user->empid = Str::upper($request->empid);
            }
            $user->languagues = $request->languages;
            $user->skills = $request->skills;
            $user->phone = $request->phone;
            $user->country = $request->country;
            $user->timezone = $request->timezone;

            $user->status = $request->input('status');

            $user->update();


            $users = User::find($user->id);

            $users->name = $user->firstname . ' ' . $user->lastname;

            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $fileArray = array('image' => $file);
                $rules = array(
                    'image' => 'mimes:jpeg,jpg,png|required|max:5120' // max 10000kb
                );

                // Now pass the input and rules into the validator
                $validator = Validator::make($fileArray, $rules);

                if ($validator->fails()) {
                    return redirect()->back()->with('error', lang('Please check the format and size of the file.', 'alerts'));
                } else {
                    $image_name = time() . '.' . $file->getClientOriginalExtension();
                    $provider = storage()->provider;
                    $existprovider = existprovider($user->storage_disk);
                    if($existprovider)
                    $existprovider->provider::delete('/uploads/profile' . "/" . $user->image);
                    $upload =  $provider::uploadprofile($file,$image_name);
                    if($upload)
                    $users->update(['image' => $image_name,'storage_disk' => storage()->storage_disk]);
                    else
                    return redirect('admin/profile')->with('error', lang('Image upload failed please try again.', 'alerts'));

                }
            }

            $users->update();
        }else{
            return redirect()->back()->with('error', lang('You are not allowed to update this profile.', 'alerts'));
        }

        if($employee->id == Auth::user()->id && $request->role != $user->getRoleNames()[0]){
            return redirect()->back()->with('error', lang('You are not eligible to update your role.', 'alerts'));
        }else{
            if(!empty($user->getRoleNames()[0])){
                $user->removeRole( $user->getRoleNames()[0] );
            }
            $user->assignRole($request->role);
        }

        if($request->has('24hoursbusinessswitch')){
            $this->personalfullhours($request->input('24hoursbusinessswitch'),$user);
        }elseif($request->starttime1 != null || $request->endtime1 != null ||$request->starttime2 != null || $request->endtime2 != null || $request->starttime3 != null || $request->endtime3 != null || $request->starttime4 != null || $request->endtime4 != null || $request->starttime5 != null || $request->endtime5 != null || $request->starttime6 != null || $request->endtime6 != null || $request->starttime7 != null || $request->endtime7 != null){
            $this->bussinesspersonalstore($request,$user);
        }else{
            $businesshours = PersonalBusinessHours::where('user_id', $user->id)->get();
            foreach($businesshours as $businesshour){
                $businesshour->delete();
            }

            $user->personalworkhours = null;
            $user->personal24hours = null;
            $user->save();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Employee Profile Updated';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return redirect('admin/employee')->with('success', lang('The employee’s profile was successfully updated.', 'alerts'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('Employee Delete');

        $id = decrypt($id);

        if ($id == 1) {
            return;
        }

        $user = User::where('id', $id)->findOrFail($id);

        if(Auth::user()->id == 1){
            $editallow = 'allowed';
        }elseif($user->id == Auth::user()->id || $user->getRoleNames()[0] != 'superadmin'){
            $editallow = 'allowed';
        }else{
            $editallow = 'notallowed';
        }

        if($editallow == 'allowed'){
            $tickets = Ticket::where('selfassignuser_id', $user->id)->get();
            foreach($tickets as $ticket){
                $ticket->myassignuser_id = null;
                $ticket->selfassignuser_id = null;
                $ticket->save();
            }

            $user->usetting()->delete();
            $custnotifications = senduserlist::where('touser_id',$user->id)->get();
            foreach($custnotifications as $custnotification){
                $custnotifycount = senduserlist::where('mail_id',$custnotification->mail_id)->count();
                if($custnotifycount == 1){
                    $custnotification->sendmaildata->delete();
                }
                $custnotification->delete();
            }

            $user->delete();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Employee Profile Deleted';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => lang('The employee was successfully deleted.', 'alerts')]);
        }else{
            return response()->json(['error' => lang('You are not allowed to delete this profile.', 'alerts')]);
        }

    }

    public function usermassdestroy(Request $request)
    {
        $this->authorize('Employee Delete');

        $student_id_arrays = $request->input('id');

        $student_id_array = array_map(function ($encryptedValue) {
            return decrypt($encryptedValue);
        }, $student_id_arrays);

        $customers = User::whereIn('id', $student_id_array)->where('id', '!=', 1)->get();

        foreach ($customers as $user) {
            // to remove myassignid and selfassignid when destroying employee
            $tickets = Ticket::where('selfassignuser_id', $user->id)->get();
            foreach($tickets as $ticket){
                $ticket->myassignuser_id = null;
                $ticket->selfassignuser_id = null;
                $ticket->save();
            }

            $user->usetting()->delete();
            $custnotifications = senduserlist::where('touser_id',$user->id)->get();
            foreach($custnotifications as $custnotification){
                $custnotifycount = senduserlist::where('mail_id',$custnotification->mail_id)->count();
                if($custnotifycount == 1){
                    $custnotification->sendmaildata->delete();
                }
                $custnotification->delete();
            }

            $user->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Multiple Employees Profile Deleted';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('The employee was successfully deleted.', 'alerts')]);
    }

    public function status(Request $request, $id)
    {
        $this->authorize('Employee Edit');

        $id = decrypt($id);
        $calID = User::find($id);

        if(Auth::user()->id == 1){
            $editallow = 'allowed';
        }elseif($calID->id == Auth::user()->id || $calID->getRoleNames()[0] != 'superadmin'){
            $editallow = 'allowed';
        }else{
            $editallow = 'notallowed';
        }

        if($editallow == 'allowed'){
            $calID->status = $request->status;
            $calID->save();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Employee Status Updated';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['code' => 200, 'success' => lang('Updated successfully', 'alerts')], 200);
        }else{
            return response()->json(['code' => 500, 'error' => lang('You are not allowed to update this profile.', 'alerts')], 500);
        }
    }

    public function userimportindex()
    {

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;


        return view('admin.agent.userimport')->with($data);
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function usercsv(Request $req)
    {
        $this->authorize('Employee Importlist');
        if ($req->hasFile('file')) {
            $file = $req->file('file')->store('import');

            $import = Excel::import(new UserImport, $file);

            if(session()->get('employeeimported') != null){
                session()->forget('employeeimported');

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Employee List Imported';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                return redirect()->route('employee')->with('success', lang('The employee list was imported successfully.', 'alerts'));
            }else{
                return redirect()->back()->with('error', lang('Data is insufficient, please provide sufficient data.', 'alerts'));
            }

        } else {
            return redirect()->back()->with('error', 'Please select file to import data of Employee.');
        }
    }

    public function employeepasswordreset(Request $req)
    {
        $this->authorize('Employee Edit');

        $id = decrypt($req->sprukopasswordreset_id);

        $passwordchanging = User::find($id);

        if(Auth::user()->id == 1){
            $editallow = 'allowed';
        }elseif($passwordchanging->id == Auth::user()->id || $passwordchanging->getRoleNames()[0] != 'superadmin'){
            $editallow = 'allowed';
        }else{
            $editallow = 'notallowed';
        }

        if($editallow == 'allowed'){
            $passwordchanging->password = Hash::make($req->resetpassword);
            $passwordchanging->update();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Employee Password Deleted';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => lang('The password has been successfully changed!', 'alerts')], 200);
        }else{
            return response()->json(['code' => 500, 'error' => lang('You are not allowed to change password.', 'alerts')], 500);
        }
    }
}
