<?php

namespace App\Http\Controllers\Admin;

use App\Events\ChatMessageEvent;
use App\Events\LiveNotification;
use App\Http\Controllers\Controller;
use App\Jobs\MailSend;
use Illuminate\Http\Request;
use App\Models\Ticket\Ticket;
use App\Models\User;
use App\Models\Ticket\Comment;
use App\Notifications\TicketAssignNotification;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class AdminAssignedticketsController extends Controller
{

    public function create(Request $request)
    {
        $this->validate($request, [
            'assigned_user_id' => 'required',
        ]);

        $calID = Ticket::find($request->assigned_id);

        if($calID->selfassignuser_id == $request->assigned_user_id){
            return response()->json(['message' => 'sameuser', 'error' => lang('This ticket is already assign to selected agent.', 'alerts')], 500);
        }

        $calID->myassignuser_id	 = Auth::id();
        $calID->selfassignuser_id = $request->assigned_user_id;
        $calID->save();

        $users = User::with('roles')->where('status', 1)->findOrFail($request->assigned_user_id);

        $ticketData = [
            'ticket_username' => $calID->cust->username,
            'ticket_id' => $calID->ticket_id,
            'ticket_title' => $calID->subject,
            'ticket_description' => $calID->message,
            'ticket_admin_url' => fetchticketviewurl($calID),
            'ticket_category' => $calID->category != null ? $calID->category->name : 'Category not available',
            'item_name' => $calID->item_name != null ? $calID->item_name : 'Item Name not available',
        ];

        $comment = Comment::create([
            'ticket_id' => $calID->id,
            'user_id' => Auth::user()->id,
            'cust_id' => null,
            'comment' => 'Ticket has been assigned to '.$users->name,
            'commenttype' => 'tickethistory',
        ]);

        $ticket = $calID;
        $ticketinfo = view('admin.superadmindashboard.allticketsinfo', compact('ticket'))->render();
        $comment->ticketinfo = $ticketinfo;
        $comment->assignerusername = $calID->selfassign->name;
        $comment->assigneruserprofile = $calID->selfassign != null ? userprofileimage($calID->selfassign) : null;

        event(new ChatMessageEvent(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$calID->id,$calID->cust->id,$comment,'tickethistory',Auth::user()->name));

        try{
            $user = User::find($calID->selfassignuser_id);
            $user->notify(new TicketAssignNotification($calID));
            event(new LiveNotification('Ticket has been assigned to you',$user,$calID,fetchticketviewurl($calID)));
            if($user->usetting->emailnotifyon == 1){
                dispatch((new MailSend($user->email, 'when_ticket_assign_to_other_employee', $ticketData)));
            }
        }catch(\Exception $e){
            return response()->json(['code'=>200, 'success'=> lang('The ticket was successfully assigned.', 'alerts')], 200);
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Assigned a ticket';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code'=>200, 'success'=> lang('The ticket was successfully assigned.', 'alerts')], 200);

    }

    public function show(Request $req, $id){

        if($req->ajax())
        {

            $output = '';
            $id = decrypt($id);
            $assign = Ticket::find($id);
            $assugnuser_id = $assign->selfassignuser_id;

            $data = User::where('status', 1)->get();

            $total_row = $data->count();

            if($total_row > 0){
                $output .='<option label="Select Agent"></option>';
                foreach($data as $row){
                    if(Auth::user()->id == $assugnuser_id){
                        $output .= '
                        <option  value="'.$row->id.'"' .($row->id == $assugnuser_id? 'selected': '').  '>'.$row->name.' ('.(!empty($row->getRoleNames()[0])? $row->getRoleNames()[0] : '').')</option>

                        ';
                    }else{
                        if(Auth::user()->id != $row->id){
                            if(!empty($assugnuser_id)){
                                $output .= '
                                <option  value="'.$row->id.'"' .($row->id == $assugnuser_id? 'selected': '').  '>'.$row->name.' ('.(!empty($row->getRoleNames()[0])? $row->getRoleNames()[0] : '').')</option>

                                ';
                            }else{
                                $output .= '
                                <option  value="'.$row->id.'">'.$row->name.' ('.(!empty($row->getRoleNames()[0])? $row->getRoleNames()[0] : '').')</option>

                                ';
                            }
                        }
                    }
                }

            }
            $data = array(
                'assign_user_exist'=> !empty($assugnuser_id) ? 'yes' : 'no',
                'assign_data'=> $assign,
                'table_data' => $output,
                'total_data' => $total_row
            );

            return response()->json($data);
        }

    }

    public function update(Request $req, $id)
    {
        $id = decrypt($id);
        $calID = Ticket::find($id);
        $calID->myassignuser_id	 = null;
        $calID->selfassignuser_id = null;
        $calID->save();

        $comment = Comment::create([
            'ticket_id' => $calID->id,
            'user_id' => Auth::user()->id,
            'cust_id' => null,
            'comment' => 'Ticket has been unassigned',
            'commenttype' => 'tickethistory',
        ]);

        $ticket = $calID;
        $ticketinfo = view('admin.superadmindashboard.allticketsinfo', compact('ticket'))->render();
        $comment->ticketinfo = $ticketinfo;

        event(new ChatMessageEvent(null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$calID->id,$calID->cust->id,$comment,'tickethistory',Auth::user()->name));

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Unassigned a ticket';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['data'=> $calID, 'success'=> lang('Updated successfully', 'alerts')]);
    }
}
