<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class LiveNotification implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $message;
    public $userdata;
    public $ticketdata;
    public $routelink;

    /**
     * Create a new event instance.
     */
    public function __construct($message,$userdata,$ticketdata,$routelink)
    {
        $this->message = $message;
        $this->userdata = $userdata;
        $this->ticketdata = $ticketdata;
        $this->routelink = $routelink;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
            new Channel('livenotifications'),
        ];
    }
    // public function broadcastOn()
    // {
    //     return new Channel('livenotifications');
    // }
}
